/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.UnknownFormatConversionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.FormatStringFormatter;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.LoggerManager;
import test.BundleBinsDemo;

public class QDataSetTableModel
extends AbstractTableModel {
    private static final Logger logger = LoggerManager.getLogger("qdataset.dsutil");
    QDataSet ds;
    QDataSet wds;
    QDataSet bundle1;
    QDataSet dep0;
    QDataSet dep1;
    int dep0Offset;
    int colCount;
    Units[] units;
    String[] labels;
    DatumFormatter[] df;
    JTableHeader header;
    TableColumn column;
    JTextField text;
    JPopupMenu renamePopup;

    public QDataSetTableModel(QDataSet ds) {
        this.ds = ds;
        this.wds = DataSetUtil.weightsDataSet(ds);
        this.dep0 = (QDataSet)ds.property("DEPEND_0");
        this.dep0Offset = this.dep0 == null ? 0 : 1;
        this.bundle1 = (QDataSet)ds.property("BUNDLE_1");
        this.dep1 = (QDataSet)ds.property("DEPEND_1");
        if (this.dep1 != null && this.dep1.rank() > 1 && !SemanticOps.isBins(this.dep1)) {
            System.err.println("dep1 is sliced at 0");
        }
        this.colCount = this.dep0Offset;
        this.colCount = ds.rank() == 1 ? ++this.colCount : (this.colCount += ds.length(0));
        this.units = new Units[this.colCount];
        this.labels = new String[this.colCount];
        this.df = new DatumFormatter[this.colCount];
        int i = 0;
        if (this.dep0 != null) {
            this.units[i] = SemanticOps.getUnits(this.dep0);
            this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
            this.labels[i] = (String)this.dep0.property("LABEL");
            ++i;
        }
        if (this.bundle1 != null) {
            for (int j = 0; j < this.bundle1.length(); ++j) {
                String format;
                this.units[i] = (Units)this.bundle1.property("UNITS", j);
                if (this.units[i] == null) {
                    this.units[i] = Units.dimensionless;
                }
                this.df[i] = (format = (String)this.bundle1.property("FORMAT", j)) == null ? this.units[i].getDatumFormatterFactory().defaultFormatter() : this.getDataFormatter(format, this.units[i]);
                this.labels[i] = (String)this.bundle1.property("LABEL", j);
                if (this.labels[i] == null) {
                    this.labels[i] = (String)this.bundle1.property("NAME", j);
                }
                ++i;
            }
        } else if (this.dep1 != null) {
            Units dep1Units = SemanticOps.getUnits(this.dep1);
            if (dep1Units == null) {
                dep1Units = Units.dimensionless;
            }
            int dep1len = this.dep1.rank() == 1 || SemanticOps.isBins(this.dep1) ? this.dep1.length() : this.dep1.length(0);
            for (int k = 0; k < dep1len; ++k) {
                this.units[i] = SemanticOps.getUnits(ds);
                this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
                if (this.dep1.rank() == 1) {
                    this.labels[i] = dep1Units.createDatum(this.dep1.value(k)).toString();
                } else if (SemanticOps.isBins(this.dep1)) {
                    DatumRange dr = DataSetUtil.asDatumRange(this.dep0.slice(k));
                    this.labels[i] = dr.toString();
                } else {
                    this.labels[i] = dep1Units.createDatum(this.dep1.value(0, k)).toString() + "*";
                }
                ++i;
            }
        }
        if (this.ds.rank() == 1) {
            this.labels[i] = (String)this.ds.property("LABEL");
            if (this.labels[i] == null) {
                this.labels[i] = "data";
            }
            this.units[i] = SemanticOps.getUnits(ds);
            this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
            if (!this.identifiesUnits(this.labels[i], this.units[i])) {
                int n = i;
                this.labels[n] = this.labels[n] + " (" + this.units[i] + ")";
            }
            ++i;
        }
        for (i = 0; i < this.units.length; ++i) {
            if (this.units[i] == null) {
                this.units[i] = Units.dimensionless;
                this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
            }
            if (this.labels[i] != null) continue;
            this.labels[i] = "col " + i;
        }
        String format = (String)ds.property("FORMAT");
        if (format != null) {
            FormatStringFormatter thedf = new FormatStringFormatter(format, false);
            for (i = 0; i < this.df.length; ++i) {
                this.df[i] = thedf;
            }
        }
    }

    private void editColumnAt(Point p) {
        int columnIndex = this.header.columnAtPoint(p);
        if (columnIndex != -1) {
            this.column = this.header.getColumnModel().getColumn(columnIndex);
            Rectangle columnRectangle = this.header.getHeaderRect(columnIndex);
            this.text.setText(this.column.getHeaderValue().toString());
            this.renamePopup.setPreferredSize(new Dimension(columnRectangle.width, columnRectangle.height - 1));
            this.renamePopup.show(this.header, columnRectangle.x, 0);
            this.text.requestFocusInWindow();
            this.text.selectAll();
        }
    }

    private void renameColumn() {
        this.column.setHeaderValue(this.text.getText());
        this.renamePopup.setVisible(false);
        this.header.repaint();
    }

    public MouseListener getTableHeaderMouseListener(JTable jTable1) {
        this.header = jTable1.getTableHeader();
        MouseAdapter result = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 1) {
                    QDataSetTableModel.this.editColumnAt(event.getPoint());
                }
            }
        };
        this.text = new JTextField();
        this.text.setBorder(null);
        this.text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QDataSetTableModel.this.renameColumn();
            }
        });
        this.renamePopup = new JPopupMenu();
        this.renamePopup.setBorder(new MatteBorder(0, 1, 1, 1, Color.DARK_GRAY));
        this.renamePopup.add(this.text);
        return result;
    }

    private DatumFormatter getDataFormatter(String df, Units u) {
        try {
            if (df.trim().isEmpty()) {
                return u.getDatumFormatterFactory().defaultFormatter();
            }
            if (!df.contains("%")) {
                df = "%" + df;
            }
            return new FormatStringFormatter(df, false);
        }
        catch (UnknownFormatConversionException ex) {
            logger.log(Level.FINER, null, ex);
            return u.getDatumFormatterFactory().defaultFormatter();
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINER, null, ex);
            return u.getDatumFormatterFactory().defaultFormatter();
        }
    }

    private boolean identifiesUnits(String s, Units u) {
        return s.contains(String.valueOf(u));
    }

    @Override
    public int getRowCount() {
        return this.ds.length();
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.dep0Offset) {
            if (this.dep0.rank() == 2) {
                DatumRange dr = DataSetUtil.asDatumRange(this.dep0.slice(rowIndex));
                return dr.toString();
            }
            Datum d = this.units[columnIndex].createDatum(this.dep0.value(rowIndex));
            return this.df[columnIndex].format(d, this.units[columnIndex]);
        }
        if (this.ds.rank() == 1) {
            if (this.wds.value(rowIndex) == 0.0) {
                return "fill (" + this.ds.value(rowIndex) + ")";
            }
            Datum d = this.units[columnIndex].createDatum(this.ds.value(rowIndex));
            return this.df[columnIndex].format(d, this.units[columnIndex]);
        }
        if (this.ds.rank() == 2) {
            if (this.wds.value(rowIndex, columnIndex - this.dep0Offset) == 0.0) {
                return "fill (" + this.ds.value(rowIndex, columnIndex - this.dep0Offset) + ")";
            }
            double d = this.ds.value(rowIndex, columnIndex - this.dep0Offset);
            if (d > -1.0E31) {
                Datum datum = this.units[columnIndex].createDatum(d);
                return this.df[columnIndex].format(datum, this.units[columnIndex]);
            }
            return "fill (" + d + ")";
        }
        return "?????";
    }

    public TableColumnModel getTableColumnModel() {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        QDataSet bds = (QDataSet)this.ds.property("BUNDLE_1");
        if (bds != null) {
            bds = DataSetOps.flattenBundleDescriptor(bds);
        }
        for (int i = 0; i < this.colCount; ++i) {
            String s;
            Units u;
            TableColumn c = new TableColumn(i);
            if (i < this.dep0Offset) {
                c.setHeaderValue(this.dep0.property("LABEL"));
                u = (Units)this.dep0.property("UNITS");
            } else {
                c.setHeaderValue(this.labels[i]);
                u = bds == null ? (Units)this.ds.property("UNITS") : (Units)bds.property("UNITS", i - this.dep0Offset);
            }
            c.setPreferredWidth(u != null && UnitsUtil.isTimeLocation(u) ? 150 : 80);
            c.setMinWidth(u != null && UnitsUtil.isTimeLocation(u) ? 130 : 80);
            if (u instanceof EnumerationUnits && this.ds.length() > 0 && (s = this.ds.slice(0).slice(i).toString()).length() > 14) {
                c.setPreferredWidth(Math.min(s.length() * 7, 600));
            }
            result.addColumn(c);
        }
        return result;
    }

    @Override
    public String getColumnName(int i) {
        if (i < this.dep0Offset) {
            return (String)this.dep0.property("LABEL");
        }
        return this.labels[i];
    }

    public static void main(String[] args) {
        QDataSet ds = BundleBinsDemo.demo1();
        QDataSetTableModel m = new QDataSetTableModel(ds);
        JTable t = new JTable();
        t.setModel(m);
        t.setColumnModel(m.getTableColumnModel());
        JFrame frame = new JFrame();
        frame.getContentPane().add(t);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

