/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.util.ValuesTreeModel;
import org.das2.util.DasMath;

public class PropertiesTreeModel
extends DefaultTreeModel {
    QDataSet ds;
    String dsLabel;
    MutableTreeNode mroot;

    public PropertiesTreeModel(QDataSet ds, int valuesSizeLimit) {
        this(null, ds, valuesSizeLimit);
    }

    public PropertiesTreeModel(String prefix, QDataSet ds, int valuesSizeLimit) {
        super(new DefaultMutableTreeNode((prefix == null ? "" : prefix) + DataSetUtil.toString(ds)));
        this.mroot = (MutableTreeNode)this.root;
        this.ds = ds;
        Map<String, Object> properties = DataSetUtil.getProperties(ds);
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            MutableTreeNode nextChild;
            String key = e.getKey();
            Object value = e.getValue();
            if (key.equals("QUBE") && (ds.rank() < 2 || ds.property("BUNDLE_1") != null)) continue;
            if (key.startsWith("BUNDLE_") && value instanceof QDataSet) {
                QDataSet bdsd = (QDataSet)value;
                StringBuilder svalue = new StringBuilder();
                svalue.append(key).append("=");
                if (bdsd.length() > 0) {
                    svalue.append(bdsd.property("NAME", 0));
                }
                for (int i = 1; i < bdsd.length(); ++i) {
                    svalue.append(",").append(bdsd.property("NAME", i));
                }
                BundleDescriptorTreeModel rm = new BundleDescriptorTreeModel(svalue.toString(), (QDataSet)value);
                nextChild = (MutableTreeNode)rm.getRoot();
            } else if (value instanceof QDataSet) {
                PropertiesTreeModel model = new PropertiesTreeModel(key + "=", (QDataSet)value, valuesSizeLimit);
                nextChild = (MutableTreeNode)model.getRoot();
            } else if (value.getClass().isArray()) {
                value.getClass().getComponentType();
                ArrayList<Object> list = new ArrayList<Object>();
                int nn = Math.min(Array.getLength(value), 5);
                for (int i = 0; i < nn; ++i) {
                    list.add(Array.get(value, i));
                }
                if (Array.getLength(value) > 5) {
                    list.add("...");
                }
                nextChild = new DefaultMutableTreeNode("" + key + "=" + list);
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                nextChild = (MutableTreeNode)new MapTreeModel(key + " (map)", (Map)value).getRoot();
            } else {
                String svalue = String.valueOf(value);
                if (value instanceof Number && (key.equals("VALID_MIN") || key.equals("VALID_MAX") || key.equals("TYPICAL_MIN") || key.equals("TYPICAL_MAX"))) {
                    Units u = (Units)properties.get("UNITS");
                    if (u != null && UnitsUtil.isTimeLocation(u)) {
                        svalue = u.isValid(((Number)value).doubleValue()) ? u.createDatum((Number)value).toString() + " (" + svalue + ")" : "fill (" + svalue + ")";
                    }
                } else if (key.equals("FILL_VALUE") && value instanceof Number) {
                    svalue = value instanceof Long || value instanceof Integer || value instanceof Short ? String.valueOf(value) : String.valueOf(DasMath.roundNSignificantDigits(((Number)value).doubleValue(), 6));
                }
                nextChild = new DefaultMutableTreeNode("" + key + "=" + svalue);
            }
            this.mroot.insert(nextChild, this.mroot.getChildCount());
        }
        if (ds.rank() > 0) {
            if (SemanticOps.isJoin(ds)) {
                int lin = 19;
                for (int i = 0; i < ds.length(); ++i) {
                    if (i < lin || i >= ds.length() - 3) {
                        QDataSet ds1 = ds.slice(i);
                        MutableTreeNode values = (MutableTreeNode)new PropertiesTreeModel(String.format("slice(%d)= ", i), ds1, valuesSizeLimit).getRoot();
                        this.mroot.insert(values, this.mroot.getChildCount());
                        continue;
                    }
                    if (i != lin) continue;
                    this.mroot.insert(new DefaultMutableTreeNode("..."), this.mroot.getChildCount());
                }
            } else {
                DefaultMutableTreeNode values = new DefaultMutableTreeNode("values");
                ValuesTreeModel.valuesTreeNode("value(", values, ds, valuesSizeLimit);
                this.mroot.insert(values, this.mroot.getChildCount());
            }
        }
    }

    private static class BundleDescriptorTreeModel
    extends DefaultTreeModel {
        public BundleDescriptorTreeModel(String label, QDataSet root) {
            super(new DefaultMutableTreeNode(root));
            MutableTreeNode mrt = (MutableTreeNode)this.getRoot();
            ((DefaultMutableTreeNode)mrt).setUserObject(label);
            for (int i = 0; i < root.length(); ++i) {
                PropertiesTreeModel m = new PropertiesTreeModel(root.slice(i), 20);
                mrt.insert((MutableTreeNode)m.getRoot(), mrt.getChildCount());
            }
        }
    }

    private static class MapTreeModel
    extends DefaultTreeModel {
        MapTreeModel(Object root, Map values) {
            super(new DefaultMutableTreeNode(root));
            MutableTreeNode mrt = (MutableTreeNode)this.getRoot();
            for (Map.Entry o : values.entrySet()) {
                Map.Entry val = o;
                Object value = val.getValue();
                if (value != null && value.getClass().isArray()) {
                    value.getClass().getComponentType();
                    ArrayList<Object> list = new ArrayList<Object>();
                    int nn = Math.min(Array.getLength(value), 5);
                    for (int i = 0; i < nn; ++i) {
                        list.add(Array.get(value, i));
                    }
                    if (Array.getLength(value) > 5) {
                        list.add("...");
                    }
                    DefaultMutableTreeNode nextChild = new DefaultMutableTreeNode("" + val.getKey() + "=" + list);
                    mrt.insert(nextChild, mrt.getChildCount());
                    continue;
                }
                if (value != null && Map.class.isAssignableFrom(value.getClass())) {
                    MutableTreeNode nextChild = (MutableTreeNode)new MapTreeModel(val.getKey(), (Map)value).getRoot();
                    mrt.insert(nextChild, mrt.getChildCount());
                    continue;
                }
                mrt.insert(new DefaultMutableTreeNode("" + val.getKey() + "=" + val.getValue()), mrt.getChildCount());
            }
        }
    }
}

