/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;

public class LinFit {
    private static final int ITMAX = 100;
    private static final double EPS = 3.0E-7;
    private static final double FPMIN = 1.0E-30;
    private double a;
    private double b;
    private double siga;
    private double sigb;
    private double chi2;
    private double q;
    private QDataSet x;
    private QDataSet y;
    private QDataSet sig;
    private int nData;
    private boolean doneErrors;
    double wt;
    double t;
    double sxoss;
    double sx = 0.0;
    double sy = 0.0;
    double st2 = 0.0;
    double ss;
    double sigdat;
    int mwt = 0;

    public LinFit(QDataSet x, QDataSet y) {
        FDataSet wds = FDataSet.createRank1(x.length());
        QDataSet wdsx = DataSetUtil.weightsDataSet(x);
        QDataSet wdsy = DataSetUtil.weightsDataSet(y);
        for (int i = 0; i < x.length(); ++i) {
            wds.putValue(i, wdsx.value(i) != 0.0 && wdsy.value(i) != 0.0 ? 1 : 0);
        }
        this.doFit(x, y, wds);
    }

    public LinFit(QDataSet x, QDataSet y, QDataSet sig) {
        this.doFit(x, y, sig);
    }

    private void doFit(QDataSet x, QDataSet y, QDataSet sig) {
        int i;
        if (x.rank() != 1 || y.rank() != 1) {
            throw new IllegalArgumentException("x and y must be rank 1");
        }
        this.x = x;
        this.y = y;
        this.nData = x.length();
        this.sig = sig;
        this.doneErrors = false;
        this.mwt = sig != null ? this.nData : 0;
        this.b = 0.0;
        if (this.mwt > 0) {
            this.ss = 0.0;
            for (i = 0; i < this.nData; ++i) {
                if (!(sig.value(i) > 0.0)) continue;
                this.wt = 1.0 / this.SQR(sig.value(i));
                this.ss += this.wt;
                this.sx += x.value(i) * this.wt;
                this.sy += y.value(i) * this.wt;
            }
        } else {
            for (i = 0; i < this.nData; ++i) {
                this.sx += x.value(i);
                this.sy += y.value(i);
            }
            this.ss = this.nData;
        }
        this.sxoss = this.sx / this.ss;
        if (this.mwt > 0) {
            for (i = 0; i < this.nData; ++i) {
                this.t = (x.value(i) - this.sxoss) / sig.value(i);
                this.st2 += this.t * this.t;
                this.b += this.t * y.value(i) / sig.value(i);
            }
        } else {
            for (i = 0; i < this.nData; ++i) {
                this.t = x.value(i) - this.sxoss;
                this.st2 += this.t * this.t;
                this.b += this.t * y.value(i);
            }
        }
        this.b /= this.st2;
        this.a = (this.sy - this.sx * this.b) / this.ss;
    }

    private void doErrors() {
        this.siga = Math.sqrt((1.0 + this.sx * this.sx / (this.ss * this.st2)) / this.ss);
        this.sigb = Math.sqrt(1.0 / this.st2);
        this.q = 0.0;
        this.chi2 = 0.0;
        if (this.nData <= 2) {
            return;
        }
        if (this.mwt == 0) {
            for (int i = 0; i < this.nData; ++i) {
                this.chi2 += this.SQR(this.y.value(i) - this.a - this.b * this.x.value(i));
            }
            this.q = 1.0;
            this.sigdat = Math.sqrt(this.chi2 / (double)(this.nData - 2));
            this.siga *= this.sigdat;
            this.sigb *= this.sigdat;
        } else {
            for (int i = 0; i < this.nData; ++i) {
                this.chi2 += this.SQR((this.y.value(i) - this.a - this.b * this.x.value(i)) / this.sig.value(i));
            }
            this.q = this.gammq(0.5 * (double)(this.nData - 2), 0.5 * this.chi2);
        }
        this.doneErrors = true;
    }

    public double getA() {
        if (!this.doneErrors) {
            this.doErrors();
        }
        return this.a;
    }

    public double getB() {
        if (!this.doneErrors) {
            this.doErrors();
        }
        return this.b;
    }

    public Datum getSlope() {
        Units xunits = SemanticOps.getUnits(this.x).getOffsetUnits();
        Units yunits = SemanticOps.getUnits(this.y).getOffsetUnits();
        return yunits.divide(this.getB(), 1, xunits);
    }

    public Datum getIntercept() {
        Units yunits = SemanticOps.getUnits(this.y).getOffsetUnits();
        return yunits.createDatum(this.getA());
    }

    public double getChi2() {
        if (!this.doneErrors) {
            this.doErrors();
        }
        return this.chi2;
    }

    public double getQ() {
        if (!this.doneErrors) {
            this.doErrors();
        }
        return this.q;
    }

    public double getSiga() {
        if (!this.doneErrors) {
            this.doErrors();
        }
        return this.siga;
    }

    public double getSigb() {
        if (!this.doneErrors) {
            this.doErrors();
        }
        return this.sigb;
    }

    double gammq(double a, double x) {
        Double gamser = 0.0;
        Double gammcf = 0.0;
        Double gln = 0.0;
        if (x < 0.0 || a <= 0.0) {
            return 0.0;
        }
        if (x < a + 1.0) {
            gamser = this.gser(gamser, a, x, gln);
            return 1.0 - gamser;
        }
        gammcf = this.gcf(gammcf, a, x, gln);
        return gammcf;
    }

    double gser(Double gamser, double a, double x, Double gln) {
        double sum;
        gln = this.gammln(a);
        if (x <= 0.0) {
            if (x < 0.0) {
                throw new IllegalArgumentException("x less than 0 in routine gser");
            }
            gamser = 0.0;
            return gamser;
        }
        double ap = a;
        double del = sum = 1.0 / a;
        for (int n = 1; n <= 100; ++n) {
            sum += (del *= x / (ap += 1.0));
            if (!(Math.abs(del) < Math.abs(sum) * 3.0E-7)) continue;
            gamser = sum * Math.exp(-x + a * Math.log(x) - gln);
            return gamser;
        }
        throw new IllegalArgumentException("a too large, ITMAX too small in routine gser");
    }

    double gcf(Double gammcf, double a, double x, Double gln) {
        double d;
        gln = this.gammln(a);
        double b = x + 1.0 - a;
        double c = 9.999999999999999E29;
        double h = d = 1.0 / b;
        for (int i = 1; i <= 100; ++i) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < 1.0E-30) {
                d = 1.0E-30;
            }
            if (Math.abs(c = b + an / c) < 1.0E-30) {
                c = 1.0E-30;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < 3.0E-7) break;
        }
        gammcf = Math.exp(-x + a * Math.log(x) - gln) * h;
        return gammcf;
    }

    double gammln(double xx) {
        double x;
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    private final double SQR(double f) {
        return f * f;
    }
}

