/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.ops.Ops;

public class Griddata {
    public static QDataSet griddata(QDataSet triangles, QDataSet itriangle, QDataSet weights, QDataSet zbuck) {
        ArrayDataSet result = ArrayDataSet.copy(Double.TYPE, itriangle);
        QubeDataSetIterator iter = new QubeDataSetIterator(itriangle);
        int nvert = triangles.length(0);
        assert (nvert <= 3);
        QDataSet weightsBuck = Ops.valid(zbuck);
        double fill = -1.0E38;
        while (iter.hasNext()) {
            iter.next();
            double itri = iter.getValue(itriangle);
            double s = 0.0;
            double w = 0.0;
            for (int i = 0; i < nvert; ++i) {
                double w1 = weights.value(iter.index(0), i);
                int itri1 = (int)triangles.value((int)itri, i);
                double wval = weightsBuck.value(itri1);
                if ((wval *= w1) > 0.0) {
                    double zval = zbuck.value(itri1);
                    w += wval;
                    s += wval * zval;
                    continue;
                }
                if (!(wval < 0.0)) continue;
                throw new IllegalArgumentException("negative weights not allowed at index " + iter.index(0));
            }
            if (w == 0.0) {
                iter.putValue(result, fill);
                continue;
            }
            iter.putValue(result, s / w);
        }
        DataSetUtil.copyDimensionProperties(zbuck, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet griddata(QDataSet xx, QDataSet yy, QDataSet buck) {
        throw new UnsupportedOperationException("not implemented");
    }

    public static QDataSet triangulate(QDataSet buck) {
        int nfree = buck.length(0);
        if (nfree == 1) {
            buck = Ops.unbundle(buck, 0);
            QDataSet ss = Ops.sort(buck);
            QDataSet result = Ops.bundle(ss.trim(0, ss.length() - 1), ss.trim(1, ss.length()));
            return result;
        }
        throw new IllegalArgumentException("nfree(" + nfree + ") must be one (for now)");
    }

    public static QDataSet triLocate(QDataSet buck, QDataSet tri, QDataSet grid) {
        int nfree = buck.length(0);
        if (nfree == 1) {
            ArrayDataSet result = ArrayDataSet.createRank1(Integer.TYPE, grid.length());
            buck = Ops.unbundle(buck, 0);
            block0: for (int i = 0; i < grid.length(); ++i) {
                double d = grid.value(i);
                result.putValue(i, -1.0E38);
                for (int j = 0; j < tri.length(); ++j) {
                    if (!(d >= buck.value((int)tri.value(j, 0))) || !(d < buck.value((int)tri.value(j, 1)))) continue;
                    result.putValue(i, j);
                    continue block0;
                }
            }
            return result;
        }
        throw new IllegalArgumentException("nfree(" + nfree + ") must be one (for now)");
    }

    public static QDataSet weights(QDataSet buck, QDataSet tri, QDataSet grid, QDataSet itri) {
        int nfree = buck.length(0);
        if (nfree == 1) {
            DDataSet result = DDataSet.createRank2(grid.length(), nfree + 1);
            buck = Ops.unbundle(buck, 0);
            for (int i = 0; i < grid.length(); ++i) {
                int itri1 = (int)itri.value(i);
                int tri1 = (int)tri.value(itri1, 0);
                int tri2 = (int)tri.value(itri1, 1);
                double len = Math.abs(buck.value(tri2) - buck.value(tri1));
                double l1 = grid.value(i, 0);
                result.putValue(i, 0, Math.abs(buck.value(tri2) - l1) / len);
                result.putValue(i, 1, Math.abs(l1 - buck.value(tri1)) / len);
            }
            return result;
        }
        throw new IllegalArgumentException("nfree(" + nfree + ") must be one (for now)");
    }
}

