/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.math.fft.ComplexArray;
import org.das2.qds.math.fft.GeneralFFT;
import org.das2.qds.ops.Ops;

public class FFTUtil {
    private static transient TTagBufElement freqDomainTagsForPowerBuf = null;

    public static QDataSet fftPower(GeneralFFT fft, QDataSet vds) {
        return FFTUtil.fftPower(fft, vds, FFTUtil.getWindowUnity(vds.length()));
    }

    public static QDataSet window(QDataSet ds, int size) {
        JoinDataSet jds = new JoinDataSet(2);
        JoinDataSet dep1 = new JoinDataSet(2);
        int idx = 0;
        DDataSet ttags = DDataSet.createRank1(ds.length() / size);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 == null) {
            dep0 = Ops.dindgen(ds.length());
        }
        ttags.putProperty("UNITS", SemanticOps.getUnits(dep0));
        DDataSet offsets = null;
        boolean qube = true;
        while (idx + size < ds.length()) {
            DDataSet offsets1 = DDataSet.createRank1(size);
            for (int i = 0; i < size; ++i) {
                offsets1.putValue(i, dep0.value(idx + i) - dep0.value(idx));
                if (offsets != null && offsets.value(i) != offsets1.value(i)) {
                    qube = false;
                }
                offsets = offsets1;
            }
            offsets1.putProperty("UNITS", SemanticOps.getUnits(dep0).getOffsetUnits());
            jds.join(DataSetOps.trim(ds, idx, size));
            dep1.join(offsets1);
            ttags.putValue(idx / size, dep0.value(idx));
            idx += size;
        }
        jds.putProperty("DEPEND_0", ttags);
        if (qube) {
            jds.putProperty("DEPEND_1", offsets);
        } else {
            jds.putProperty("DEPEND_1", dep1);
        }
        return jds;
    }

    public static QDataSet getWindowUnity(final int size) {
        AbstractDataSet unity = new AbstractDataSet(){

            @Override
            public int rank() {
                return 1;
            }

            @Override
            public int length() {
                return size;
            }

            @Override
            public double value(int i) {
                return 1.0;
            }
        };
        return unity;
    }

    public static QDataSet getWindow10PercentEdgeCosine(int size) {
        int i;
        int n = size;
        int maxlim = 410;
        int lim = Math.min(n / 10, maxlim);
        double[] ww = new double[n];
        double step = Math.PI / (double)lim;
        for (i = 0; i < lim; ++i) {
            ww[i] = (1.0 - Math.cos(step * (double)i)) / 2.0;
            ww[n - i - 1] = ww[i];
        }
        for (i = lim; i < size - lim; ++i) {
            ww[i] = 1.0;
        }
        return DDataSet.wrap(ww);
    }

    public static QDataSet getWindowHanning(int size) {
        int n = size;
        double[] ww = new double[n];
        for (int k = 0; k < size; ++k) {
            double eta = (double)k / (double)(size - 1);
            ww[k] = 1.0 - Math.cos(Math.PI * 2 * eta);
        }
        return DDataSet.wrap(ww);
    }

    public static QDataSet fftPower(GeneralFFT fft, QDataSet vds, QDataSet weights) {
        return FFTUtil.fftPower(fft, vds, weights, null);
    }

    public static QDataSet fftPower(GeneralFFT fft, QDataSet vds, QDataSet weights, QDataSet powxTags) {
        double binsize;
        Units xUnits;
        double[] yreal = new double[fft.size()];
        for (int i = 0; i < fft.size(); ++i) {
            yreal[i] = vds.value(i) * weights.value(i);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        if (powxTags == null) {
            QDataSet dep0 = (QDataSet)vds.property("DEPEND_0");
            if (dep0 == null) {
                dep0 = new IndexGenDataSet(vds.length());
            }
            powxTags = FFTUtil.getFrequencyDomainTagsForPower(dep0);
        }
        if ((xUnits = (Units)powxTags.property("UNITS")).isConvertibleTo(Units.hertz)) {
            UnitsConverter uc = xUnits.getConverter(Units.hertz);
            binsize = uc.convert(powxTags.value(0));
        } else {
            binsize = powxTags.value(0);
        }
        DDataSet result = DDataSet.createRank1(powxTags.length());
        for (int i1 = 0; i1 < result.length(); ++i1) {
            result.putValue(i1, 2.0 * ComplexArray.magnitude2(ca, i1 + 1) / binsize);
        }
        Units u = (Units)vds.property("UNITS");
        if (u != null && u.toString().equalsIgnoreCase("mV/m")) {
            for (int i = 0; i < result.length(); ++i) {
                result.putValue(i, result.value(i) / 1000000.0);
            }
            result.putProperty("UNITS", SemanticOps.lookupUnits("(V/m)^2/Hz"));
        }
        result.putProperty("DEPEND_0", powxTags);
        return result;
    }

    public static QDataSet fft(GeneralFFT fft, QDataSet vds, QDataSet weights) {
        double binsize;
        QDataSet xtags;
        Units xUnits;
        int i;
        double[] yreal = new double[fft.size()];
        if (weights == null) {
            for (i = 0; i < fft.size(); ++i) {
                yreal[i] = vds.value(i);
            }
        } else {
            for (i = 0; i < fft.size(); ++i) {
                yreal[i] = vds.value(i) * weights.value(i);
            }
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        QDataSet dep0 = (QDataSet)vds.property("DEPEND_0");
        if (dep0 == null) {
            dep0 = new IndexGenDataSet(vds.length());
        }
        if ((xUnits = (Units)(xtags = FFTUtil.getFrequencyDomainTags(dep0)).property("UNITS")).isConvertibleTo(Units.hertz)) {
            UnitsConverter uc = xUnits.getConverter(Units.hertz);
            binsize = 2.0 * uc.convert(xtags.value(xtags.length() / 2)) / (double)fft.size();
        } else {
            binsize = 2.0 * xtags.value(xtags.length() / 2) / (double)fft.size();
        }
        DDataSet result = DDataSet.createRank2(xtags.length(), 2);
        for (int i2 = 1; i2 < xtags.length(); ++i2) {
            result.putValue(i2, 0, ca.getReal(i2) / binsize);
            result.putValue(i2, 1, ca.getImag(i2) / binsize);
        }
        result.putProperty("DEPEND_0", xtags);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QDataSet getFrequencyDomainTagsForPower(QDataSet dep0) {
        Units xunits = SemanticOps.getUnits(dep0);
        if (dep0.length() < 2) {
            throw new IllegalArgumentException("dep0 must be two or more elements");
        }
        Class<FFTUtil> clazz = FFTUtil.class;
        synchronized (FFTUtil.class) {
            if (freqDomainTagsForPowerBuf != null && Math.abs(FFTUtil.freqDomainTagsForPowerBuf.dt - (dep0.value(1) - dep0.value(0))) < FFTUtil.freqDomainTagsForPowerBuf.ddt && FFTUtil.freqDomainTagsForPowerBuf.n == dep0.length() && FFTUtil.freqDomainTagsForPowerBuf.units == xunits) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return FFTUtil.freqDomainTagsForPowerBuf.data;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            QDataSet xtags = FFTUtil.getFrequencyDomainTags(dep0);
            Units xUnits = (Units)xtags.property("UNITS");
            DDataSet powTags = DDataSet.createRank1(xtags.length() / 2 - 1);
            for (int i = 1; i < xtags.length() / 2; ++i) {
                powTags.putValue(i - 1, xtags.value(i));
            }
            powTags.putProperty("UNITS", xUnits);
            powTags.putProperty("CADENCE", xtags.property("CADENCE"));
            Class<FFTUtil> clazz2 = FFTUtil.class;
            synchronized (FFTUtil.class) {
                TTagBufElement buf = new TTagBufElement();
                buf.data = powTags;
                buf.dt = dep0.value(1) - dep0.value(0);
                buf.ddt = buf.dt / 1.0E7;
                buf.n = dep0.length();
                buf.units = xunits;
                freqDomainTagsForPowerBuf = buf;
                // ** MonitorExit[var5_7] (shouldn't be in output)
                return powTags;
            }
        }
    }

    public static ComplexArray.Double fft(GeneralFFT fft, QDataSet vds) {
        ComplexArray.Double ca;
        if (vds.rank() == 2) {
            double[] yreal = new double[vds.length()];
            double[] yimag = new double[vds.length()];
            for (int i = 0; i < vds.length(); ++i) {
                yreal[i] = vds.value(i, 0);
                yimag[i] = vds.value(i, 1);
            }
            ca = ComplexArray.newArray(yreal, yimag);
        } else {
            double[] yreal = new double[vds.length()];
            for (int i = 0; i < vds.length(); ++i) {
                yreal[i] = vds.value(i);
            }
            ca = ComplexArray.newArray(yreal);
        }
        fft.transform(ca);
        return ca;
    }

    public static ComplexArray.Double ifft(GeneralFFT fft, QDataSet vds) {
        if (vds.rank() != 2) {
            throw new IllegalArgumentException("input must be rank 2: dataset[n;real,complex]");
        }
        double[] yreal = new double[vds.length()];
        for (int i = 0; i < vds.length(); ++i) {
            yreal[i] = vds.value(i, 0);
        }
        double[] yimag = new double[vds.length()];
        for (int i = 0; i < vds.length(); ++i) {
            yimag[i] = vds.value(i, 1);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal, yimag);
        fft.invTransform(ca);
        return ca;
    }

    public static double[] getFrequencyDomainTags(double fs, int size) {
        int i;
        double[] result = new double[size];
        int n = size;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = fs / (double)n * (double)i;
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = fs / (double)n * (double)(n21 - n + i);
        }
        return result;
    }

    public static QDataSet getTimeDomainTags(QDataSet frequencyDomainTags) {
        QDataSet nyquistFreq = frequencyDomainTags.slice(frequencyDomainTags.length() / 2);
        Datum dt = Ops.datum(Ops.divide(0.5, (Object)nyquistFreq));
        return Ops.taggen(0.0, dt.value(), frequencyDomainTags.length(), dt.getUnits());
    }

    public static QDataSet getFrequencyDomainTags(QDataSet timeDomainTags) {
        int i;
        double Tcheck;
        double T;
        Units timeUnit = (Units)timeDomainTags.property("UNITS");
        if (timeUnit == null) {
            timeUnit = Units.dimensionless;
        }
        QDataSet x = timeDomainTags;
        double[] result = new double[x.length()];
        result[0] = 0.0;
        int n = x.length();
        if (n > 120) {
            T = (x.value(n - 1) - x.value(0)) / (double)(n - 1);
            Tcheck = (x.value(60) - x.value(0)) / 60.0;
        } else {
            T = (x.value(n - 1) - x.value(0)) / (double)(n - 1);
            Tcheck = x.value(1) - x.value(0);
        }
        if (Math.abs((T - Tcheck) / T) > 0.001) {
            System.err.println("WARNING: timetags do not appear to be uniform: " + x);
        }
        int n21 = n / 2 + 1;
        Units frequencyUnit = UnitsUtil.getInverseUnit(timeUnit.getOffsetUnits());
        if (T > 0.5) {
            if (frequencyUnit == Units.megaHertz) {
                if (T > 1000.0) {
                    frequencyUnit = Units.hertz;
                    T /= 1000000.0;
                } else {
                    frequencyUnit = Units.kiloHertz;
                    T /= 1000.0;
                }
            } else if (frequencyUnit == Units.gigaHertz) {
                if (T > 1000000.0) {
                    frequencyUnit = Units.hertz;
                    T /= 1.0E9;
                } else {
                    frequencyUnit = Units.kiloHertz;
                    T /= 1000000.0;
                }
            }
        }
        for (i = 0; i < n21; ++i) {
            result[i] = (double)i / ((double)n * T);
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = (double)(n21 - n + i) / ((double)n * T);
        }
        DDataSet r = DDataSet.wrap(result);
        r.putProperty("CADENCE", DataSetUtil.asDataSet(1.0 / ((double)n * T), frequencyUnit));
        r.putProperty("UNITS", frequencyUnit);
        return r;
    }

    private static class TTagBufElement {
        QDataSet data;
        double dt;
        double ddt;
        int n;
        Units units;

        private TTagBufElement() {
        }
    }
}

