/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.util.Arrays;
import org.das2.datum.UnitsConverter;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;

public class BinAverage {
    private BinAverage() {
    }

    public static DDataSet rebin(QDataSet ds, QDataSet newTags0) {
        return BinAverage.binAverage(ds, newTags0);
    }

    public static DDataSet binAverage(QDataSet ds, QDataSet newTags0) {
        int i;
        QDataSet dstags = (QDataSet)ds.property("DEPEND_0");
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        DDataSet result = DDataSet.createRank1(newTags0.length());
        DDataSet weights = DDataSet.createRank1(newTags0.length());
        int ibin = -1;
        for (i = 0; i < ds.length(); ++i) {
            ibin = DataSetUtil.closest(newTags0, dstags.value(i), ibin);
            double d = ds.value(i);
            double w = wds.value(i);
            double s = result.value(ibin);
            result.putValue(ibin, s + d * w);
            double n = weights.value(ibin);
            weights.putValue(ibin, n + w);
        }
        for (i = 0; i < result.length(); ++i) {
            if (weights.value(i) > 0.0) {
                result.putValue(i, result.value(i) / weights.value(i));
                continue;
            }
            result.putValue(i, fill);
        }
        weights.putProperty("DEPEND_0", newTags0);
        result.putProperty("DEPEND_0", newTags0);
        result.putProperty("FILL_VALUE", fill);
        result.putProperty("WEIGHTS", weights);
        return result;
    }

    public static DDataSet rebin(QDataSet ds, QDataSet newTags0, QDataSet newTags1) {
        return BinAverage.binAverage(ds, newTags0, newTags1);
    }

    public static DDataSet binAverage(QDataSet ds, QDataSet newTags0, QDataSet newTags1) {
        int i;
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("ds must be rank2");
        }
        if (SemanticOps.isBundle(ds)) {
            return BinAverage.rebinBundle(ds, newTags0, newTags1);
        }
        QDataSet dstags0 = (QDataSet)ds.property("DEPEND_0");
        if (dstags0 == null) {
            throw new IllegalArgumentException("expected ds to have DEPEND_0");
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("FILL_VALUE")).doubleValue();
        DDataSet result = DDataSet.createRank2(newTags0.length(), newTags1.length());
        DDataSet weights = DDataSet.createRank2(newTags0.length(), newTags1.length());
        QDataSet ibin1CacheDs = null;
        int[] ibins1 = null;
        int ibin0 = -1;
        for (i = 0; i < ds.length(); ++i) {
            int j;
            ibin0 = DataSetUtil.closest(newTags0, dstags0.value(i), ibin0);
            QDataSet dstags1 = (QDataSet)ds.property("DEPEND_1", i);
            if (dstags1 != ibin1CacheDs) {
                ibins1 = new int[dstags1.length()];
                Arrays.fill(ibins1, -1);
                for (j = 0; j < dstags1.length(); ++j) {
                    ibins1[j] = DataSetUtil.closest(newTags1, dstags1.value(j), ibins1[j]);
                }
                ibin1CacheDs = dstags1;
            }
            for (j = 0; j < dstags1.length(); ++j) {
                int ibin1 = ibins1[j];
                double d = ds.value(i, j);
                double w = wds.value(i, j);
                double s = result.value(ibin0, ibin1);
                result.putValue(ibin0, ibin1, s + w * d);
                double n = weights.value(ibin0, ibin1);
                weights.putValue(ibin0, ibin1, n + w);
            }
        }
        for (i = 0; i < result.length(); ++i) {
            for (int j = 0; j < result.length(i); ++j) {
                if (weights.value(i, j) > 0.0) {
                    result.putValue(i, j, result.value(i, j) / weights.value(i, j));
                    continue;
                }
                result.putValue(i, j, fill);
            }
        }
        weights.putProperty("DEPEND_0", newTags0);
        weights.putProperty("DEPEND_1", newTags1);
        result.putProperty("DEPEND_0", newTags0);
        result.putProperty("DEPEND_1", newTags1);
        result.putProperty("FILL_VALUE", fill);
        result.putProperty("WEIGHTS", weights);
        return result;
    }

    private static boolean isLinearlySpaced(QDataSet dep0, double xscal, double xbase) {
        int nx = dep0.length();
        for (int i = 0; i < nx; ++i) {
            if ((int)((dep0.value(i) - xbase) / xscal) == i) continue;
            return false;
        }
        return true;
    }

    public static DDataSet rebinBundle(QDataSet ds, QDataSet dep0, QDataSet dep1, QDataSet dep2) {
        return BinAverage.binAverageBundle(ds, dep0, dep1, dep2);
    }

    public static DDataSet binAverageBundle(QDataSet ds, QDataSet dep0, QDataSet dep1, QDataSet dep2) {
        double zbase;
        double ybase;
        double xbase;
        DDataSet sresult = DDataSet.createRank3(dep0.length(), dep1.length(), dep2.length());
        IDataSet nresult = IDataSet.createRank3(dep0.length(), dep1.length(), dep2.length());
        QDataSet wds = DataSetUtil.weightsDataSet(DataSetOps.slice1(ds, 3));
        double xscal = dep0.value(1) - dep0.value(0);
        if (!BinAverage.isLinearlySpaced(dep0, xscal, xbase = dep0.value(0) - xscal / 2.0)) {
            throw new IllegalArgumentException("dep0 must be uniformly spaced.");
        }
        double yscal = dep1.value(1) - dep1.value(0);
        if (!BinAverage.isLinearlySpaced(dep1, yscal, ybase = dep1.value(0) - yscal / 2.0)) {
            throw new IllegalArgumentException("dep1 must be uniformly spaced.");
        }
        double zscal = dep2.value(1) - dep2.value(0);
        if (!BinAverage.isLinearlySpaced(dep2, zscal, zbase = dep2.value(0) - zscal / 2.0)) {
            throw new IllegalArgumentException("dep2 must be uniformly spaced.");
        }
        int nx = dep0.length();
        int ny = dep1.length();
        int nz = dep2.length();
        if (ds.length() > 0) {
            UnitsConverter xuc = SemanticOps.getLooseUnitsConverter(ds.slice(0).slice(0), dep0);
            UnitsConverter yuc = SemanticOps.getLooseUnitsConverter(ds.slice(0).slice(1), dep1);
            UnitsConverter zuc = SemanticOps.getLooseUnitsConverter(ds.slice(0).slice(2), dep2);
            for (int ids = 0; ids < ds.length(); ++ids) {
                double w = wds.value(ids);
                if (!(w > 0.0)) continue;
                double x = xuc.convert(ds.value(ids, 0));
                double y = yuc.convert(ds.value(ids, 1));
                double z = zuc.convert(ds.value(ids, 2));
                double f = ds.value(ids, 3);
                int i = (int)((x - xbase) / xscal);
                int j = (int)((y - ybase) / yscal);
                int k = (int)((z - zbase) / zscal);
                if (i < 0 || j < 0 || k < 0 || i >= nx || j >= ny || k >= nz) continue;
                sresult.putValue(i, j, k, f + sresult.value(i, j, k));
                nresult.putValue(i, j, k, w + nresult.value(i, j, k));
            }
        }
        double fill = -1.0E31;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                for (int k = 0; k < nz; ++k) {
                    int n = (int)nresult.value(i, j, k);
                    if (n > 0) {
                        sresult.putValue(i, j, k, sresult.value(i, j, k) / (double)n);
                        continue;
                    }
                    sresult.putValue(i, j, k, fill);
                }
            }
        }
        DataSetUtil.copyDimensionProperties(ds, sresult);
        nresult.putProperty("DEPEND_0", dep0);
        nresult.putProperty("DEPEND_1", dep1);
        nresult.putProperty("DEPEND_2", dep2);
        sresult.putProperty("DEPEND_0", dep0);
        sresult.putProperty("DEPEND_1", dep1);
        sresult.putProperty("DEPEND_2", dep2);
        sresult.putProperty("FILL_VALUE", fill);
        sresult.putProperty("WEIGHTS", nresult);
        sresult.putProperty("RENDER_TYPE", "nnSpectrogram");
        return sresult;
    }

    public static DDataSet rebinBundle(QDataSet ds, QDataSet dep0, QDataSet dep1) {
        return BinAverage.binAverageBundle(ds, dep0, dep1);
    }

    public static DDataSet binAverageBundle(QDataSet ds, QDataSet dep0, QDataSet dep1) {
        DDataSet sresult = DDataSet.createRank2(dep0.length(), dep1.length());
        IDataSet nresult = IDataSet.createRank2(dep0.length(), dep1.length());
        QDataSet wds = DataSetUtil.weightsDataSet(DataSetOps.slice1(ds, 2));
        double xscal = dep0.value(1) - dep0.value(0);
        double xbase = dep0.value(0) - xscal / 2.0;
        int nx = dep0.length();
        for (int i = 0; i < nx; ++i) {
            if ((int)((dep0.value(i) - xbase) / xscal) == i) continue;
            throw new IllegalArgumentException("dep0 must be uniformly spaced.");
        }
        double yscal = dep1.value(1) - dep1.value(0);
        double ybase = dep1.value(0) - yscal / 2.0;
        int ny = dep1.length();
        for (int i = 0; i < ny; ++i) {
            if ((int)((dep1.value(i) - ybase) / yscal) == i) continue;
            throw new IllegalArgumentException("dep1 must be uniformly spaced.");
        }
        if (ds.length() > 0) {
            UnitsConverter xuc = SemanticOps.getLooseUnitsConverter(ds.slice(0).slice(0), dep0);
            UnitsConverter yuc = SemanticOps.getLooseUnitsConverter(ds.slice(0).slice(1), dep1);
            for (int ids = 0; ids < ds.length(); ++ids) {
                double w = wds.value(ids);
                if (!(w > 0.0)) continue;
                double x = xuc.convert(ds.value(ids, 0));
                double y = yuc.convert(ds.value(ids, 1));
                double z = ds.value(ids, 2);
                int i = (int)((x - xbase) / xscal);
                int j = (int)((y - ybase) / yscal);
                if (i < 0 || j < 0 || i >= nx || j >= ny) continue;
                sresult.putValue(i, j, z + sresult.value(i, j));
                nresult.putValue(i, j, w + nresult.value(i, j));
            }
        }
        double fill = -1.0E31;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                int n = (int)nresult.value(i, j);
                if (n > 0) {
                    sresult.putValue(i, j, sresult.value(i, j) / (double)n);
                    continue;
                }
                sresult.putValue(i, j, fill);
            }
        }
        DataSetUtil.copyDimensionProperties(ds, sresult);
        nresult.putProperty("DEPEND_0", dep0);
        nresult.putProperty("DEPEND_1", dep1);
        sresult.putProperty("DEPEND_0", dep0);
        sresult.putProperty("DEPEND_1", dep1);
        sresult.putProperty("FILL_VALUE", fill);
        sresult.putProperty("WEIGHTS", nresult);
        sresult.putProperty("RENDER_TYPE", "nnSpectrogram");
        return sresult;
    }

    public static QDataSet residuals(QDataSet ds, int boxcarSize) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("rank must be 1");
        }
        DDataSet mean = BinAverage.boxcar(ds, boxcarSize);
        QDataSet dres = Ops.pow((Object)Ops.subtract(ds, mean), (Object)2);
        QDataSet var = Ops.sqrt(BinAverage.boxcar(dres, boxcarSize));
        QDataSet res = Ops.divide(Ops.abs(Ops.subtract(ds, mean)), var);
        return res;
    }

    public static DDataSet boxcar(QDataSet ds, int size) {
        double w;
        double d;
        int i;
        int nn = ds.length();
        int s2 = size / 2;
        int s3 = s2 + size % 2;
        if (ds.rank() != 1) {
            if (SemanticOps.isRank2Waveform(ds)) {
                DDataSet result = (DDataSet)ArrayDataSet.createRank2(Double.TYPE, ds.length(), ds.length(0));
                for (int i2 = 0; i2 < ds.length(); ++i2) {
                    DDataSet r1 = BinAverage.boxcar(ds.slice(i2), size);
                    DDataSet.copyElements(r1, 0, result, i2, r1.length());
                }
                return result;
            }
            throw new IllegalArgumentException("dataset must be rank 1");
        }
        if (ds.length() < size) {
            throw new IllegalArgumentException("dataset length is less than window size");
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        DDataSet sums = DDataSet.createRank1(nn);
        DataSetUtil.putProperties(DataSetUtil.getProperties(ds), sums);
        DDataSet weights = DDataSet.createRank1(nn);
        double runningSum = 0.0;
        double runningWeight = 0.0;
        for (i = 0; i < size; ++i) {
            d = ds.value(i);
            w = wds.value(i);
            sums.putValue(i, d);
            weights.putValue(i, w);
            runningSum += d * w;
            runningWeight += w;
        }
        for (i = s2; i < nn - s3; ++i) {
            sums.putValue(i, runningSum);
            weights.putValue(i, runningWeight);
            double d0 = ds.value(i - s2);
            double w0 = wds.value(i - s2);
            double d2 = ds.value(i - s2 + size);
            double w2 = wds.value(i - s2 + size);
            runningSum += d2 * w2 - d0 * w0;
            runningWeight += w2 - w0;
        }
        for (i = nn - s3; i < nn; ++i) {
            d = ds.value(i);
            w = wds.value(i);
            sums.putValue(i, d);
            weights.putValue(i, w);
        }
        DDataSet result = sums;
        Number fill = (Number)wds.property("SUGGEST_FILL");
        if (fill == null) {
            fill = -1.0E31;
        }
        for (int i3 = 0; i3 < nn; ++i3) {
            w = weights.value(i3);
            if (w > 0.0) {
                double s = result.value(i3);
                result.putValue(i3, s / w);
                continue;
            }
            result.putValue(i3, fill.doubleValue());
        }
        result.putProperty("WEIGHTS", weights);
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet rebin(QDataSet ds, int n0) {
        DDataSet result = DDataSet.createRank1(n0);
        DDataSet weights = DDataSet.createRank1(n0);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        int binSize0 = ds.length() / n0;
        double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
        for (int i0 = 0; i0 < n0; ++i0) {
            int j0 = i0 * binSize0;
            double s = 0.0;
            double w = 0.0;
            for (int k0 = 0; k0 < binSize0; ++k0) {
                double w1 = wds.value(j0 + k0);
                if (!(w1 > 0.0)) continue;
                w += w1;
                s += w1 * ds.value(j0 + k0);
            }
            weights.putValue(i0, w);
            result.putValue(i0, w == 0.0 ? fill : s / w);
        }
        result.putProperty("WEIGHTS", weights);
        result.putProperty("FILL_VALUE", fill);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", BinAverage.rebin(dep0, binSize0));
        }
        DataSetUtil.copyDimensionProperties(ds, result);
        return result;
    }

    public static QDataSet rebin(QDataSet ds, int n0, int n1) {
        QDataSet dep1;
        DDataSet result = DDataSet.createRank2(n0, n1);
        DDataSet weights = DDataSet.createRank2(n0, n1);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
        int binSize0 = ds.length() / n0;
        int binSize1 = ds.length(0) / n1;
        if (binSize0 == 0) {
            throw new IllegalArgumentException("rebin can only be used to reduce data");
        }
        if (binSize1 == 0) {
            throw new IllegalArgumentException("rebin can only be used to reduce data");
        }
        for (int i0 = 0; i0 < n0; ++i0) {
            for (int i1 = 0; i1 < n1; ++i1) {
                int j0 = i0 * binSize0;
                int j1 = i1 * binSize1;
                double s = 0.0;
                double w = 0.0;
                for (int k0 = 0; k0 < binSize0; ++k0) {
                    for (int k1 = 0; k1 < binSize1; ++k1) {
                        double w1 = wds.value(j0 + k0, j1 + k1);
                        if (!(w1 > 0.0)) continue;
                        w += w1;
                        s += w1 * ds.value(j0 + k0, j1 + k1);
                    }
                }
                weights.putValue(i0, i1, w);
                result.putValue(i0, i1, w == 0.0 ? fill : s / w);
            }
        }
        result.putProperty("WEIGHTS", weights);
        result.putProperty("FILL_VALUE", fill);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", BinAverage.rebin(dep0, n0));
        }
        if ((dep1 = (QDataSet)ds.property("DEPEND_1")) != null) {
            if (dep1.rank() != 1) {
                throw new IllegalArgumentException("dep1 must be rank 1");
            }
            result.putProperty("DEPEND_1", BinAverage.rebin(dep1, n1));
        }
        DataSetUtil.copyDimensionProperties(ds, result);
        return result;
    }

    public static QDataSet rebin(QDataSet ds, int n0, int n1, int n2) {
        QDataSet dep2;
        QDataSet dep1;
        DDataSet result = DDataSet.createRank3(n0, n1, n2);
        DDataSet weights = DDataSet.createRank3(n0, n1, n2);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
        int binSize0 = ds.length() / n0;
        int binSize1 = ds.length(0) / n1;
        int binSize2 = ds.length(0, 0) / n2;
        if (binSize0 == 0) {
            throw new IllegalArgumentException("rebin can only be used to reduce data");
        }
        if (binSize1 == 0) {
            throw new IllegalArgumentException("rebin can only be used to reduce data");
        }
        if (binSize2 == 0) {
            throw new IllegalArgumentException("rebin can only be used to reduce data");
        }
        for (int i0 = 0; i0 < n0; ++i0) {
            for (int i1 = 0; i1 < n1; ++i1) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    int j0 = i0 * binSize0;
                    int j1 = i1 * binSize1;
                    int j2 = i2 * binSize2;
                    double s = 0.0;
                    double w = 0.0;
                    for (int k0 = 0; k0 < binSize0; ++k0) {
                        for (int k1 = 0; k1 < binSize1; ++k1) {
                            for (int k2 = 0; k2 < binSize2; ++k2) {
                                double w1 = wds.value(j0 + k0, j1 + k1, j2 + k2);
                                if (!(w1 > 0.0)) continue;
                                w += w1;
                                s += w1 * ds.value(j0 + k0, j1 + k1, j2 + k2);
                            }
                        }
                    }
                    weights.putValue(i0, i1, i2, w);
                    result.putValue(i0, i1, i2, w == 0.0 ? fill : s / w);
                }
            }
        }
        result.putProperty("WEIGHTS", weights);
        result.putProperty("FILL_VALUE", fill);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", BinAverage.rebin(dep0, n0));
        }
        if ((dep1 = (QDataSet)ds.property("DEPEND_1")) != null) {
            if (dep1.rank() != 1) {
                throw new IllegalArgumentException("dep1 must be rank 1");
            }
            result.putProperty("DEPEND_1", BinAverage.rebin(dep1, n1));
        }
        if ((dep2 = (QDataSet)ds.property("DEPEND_2")) != null) {
            if (dep2.rank() != 1) {
                throw new IllegalArgumentException("dep2 must be rank 1");
            }
            result.putProperty("DEPEND_2", BinAverage.rebin(dep2, n2));
        }
        DataSetUtil.copyDimensionProperties(ds, result);
        return result;
    }
}

