/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.das2.datum.Datum;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;

public class AsciiFormatter {
    public void formatToFile(File f, QDataSet ... dss) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(f);){
            if (dss.length == 0) {
                throw new IllegalArgumentException("at least one dataset, please");
            }
            int n = dss[0].length();
            for (int i = 0; i < n; ++i) {
                int ifield = 0;
                for (QDataSet ds : dss) {
                    if (ds.rank() == 2) {
                        for (int j = 0; j < ds.length(i); ++j) {
                            if (ifield > 0) {
                                fout.write(44);
                            }
                            fout.write(String.valueOf(ds.value(i, j)).getBytes());
                            ++ifield;
                        }
                        continue;
                    }
                    if (ds.rank() != 1) continue;
                    if (ifield > 0) {
                        fout.write(44);
                    }
                    Datum d = DataSetUtil.asDatum(ds.slice(i));
                    String s = d.getUnits().getDatumFormatterFactory().defaultFormatter().format(d, d.getUnits());
                    fout.write(s.getBytes());
                    ++ifield;
                }
                fout.write(10);
            }
        }
    }

    public void formatToFile(String f, QDataSet ... dss) throws IOException {
        this.formatToFile(new File(f), dss);
    }

    public void formatToFile(File f, QDataSet ds) throws IOException {
        this.formatToFile(f, new QDataSet[]{ds});
    }

    public void formatToFile(String f, QDataSet ds) throws IOException {
        this.formatToFile(new File(f), new QDataSet[]{ds});
    }

    public void formatToFile(String f, double[][] dd) throws IOException {
        JoinDataSet jds = new JoinDataSet(2);
        for (double[] dd1 : dd) {
            DDataSet ds = DDataSet.wrap(dd1);
            jds.join(ds);
        }
        this.formatToFile(new File(f), (QDataSet)jds);
    }
}

