/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanelUtil;
import org.das2.qds.ops.Ops;

public class TrimFilterEditorPanel
extends AbstractFilterEditorPanel {
    public static final String PROP_REGEX = "\\|trim\\(\\s*(\\S+)\\s*\\,\\s*(\\S+)\\s*\\)";
    public static final String PROP_TRIMI_REGEX = "\\|trim(\\d)\\(\\s*(\\S+)\\s*\\,\\s*(\\S+)\\s*\\)";
    private boolean automaticSetting = true;
    private JComboBox dimensionCB;
    private JLabel endLabel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JTextField lowerBound;
    private JTextField upperBound;

    public TrimFilterEditorPanel() {
        this.initComponents();
    }

    public static void main(String[] args) {
        TrimFilterEditorPanel filter = new TrimFilterEditorPanel();
        QDataSet ds = Ops.ripplesTimeSeries(1440);
        int dataSize = TrimFilterEditorPanel.getDataSetSize(ds);
        filter.setFilter("|trim(0," + dataSize + ")");
        filter.setInput(ds);
        JOptionPane.showMessageDialog(null, filter);
        System.err.println(filter.getFilter());
    }

    private static int getDataSetSize(QDataSet ds) {
        int dataSize = ds.length();
        return dataSize;
    }

    @Override
    public void setInput(QDataSet ds) {
        if (this.automaticSetting) {
            this.endLabel.setText(String.format("Up to but not including (%d bins):", ds.length()));
        }
        String[] depNames1 = FilterEditorPanelUtil.getDimensionNames(ds);
        int index = this.dimensionCB.getSelectedIndex();
        this.dimensionCB.setModel(new DefaultComboBoxModel<String>(depNames1));
        this.dimensionCB.setSelectedIndex(index);
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile(PROP_REGEX);
        Matcher m = p.matcher(filter);
        Pattern p2 = Pattern.compile(PROP_TRIMI_REGEX);
        Matcher m2 = p2.matcher(filter);
        if (m.matches()) {
            this.lowerBound.setText(m.group(1));
            this.upperBound.setText(m.group(2));
            this.automaticSetting = false;
            this.dimensionCB.setSelectedIndex(0);
        } else if (m2.matches()) {
            this.lowerBound.setText(m2.group(2));
            this.upperBound.setText(m2.group(3));
            this.automaticSetting = false;
            this.dimensionCB.setSelectedIndex(Integer.parseInt(m2.group(1)));
        } else {
            this.lowerBound.setText("0");
            this.upperBound.setText("10");
            this.dimensionCB.setSelectedIndex(0);
            this.automaticSetting = true;
        }
    }

    @Override
    public String getFilter() {
        String upperBoundPoint = this.upperBound.getText().replaceAll("\\s", "");
        String lowerBoundPoint = this.lowerBound.getText().replaceAll("\\s", "");
        if (this.dimensionCB.getSelectedIndex() == 0) {
            return "|trim(" + lowerBoundPoint + "," + upperBoundPoint + ")";
        }
        if (this.dimensionCB.getSelectedIndex() == 1) {
            return "|trim" + this.dimensionCB.getSelectedIndex() + "(" + lowerBoundPoint + "," + upperBoundPoint + ")";
        }
        return "|trim(" + this.dimensionCB.getSelectedIndex() + "," + lowerBoundPoint + "," + upperBoundPoint + ")";
    }

    private void initComponents() {
        this.endLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.upperBound = new JTextField();
        this.lowerBound = new JTextField();
        this.jLabel1 = new JLabel();
        this.dimensionCB = new JComboBox();
        this.endLabel.setText("Up to but not including:");
        this.endLabel.setToolTipText("Negative indeces are allowed, so -1 refers to the last index.  Blank may be used to include the last index.");
        this.jLabel3.setText("Trim from (index or Datum):");
        this.jLabel3.setToolTipText("index of the first element, and negative indices are relative to the end.  A datum may be used as well.");
        this.upperBound.setText("-1");
        this.lowerBound.setText("0");
        this.jLabel1.setText("Trim Dimension:");
        this.dimensionCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dimensionCB, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.endLabel).addComponent(this.jLabel3)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lowerBound).addComponent(this.upperBound, -1, 163, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dimensionCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.lowerBound, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endLabel).addComponent(this.upperBound, -2, -1, -2)).addGap(19, 19, 19)));
    }
}

