/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.das2.qds.filters.AddFilterDialog;

public class TooltipKeeper {
    private static TooltipKeeper instance = null;
    DefaultMutableTreeNode tree;

    public static TooltipKeeper getInstance() {
        if (instance == null) {
            instance = new TooltipKeeper();
        }
        return instance;
    }

    private TooltipKeeper() {
        try (InputStream in = AddFilterDialog.class.getResourceAsStream("filters.xml");){
            this.tree = AddFilterDialog.build(in);
        }
        catch (IOException ex) {
            this.tree = null;
        }
    }

    private String getTooltipFor(String filter, DefaultMutableTreeNode root) {
        Object o = root.getUserObject();
        if (o instanceof AddFilterDialog.Bookmark) {
            AddFilterDialog.Bookmark b = (AddFilterDialog.Bookmark)o;
            String t = b.filter;
            if (t.length() > 0) {
                int i = t.indexOf(40);
                if (i == -1) {
                    i = t.length();
                }
                if (t.substring(0, i).equals(filter)) {
                    return b.description;
                }
            }
        }
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            String s = this.getTooltipFor(filter, (DefaultMutableTreeNode)children.nextElement());
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public String getTooltipFor(String filter) {
        int i = filter.indexOf(40);
        filter = filter.substring(0, i);
        return this.getTooltipFor(filter, this.tree);
    }
}

