/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanelUtil;
import org.das2.qds.filters.FiltersChainPanel;

public class SlicesFilterEditorPanel
extends AbstractFilterEditorPanel
implements FilterEditorPanel {
    static final long t0 = System.currentTimeMillis();
    int[] qube = null;
    JSpinner[] spinners = new JSpinner[8];
    JCheckBox[] checkboxs = new JCheckBox[8];
    int rank = 8;

    public SlicesFilterEditorPanel() {
        this.setFilter("|slices(:)");
    }

    @Override
    public String getFilter() {
        logger.fine("getFilter");
        StringBuilder result = new StringBuilder("|slices(");
        for (int i = 0; i < this.rank; ++i) {
            String sep;
            String string = sep = i == 0 ? "" : ",";
            if (this.checkboxs[i].isSelected()) {
                result.append(sep).append(this.spinners[i].getValue());
                continue;
            }
            result.append(sep).append("':'");
        }
        result.append(")");
        return result.toString();
    }

    private JPanel getDimensionPanel(final int i, String s) throws NumberFormatException {
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        final JCheckBox cb1 = new JCheckBox("Index" + i + ":");
        cb1.setToolTipText("slice on this dimension");
        p1.add(cb1);
        this.checkboxs[i] = cb1;
        cb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlicesFilterEditorPanel.this.spinners[i].setEnabled(cb1.isSelected());
            }
        });
        p1.add(Box.createHorizontalStrut(14));
        JSpinner sp1 = new JSpinner();
        if (sp1.getEditor() instanceof JFormattedTextField) {
            ((JFormattedTextField)sp1.getEditor()).setColumns(10);
        }
        SlicesFilterEditorPanel.addMouseWheelListenerToSpinner(sp1);
        this.spinners[i] = sp1;
        if (s.startsWith("'") && s.endsWith("'")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.equals(":")) {
            sp1.setEnabled(false);
            cb1.setSelected(false);
        } else {
            sp1.setValue(Integer.parseInt(s));
            cb1.setSelected(true);
        }
        p1.add(sp1);
        p1.add(Box.createGlue());
        return p1;
    }

    private static void addMouseWheelListenerToSpinner(final JSpinner sliceIndexSpinner) {
        sliceIndexSpinner.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                int maxIndex;
                Number nmax;
                SpinnerNumberModel snm = (SpinnerNumberModel)sliceIndexSpinner.getModel();
                int newIndex = snm.getNumber().intValue() - evt.getWheelRotation();
                if (newIndex < 0) {
                    newIndex = 0;
                }
                if ((nmax = (Number)((Object)snm.getMaximum())) != null && newIndex > (maxIndex = nmax.intValue())) {
                    newIndex = maxIndex;
                }
                snm.setValue(newIndex);
            }
        });
    }

    @Override
    public final void setFilter(String filter) {
        logger.log(Level.FINE, "setFilter {0}", filter);
        Pattern p = Pattern.compile("\\|slices\\((.*)\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            String arg = m.group(1);
            String[] ss = arg.split(",");
            this.rank = ss.length;
            this.removeAll();
            this.setLayout(new BoxLayout(this, 1));
            for (int i = 0; i < this.rank; ++i) {
                this.add(this.getDimensionPanel(i, ss[i]));
            }
        }
    }

    @Override
    public void setInput(QDataSet ds) {
        int i;
        logger.log(Level.FINE, "setInput {0}", ds.toString());
        String[] depNames1 = FilterEditorPanelUtil.getDimensionNames(ds);
        int rmCount = this.rank - ds.rank();
        this.rank = ds.rank();
        for (i = 0; i < this.rank; ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (this.checkboxs[i] == null) {
                this.add(this.getDimensionPanel(i, ":"));
            }
            this.checkboxs[i].setText(depNames1[i]);
            this.checkboxs[i].setToolTipText("slice on " + depNames1[i]);
            int max = dep == null ? Integer.MAX_VALUE : (dep.rank() == 1 ? dep.length() : (dep.rank() == 2 ? dep.length(0) : Integer.MAX_VALUE));
            int val = (Integer)this.spinners[i].getValue();
            if (val < 0) {
                val = 0;
            }
            if (val >= max) {
                val = max;
            }
            this.spinners[i].setModel(new SpinnerNumberModel(val, 0, max, 1));
        }
        for (i = ds.rank(); i < ds.rank() + rmCount; ++i) {
            try {
                this.remove(i);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        for (i = 0; i < this.rank - 4; ++i) {
            this.checkboxs[i].setEnabled(false);
        }
    }

    public static void main(String[] args) {
        SlicesFilterEditorPanel filter = new SlicesFilterEditorPanel();
        QDataSet ds = FiltersChainPanel.getExampleDataSet("qube");
        filter.setFilter("|slices(0,:)");
        filter.setInput(ds);
        JOptionPane.showMessageDialog(null, filter);
        System.err.println(filter.getFilter());
    }
}

