/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanelUtil;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class SliceFilterEditorPanel
extends AbstractFilterEditorPanel
implements FilterEditorPanel {
    static final long t0 = System.currentTimeMillis();
    int[] qube = null;
    int sliceByDatumIndex = -1;
    WeakReference<QDataSet> inputDs = null;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton sliceAtDatumButton;
    private JTextField sliceAtDatumTF;
    private JRadioButton sliceAtIndexButton;
    private JComboBox sliceDimensionCB;
    private JSpinner sliceIndexSpinner;
    private BindingGroup bindingGroup;

    public SliceFilterEditorPanel() {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.WARNING, "called off event thread");
        }
        this.initComponents();
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.sliceIndexSpinner);
        editor.getFormat().setGroupingUsed(false);
        this.sliceIndexSpinner.setEditor(editor);
        this.setName("sliceFilterEditorPanel" + String.format("%04d", (System.currentTimeMillis() - t0) / 100L));
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.sliceDimensionCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.sliceIndexSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.sliceAtDatumTF = new JTextField();
        this.sliceAtIndexButton = new JRadioButton();
        this.sliceAtDatumButton = new JRadioButton();
        this.sliceDimensionCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sliceDimensionCB.setName("sliceDimensionCB");
        this.sliceDimensionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliceFilterEditorPanel.this.sliceDimensionCBActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Index:");
        this.jLabel1.setToolTipText("Index of the slice");
        this.sliceIndexSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.sliceIndexSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SliceFilterEditorPanel.this.sliceIndexSpinnerStateChanged(evt);
            }
        });
        this.sliceIndexSpinner.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SliceFilterEditorPanel.this.sliceIndexSpinnerMouseWheelMoved(evt);
            }
        });
        this.jLabel2.setText("Slice Dimension:");
        this.sliceAtDatumTF.setText("2000-01-01T00:00:00.000Z");
        this.sliceAtDatumTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliceFilterEditorPanel.this.sliceAtDatumTFActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.sliceAtIndexButton);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.sliceIndexSpinner, (Property)ELProperty.create((String)"${enabled}"), (Object)this.sliceAtIndexButton, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.buttonGroup1.add(this.sliceAtDatumButton);
        this.sliceAtDatumButton.setToolTipText("Slice at time or datum location");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.sliceAtDatumTF, (Property)ELProperty.create((String)"${enabled}"), (Object)this.sliceAtDatumButton, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliceDimensionCB, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.sliceAtIndexButton).addGap(3, 3, 3).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliceIndexSpinner, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliceAtDatumButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliceAtDatumTF, -1, 197, Short.MAX_VALUE))).addGap(12, 12, 12)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sliceDimensionCB, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sliceAtIndexButton).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.sliceIndexSpinner, -2, -1, -2)).addComponent(this.sliceAtDatumTF, -2, -1, -2).addComponent(this.sliceAtDatumButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void sliceDimensionCBActionPerformed(ActionEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.WARNING, "called off event thread");
        }
        LoggerManager.logGuiEvent(evt);
        String ff = this.getFilter();
        logger.log(Level.FINEST, "0: {0}{1}", new Object[]{ff, this.getName()});
        this.firePropertyChange("filter", null, ff);
        int idx = this.sliceDimensionCB.getSelectedIndex();
        if (this.qube != null) {
            SpinnerNumberModel snm = (SpinnerNumberModel)this.sliceIndexSpinner.getModel();
            snm.setMaximum(Integer.valueOf(this.qube[idx] - 1));
            if (snm.getNumber().intValue() >= this.qube[idx]) {
                snm.setValue(this.qube[idx] - 1);
            }
        }
        if (this.sliceByDatumIndex != idx) {
            this.sliceAtIndexButton.setSelected(true);
            this.sliceByDatumIndex = idx;
        }
        this.updateFeedback();
    }

    private void sliceIndexSpinnerStateChanged(ChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.WARNING, "called off event thread");
        }
        LoggerManager.logGuiEvent(evt);
        String ff = this.getFilter();
        logger.log(Level.FINEST, "1: {0}{1}", new Object[]{ff, this.getName()});
        this.firePropertyChange("filter", null, ff);
        this.updateFeedback();
    }

    private void sliceIndexSpinnerMouseWheelMoved(MouseWheelEvent evt) {
        int maxIndex;
        Number nmax;
        SpinnerNumberModel snm;
        int newIndex;
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.WARNING, "called off event thread");
        }
        if ((newIndex = (snm = (SpinnerNumberModel)this.sliceIndexSpinner.getModel()).getNumber().intValue() - evt.getWheelRotation()) < 0) {
            newIndex = 0;
        }
        if ((nmax = (Number)((Object)snm.getMaximum())) != null && newIndex > (maxIndex = nmax.intValue())) {
            newIndex = maxIndex;
        }
        snm.setValue(newIndex);
        this.updateFeedback();
    }

    private void sliceAtDatumTFActionPerformed(ActionEvent evt) {
        this.updateFeedback();
    }

    private void updateFeedback() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                QDataSet dep;
                QDataSet ds;
                int dim = SliceFilterEditorPanel.this.sliceDimensionCB.getSelectedIndex();
                boolean na = true;
                if (SliceFilterEditorPanel.this.inputDs != null && (ds = (QDataSet)SliceFilterEditorPanel.this.inputDs.get()) != null && (dep = (QDataSet)ds.property("DEPEND_" + dim)) != null && dep.rank() == 1) {
                    if (SliceFilterEditorPanel.this.getIndexMode()) {
                        int index = (Integer)SliceFilterEditorPanel.this.sliceIndexSpinner.getValue();
                        String s = DataSetUtil.asDatum(dep.slice(index)).toString();
                        SliceFilterEditorPanel.this.sliceAtDatumTF.setText(s);
                        na = false;
                    } else {
                        String t = SliceFilterEditorPanel.this.sliceAtDatumTF.getText();
                        Units depu = SemanticOps.getUnits(dep);
                        try {
                            if (t != null) {
                                Datum dt = depu.parse(t);
                                int i = DataSetUtil.closestIndex(dep, dt);
                                Object o = SliceFilterEditorPanel.this.sliceIndexSpinner.getValue();
                                if (o != null && o instanceof Integer) {
                                    int i0 = (Integer)o;
                                    if (i0 != i) {
                                        SliceFilterEditorPanel.this.sliceIndexSpinner.setValue(i);
                                    }
                                } else {
                                    SliceFilterEditorPanel.this.sliceIndexSpinner.setValue(i);
                                }
                            }
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(SliceFilterEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                if (na && SliceFilterEditorPanel.this.getIndexMode()) {
                    SliceFilterEditorPanel.this.sliceAtDatumTF.setText("N/A");
                    SliceFilterEditorPanel.this.sliceAtDatumTF.setToolTipText("value is not available");
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private boolean getIndexMode() {
        return !this.sliceAtDatumButton.isSelected();
    }

    private static boolean checkIndexMode(String filter) {
        Pattern p = Pattern.compile("\\|slice(\\d)\\((\\d+)\\)");
        Matcher m = p.matcher(filter);
        return m.matches();
    }

    @Override
    public String getFilter() {
        String s;
        logger.fine("getFilter");
        this.updateFeedback();
        if (this.getIndexMode()) {
            s = String.format("|slice%d(%d)", this.sliceDimensionCB.getSelectedIndex(), (Integer)this.sliceIndexSpinner.getValue());
        } else {
            String pos = this.sliceAtDatumTF.getText().replaceAll("\\s+", "");
            s = String.format("|slice%d('%s')", this.sliceDimensionCB.getSelectedIndex(), pos);
        }
        logger.log(Level.FINER, "getFilter() -> {0}", s);
        return s;
    }

    @Override
    public void setFilter(String filter) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.WARNING, "called off event thread");
        }
        logger.log(Level.FINE, "setFilter {0}", filter);
        Pattern p = Pattern.compile("\\|slice(\\d)\\((\\d+)\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            int dim = Integer.parseInt(m.group(1));
            int index = Integer.parseInt(m.group(2));
            this.sliceDimensionCB.setSelectedIndex(dim);
            this.sliceIndexSpinner.setValue(index);
            this.sliceAtIndexButton.setSelected(true);
            this.sliceByDatumIndex = dim;
        } else {
            Pattern p2 = Pattern.compile("\\|slice(\\d)\\(\\'(\\S+)\\'\\)");
            Matcher m2 = p2.matcher(filter);
            if (m2.matches()) {
                int dim = Integer.parseInt(m2.group(1));
                String at = m2.group(2);
                this.sliceDimensionCB.setSelectedIndex(dim);
                this.sliceAtDatumTF.setText(at);
                this.sliceAtDatumTF.setEditable(true);
                this.sliceAtDatumButton.setSelected(true);
                this.sliceByDatumIndex = dim;
            }
        }
    }

    @Override
    public void setInput(QDataSet ds) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.WARNING, "called off event thread");
        }
        String oldFilter = this.getFilter();
        logger.log(Level.FINE, "setInput {0}", ds.toString());
        this.inputDs = new WeakReference<QDataSet>(ds);
        String[] depNames1 = FilterEditorPanelUtil.getDimensionNames(ds);
        switch (depNames1.length) {
            case 2: {
                logger.log(Level.FINE, "got depNames: {0},{1}", new Object[]{depNames1[0], depNames1[1]});
                break;
            }
            case 3: {
                logger.log(Level.FINE, "got depNames: {0},{1},{2}", new Object[]{depNames1[0], depNames1[1], depNames1[2]});
                break;
            }
            case 4: {
                logger.log(Level.FINE, "got depNames: {0},{1},{2},{3}", new Object[]{depNames1[0], depNames1[1], depNames1[2], depNames1[3]});
                break;
            }
            default: {
                logger.log(Level.FINE, "got depNames in setInput ");
            }
        }
        int idx = this.sliceDimensionCB.getSelectedIndex();
        this.sliceDimensionCB.setModel(new DefaultComboBoxModel<String>(depNames1));
        this.qube = DataSetUtil.qubeDims(ds);
        if (this.qube != null && idx < this.qube.length) {
            ((SpinnerNumberModel)this.sliceIndexSpinner.getModel()).setMaximum(Integer.valueOf(this.qube[idx] - 1));
            int index = (Integer)this.sliceIndexSpinner.getValue();
            if (index > this.qube[idx] - 1) {
                this.sliceIndexSpinner.setValue(this.qube[idx] - 1);
            }
        }
        try {
            this.sliceDimensionCB.setSelectedIndex(idx);
        }
        catch (IllegalArgumentException ex) {
            this.sliceDimensionCB.setSelectedIndex(0);
        }
        String newFilter = this.getFilter();
        if (!oldFilter.equals(newFilter)) {
            this.firePropertyChange("filter", oldFilter, newFilter);
        }
    }

    @Override
    public boolean validateFilter(String filter, QDataSet in) {
        if (in == null) {
            return true;
        }
        this.qube = DataSetUtil.qubeDims(in);
        logger.log(Level.FINE, "setFilter {0}", filter);
        Pattern p = Pattern.compile("\\|slice(\\d)\\((\\d+)\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            int dim = Integer.parseInt(m.group(1));
            int index = Integer.parseInt(m.group(2));
            if (dim == 0) {
                return in.length() > index;
            }
            if (dim >= this.qube.length) {
                return false;
            }
            return this.qube[dim] > index;
        }
        return true;
    }
}

