/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.layout.GroupLayout;

public class ReducexFilterEditorPanel
extends AbstractFilterEditorPanel {
    public JLabel jLabel1;
    public JTextField scalarTF;
    public JComboBox unitsCB;

    public ReducexFilterEditorPanel() {
        this.initComponents();
        Units tu = Units.seconds;
        Units[] array = tu.getOffsetUnits().getConvertibleUnits();
        this.unitsCB.setModel(new DefaultComboBoxModel<Units>(array));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.scalarTF = new JTextField();
        this.unitsCB = new JComboBox();
        this.jLabel1.setText("Reduce data to intervals of:  ");
        this.scalarTF.setText("1");
        this.scalarTF.setPreferredSize(new Dimension(30, 27));
        this.unitsCB.setEditable(true);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.scalarTF, -1, 48, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.unitsCB, -2, 136, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.scalarTF, -2, -1, -2).add((Component)this.unitsCB, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void setFilter(String filter) {
        block7: {
            Pattern p = Pattern.compile("\\|reducex\\('(.*)'\\)");
            Matcher m = p.matcher(filter);
            if (m.matches()) {
                try {
                    Datum d = DatumUtil.parse(m.group(1));
                    double dv = d.doubleValue(d.getUnits());
                    if (dv == (double)((int)dv)) {
                        this.scalarTF.setText(String.valueOf((int)dv));
                    } else {
                        this.scalarTF.setText(String.valueOf(dv));
                    }
                    this.unitsCB.setSelectedItem(d.getUnits());
                }
                catch (ParseException ex) {
                    Pattern p2 = Pattern.compile("\\|reducex\\('?(\\d+)\\s*(\\S+)'?\\)");
                    Matcher m2 = p2.matcher(filter);
                    if (m2.matches()) {
                        this.scalarTF.setText(m.group(1));
                        this.unitsCB.setSelectedItem(Units.lookupUnits(m.group(2)));
                        break block7;
                    }
                    this.scalarTF.setText("1");
                    this.unitsCB.setSelectedItem(Units.hours);
                }
            } else {
                this.scalarTF.setText("1");
                this.unitsCB.setSelectedItem(Units.hours);
            }
        }
    }

    @Override
    public String getFilter() {
        return "|reducex('" + this.scalarTF.getText() + "" + this.unitsCB.getSelectedItem() + "')";
    }

    @Override
    public void setInput(QDataSet ds) {
        QDataSet dep0 = SemanticOps.xtagsDataSet(ds);
        Units tu = SemanticOps.getUnits(dep0);
        Units[] array = tu.getOffsetUnits().getConvertibleUnits();
        Object u = this.unitsCB.getSelectedItem();
        this.unitsCB.setModel(new DefaultComboBoxModel<Units>(array));
        this.unitsCB.setSelectedItem(u);
    }
}

