/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.layout.GroupLayout;

public class MedianFilterEditorPanel
extends AbstractFilterEditorPanel {
    public JLabel jLabel1;
    public JTextField sizeTF;

    public MedianFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.sizeTF = new JTextField();
        FormListener formListener = new FormListener();
        this.setToolTipText("The median boxcar size can be between 5 and n/2, where n is the length of the data");
        this.jLabel1.setText("Median Boxcar Size:  ");
        this.sizeTF.setText("5");
        this.sizeTF.setPreferredSize(new Dimension(50, 27));
        this.sizeTF.addActionListener(formListener);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 156, -2).addPreferredGap(0).add((Component)this.sizeTF, -2, -1, -2).addContainerGap(46, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.sizeTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sizeTFActionPerformed(ActionEvent evt) {
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile("\\|medianFilter\\((.*)\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.sizeTF.setText(m.group(1));
        } else {
            this.sizeTF.setText("5");
        }
        this.sizeTF.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                int i;
                String t = ((JTextField)input).getText();
                try {
                    i = Integer.parseInt(t);
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                return i > 4 && i < 10000;
            }
        });
    }

    @Override
    public String getFilter() {
        return "|medianFilter(" + this.sizeTF.getText() + ")";
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == MedianFilterEditorPanel.this.sizeTF) {
                MedianFilterEditorPanel.this.sizeTFActionPerformed(evt);
            }
        }
    }
}

