/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.AddFilterDialog;
import org.das2.qds.filters.AddFilterEditorPanel;
import org.das2.qds.filters.AnyFilterEditorPanel;
import org.das2.qds.filters.ButterworthFilterEditorPanel;
import org.das2.qds.filters.CollapseFilterEditorPanel;
import org.das2.qds.filters.ContourFilterEditorPanel;
import org.das2.qds.filters.DbAboveBackgroundDim1FilterEditorPanel;
import org.das2.qds.filters.DetrendFilterEditorPanel;
import org.das2.qds.filters.DivideFilterEditorPanel;
import org.das2.qds.filters.FftPowerFilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanel;
import org.das2.qds.filters.GetPropertyEditorPanel;
import org.das2.qds.filters.HanningFilterEditorPanel;
import org.das2.qds.filters.Histogram2dFilterEditorPanel;
import org.das2.qds.filters.HistogramFilterEditorPanel;
import org.das2.qds.filters.MedianFilterEditorPanel;
import org.das2.qds.filters.MultiplyFilterEditorPanel;
import org.das2.qds.filters.NoArgFilterEditorPanel;
import org.das2.qds.filters.NormalizeFilterEditorPanel;
import org.das2.qds.filters.PowFilterEditorPanel;
import org.das2.qds.filters.PutPropertyFilterEditorPanel;
import org.das2.qds.filters.ReducexFilterEditorPanel;
import org.das2.qds.filters.SetDepend0CadenceFilterEditorPanel;
import org.das2.qds.filters.SetDepend0UnitsFilterEditorPanel;
import org.das2.qds.filters.SetDepend1CadenceFilterEditorPanel;
import org.das2.qds.filters.SetUnitsFilterEditorPanel;
import org.das2.qds.filters.SingleArgumentEditorPanel;
import org.das2.qds.filters.SliceFilterEditorPanel;
import org.das2.qds.filters.SlicesFilterEditorPanel;
import org.das2.qds.filters.SmoothFilterEditorPanel;
import org.das2.qds.filters.SubtractFilterEditorPanel;
import org.das2.qds.filters.TooltipKeeper;
import org.das2.qds.filters.TotalFilterEditorPanel;
import org.das2.qds.filters.TrimFilterEditorPanel;
import org.das2.qds.filters.UnbundleFilterEditorPanel;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.TickleTimer;
import org.das2.util.WindowManager;
import org.das2.util.monitor.NullProgressMonitor;

public final class FiltersChainPanel
extends JPanel
implements FilterEditorPanel {
    private QDataSet inputDs;
    private String currentFilter = null;
    private FilterEditorPanel currentFilterPanel = null;
    private boolean implicitUnbundle = false;
    private final TickleTimer timer;
    private final Timer recalculatingTimer;
    private static final Logger logger = LoggerManager.getLogger("qdataset.filters");
    private static final String CLASS_NAME = FiltersChainPanel.class.getName();
    private final Color backgroundColor;
    private HashSet<String> adjusting = new HashSet();
    List<FilterEditorPanel> editors = new LinkedList<FilterEditorPanel>();
    List<QDataSet> results = new LinkedList<QDataSet>();
    List<String> resultFilters = new LinkedList<String>();
    List<Boolean> recalculating = new LinkedList<Boolean>();
    private JScrollPane scrollPane;
    private final FocusListener lostFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            logger.log(Level.FINE, "focusGained {0}", e.getComponent().getName());
            FiltersChainPanel.this.currentFilterPanel = FiltersChainPanel.this.getFilterEditorPanelParent(e.getComponent());
        }

        @Override
        public void focusLost(FocusEvent e) {
            logger.log(Level.FINE, "focusLost {0}", e.getComponent().getName());
            FilterEditorPanel c = FiltersChainPanel.this.getFilterEditorPanelParent(e.getComponent());
            FilterEditorPanel n = FiltersChainPanel.this.getFilterEditorPanelParent(e.getOppositeComponent());
            if (c == null) {
                return;
            }
            if (c != FiltersChainPanel.this.currentFilterPanel || c != n) {
                FiltersChainPanel.this.updateSoon(null);
                FiltersChainPanel.this.currentFilterPanel = c;
            } else {
                logger.log(Level.FINER, "... already up to date");
            }
        }
    };
    private final ActionListener requestUpdateListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.log(Level.FINE, "requestUpdateFrom {0}", e.getSource());
            FiltersChainPanel.this.updateSoon(null);
        }
    };
    private final ChangeListener requestChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            FiltersChainPanel.this.updateSoon(null);
        }
    };
    private boolean addSubtractButtons = true;
    public static final String PROP_ADDSUBTRACTBUTTONS = "addSubtractButtons";

    public FiltersChainPanel() {
        logger.entering(CLASS_NAME, "<init>");
        this.initComponents();
        this.backgroundColor = this.getBackground();
        this.setLayout(new BoxLayout(this, 1));
        this.timer = new TickleTimer(50L, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FiltersChainPanel.this.updateImmediately();
            }
        });
        this.recalculatingTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiltersChainPanel.this.indicateRecalculating();
            }
        });
        this.recalculatingTimer.setRepeats(false);
        this.setFilter("");
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.scrollPane);
    }

    private FilterEditorPanel getEditorFor(String f, FilterEditorPanel recyclable) {
        JPanel result;
        logger.entering(CLASS_NAME, "getEditorFor", f);
        if (!f.startsWith("|")) {
            f = "|" + f;
        }
        if (!f.contains("(") && !f.endsWith(")")) {
            f = f + "()";
        }
        String srecyclable = recyclable == null ? null : recyclable.getFilter();
        int i = f.indexOf("(");
        if (i == -1) {
            i = f.length();
        }
        if (srecyclable != null && srecyclable.startsWith(f.substring(0, i))) {
            assert (recyclable != null);
            logger.log(Level.FINE, "recycling to provide {0}", f);
            if (!srecyclable.equals(f)) {
                recyclable.setFilter(f);
            }
            return recyclable;
        }
        logger.log(Level.FINE, "creating new editor panel for {0}", f);
        if (f.matches("\\|add\\((.*)\\)")) {
            result = new AddFilterEditorPanel();
        } else if (f.matches("\\|subtract\\((.*)\\)")) {
            result = new SubtractFilterEditorPanel();
        } else if (f.matches("\\|butterworth\\((\\d),(\\S+),(\\S+)\\)")) {
            result = new ButterworthFilterEditorPanel();
        } else if (f.matches("\\|butterworth\\((\\d),(\\S+),(\\S+),(\\S+)\\)")) {
            result = new ButterworthFilterEditorPanel();
        } else if (f.matches("\\|collapse(\\d)\\(\\)")) {
            result = new CollapseFilterEditorPanel();
        } else if (f.matches("\\|contour\\((.*)\\)")) {
            result = new ContourFilterEditorPanel();
        } else if (f.matches("\\|detrend\\((.*)\\)")) {
            result = new DetrendFilterEditorPanel();
        } else if (f.matches("\\|divide\\((.*)\\)")) {
            result = new DivideFilterEditorPanel();
        } else if (f.matches("\\|fftPower\\((\\d+),(\\d),'?(\\S+)'?\\)")) {
            result = new FftPowerFilterEditorPanel();
        } else if (f.matches("\\|hanning\\((.*)\\)")) {
            result = new HanningFilterEditorPanel();
        } else if (f.matches("\\|medianFilter\\((.*)\\)")) {
            result = new MedianFilterEditorPanel();
        } else if (f.matches("\\|multiply\\((.*)\\)")) {
            result = new MultiplyFilterEditorPanel();
        } else if (f.matches("\\|reducex\\('?(\\d+)\\s?(\\S+)'?\\)")) {
            result = new ReducexFilterEditorPanel();
        } else if (f.matches("\\|setDepend0Cadence\\('?(\\d+)\\s*(\\w+)'?\\)")) {
            result = new SetDepend0CadenceFilterEditorPanel();
        } else if (f.matches("\\|setDepend1Cadence\\('?(\\d+)\\s*(\\w*)'?\\)")) {
            result = new SetDepend1CadenceFilterEditorPanel();
        } else if (f.matches("\\|setDepend0Units\\('(\\S+)'\\)")) {
            result = new SetDepend0UnitsFilterEditorPanel();
        } else if (f.matches("\\|setUnits\\('(\\S+)'\\)")) {
            result = new SetUnitsFilterEditorPanel();
        } else if (f.matches("\\|slice(\\d)\\((\\d+)\\)")) {
            result = new SliceFilterEditorPanel();
        } else if (f.matches("\\|slice(\\d)\\(\\'(\\S+)\\'\\)")) {
            if (recyclable instanceof SliceFilterEditorPanel) {
                recyclable.setFilter(f);
                return recyclable;
            }
            result = new SliceFilterEditorPanel();
        } else {
            result = f.matches("\\|cos\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|sin\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|total(\\d)\\(()\\)") ? new TotalFilterEditorPanel() : (f.matches("\\|slices\\((.*)\\)") ? new SlicesFilterEditorPanel() : (f.matches("\\|smooth\\(\\d+\\)") ? new SmoothFilterEditorPanel() : (f.matches("\\|smoothfit\\(\\d+\\)") ? new SmoothFilterEditorPanel() : (f.matches("\\|histogram\\(\\)") ? new HistogramFilterEditorPanel() : (f.matches("\\|histogram\\((\\S+),(\\S+),(\\S+)\\)") ? new HistogramFilterEditorPanel() : (f.matches("\\|histogram2d\\(((\\d+),(\\d+)(,(.+),(.+))?)?\\)") ? new Histogram2dFilterEditorPanel() : (f.matches("\\|unbundle\\('?(\\w+)'?\\)") ? new UnbundleFilterEditorPanel() : (f.matches("\\|dbAboveBackgroundDim1\\((\\S+)\\)") ? new DbAboveBackgroundDim1FilterEditorPanel() : (f.matches("\\|normalize\\((.*)\\)") ? new NormalizeFilterEditorPanel() : (f.matches("\\|transpose\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|toDegrees\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|toRadians\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|valid\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|extent\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|diff\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|sqrt\\(\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|flattenWaveform\\(.*\\)") ? new NoArgFilterEditorPanel() : (f.matches("\\|pow\\(.*\\)") ? new PowFilterEditorPanel() : (f.matches("\\|getProperty\\((.*)\\)") ? new GetPropertyEditorPanel() : (f.matches("\\|putProperty\\((.*)\\)") ? new PutPropertyFilterEditorPanel() : (f.matches("\\|setValidRange\\((.*)\\)") ? new SingleArgumentEditorPanel("setValidRange", "Valid Range", "The limits of valid data (inclusive)", new String[]{"", "-1e31 to 1e31", "0 to 100"}) : (f.matches("\\|setFillValue\\((.*)\\)") ? new SingleArgumentEditorPanel("setFillValue", "Fill Value", "Numerical value marking invalid data", new String[]{"", "-1e31", "0", "-1"}) : (f.matches("\\|putProperty\\((.*)\\)") ? new PutPropertyFilterEditorPanel() : (f.matches("\\|trim\\(\\s*(\\S+)\\s*\\,\\s*(\\S+)\\s*\\)") ? new TrimFilterEditorPanel() : (f.matches("\\|trim(\\d)\\(\\s*(\\S+)\\s*\\,\\s*(\\S+)\\s*\\)") ? new TrimFilterEditorPanel() : new AnyFilterEditorPanel())))))))))))))))))))))))))));
        }
        result.setFilter(f);
        String tooltip = TooltipKeeper.getInstance().getTooltipFor(f);
        if (tooltip != null) {
            result.getPanel().setToolTipText(tooltip);
        }
        return result;
    }

    @Override
    public String getFilter() {
        logger.entering(CLASS_NAME, "getFilter");
        final StringBuilder b = new StringBuilder();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ArrayList<FilterEditorPanel> leditors = new ArrayList<FilterEditorPanel>(FiltersChainPanel.this.editors);
                boolean ifilter = false;
                for (FilterEditorPanel p : leditors) {
                    if (!ifilter && p instanceof UnbundleFilterEditorPanel && FiltersChainPanel.this.implicitUnbundle) {
                        b.append(((UnbundleFilterEditorPanel)p).getComponent());
                        continue;
                    }
                    b.append(p.getFilter());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Logger.getLogger(FiltersChainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return b.toString();
    }

    private void deleteFilter(int fi) {
        FilterEditorPanel p = this.editors.remove(fi);
        this.removeFocusListeners(p.getPanel());
        this.setFilter(this.getFilter());
        this.resetFilterInput();
        this.updateSoon(this.getFilter());
    }

    private void resetFilterInput() {
        QDataSet inputDs1 = this.inputDs;
        this.setInput(null);
        this.setInput(inputDs1);
    }

    private FilterEditorPanel getFilterEditorPanelParent(Component c) {
        while (c != null && !(c instanceof FilterEditorPanel)) {
            c = c.getParent();
        }
        if (c == null) {
            return null;
        }
        return (FilterEditorPanel)((Object)c);
    }

    private void addFilterNew(int idx) {
        AddFilterDialog afd = new AddFilterDialog();
        int r = WindowManager.showConfirmDialog(this, afd, "Add Operation", 2);
        if (r == 0) {
            String ss = afd.getValue();
            FilterEditorPanel filter1 = this.getEditorFor(ss, null);
            filter1.getPanel().addFocusListener(this.lostFocusListener);
            this.addFocusListeners(filter1.getPanel());
            this.editors.add(idx, filter1);
            String filter = this.getFilter();
            this.setFilter(filter);
            this.resetFilterInput();
            this.updateSoon(filter);
        }
    }

    private void addFocusListeners(JPanel p) {
        for (Component c : p.getComponents()) {
            c.addFocusListener(this.lostFocusListener);
            if (c instanceof JTextField) {
                ((JTextField)c).addActionListener(this.requestUpdateListener);
                continue;
            }
            if (c instanceof JComboBox) {
                ((JComboBox)c).addActionListener(this.requestUpdateListener);
                continue;
            }
            if (c instanceof JSpinner) {
                ((JSpinner)c).addChangeListener(this.requestChangeListener);
                continue;
            }
            if (c instanceof AbstractButton) {
                ((AbstractButton)c).addActionListener(this.requestUpdateListener);
                continue;
            }
            if (!(c instanceof JPanel)) continue;
            this.addFocusListeners((JPanel)c);
        }
    }

    private void removeFocusListeners(JPanel p) {
        for (Component c : p.getComponents()) {
            c.removeFocusListener(this.lostFocusListener);
            if (c instanceof JTextField) {
                ((JTextField)c).removeActionListener(this.requestUpdateListener);
                continue;
            }
            if (c instanceof JComboBox) {
                ((JComboBox)c).removeActionListener(this.requestUpdateListener);
                continue;
            }
            if (c instanceof JSpinner) {
                ((JSpinner)c).removeChangeListener(this.requestChangeListener);
                continue;
            }
            if (c instanceof AbstractButton) {
                ((AbstractButton)c).removeChangeListener(this.requestChangeListener);
                continue;
            }
            if (!(c instanceof JPanel)) continue;
            this.addFocusListeners((JPanel)c);
        }
    }

    public boolean isAddSubtractButtons() {
        return this.addSubtractButtons;
    }

    public void setAddSubtractButtons(boolean addSubtractButtons) {
        boolean oldAddSubtractButtons = this.addSubtractButtons;
        this.addSubtractButtons = addSubtractButtons;
        String filter = this.getFilter();
        this.setFilter(null);
        this.setFilter(filter);
        this.firePropertyChange(PROP_ADDSUBTRACTBUTTONS, oldAddSubtractButtons, addSubtractButtons);
    }

    private JPanel onePanel(final int fi) {
        JPanel pp;
        logger.entering(CLASS_NAME, "onePanel", fi);
        final JPanel sub = new JPanel(new BorderLayout());
        String sfilter = fi == -1 ? "" : this.editors.get(fi).getFilter();
        JPanel jPanel = pp = fi == -1 ? null : this.editors.get(fi).getPanel();
        if (pp != null) {
            this.addFocusListeners(pp);
        }
        Dimension limit = new Dimension(24, 24);
        if (this.addSubtractButtons) {
            JButton subAdd = new JButton("");
            subAdd.setIcon(new ImageIcon(FiltersChainPanel.class.getResource("/resources/add.png")));
            subAdd.setMaximumSize(limit);
            subAdd.setPreferredSize(limit);
            if (fi >= 0) {
                subAdd.setToolTipText("insert new filter before " + sfilter);
                subAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        FiltersChainPanel.this.addFilterNew(fi);
                    }
                });
            } else {
                subAdd.setToolTipText("insert new filter");
                subAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        FiltersChainPanel.this.addFilterNew(FiltersChainPanel.this.editors.size());
                    }
                });
            }
            sub.add((Component)subAdd, "West");
            if (fi >= 0) {
                JButton subDelete = new JButton("");
                subDelete.setIcon(new ImageIcon(FiltersChainPanel.class.getResource("/resources/subtract.png")));
                subDelete.setMaximumSize(limit);
                subDelete.setPreferredSize(limit);
                subDelete.setToolTipText("remove filter " + sfilter);
                subDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        FiltersChainPanel.this.deleteFilter(fi);
                        Container parent = sub.getParent();
                        parent.remove(sub);
                        parent.validate();
                    }
                });
                sub.add((Component)subDelete, "East");
            }
        }
        if (fi >= 0) {
            sub.add((Component)pp, "Center");
        } else if (this.addSubtractButtons) {
            JLabel tf = new JLabel();
            tf.setText("<html><i>&nbsp;(click to add)</i></html>");
            sub.add((Component)tf, "Center");
        }
        Dimension maximumSize = sub.getPreferredSize();
        maximumSize.width = Integer.MAX_VALUE;
        sub.setMaximumSize(maximumSize);
        return sub;
    }

    @Override
    public void setFilter(String filter) {
        int i;
        logger.entering(CLASS_NAME, "setFilter", filter);
        String oldFilter = this.getFilter();
        if (this.currentFilter != null && this.currentFilter.equals(filter)) {
            logger.fine("filter unchanged, so we don't need to do anything, right?");
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.warning("must be called from event thread");
        }
        if (filter == null) {
            filter = "";
        }
        String[] ss = filter.split("\\|", -2);
        ArrayList<FilterEditorPanel> recycle = new ArrayList<FilterEditorPanel>(this.editors);
        for (int i2 = this.editors.size(); i2 < ss.length; ++i2) {
            recycle.add(null);
        }
        for (FilterEditorPanel p : this.editors) {
            this.removeFocusListeners(p.getPanel());
        }
        this.editors.clear();
        this.recalculating.clear();
        JPanel content = new JPanel();
        this.setPreferredSize(new Dimension(500, 300));
        BoxLayout lo = new BoxLayout(content, 1);
        content.setLayout(lo);
        int scroll0 = this.scrollPane.getVerticalScrollBar().getValue();
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(this.scrollPane.getFont().getSize());
        for (i = 0; i < ss.length; ++i) {
            ss[i] = ss[i].trim();
        }
        i = 0;
        if (ss[0].length() > 0) {
            FilterEditorPanel filterEditorPanel = this.getEditorFor("|unbundle(" + ss[0] + ")", (FilterEditorPanel)recycle.get(0));
            this.editors.add(filterEditorPanel);
            this.recalculating.add(Boolean.FALSE);
            JPanel ll = this.onePanel(i);
            content.add(ll);
            ++i;
            content.add(new JLabel("--------"));
            this.implicitUnbundle = true;
        } else {
            this.implicitUnbundle = false;
        }
        for (String s : ss = Arrays.copyOfRange(ss, 1, ss.length)) {
            if (s.length() <= 0) continue;
            FilterEditorPanel p = this.getEditorFor(s, (FilterEditorPanel)recycle.get(this.editors.size()));
            this.editors.add(p);
            this.recalculating.add(Boolean.FALSE);
            JPanel ll = this.onePanel(i);
            content.add(ll);
            if (++i >= ss.length) continue;
            content.add(new JLabel("--------"));
        }
        JPanel jPanel = this.onePanel(-1);
        content.add(jPanel);
        content.add(Box.createVerticalGlue());
        this.scrollPane.setViewportView(content);
        this.scrollPane.getVerticalScrollBar().setValue(scroll0);
        this.currentFilter = filter;
        this.revalidate();
        this.firePropertyChange("filter", oldFilter, filter);
    }

    private void updateImmediately() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String f = FiltersChainPanel.this.getFilter();
                String oldCurrentFilter = FiltersChainPanel.this.currentFilter;
                FiltersChainPanel.this.setFilter(f);
                if (FiltersChainPanel.this.inputDs != null) {
                    FiltersChainPanel.this.setInput(FiltersChainPanel.this.inputDs);
                }
                if (oldCurrentFilter.equals(f)) {
                    logger.fine("does not change.");
                } else {
                    FiltersChainPanel.this.firePropertyChange("filter", oldCurrentFilter, f);
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(run);
        }
        catch (InterruptedException | InvocationTargetException ex) {
            Logger.getLogger(FiltersChainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void indicateRecalculating() {
        for (int i = 0; i < this.recalculating.size(); ++i) {
            boolean recalc = this.recalculating.get(i);
            if (recalc) {
                this.editors.get(i).getPanel().setBackground(Color.GRAY);
                continue;
            }
            this.editors.get(i).getPanel().setBackground(this.backgroundColor);
        }
    }

    private void updateSoon(String label) {
        logger.entering(CLASS_NAME, "updateSoon", label);
        if (!this.adjusting.isEmpty()) {
            logger.fine("currently adjusting.");
            return;
        }
        String oldCurrentFilter = this.currentFilter;
        String f = this.getFilter();
        if (oldCurrentFilter.equals(f)) {
            logger.fine("does not change.");
        } else {
            this.timer.tickle(label);
        }
    }

    private void setInput(QDataSet ds, String filter, List<FilterEditorPanel> leditors) {
        if (SwingUtilities.isEventDispatchThread()) {
            logger.warning("must NOT be called from event thread");
        }
        String[] ss = filter.split("\\|");
        int i = 0;
        int iss = 0;
        final String key = filter;
        this.adjusting.add(key);
        boolean eventWillBeFired = false;
        for (String s : ss) {
            s = s.trim();
            ++iss;
            if (s.length() > 0) {
                final FilterEditorPanel p = leditors.get(i);
                if (ds != null) {
                    PropertyChangeListener[] pcls;
                    boolean fireUpdateSoon;
                    final int fi = i;
                    final QDataSet fds = ds;
                    eventWillBeFired = fireUpdateSoon = iss == ss.length;
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            p.setInput(fds);
                            if (FiltersChainPanel.this.recalculating.size() > fi) {
                                FiltersChainPanel.this.recalculating.set(fi, Boolean.FALSE);
                                FiltersChainPanel.this.indicateRecalculating();
                            }
                            if (fireUpdateSoon) {
                                FiltersChainPanel.this.adjusting.remove(key);
                                FiltersChainPanel.this.updateSoon(key);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(run);
                    if (iss < ss.length) {
                        try {
                            ds = iss == 1 && this.implicitUnbundle ? DataSetOps.sprocess("|unbundle(" + s + ")", ds, new NullProgressMonitor()) : DataSetOps.sprocess("|" + s, ds, new NullProgressMonitor());
                        }
                        catch (Exception ex) {
                            p.getPanel().setToolTipText(ex.getMessage());
                            ds = null;
                        }
                    }
                    for (PropertyChangeListener pcl : pcls = p.getPanel().getPropertyChangeListeners()) {
                        p.getPanel().removePropertyChangeListener(pcl);
                    }
                    p.getPanel().addPropertyChangeListener("filter", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            FiltersChainPanel.this.updateSoon((String)evt.getNewValue());
                        }
                    });
                }
                ++i;
            }
            if (eventWillBeFired) continue;
            this.adjusting.remove(key);
            this.updateSoon(key);
        }
        this.repaint();
    }

    public QDataSet getInput() {
        return this.inputDs;
    }

    public void resetInput(final QDataSet ds) {
        logger.entering(CLASS_NAME, "resetInput", ds);
        this.inputDs = ds;
        final String filter = this.getFilter();
        logger.log(Level.FINE, "filter: {0}", filter);
        for (int i = 0; i < this.recalculating.size(); ++i) {
            this.recalculating.set(i, Boolean.TRUE);
        }
        this.recalculatingTimer.restart();
        final ArrayList<FilterEditorPanel> leditors = new ArrayList<FilterEditorPanel>(this.editors);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                logger.entering(CLASS_NAME, "resetInput", ds);
                FiltersChainPanel.this.setInput(ds, filter, leditors);
                logger.exiting(CLASS_NAME, "resetInput", ds);
            }
        };
        new Thread(run, "resetInput").start();
        logger.exiting(CLASS_NAME, "resetInput", ds);
    }

    @Override
    public void setInput(QDataSet ds) {
        logger.entering(CLASS_NAME, "setInput", ds);
        if (this.inputDs == ds) {
            logger.fine("already set input...");
            return;
        }
        this.resetInput(ds);
        logger.exiting(CLASS_NAME, "setInput", ds);
    }

    public boolean validateFilter(String filter) {
        String[] ss = filter.split("\\|");
        int i = 0;
        ArrayList<FilterEditorPanel> leditors = new ArrayList<FilterEditorPanel>(this.editors);
        QDataSet ds = this.inputDs;
        for (String s : ss) {
            if ((s = s.trim()).length() <= 0) continue;
            if (i < leditors.size()) {
                FilterEditorPanel p = (FilterEditorPanel)leditors.get(i);
                try {
                    if (!p.validateFilter("|" + s, ds)) {
                        return false;
                    }
                    ds = null;
                }
                catch (RuntimeException ex) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean validateFilter(String filter, QDataSet in) {
        this.inputDs = in;
        return this.validateFilter(filter);
    }

    @Override
    public JPanel getPanel() {
        logger.entering(CLASS_NAME, "getPanel");
        return this;
    }

    protected static QDataSet getExampleDataSet(String s) {
        try {
            switch (s) {
                case "rank1TimeSeries": {
                    return Ops.ripplesTimeSeries(20);
                }
                case "qube": {
                    MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.ripples(300, 30, 20);
                    MutablePropertyDataSet dds = (MutablePropertyDataSet)Ops.timegen("2000-01-01T00:00", "60s", 300);
                    dds.putProperty("NAME", "Epoch");
                    ds.putProperty("DEPEND_0", dds);
                    dds = (MutablePropertyDataSet)Ops.findgen(30);
                    dds.putProperty("NAME", "index30");
                    ds.putProperty("DEPEND_1", dds);
                    dds = (MutablePropertyDataSet)Ops.findgen(20);
                    dds.putProperty("NAME", "index20");
                    ds.putProperty("DEPEND_2", dds);
                    return ds;
                }
            }
            return Ops.ripplesVectorTimeSeries(30);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        logger.setLevel(Level.ALL);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        logger.addHandler(h);
        final FiltersChainPanel ff = new FiltersChainPanel();
        final QDataSet ds = FiltersChainPanel.getExampleDataSet("qube");
        ff.setFilter("|slice0(2)|cos()|collapse1()|butterworth(2,500,750,True)");
        ff.setInput(ds);
        final JTextField tf = new JTextField();
        tf.setText(ff.getFilter());
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ff.setFilter(tf.getText());
                ff.setInput(ds);
            }
        });
        ff.addPropertyChangeListener("filter", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                tf.setText(ff.getFilter());
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add(ff);
        p.add((Component)tf, "North");
        JButton b = new JButton("reset data");
        p.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ff.setInput(null);
                ff.setInput(ds);
            }
        });
        JDialog d = new JDialog();
        d.setContentPane(p);
        d.setResizable(true);
        d.setModal(true);
        d.pack();
        d.setSize(640, 480);
        d.setVisible(true);
        System.err.println(ff.getFilter());
    }
}

