/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.layout.GroupLayout;

public class FftPowerFilterEditorPanel
extends AbstractFilterEditorPanel {
    private String slide;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JTextField sizeTF;
    public JComboBox slideCB;
    public JComboBox windowCB;

    public FftPowerFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.slideCB = new JComboBox();
        this.sizeTF = new JTextField();
        this.windowCB = new JComboBox();
        this.jLabel1.setText("Size: ");
        this.jLabel2.setText("Slide: ");
        this.jLabel3.setText("Window: ");
        this.slideCB.setModel(new DefaultComboBoxModel<String>(new String[]{"No Overlap", "1/2 Overlap", "2/3 Overlap", "3/4 Overlap", "7/8 Overlap"}));
        this.slideCB.setMinimumSize(new Dimension(125, 27));
        this.slideCB.setPreferredSize(new Dimension(125, 27));
        this.sizeTF.setText("512");
        this.sizeTF.setPreferredSize(new Dimension(90, 27));
        this.windowCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Hanning (Hann)", "TenPercentEdgeCosine", "Unity"}));
        this.windowCB.setPreferredSize(new Dimension(125, 27));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel3)).add(29, 29, 29).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sizeTF, -2, -1, -2).add((Component)this.slideCB, -2, -1, -2).add((Component)this.windowCB, -2, 192, -2)).addContainerGap(26, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.sizeTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.slideCB, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.windowCB, -2, -1, -2).add((Component)this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile("\\|fftPower\\((\\d+),(\\d),'?(\\w+)\\'?\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.sizeTF.setText(m.group(1));
            if (m.group(2).equals("1")) {
                this.slideCB.setSelectedIndex(0);
            } else if (m.group(2).equals("2")) {
                this.slideCB.setSelectedIndex(1);
            } else if (m.group(2).equals("3")) {
                this.slideCB.setSelectedIndex(2);
            } else if (m.group(2).equals("4")) {
                this.slideCB.setSelectedIndex(3);
            } else if (m.group(2).equals("8")) {
                this.slideCB.setSelectedIndex(4);
            } else {
                this.slideCB.setSelectedIndex(0);
            }
            this.windowCB.setSelectedItem(m.group(3));
        } else {
            this.sizeTF.setText("512");
            this.slideCB.setSelectedIndex(0);
            this.windowCB.setSelectedIndex(0);
        }
    }

    @Override
    public String getFilter() {
        if (this.slideCB.getSelectedItem().equals("No Overlap")) {
            this.slide = "1";
        } else if (this.slideCB.getSelectedItem().equals("1/2 Overlap")) {
            this.slide = "2";
        } else if (this.slideCB.getSelectedItem().equals("2/3 Overlap")) {
            this.slide = "3";
        } else if (this.slideCB.getSelectedItem().equals("3/4 Overlap")) {
            this.slide = "4";
        } else if (this.slideCB.getSelectedItem().equals("7/8 Overlap")) {
            this.slide = "8";
        }
        String window = (String)this.windowCB.getSelectedItem();
        if (window.startsWith("Hanning")) {
            window = "Hanning";
        }
        return "|fftPower(" + this.sizeTF.getText() + "," + this.slide + ",'" + window + "')";
    }
}

