/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.layout.GroupLayout;

public class DbAboveBackgroundDim1FilterEditorPanel
extends AbstractFilterEditorPanel {
    public ButtonGroup buttonGroup1;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JTextField percentTF;
    public JRadioButton powerRadioButton;
    public JRadioButton voltageButton;

    public DbAboveBackgroundDim1FilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.percentTF = new JTextField();
        this.jLabel2 = new JLabel();
        this.voltageButton = new JRadioButton();
        this.powerRadioButton = new JRadioButton();
        FormListener formListener = new FormListener();
        this.jLabel1.setText("Show data as decibels above the ");
        this.percentTF.setText("10");
        this.percentTF.setPreferredSize(new Dimension(40, 27));
        this.jLabel2.setText("% level,");
        this.buttonGroup1.add(this.voltageButton);
        this.voltageButton.setSelected(true);
        this.voltageButton.setText("input data are proportional to field intensity (20 * log10( ds / background ))");
        this.voltageButton.addActionListener(formListener);
        this.buttonGroup1.add(this.powerRadioButton);
        this.powerRadioButton.setText("input data are proportional to power (10 * log10( ds / background ))");
        this.powerRadioButton.addActionListener(formListener);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(1, 1, 1).add((Component)this.percentTF, -2, -1, -2).add(3, 3, 3).add((Component)this.jLabel2)).add((Component)this.voltageButton).add((Component)this.powerRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.percentTF, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.voltageButton).addPreferredGap(0).add((Component)this.powerRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void powerRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void voltageButtonActionPerformed(ActionEvent evt) {
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile("\\|dbAboveBackgroundDim1\\((\\d+)\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.percentTF.setText(m.group(1));
            this.powerRadioButton.setSelected(false);
            this.voltageButton.setSelected(true);
        } else {
            Pattern p2 = Pattern.compile("\\|dbAboveBackgroundDim1\\((\\d+),(True|False)\\)");
            Matcher m2 = p2.matcher(filter);
            if (m2.matches()) {
                this.percentTF.setText(m2.group(1));
                this.powerRadioButton.setSelected(m2.group(2).equals("True"));
                this.voltageButton.setSelected(!m2.group(2).equals("True"));
            } else {
                this.percentTF.setText("10");
            }
        }
    }

    @Override
    public String getFilter() {
        if (this.powerRadioButton.isSelected()) {
            return "|dbAboveBackgroundDim1(" + this.percentTF.getText() + ",True)";
        }
        return "|dbAboveBackgroundDim1(" + this.percentTF.getText() + ")";
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DbAboveBackgroundDim1FilterEditorPanel.this.voltageButton) {
                DbAboveBackgroundDim1FilterEditorPanel.this.voltageButtonActionPerformed(evt);
            } else if (evt.getSource() == DbAboveBackgroundDim1FilterEditorPanel.this.powerRadioButton) {
                DbAboveBackgroundDim1FilterEditorPanel.this.powerRadioButtonActionPerformed(evt);
            }
        }
    }
}

