/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanelUtil;
import org.jdesktop.layout.GroupLayout;

public class ButterworthFilterEditorPanel
extends AbstractFilterEditorPanel {
    private String tf;
    public JTextField cutoffFreq;
    public JTextField highFreq;
    public JLabel jLabel1;
    public JLabel jLabel10;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JTextField lowFreq;
    public JComboBox orderCB;
    public JPanel orderPanel;
    public JPanel subPanel1;
    public JPanel subPanel3;
    public JPanel subPanel4;
    public JComboBox type1CB;

    public ButterworthFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.orderPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.orderCB = new JComboBox();
        this.subPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.type1CB = new JComboBox();
        this.subPanel3 = new JPanel();
        this.jLabel10 = new JLabel();
        this.cutoffFreq = new JTextField();
        this.jLabel3 = new JLabel();
        this.subPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.lowFreq = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.highFreq = new JTextField();
        this.jLabel7 = new JLabel();
        FormListener formListener = new FormListener();
        this.jLabel1.setText("Order:  ");
        this.orderCB.setEditable(true);
        this.orderCB.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4"}));
        this.jLabel2.setText("Type:");
        this.type1CB.setModel(new DefaultComboBoxModel<String>(new String[]{"High-Pass", "Low-Pass", "Band-Pass", "Band-Reject"}));
        this.type1CB.addActionListener(formListener);
        GroupLayout subPanel1Layout = new GroupLayout((Container)this.subPanel1);
        this.subPanel1.setLayout((LayoutManager)subPanel1Layout);
        subPanel1Layout.setHorizontalGroup((GroupLayout.Group)subPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)subPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)subPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)subPanel1Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.type1CB, -2, -1, -2)).add((Component)this.jLabel2, -2, 55, -2)).add(0, 0, Short.MAX_VALUE)));
        subPanel1Layout.setVerticalGroup((GroupLayout.Group)subPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)subPanel1Layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.type1CB, -2, -1, -2)));
        GroupLayout orderPanelLayout = new GroupLayout((Container)this.orderPanel);
        this.orderPanel.setLayout((LayoutManager)orderPanelLayout);
        orderPanelLayout.setHorizontalGroup((GroupLayout.Group)orderPanelLayout.createParallelGroup(1).add((GroupLayout.Group)orderPanelLayout.createSequentialGroup().add((GroupLayout.Group)orderPanelLayout.createParallelGroup(1).add((GroupLayout.Group)orderPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)orderPanelLayout.createParallelGroup(1).add((GroupLayout.Group)orderPanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.orderCB, -2, -1, -2)).add((Component)this.jLabel1))).add((Component)this.subPanel1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        orderPanelLayout.setVerticalGroup((GroupLayout.Group)orderPanelLayout.createParallelGroup(1).add((GroupLayout.Group)orderPanelLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.orderCB, -2, -1, -2).addPreferredGap(0).add((Component)this.subPanel1, -2, -1, -2).add(0, 86, Short.MAX_VALUE)));
        this.jLabel10.setText("Cutoff Frequency:");
        this.cutoffFreq.setPreferredSize(new Dimension(75, 27));
        this.jLabel3.setText("Hz");
        GroupLayout subPanel3Layout = new GroupLayout((Container)this.subPanel3);
        this.subPanel3.setLayout((LayoutManager)subPanel3Layout);
        subPanel3Layout.setHorizontalGroup((GroupLayout.Group)subPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)subPanel3Layout.createSequentialGroup().addContainerGap(25, Short.MAX_VALUE).add((Component)this.cutoffFreq, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel3).add(10, 10, 10)).add((GroupLayout.Group)subPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel10).addContainerGap(-1, Short.MAX_VALUE)));
        subPanel3Layout.setVerticalGroup((GroupLayout.Group)subPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)subPanel3Layout.createSequentialGroup().add((Component)this.jLabel10).addPreferredGap(0).add((GroupLayout.Group)subPanel3Layout.createParallelGroup(3).add((Component)this.cutoffFreq, -2, -1, -2).add((Component)this.jLabel3))));
        this.jLabel4.setText("Low Frequency:");
        this.lowFreq.setName("lowf");
        this.lowFreq.setPreferredSize(new Dimension(75, 27));
        this.jLabel5.setText("Hz");
        this.jLabel6.setText("High Frequency:");
        this.highFreq.setPreferredSize(new Dimension(75, 27));
        this.jLabel7.setText("Hz");
        GroupLayout subPanel4Layout = new GroupLayout((Container)this.subPanel4);
        this.subPanel4.setLayout((LayoutManager)subPanel4Layout);
        subPanel4Layout.setHorizontalGroup((GroupLayout.Group)subPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)subPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)subPanel4Layout.createParallelGroup(1).add((Component)this.jLabel6).add((GroupLayout.Group)subPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)subPanel4Layout.createSequentialGroup().add(19, 19, 19).add((Component)this.highFreq, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel7)).add(2, (GroupLayout.Group)subPanel4Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.lowFreq, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel5))).add((Component)this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        subPanel4Layout.setVerticalGroup((GroupLayout.Group)subPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)subPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)subPanel4Layout.createParallelGroup(3).add((Component)this.lowFreq, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((Component)this.jLabel6).addPreferredGap(0).add((GroupLayout.Group)subPanel4Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.highFreq, -2, 27, -2)).addContainerGap(17, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.orderPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.subPanel3, -2, -1, -2).add((Component)this.subPanel4, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.orderPanel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.subPanel4, -2, -1, -2)));
    }

    private void setType(int type) {
        switch (type) {
            case 0: {
                this.subPanel3.setVisible(true);
                this.subPanel4.setVisible(false);
                break;
            }
            case 1: {
                this.subPanel3.setVisible(true);
                this.subPanel4.setVisible(false);
                break;
            }
            case 2: {
                this.subPanel3.setVisible(false);
                this.subPanel4.setVisible(true);
                break;
            }
            case 3: {
                this.subPanel3.setVisible(false);
                this.subPanel4.setVisible(true);
                break;
            }
        }
    }

    private void type1CBActionPerformed(ActionEvent evt) {
        this.setType(this.type1CB.getSelectedIndex());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ButterworthFilterEditorPanel p = new ButterworthFilterEditorPanel();
                p.setFilter("|butterworth(1,45.,46.,True)");
                JOptionPane.showMessageDialog(null, p);
                System.err.println(p.getFilter());
            }
        });
    }

    @Override
    public void setFilter(String filter) {
        String dec = FilterEditorPanelUtil.decimalRegexSloppy();
        String decw = "\\s*(" + dec + ")\\s*";
        Pattern p = Pattern.compile("\\|butterworth\\((\\d)," + decw + ",(\\w+)\\)");
        Pattern p1 = Pattern.compile("\\|butterworth\\((\\d)," + decw + "," + decw + ",(\\w+)\\)");
        Matcher m = p.matcher(filter);
        Matcher n = p1.matcher(filter);
        if (m.matches()) {
            this.orderCB.setSelectedItem(m.group(1));
            this.cutoffFreq.setText(m.group(2));
            switch (m.group(3)) {
                case "True": {
                    this.type1CB.setSelectedIndex(1);
                    break;
                }
                case "False": {
                    this.type1CB.setSelectedIndex(0);
                    break;
                }
                default: {
                    this.type1CB.setSelectedIndex(0);
                    break;
                }
            }
        } else if (n.matches()) {
            this.orderCB.setSelectedItem(n.group(1));
            this.lowFreq.setText(n.group(2));
            this.highFreq.setText(n.group(3));
            switch (n.group(4)) {
                case "True": {
                    this.type1CB.setSelectedIndex(2);
                    break;
                }
                case "False": {
                    this.type1CB.setSelectedIndex(3);
                    break;
                }
                default: {
                    this.type1CB.setSelectedIndex(0);
                    break;
                }
            }
        } else {
            this.orderCB.setSelectedIndex(0);
            this.lowFreq.setText("0");
            this.highFreq.setText("50");
            this.cutoffFreq.setText("10");
            this.type1CB.setSelectedIndex(0);
        }
        this.setType(this.type1CB.getSelectedIndex());
    }

    @Override
    public String getFilter() {
        if (this.type1CB.getSelectedItem().equals("Low-Pass")) {
            this.tf = "True";
            return "|butterworth(" + this.orderCB.getSelectedItem() + "," + this.cutoffFreq.getText() + "," + this.tf + ")";
        }
        if (this.type1CB.getSelectedItem().equals("High-Pass")) {
            this.tf = "False";
            return "|butterworth(" + this.orderCB.getSelectedItem() + "," + this.cutoffFreq.getText() + "," + this.tf + ")";
        }
        if (this.type1CB.getSelectedItem().equals("Band-Pass")) {
            this.tf = "True";
            return "|butterworth(" + this.orderCB.getSelectedItem() + "," + this.lowFreq.getText() + "," + this.highFreq.getText() + "," + this.tf + ")";
        }
        if (this.type1CB.getSelectedItem().equals("Band-Reject")) {
            this.tf = "False";
            return "|butterworth(" + this.orderCB.getSelectedItem() + "," + this.lowFreq.getText() + "," + this.highFreq.getText() + "," + this.tf + ")";
        }
        this.tf = "False";
        return "|butterworth(" + this.orderCB.getSelectedItem() + "," + this.cutoffFreq.getText() + "," + this.tf + ")";
    }

    public String getHighFreq() {
        return this.highFreq.getText();
    }

    public String getLowFreq() {
        return this.lowFreq.getText();
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ButterworthFilterEditorPanel.this.type1CB) {
                ButterworthFilterEditorPanel.this.type1CBActionPerformed(evt);
            }
        }
    }
}

