/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.buffer;

import java.nio.ByteBuffer;
import org.das2.qds.buffer.BufferDataSet;

public class NybbleDataSet
extends BufferDataSet {
    public NybbleDataSet(int rank, int reclenbits, int recoffsbits, int len0, int len1, int len2, int len3, ByteBuffer back) {
        super(rank, reclenbits, recoffsbits, BufferDataSet.BITS, len0, len1, len2, len3, BufferDataSet.NYBBLE, back);
        this.reclen = reclenbits / 8;
    }

    @Override
    protected int offset() {
        return this.recoffset;
    }

    @Override
    protected int offset(int i0) {
        return this.recoffset + i0 / 2;
    }

    @Override
    protected int offset(int i0, int i1) {
        return this.recoffset + this.reclen * i0 + i1 / 2;
    }

    @Override
    public double value() {
        return this.back.get(this.offset()) & 0xF;
    }

    @Override
    public double value(int i0) {
        if (i0 % 2 == 0) {
            return this.back.get(this.offset(i0)) & 0xF;
        }
        return this.back.get(this.offset(i0)) >> 4;
    }

    @Override
    public double value(int i0, int i1) {
        try {
            if (i0 % 2 == 0) {
                return this.back.get(this.offset(i0, i1)) & 0xF;
            }
            return this.back.get(this.offset(i0, i1)) >> 4;
        }
        catch (IndexOutOfBoundsException ex) {
            System.err.println("here");
            throw ex;
        }
    }

    @Override
    public double value(int i0, int i1, int i2) {
        throw new IllegalArgumentException("not supported");
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        throw new IllegalArgumentException("not supported");
    }

    @Override
    public int rank() {
        return super.rank();
    }

    @Override
    public int length(int i) {
        return super.length(i);
    }

    @Override
    public int length() {
        return super.length();
    }

    @Override
    public void putValue(double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, int i1, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, int i1, int i2, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

