/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.buffer;

import java.nio.ByteBuffer;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.FloatReadAccess;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.BufferDataSet;

public class FloatDataSet
extends BufferDataSet
implements WritableDataSet {
    public FloatDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, ByteBuffer back) {
        super(rank, reclen, recoffs, len0, len1, len2, len3, FLOAT, back);
    }

    @Override
    public double value() {
        return this.back.getFloat(this.offset());
    }

    @Override
    public double value(int i0) {
        return this.back.getFloat(this.offset(i0));
    }

    @Override
    public double value(int i0, int i1) {
        return this.back.getFloat(this.offset(i0, i1));
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.back.getFloat(this.offset(i0, i1, i2));
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.back.getFloat(this.offset(i0, i1, i2, i3));
    }

    @Override
    public void putProperty(String name, Object value) {
        if (name.equals("UNITS") && UnitsUtil.isTimeLocation((Units)value)) {
            logger.warning("floats are being used to store times, which typically lacks sufficient resolution to represent data.");
        }
        super.putProperty(name, value);
    }

    @Override
    public void putValue(double d) {
        this.ensureWritable();
        this.back.putFloat(this.offset(), (float)d);
    }

    @Override
    public void putValue(int i0, double d) {
        this.ensureWritable();
        this.back.putFloat(this.offset(i0), (float)d);
    }

    @Override
    public void putValue(int i0, int i1, double d) {
        this.ensureWritable();
        this.back.putFloat(this.offset(i0, i1), (float)d);
    }

    @Override
    public void putValue(int i0, int i1, int i2, double d) {
        this.ensureWritable();
        this.back.putFloat(this.offset(i0, i1, i2), (float)d);
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double d) {
        this.ensureWritable();
        this.back.putFloat(this.offset(i0, i1, i2, i3), (float)d);
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            if (this.isImmutable()) {
                return null;
            }
            return (T)this;
        }
        if (clazz == FloatReadAccess.class) {
            return clazz.cast(new FloatDataSetFloatReadAccess());
        }
        return super.capability(clazz);
    }

    public class FloatDataSetFloatReadAccess
    implements FloatReadAccess {
        @Override
        public float fvalue() {
            return FloatDataSet.this.back.getFloat(FloatDataSet.this.offset());
        }

        @Override
        public float fvalue(int i0) {
            return FloatDataSet.this.back.getFloat(FloatDataSet.this.offset(i0));
        }

        @Override
        public float fvalue(int i0, int i1) {
            return FloatDataSet.this.back.getFloat(FloatDataSet.this.offset(i0, i1));
        }

        @Override
        public float fvalue(int i0, int i1, int i2) {
            return FloatDataSet.this.back.getFloat(FloatDataSet.this.offset(i0, i1, i2));
        }

        @Override
        public float fvalue(int i0, int i1, int i2, int i3) {
            return FloatDataSet.this.back.getFloat(FloatDataSet.this.offset(i0, i1, i2, i3));
        }
    }
}

