/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.TrimDataSet;

public abstract class WeightsDataSet
implements QDataSet {
    final double vmin;
    final double vmax;
    double reportFill;
    final double fill;
    final double fillMin;
    final double fillMax;
    public static final String PROP_SUGGEST_FILL = "SUGGEST_FILL";
    final boolean check;
    QDataSet ds;
    String dsname;

    protected WeightsDataSet(QDataSet ds) {
        Number ofill;
        Number validMax;
        this.ds = ds;
        Number validMin = (Number)ds.property("VALID_MIN");
        if (validMin == null) {
            validMin = Double.NEGATIVE_INFINITY;
        }
        if ((validMax = (Number)ds.property("VALID_MAX")) == null) {
            validMax = Double.POSITIVE_INFINITY;
        }
        double d = this.fill = (ofill = (Number)ds.property("FILL_VALUE")) == null ? Double.NaN : ofill.doubleValue();
        if (this.fill < 0.0) {
            this.fillMin = this.fill * 1.000001;
            this.fillMax = this.fill * 0.999991;
        } else if (this.fill >= 0.0) {
            this.fillMin = this.fill * 0.999991;
            this.fillMax = this.fill * 1.000001;
        } else {
            this.fillMin = Double.NaN;
            this.fillMax = Double.NaN;
        }
        this.reportFill = this.fill;
        if (this.reportFill == 0.0 || this.reportFill == 1.0) {
            this.reportFill = 127.0;
        }
        this.vmin = validMin.doubleValue();
        this.vmax = validMax.doubleValue();
        this.check = this.vmin > -1.7976931348623157E308 || this.vmax < Double.MAX_VALUE || !Double.isNaN(this.fill);
        String name = (String)ds.property("NAME");
        this.dsname = name == null ? "wds" : "wds_" + name;
    }

    @Override
    public int rank() {
        return this.ds.rank();
    }

    public String toString() {
        return DataSetUtil.toString(this.ds);
    }

    @Override
    public abstract double value();

    @Override
    public abstract double value(int var1);

    @Override
    public abstract double value(int var1, int var2);

    @Override
    public abstract double value(int var1, int var2, int var3);

    @Override
    public abstract double value(int var1, int var2, int var3, int var4);

    @Override
    public Object property(String name) {
        if (name.equals("FILL_VALUE")) {
            return this.reportFill;
        }
        if (name.equals("NAME")) {
            return this.dsname;
        }
        if (name.equals(PROP_SUGGEST_FILL)) {
            return this.fill;
        }
        return null;
    }

    @Override
    public Object property(String name, int i) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1, int i2) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1, int i2, int i3) {
        return this.property(name);
    }

    @Override
    public int length() {
        return this.ds.length();
    }

    @Override
    public int length(int i) {
        return this.ds.length(i);
    }

    @Override
    public int length(int i, int j) {
        return this.ds.length(i, j);
    }

    @Override
    public int length(int i, int j, int k) {
        return this.ds.length(i, j, k);
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        return null;
    }

    @Override
    public QDataSet slice(int i) {
        return new Slice0DataSet(this, i);
    }

    @Override
    public QDataSet trim(int start, int end) {
        if (start == 0 && end == this.ds.length()) {
            return this;
        }
        return new TrimDataSet(this, start, end);
    }

    public static QDataSet applyRules(QDataSet src, QDataSet v) {
        ValidRangeFillFinite wds = new ValidRangeFillFinite(src);
        wds.ds = v;
        return wds;
    }

    public static final class AllValid
    extends WeightsDataSet {
        public AllValid(QDataSet ds) {
            super(ds);
        }

        @Override
        public double value() {
            return 1.0;
        }

        @Override
        public double value(int i) {
            return 1.0;
        }

        @Override
        public double value(int i0, int i1) {
            return 1.0;
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return 1.0;
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            return 1.0;
        }
    }

    public static final class FillFinite
    extends WeightsDataSet {
        public FillFinite(QDataSet ds) {
            super(ds);
        }

        private double weight(double v) {
            return v == this.fill || v > this.fillMin && v < this.fillMax || Double.isNaN(v) ? 0.0 : 1.0;
        }

        @Override
        public double value() {
            return this.weight(this.ds.value());
        }

        @Override
        public double value(int i) {
            return this.weight(this.ds.value(i));
        }

        @Override
        public double value(int i0, int i1) {
            return this.weight(this.ds.value(i0, i1));
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return this.weight(this.ds.value(i0, i1, i2));
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            return this.weight(this.ds.value(i0, i1, i2, i3));
        }
    }

    public static final class Finite
    extends WeightsDataSet {
        public Finite(QDataSet ds) {
            super(ds);
        }

        private double weight(double v) {
            return Double.isNaN(v) ? 0.0 : 1.0;
        }

        @Override
        public double value() {
            return this.weight(this.ds.value());
        }

        @Override
        public double value(int i) {
            return this.weight(this.ds.value(i));
        }

        @Override
        public double value(int i0, int i1) {
            return this.weight(this.ds.value(i0, i1));
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return this.weight(this.ds.value(i0, i1, i2));
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            return this.weight(this.ds.value(i0, i1, i2, i3));
        }
    }

    public static final class ValidRangeFillFinite
    extends WeightsDataSet {
        public ValidRangeFillFinite(QDataSet ds) {
            super(ds);
        }

        private double weight(double v) {
            return v == this.fill || v > this.fillMin && v < this.fillMax || Double.isNaN(v) || v > this.vmax || v < this.vmin ? 0.0 : 1.0;
        }

        @Override
        public double value() {
            return this.weight(this.ds.value());
        }

        @Override
        public double value(int i) {
            return this.weight(this.ds.value(i));
        }

        @Override
        public double value(int i0, int i1) {
            return this.weight(this.ds.value(i0, i1));
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return this.weight(this.ds.value(i0, i1, i2));
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            return this.weight(this.ds.value(i0, i1, i2, i3));
        }
    }
}

