/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.ArrayList;
import java.util.List;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;

public final class TailBundleDataSet
extends AbstractDataSet {
    List<QDataSet> datasets;
    int rank;
    int[] qube;

    public TailBundleDataSet(int rank) {
        this.rank = rank;
        this.datasets = new ArrayList<QDataSet>();
        if (rank == 4) {
            this.putProperty("BUNDLE_3", new BundleDescriptor());
            this.putProperty("QUBE", Boolean.TRUE);
        } else if (rank == 3) {
            this.putProperty("BUNDLE_2", new BundleDescriptor());
            this.putProperty("QUBE", Boolean.TRUE);
        } else if (rank == 2) {
            this.putProperty("BUNDLE_1", new BundleDescriptor());
            this.putProperty("QUBE", Boolean.TRUE);
        } else {
            this.putProperty("BUNDLE_0", new BundleDescriptor());
        }
    }

    public TailBundleDataSet(QDataSet ds) {
        this(ds.rank() + 1);
        this.bundle(ds);
    }

    public void bundle(QDataSet ds) {
        if (ds.rank() != this.rank - 1) {
            throw new IllegalArgumentException("dataset rank must be " + (this.rank - 1));
        }
        if (this.rank > 1) {
            if (this.qube != null) {
                int[] qube = DataSetUtil.qubeDims(ds);
                if (qube[0] != this.qube[0]) {
                    throw new IllegalArgumentException(String.format("dataset length (%d) is not consistent with the bundle's length (%d)", ds.length(), this.qube[0]));
                }
            } else {
                this.qube = DataSetUtil.qubeDims(ds);
            }
        }
        this.datasets.add(ds);
    }

    public QDataSet unbundle(int i) {
        return this.datasets.get(i);
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public double value(int i0) {
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank 1 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i0).value();
    }

    @Override
    public double value(int i0, int i1) {
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank 2 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i1).value(i0);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank 3 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i2).value(i0, i1);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank 4 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i3).value(i0, i1, i2);
    }

    @Override
    public Object property(String name, int i0) {
        if (this.rank == 1) {
            return this.datasets.get(i0).property(name);
        }
        Object result = super.property(name);
        if (result == null) {
            return null;
        }
        return result;
    }

    @Override
    public int length() {
        if (this.rank == 1) {
            return this.datasets.size();
        }
        return this.qube[0];
    }

    @Override
    public int length(int i0) {
        if (this.rank() == 2) {
            return this.datasets.size();
        }
        return this.qube[1];
    }

    @Override
    public int length(int i0, int i1) {
        if (this.rank() == 3) {
            return this.datasets.size();
        }
        return this.qube[2];
    }

    @Override
    public int length(int i0, int i1, int i2) {
        if (this.rank() == 4) {
            return this.datasets.size();
        }
        return this.qube[3];
    }

    @Override
    public String toString() {
        if (this.rank == 1) {
            return DataSetUtil.format(this);
        }
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        String dep0name = "";
        if (dep0 != null) {
            dep0name = (String)dep0.property("NAME");
            dep0name = dep0name == null ? "" : dep0name + "=";
        }
        String ss = DataSetUtil.toString(this.qube);
        ss = ss.substring(1, ss.length() - 1);
        return "BundleDataSet[" + dep0name + ss + "," + this.datasets.size() + " datasets]";
    }

    public class BundleDescriptor
    extends AbstractDataSet {
        @Override
        public int rank() {
            return 2;
        }

        @Override
        public int length() {
            return TailBundleDataSet.this.datasets.size();
        }

        @Override
        public int length(int i) {
            return 0;
        }

        @Override
        public Object property(String name, int i) {
            Object v = this.properties.get(name + "__" + i);
            if (i >= TailBundleDataSet.this.datasets.size()) {
                throw new IndexOutOfBoundsException("No dataset at index " + i + " only " + TailBundleDataSet.this.datasets.size() + " datasets.");
            }
            if (v == null) {
                if (DataSetUtil.isInheritedProperty(name)) {
                    return TailBundleDataSet.this.datasets.get(i).property(name);
                }
                return null;
            }
            return v;
        }

        @Override
        public double value(int i0, int i1) {
            throw new IndexOutOfBoundsException("length=0");
        }

        @Override
        public String toString() {
            StringBuilder names = new StringBuilder();
            String s = (String)TailBundleDataSet.this.datasets.get(0).property("NAME");
            names.append(s == null ? "data" : s);
            for (int i = 1; i < TailBundleDataSet.this.datasets.size(); ++i) {
                s = (String)TailBundleDataSet.this.datasets.get(i).property("NAME");
                names.append(",").append(s == null ? "data" : s);
            }
            return "BundleDescriptor[ " + names.toString() + "]";
        }
    }
}

