/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.datum.Units;
import org.das2.qds.AbstractRank1DataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;

public class TagGenDataSet
extends AbstractRank1DataSet {
    double scale;
    double offset;

    public TagGenDataSet(int length, double scale, double offset) {
        this(length, scale, offset, null);
    }

    public TagGenDataSet(int length, double scale, double offset, Units units) {
        super(length);
        this.scale = scale;
        this.offset = offset;
        if (units != null) {
            this.putProperty("CADENCE", DRank0DataSet.create(scale, units.getOffsetUnits()));
            this.putProperty("UNITS", units);
        } else {
            this.putProperty("UNITS", Units.dimensionless);
            this.putProperty("CADENCE", DRank0DataSet.create(scale, Units.dimensionless));
        }
        if (scale > 0.0) {
            this.putProperty("MONOTONIC", Boolean.TRUE);
        }
    }

    @Override
    public double value(int i) {
        return (double)i * this.scale + this.offset;
    }

    @Override
    public QDataSet trim(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        Units u = (Units)this.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        TagGenDataSet result = new TagGenDataSet(end - start, this.scale, this.offset + (double)start * this.scale, u);
        DataSetUtil.copyDimensionProperties(this, result);
        return result;
    }

    @Override
    public QDataSet slice(int i) {
        Units u = (Units)this.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        return DRank0DataSet.create((double)i * this.scale + this.offset, u);
    }
}

