/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class SubsetDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerManager.getLogger("qdataset");
    QDataSet source;
    QDataSet[] sorts;
    int[] lens;
    boolean nonQube = false;

    public SubsetDataSet(QDataSet source) {
        this.source = source;
        this.sorts = new QDataSet[4];
        this.lens = new int[4];
        if (!DataSetUtil.isQube(source)) {
            this.nonQube = true;
        } else {
            QDataSet dep1 = (QDataSet)source.slice(0).property("DEPEND_0");
            this.putProperty("DEPEND_1", dep1);
        }
        int[] lenss = DataSetUtil.qubeDims(source);
        if (this.nonQube) {
            this.lens[0] = source.length();
            this.sorts[0] = new IndexGenDataSet(this.lens[0]);
            for (int i = 1; i < source.rank(); ++i) {
                this.lens[i] = Integer.MAX_VALUE;
                this.sorts[i] = new IndexGenDataSet(this.lens[i]);
            }
        } else {
            for (int i = 0; i < lenss.length; ++i) {
                this.lens[i] = lenss[i];
                this.sorts[i] = new IndexGenDataSet(lenss[i]);
            }
        }
    }

    public void applyIndex(int idim, QDataSet idx) {
        QDataSet max;
        if (this.nonQube && idim > 0) {
            throw new IllegalArgumentException("unable to applyIndex on non-qube source dataset");
        }
        if (idx.rank() == 1 && (max = Ops.reduceMax(idx, 0)).value() >= (double)this.lens[idim]) {
            logger.log(Level.WARNING, "idx dataset contains maximum that is out-of-bounds: {0}", max);
        }
        this.sorts[idim] = idx;
        this.lens[idim] = idx.length();
        if (idx.rank() > 1) {
            throw new IllegalArgumentException("indexes must be rank 1");
        }
        QDataSet dep = (QDataSet)this.property("DEPEND_" + idim);
        if (dep == null) {
            dep = (QDataSet)this.source.property("DEPEND_" + idim);
        }
        if (dep != null) {
            SubsetDataSet dim = new SubsetDataSet(dep);
            dim.applyIndex(0, idx);
            this.putProperty("DEPEND_" + idim, dim);
        }
        if (idim == 0) {
            for (int i = 1; i < 4; ++i) {
                QDataSet depi = (QDataSet)this.source.property("DEPEND_" + i);
                if (depi == null || depi.rank() <= 1) continue;
                SubsetDataSet dim = new SubsetDataSet(depi);
                dim.applyIndex(0, idx);
                this.putProperty("DEPEND_" + i, dim);
            }
        }
    }

    @Override
    public int rank() {
        return this.source.rank();
    }

    @Override
    public int length() {
        return this.lens[0];
    }

    @Override
    public int length(int i) {
        return this.nonQube ? this.source.length(i) : this.lens[1];
    }

    @Override
    public int length(int i, int j) {
        return this.nonQube ? this.source.length(i, j) : this.lens[2];
    }

    @Override
    public int length(int i, int j, int k) {
        return this.nonQube ? this.source.length(i, j, k) : this.lens[3];
    }

    @Override
    public double value() {
        return this.source.value();
    }

    @Override
    public double value(int i) {
        return this.source.value((int)this.sorts[0].value(i));
    }

    @Override
    public double value(int i0, int i1) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1));
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1), (int)this.sorts[2].value(i2));
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1), (int)this.sorts[2].value(i2), (int)this.sorts[3].value(i3));
    }

    @Override
    public Object property(String name, int i) {
        Object v = this.properties.get(name);
        return v != null ? v : this.source.property(name, i);
    }

    @Override
    public Object property(String name) {
        Object v = this.properties.get(name);
        return v != null ? v : this.source.property(name);
    }
}

