/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSet;

public class SparseDataSetBuilder {
    private SparseDataSet ds;

    public SparseDataSetBuilder(int rank) {
        this.ds = SparseDataSet.createRank(rank);
    }

    public SparseDataSet getDataSet() {
        if (this.ds.length0 == -1) {
            throw new IllegalArgumentException("setLength was never called");
        }
        return this.ds;
    }

    public void putValue(double d) {
        this.ds.putValue(d);
    }

    public void putValue(int i0, double d) {
        this.ds.putValue(i0, d);
    }

    public void putValue(int i0, int i1, double d) {
        this.ds.putValue(i0, i1, d);
    }

    public void putValue(int i0, int i1, int i2, double d) {
        this.ds.putValue(i0, i1, i2, d);
    }

    public void putValue(int i0, int i1, int i2, int i3, double d) {
        this.ds.putValue(i0, i1, i2, i3, d);
    }

    public void putProperty(String name, Object value) {
        SemanticOps.checkPropertyType(name, value, true);
        this.ds.putProperty(name, value);
    }

    public void putProperty(String name, int index, Object value) {
        SemanticOps.checkPropertyType(name, value, true);
        this.ds.putProperty(name, index, value);
    }

    public void setLength(int i0) {
        this.ds.setLength(i0);
    }

    public void setQube(int[] qube) {
        this.ds.setQube(qube);
    }
}

