/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.WritableDataSet;

public class SparseDataSet
extends AbstractDataSet
implements WritableDataSet {
    int rank;
    Map<String, Double> data;
    int length0 = -1;
    int[] qube;
    Map<String, Integer> length;

    private SparseDataSet(int rank) {
        this.rank = rank;
        this.data = new HashMap<String, Double>();
        this.length = new HashMap<String, Integer>();
    }

    public static SparseDataSet createRank(int rank) {
        return new SparseDataSet(rank);
    }

    public static SparseDataSet createRankLen(int rank, int len0) {
        SparseDataSet result = new SparseDataSet(rank);
        result.setLength(len0);
        return result;
    }

    public static SparseDataSet createQube(int[] qube) {
        SparseDataSet result = new SparseDataSet(qube.length);
        result.setQube(qube);
        return result;
    }

    public void setLength(int length) {
        this.checkImmutable();
        this.length0 = length;
    }

    public void setQube(int[] qube) {
        if (qube.length != this.rank) {
            throw new IllegalArgumentException("qube length must match rank: " + this.rank);
        }
        this.qube = Arrays.copyOf(qube, qube.length);
        this.length0 = qube[0];
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public int length() {
        if (this.length0 < 0) {
            throw new IllegalArgumentException("length of SparseDataSet was never set");
        }
        return this.length0;
    }

    @Override
    public int length(int i) {
        if (this.qube != null) {
            return this.qube[1];
        }
        Integer len = this.length.get(String.valueOf(i));
        return len == null ? 0 : len;
    }

    @Override
    public int length(int i0, int i1) {
        if (this.qube != null) {
            return this.qube[2];
        }
        Integer len = this.length.get(String.valueOf(i0) + "_" + String.valueOf(i1));
        return len == null ? 0 : len;
    }

    @Override
    public int length(int i0, int i1, int i2) {
        if (this.qube != null) {
            return this.qube[3];
        }
        Integer len = this.length.get(String.valueOf(i0) + "_" + String.valueOf(i1) + "_" + String.valueOf(i2));
        return len == null ? 0 : len;
    }

    @Override
    public void putValue(double d) {
        this.checkImmutable();
        this.data.put("", d);
    }

    @Override
    public void putValue(int i0, double d) {
        this.checkImmutable();
        if (this.qube == null) {
            this.length0 = Math.max(i0 + 1, this.length0);
        }
        this.data.put(String.valueOf(i0), d);
    }

    @Override
    public void putValue(int i0, int i1, double d) {
        this.checkImmutable();
        if (this.qube == null) {
            this.length0 = Math.max(i0 + 1, this.length0);
            Integer length1 = this.length.get(String.valueOf(i0));
            if (length1 == null || length1 <= i1) {
                length1 = i1 + 1;
                this.length.put(String.valueOf(i0), length1);
            }
        }
        this.data.put(String.valueOf(i0) + "_" + String.valueOf(i1), d);
    }

    @Override
    public void putValue(int i0, int i1, int i2, double d) {
        this.checkImmutable();
        if (this.qube == null) {
            Integer length2;
            this.length0 = Math.max(i0 + 1, this.length0);
            Integer length1 = this.length.get(String.valueOf(i0));
            if (length1 == null || length1 <= i1) {
                length1 = i1 + 1;
                this.length.put(String.valueOf(i0), length1);
            }
            if ((length2 = this.length.get(String.valueOf(i0) + "_" + String.valueOf(i1))) == null || length2 <= i1) {
                length2 = i2 + 1;
                this.length.put(String.valueOf(i0) + "_" + String.valueOf(i1), length2);
            }
        }
        this.data.put(String.valueOf(i0) + "_" + String.valueOf(i1) + "_" + String.valueOf(i2), d);
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double d) {
        this.checkImmutable();
        if (this.qube == null) {
            Integer length3;
            Integer length2;
            this.length0 = Math.max(i0 + 1, this.length0);
            Integer length1 = this.length.get(String.valueOf(i0));
            if (length1 == null || length1 <= i1) {
                length1 = i1 + 1;
                this.length.put(String.valueOf(i0), length1);
            }
            if ((length2 = this.length.get(String.valueOf(i0) + "_" + String.valueOf(i1))) == null || length2 <= i1) {
                length2 = i2 + 1;
                this.length.put(String.valueOf(i0) + "_" + String.valueOf(i1), length2);
            }
            if ((length3 = this.length.get(String.valueOf(i0) + "_" + String.valueOf(i1) + "_" + String.valueOf(i2))) == null || length3 <= i1) {
                length3 = i3 + 1;
                this.length.put(String.valueOf(i0) + "_" + String.valueOf(i1) + "_" + String.valueOf(i2), length3);
            }
        }
        this.data.put(String.valueOf(i0) + "_" + String.valueOf(i1) + "_" + String.valueOf(i2) + "_" + String.valueOf(i3), d);
    }

    @Override
    public double value() {
        if (this.rank != 0) {
            throw new IllegalArgumentException("rank mismatch, data is rank " + this.rank);
        }
        Double v = this.data.get("");
        return v == null ? 0.0 : v;
    }

    @Override
    public double value(int i0) {
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank mismatch, data is rank " + this.rank);
        }
        Double v = this.data.get(String.valueOf(i0));
        return v == null ? 0.0 : v;
    }

    @Override
    public double value(int i0, int i1) {
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank mismatch, data is rank " + this.rank);
        }
        Double v = this.data.get(String.valueOf(i0) + "_" + String.valueOf(i1));
        return v == null ? 0.0 : v;
    }

    @Override
    public double value(int i0, int i1, int i2) {
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank mismatch, data is rank " + this.rank);
        }
        Double v = this.data.get(String.valueOf(i0) + "_" + String.valueOf(i1) + "_" + String.valueOf(i2));
        return v == null ? 0.0 : v;
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank mismatch, data is rank " + this.rank);
        }
        Double v = this.data.get(String.valueOf(i0) + "_" + String.valueOf(i1) + "_" + String.valueOf(i2) + "_" + String.valueOf(i3));
        return v == null ? 0.0 : v;
    }
}

