/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.LoggerManager;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class SortDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerManager.getLogger("qdataset.sort");
    QDataSet source;
    QDataSet sort;

    public SortDataSet(QDataSet source, QDataSet sort) {
        QDataSet ds;
        QDataSet dep3;
        QDataSet dep2;
        QDataSet dep1;
        QDataSet p0;
        this.source = source;
        this.sort = sort;
        if (sort.length() == 0) {
            logger.log(Level.FINE, "sort is zero-length for {0}", source);
        } else {
            QDataSet range = Ops.extent(sort);
            if (range.value(0) < 0.0) {
                throw new IndexOutOfBoundsException("sort index contains out-of-bounds element: " + range.value(0));
            }
            if (range.value(1) >= (double)source.length()) {
                throw new IndexOutOfBoundsException("sort index contains out-of-bounds element: " + range.value(1));
            }
        }
        this.properties = new HashMap();
        QDataSet dep0 = (QDataSet)source.property("DEPEND_0");
        if (dep0 != null) {
            this.properties.put("DEPEND_0", new SortDataSet(dep0, sort));
        }
        if ((p0 = (QDataSet)source.property("PLANE_0")) != null) {
            this.properties.put("PLANE_0", new SortDataSet(p0, sort));
        }
        if ((dep1 = (QDataSet)source.property("DEPEND_1")) != null && dep1.rank() > 1) {
            this.properties.put("DEPEND_1", new SortDataSet(dep1, sort));
        }
        if ((dep2 = (QDataSet)source.property("DEPEND_2")) != null && dep2.rank() > 1) {
            this.properties.put("DEPEND_2", new SortDataSet(dep2, sort));
        }
        if ((dep3 = (QDataSet)source.property("DEPEND_3")) != null && dep3.rank() > 1) {
            this.properties.put("DEPEND_3", new SortDataSet(dep3, sort));
        }
        if ((ds = (QDataSet)source.property("BIN_PLUS")) != null) {
            if (ds.rank() == 0) {
                ds = Ops.replicate(ds, source.length());
            }
            this.properties.put("BIN_PLUS", new SortDataSet(ds, sort));
        }
        if ((ds = (QDataSet)source.property("BIN_MINUS")) != null) {
            if (ds.rank() == 0) {
                ds = Ops.replicate(ds, source.length());
            }
            this.properties.put("BIN_MINUS", new SortDataSet(ds, sort));
        }
        if ((ds = (QDataSet)source.property("DELTA_PLUS")) != null) {
            if (ds.rank() == 0) {
                ds = Ops.replicate(ds, source.length());
            }
            this.properties.put("DELTA_PLUS", new SortDataSet(ds, sort));
        }
        if ((ds = (QDataSet)source.property("DELTA_MINUS")) != null) {
            if (ds.rank() == 0) {
                ds = Ops.replicate(ds, source.length());
            }
            this.properties.put("DELTA_MINUS", new SortDataSet(ds, sort));
        }
        if ((ds = (QDataSet)source.property("BIN_MAX")) != null) {
            this.properties.put("BIN_MAX", new SortDataSet(ds, sort));
        }
        if ((ds = (QDataSet)source.property("BIN_MIN")) != null) {
            this.properties.put("BIN_MIN", new SortDataSet(ds, sort));
        }
        this.properties.put("CACHE_TAG", null);
        DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(source, null), this);
    }

    @Override
    public int rank() {
        return this.source.rank();
    }

    @Override
    public double value(int i) {
        return this.source.value((int)this.sort.value(i));
    }

    @Override
    public double value(int i0, int i1) {
        return this.source.value((int)this.sort.value(i0), i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.source.value((int)this.sort.value(i0), i1, i2);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.source.value((int)this.sort.value(i0), i1, i2, i3);
    }

    @Override
    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.source.property(name);
    }

    @Override
    public Object property(String name, int i) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.source.property(name, (int)this.sort.value(i));
    }

    @Override
    public int length() {
        return this.sort.length();
    }

    @Override
    public int length(int i) {
        return this.source.length((int)this.sort.value(i));
    }

    @Override
    public int length(int i, int j) {
        return this.source.length((int)this.sort.value(i), j);
    }

    @Override
    public int length(int i, int j, int k) {
        return this.source.length((int)this.sort.value(i), j, k);
    }
}

