/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.Map;
import java.util.logging.Logger;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.LoggerManager;

public class Slice0DataSet
extends AbstractDataSet
implements RankZeroDataSet {
    private static final Logger logger = LoggerManager.getLogger("qdataset");
    QDataSet ds;
    int index;

    public Slice0DataSet(QDataSet ds, int index) {
        this(ds, index, true);
    }

    public Slice0DataSet(QDataSet ds, int index, boolean addContext) {
        String prop;
        QDataSet plane0;
        DRank0DataSet context;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit > 4");
        }
        if (ds.rank() < 1) {
            throw new IllegalArgumentException("slice called on rank 0 dataset");
        }
        if (ds.length() == 0) {
            throw new IndexOutOfBoundsException("can't slice empty dataset " + ds);
        }
        if (index >= ds.length()) {
            throw new IndexOutOfBoundsException("can't slice " + ds + " at index " + index);
        }
        this.ds = ds;
        this.index = index;
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep0 != null && dep1 != null && dep0.rank() > 1 && dep1.rank() > 1 && !SemanticOps.isBins(dep0) && !SemanticOps.isBins(dep1)) {
            this.putProperty("DEPEND_0", new Slice0DataSet(dep0, index, false));
            this.putProperty("DEPEND_1", new Slice0DataSet(dep1, index, false));
        } else if (DataSetUtil.isQube(ds) || dep1 != null) {
            QDataSet dep;
            QDataSet bds;
            if (addContext) {
                if (dep0 != null) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep0, index, false));
                } else {
                    context = DataSetUtil.asDataSet(index);
                    context.putProperty("NAME", "slice0");
                    DataSetUtil.addContext(this, (QDataSet)context);
                }
            }
            if (dep1 != null && dep1.rank() == 2 && !SemanticOps.isBins(dep1)) {
                this.putProperty("DEPEND_0", new Slice0DataSet(dep1, index, false));
            } else if (dep1 != null && dep1.rank() == 2 && SemanticOps.isBins(dep1)) {
                this.putProperty("DEPEND_0", dep1);
            } else if (ds.rank() > 1 && dep1 != null) {
                this.putProperty("DEPEND_0", dep1);
            }
            this.putProperty("BUNDLE_0", ds.property("BUNDLE_1"));
            this.putProperty("BUNDLE_1", null);
            this.putProperty("BINS_0", ds.property("BINS_1"));
            if (ds.rank() == 1 && (bds = (QDataSet)ds.property("BUNDLE_0")) != null) {
                Map<String, Object> o = DataSetUtil.sliceProperties(bds, index, null);
                DataSetUtil.putProperties(o, this);
            }
            if (ds.rank() > 2) {
                dep = (QDataSet)ds.property("DEPEND_2");
                if (dep != null && dep.rank() == 2) {
                    this.putProperty("DEPEND_1", new Slice0DataSet(dep, index, false));
                } else {
                    this.putProperty("DEPEND_1", dep);
                }
            }
            if (ds.rank() > 3) {
                dep = (QDataSet)ds.property("DEPEND_3");
                if (dep != null && dep.rank() == 2) {
                    this.putProperty("DEPEND_2", new Slice0DataSet(dep, index, false));
                } else {
                    this.putProperty("DEPEND_2", dep);
                }
            }
        } else {
            if (dep0 != null && dep0.rank() > 1) {
                this.putProperty("DEPEND_0", new Slice0DataSet(dep0, index, false));
            } else if (dep0 != null) {
                if (addContext) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep0, index, false));
                }
            } else if (ds.property("DEPEND_0", index) == null) {
                this.putProperty("DEPEND_0", null);
            } else {
                if (addContext) {
                    context = DataSetUtil.asDataSet(index);
                    context.putProperty("NAME", "slice0");
                    DataSetUtil.addContext(this, (QDataSet)context);
                }
                this.putProperty("DEPEND_0", ds.property("DEPEND_0", index));
            }
            if (ds.rank() > 2) {
                this.putProperty("DEPEND_1", ds.property("DEPEND_1", index));
            }
            this.putProperty("RENDER_TYPE", ds.property("RENDER_TYPE", index));
            this.putProperty("BINS_0", ds.property("BINS_0", index));
            if (ds.rank() > 2) {
                this.putProperty("BINS_1", ds.property("BINS_1", index));
            }
            this.putProperty("BUNDLE_0", ds.property("BUNDLE_0", index));
            if (ds.rank() > 2) {
                this.putProperty("BUNDLE_1", ds.property("BUNDLE_1", index));
            }
        }
        this.putProperty("JOIN_0", null);
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 1) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new Slice0DataSet(plane0, index, addContext));
        }
        String[] p = DataSetUtil.correlativeProperties();
        for (int i = 0; i < p.length; ++i) {
            Object o = ds.property(p[i]);
            if (o != null && !(o instanceof QDataSet)) {
                logger.warning("dropping property " + p[i] + " because it is not a QDataSet");
                continue;
            }
            QDataSet delta = (QDataSet)o;
            if (delta == null || delta.rank() <= 0) continue;
            this.putProperty(p[i], new Slice0DataSet(delta, index, addContext));
        }
        this.putProperty("WEIGHTS", null);
        DataSetUtil.copyDimensionProperties(ds, this);
        DataSetUtil.maybeCopyRenderType(ds, this);
    }

    @Override
    public int rank() {
        return this.ds.rank() - 1;
    }

    @Override
    public double value() {
        return this.ds.value(this.index);
    }

    @Override
    public double value(int i) {
        return this.ds.value(this.index, i);
    }

    @Override
    public double value(int i0, int i1) {
        return this.ds.value(this.index, i0, i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.ds.value(this.index, i0, i1, i2);
    }

    @Override
    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name, this.index);
        }
        return null;
    }

    @Override
    public Object property(String name, int i) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name, this.index);
        }
        return null;
    }

    @Override
    public int length() {
        return this.ds.length(this.index);
    }

    @Override
    public int length(int i0) {
        return this.ds.length(this.index, i0);
    }

    @Override
    public int length(int i0, int i1) {
        return this.ds.length(this.index, i0, i1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Slice0DataSet) {
            Slice0DataSet that = (Slice0DataSet)obj;
            return that.ds.equals(this.ds) && that.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.ds.hashCode() + this.index;
    }
}

