/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetAnnotations;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SubsetDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public final class SemanticOps {
    private static final Logger logger = LoggerManager.getLogger("qdataset");
    private static final Map<String, Class> propertyTypes = new HashMap<String, Class>();

    private SemanticOps() {
    }

    public static Units getUnits(QDataSet ds) {
        if (ds == null) {
            throw new NullPointerException("ds is null");
        }
        Units u = (Units)ds.property("UNITS");
        if (u == null && ds.rank() > 1 && ds.property("JOIN_0") != null) {
            u = (Units)ds.slice(0).property("UNITS");
        }
        return u == null ? Units.dimensionless : u;
    }

    public static UnitsConverter getUnitsConverter(QDataSet src, QDataSet dst) {
        Units usrc = SemanticOps.getUnits(src);
        Units udst = SemanticOps.getUnits(dst);
        return usrc.getConverter(udst);
    }

    public static UnitsConverter getLooseUnitsConverter(QDataSet src, QDataSet dst) {
        Units usrc = SemanticOps.getUnits(src);
        Units udst = SemanticOps.getUnits(dst);
        try {
            return usrc.getConverter(udst);
        }
        catch (InconvertibleUnitsException ex) {
            if (UnitsUtil.isRatioMeasurement(usrc) && UnitsUtil.isRatioMeasurement(udst)) {
                if (Units.dimensionless == usrc || Units.dimensionless == udst) {
                    return UnitsConverter.LOOSE_IDENTITY;
                }
                throw ex;
            }
            throw ex;
        }
    }

    public static String[] getComponentNames(QDataSet ds) {
        int n = ds.length(0);
        QDataSet bdesc = (QDataSet)ds.property("BUNDLE_1");
        if (bdesc != null && bdesc.rank() == 2) {
            String[] result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = (String)bdesc.property("NAME", i);
                if (result[i] != null) continue;
                result[i] = "ch_" + i;
            }
            return result;
        }
        QDataSet labels = bdesc != null && bdesc.rank() == 1 ? bdesc : (QDataSet)ds.property("DEPEND_1");
        if (labels == null) {
            String[] result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = "ch_" + i;
            }
            return result;
        }
        Units u = SemanticOps.getUnits(labels);
        String[] slabels = new String[n];
        for (int i = 0; i < n; ++i) {
            slabels[i] = labels.rank() > 1 ? "ch_" + i : String.valueOf(u.createDatum(labels.value(i)));
        }
        return slabels;
    }

    public static String[] getComponentLabels(QDataSet ds) {
        int n = ds.length(0);
        QDataSet bdesc = (QDataSet)ds.property("BUNDLE_1");
        if (bdesc != null && bdesc.rank() == 2) {
            String[] result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = (String)bdesc.property("LABEL", i);
                if (result[i] == null) {
                    result[i] = (String)bdesc.property("NAME", i);
                }
                if (result[i] != null) continue;
                result[i] = "ch_" + i;
            }
            return result;
        }
        QDataSet labels = bdesc != null && bdesc.rank() == 1 ? bdesc : (QDataSet)ds.property("DEPEND_1");
        if (labels == null) {
            String[] result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = "ch_" + i;
            }
            return result;
        }
        Units u = SemanticOps.getUnits(labels);
        String[] slabels = new String[n];
        for (int i = 0; i < n; ++i) {
            slabels[i] = labels.rank() > 1 ? "ch_" + i : String.valueOf(u.createDatum(labels.value(i)));
        }
        return slabels;
    }

    public static synchronized Units lookupUnits(String sunits) {
        return Units.lookupUnits(sunits);
    }

    public static Units lookupTimeLengthUnit(String s) throws ParseException {
        return Units.lookupTimeLengthUnit(s);
    }

    public static synchronized Units lookupTimeUnits(String units) throws ParseException {
        return Units.lookupTimeUnits(units);
    }

    public static synchronized Units lookupTimeUnits(Datum base, Units offsetUnits) {
        return Units.lookupTimeUnits(base, offsetUnits);
    }

    public static boolean isRank1Bundle(QDataSet ds) {
        if (ds.rank() != 1) {
            return false;
        }
        if (ds.property("BUNDLE_0") != null) {
            return true;
        }
        QDataSet dep = (QDataSet)ds.property("DEPEND_0");
        if (dep == null) {
            return false;
        }
        Units depu = SemanticOps.getUnits(dep);
        return depu instanceof EnumerationUnits;
    }

    public static boolean isBundle(QDataSet ds) {
        return ds.rank() == 2 && ds.property("BUNDLE_1") != null && !SemanticOps.isRank2Waveform(ds);
    }

    public static boolean isRank2Waveform(QDataSet fillDs) {
        if (fillDs.rank() == 2) {
            QDataSet dep0 = (QDataSet)fillDs.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)fillDs.property("DEPEND_1");
            if (dep0 != null && dep1 != null && (dep1.rank() == 1 && dep1.length() >= 32 || dep1.rank() == 2 && dep1.length(0) >= 32)) {
                Units dep0units = SemanticOps.getUnits(dep0);
                Units dep1units = SemanticOps.getUnits(dep1);
                if (dep0units != Units.dimensionless && dep1units.isConvertibleTo(dep0units.getOffsetUnits())) {
                    if (dep0units != dep1units) {
                        return true;
                    }
                    return Units.seconds.isConvertibleTo(dep0units);
                }
            }
        }
        return false;
    }

    public static boolean isRank3JoinOfRank2Waveform(QDataSet ds) {
        return ds.rank() == 3 && SemanticOps.isJoin(ds) && SemanticOps.isRank2Waveform(ds.slice(0));
    }

    public static boolean isLegacyBundle(QDataSet zds) {
        Units u;
        QDataSet dep1;
        return zds.rank() == 2 && (dep1 = (QDataSet)zds.property("DEPEND_1")) != null && (u = (Units)dep1.property("UNITS")) instanceof EnumerationUnits;
    }

    public static boolean isBins(QDataSet ds) {
        String binsProp = (String)ds.property("BINS_" + (ds.rank() - 1));
        boolean bins = binsProp != null && ("min,max".equals(binsProp) || "min,maxInclusive".equals(binsProp));
        return bins;
    }

    public static boolean isMonotonic(QDataSet ds) {
        return DataSetUtil.isMonotonic(ds);
    }

    public static boolean isJoin(QDataSet ds) {
        return ds.rank() > 1 && ds.property("JOIN_0") != null;
    }

    public static QDataSet getPlanarView(QDataSet ds, String name) {
        if (ds.property("PLANE_0") == null) {
            return null;
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("empty name");
        }
        if (name.charAt(0) == 'P' && Pattern.matches("PLANE_(\\d|\\d\\d)", name)) {
            return (QDataSet)ds.property(name);
        }
        for (int i = 0; i < 50; ++i) {
            QDataSet plane = (QDataSet)ds.property("PLANE_" + i);
            if (plane == null) {
                return null;
            }
            String tname = (String)plane.property("NAME");
            if (tname == null) {
                System.err.println("unnamed plane in " + ds);
                continue;
            }
            if (!name.equals(tname)) continue;
            return plane;
        }
        return null;
    }

    public static QDataSet weightsDataSet(QDataSet ds) {
        return DataSetUtil.weightsDataSet(ds);
    }

    public static Datum guessXTagWidth(QDataSet ds, QDataSet yds) {
        RankZeroDataSet cadence = DataSetUtil.guessCadenceNew(ds, yds);
        return cadence == null ? null : DataSetUtil.asDatum((QDataSet)cadence);
    }

    public static QDataSet xtagsDataSet(QDataSet ds) {
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            return dep0;
        }
        if (SemanticOps.isBundle(ds) && !SemanticOps.isBins(ds)) {
            return DataSetOps.unbundle(ds, 0);
        }
        if (SemanticOps.isLegacyBundle(ds)) {
            return DataSetOps.unbundle(ds, 0);
        }
        if (SemanticOps.isJoin(ds) && ds.rank() > 2) {
            QDataSet xds = SemanticOps.xtagsDataSet(ds.slice(0));
            JoinDataSet result = new JoinDataSet(xds);
            for (int i = 1; i < ds.length(); ++i) {
                result.join(SemanticOps.xtagsDataSet(ds.slice(i)));
            }
            return result;
        }
        return new IndexGenDataSet(ds.length());
    }

    public static QDataSet ytagsDataSet(QDataSet ds) {
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 != null) {
            if (SemanticOps.getUnits(dep1) instanceof EnumerationUnits) {
                if (dep1.length() == 1) {
                    return DataSetOps.slice1(ds, 0);
                }
                return DataSetOps.slice1(ds, 1);
            }
            return dep1;
        }
        if (SemanticOps.isBundle(ds)) {
            if (ds.length(0) == 1) {
                return DataSetOps.unbundle(ds, 0);
            }
            return DataSetOps.unbundle(ds, 1);
        }
        if (SemanticOps.isLegacyBundle(ds)) {
            return DataSetOps.unbundle(ds, 1);
        }
        if (SemanticOps.isJoin(ds)) {
            QDataSet yds = SemanticOps.ytagsDataSet(ds.slice(0));
            JoinDataSet result = new JoinDataSet(yds);
            for (int i = 1; i < ds.length(); ++i) {
                result.join(SemanticOps.ytagsDataSet(ds.slice(i)));
            }
            return result;
        }
        if (ds.length() > 0 && ds.property("DEPEND_1") == null && ds.property("DEPEND_0", 0) != null) {
            if (DataSetUtil.isQube(ds)) {
                return SemanticOps.xtagsDataSet(ds.slice(0));
            }
            QDataSet yds = SemanticOps.xtagsDataSet(ds.slice(0));
            JoinDataSet result = new JoinDataSet(yds);
            for (int i = 1; i < ds.length(); ++i) {
                result.join(SemanticOps.xtagsDataSet(ds.slice(i)));
            }
            result.putProperty("UNITS", yds.slice(0).property("UNITS"));
            return result;
        }
        if (ds.rank() == 1) {
            return ds;
        }
        if (ds.rank() == 2 && SemanticOps.isBins(ds)) {
            return ds;
        }
        QDataSet result = (QDataSet)ds.property("DEPEND_1");
        if (result == null) {
            return new IndexGenDataSet(ds.length(0));
        }
        return result;
    }

    public static QDataSet getSimpleTableContaining(QDataSet tds, Datum x, Datum y) {
        if (tds.rank() == 2) {
            return tds;
        }
        for (int i = 0; i < tds.length(); ++i) {
            QDataSet tds1 = tds.slice(i);
            QDataSet bounds = SemanticOps.bounds(tds1);
            Units xunits = SemanticOps.getUnits(SemanticOps.xtagsDataSet(tds1));
            Units yunits = SemanticOps.getUnits(SemanticOps.ytagsDataSet(tds1));
            if (yunits instanceof EnumerationUnits) {
                return DataSetOps.slice2(tds, 0);
            }
            if (!(bounds.value(0, 0) <= x.doubleValue(xunits)) || !(x.doubleValue(xunits) < bounds.value(0, 1)) || !(bounds.value(1, 0) <= y.doubleValue(yunits)) || !(y.doubleValue(yunits) < bounds.value(1, 1))) continue;
            return tds1;
        }
        return null;
    }

    public static QDataSet getDependentDataSet(QDataSet ds) {
        if (!SemanticOps.isTableDataSet(ds)) {
            QDataSet vds = ds.rank() == 2 && SemanticOps.isBundle(ds) ? DataSetOps.unbundleDefaultDataSet(ds) : ds;
            return vds;
        }
        return ds;
    }

    public static QDataSet bounds(QDataSet ds) {
        QDataSet yrange;
        QDataSet xrange;
        QDataSet result = (QDataSet)DataSetAnnotations.getInstance().getAnnotation(ds, "bounds");
        if (result != null) {
            return result;
        }
        if (ds.rank() == 2) {
            if (ds.property("DEPEND_1") == null && ds.property("BUNDLE_1") != null && ds.property("BINS_1") == null) {
                throw new IllegalArgumentException("scheme not supported: " + ds);
            }
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds), null);
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds), null);
        } else if (ds.rank() == 3) {
            QDataSet ds1 = ds.slice(0);
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1), null);
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1), null);
            for (int i = 1; i < ds.length(); ++i) {
                ds1 = ds.slice(i);
                xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1), xrange);
                yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1), yrange);
            }
        } else if (ds.rank() == 1) {
            if (ds.property("BUNDLE_0") != null) {
                throw new IllegalArgumentException("scheme not supported: " + ds);
            }
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds), null);
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds), null);
        } else {
            throw new IllegalArgumentException("scheme not supported: " + ds);
        }
        JoinDataSet jds = (JoinDataSet)Ops.join(xrange, yrange);
        jds.putProperty("BINS_1", "min,maxInclusive");
        DataSetAnnotations.getInstance().putAnnotation(ds, "bounds", jds);
        return jds;
    }

    public static boolean isTableDataSet(QDataSet ds) {
        if (ds.rank() == 3 || SemanticOps.isSimpleTableDataSet(ds)) {
            return true;
        }
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (ds.rank() == 2) {
            if (dep1 != null) {
                return true;
            }
            QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
            return bds == null;
        }
        return false;
    }

    public static boolean isSimpleTableDataSet(QDataSet ds) {
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 != null && dep1.rank() != 1) {
            return false;
        }
        return ds.rank() == 2 && (dep1 != null && dep1.rank() == 1 || !Ops.isBundle(ds)) && !Ops.isLegacyBundle(ds);
    }

    public static boolean isSimpleBundleDataSet(QDataSet ds) {
        return ds.rank() == 2 && ds.property("BUNDLE_1") != null;
    }

    public static boolean isTimeSeries(QDataSet ds) {
        if (SemanticOps.isJoin(ds)) {
            return SemanticOps.isTimeSeries(ds.slice(0));
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        return dep0 != null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(dep0));
    }

    public static Double doubleValue(Number value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static Datum getDatum(QDataSet ds, double d) {
        Units u = SemanticOps.getUnits(ds);
        Double vmin = SemanticOps.doubleValue((Number)ds.property("VALID_MIN"));
        Double vmax = SemanticOps.doubleValue((Number)ds.property("VALID_MAX"));
        Double fill = SemanticOps.doubleValue((Number)ds.property("FILL_VALUE"));
        if (vmin != null && vmin > d) {
            return u.getFillDatum();
        }
        if (vmax != null && vmax < d) {
            return u.getFillDatum();
        }
        if (fill != null && fill == d) {
            return u.getFillDatum();
        }
        return u.createDatum(d);
    }

    public static QDataSet trim(QDataSet ds, DatumRange xrange, DatumRange yrange) {
        int rank = ds.rank();
        if (ds.rank() == 0) {
            return ds;
        }
        if (xrange == null && yrange == null) {
            return ds;
        }
        if (rank == 3 && SemanticOps.isJoin(ds)) {
            JoinDataSet jds = new JoinDataSet(ds.rank());
            for (int i = 0; i < ds.length(); ++i) {
                jds.join(SemanticOps.trim(ds.slice(i), xrange, yrange));
            }
            DataSetUtil.putProperties(DataSetUtil.getProperties(ds), jds);
            return jds;
        }
        if (rank == 2) {
            if (SemanticOps.isRank2Waveform(ds)) {
                QDataSet xds = SemanticOps.xtagsDataSet(ds);
                QDataSet yds = SemanticOps.xtagsDataSet(ds.slice(0));
                DRank0DataSet ydsMax = DataSetUtil.asDataSet(yds.value(yds.length() - 1), SemanticOps.getUnits(yds));
                QDataSet xinside = xrange == null ? null : Ops.and(Ops.ge(Ops.add(xds, ydsMax), DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
                SubsetDataSet sds = new SubsetDataSet(ds);
                if (xinside != null) {
                    sds.applyIndex(0, Ops.where(xinside));
                }
                return sds;
            }
            if (SemanticOps.isSimpleTableDataSet(ds)) {
                QDataSet xds = SemanticOps.xtagsDataSet(ds);
                QDataSet yds = SemanticOps.xtagsDataSet(ds.slice(0));
                QDataSet xinside = xrange == null ? null : Ops.and(Ops.ge(xds, DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
                QDataSet yinside = yrange == null ? null : Ops.and(Ops.ge(yds, DataSetUtil.asDataSet(yrange.min())), Ops.le(yds, DataSetUtil.asDataSet(yrange.max())));
                SubsetDataSet sds = new SubsetDataSet(ds);
                if (xinside != null) {
                    sds.applyIndex(0, Ops.where(xinside));
                }
                if (yinside != null) {
                    sds.applyIndex(1, Ops.where(yinside));
                }
                return sds;
            }
            if (SemanticOps.isBundle(ds)) {
                QDataSet xds = SemanticOps.xtagsDataSet(ds);
                QDataSet yds = SemanticOps.ytagsDataSet(ds);
                QDataSet xinside = xrange == null ? null : Ops.and(Ops.ge(xds, DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
                SubsetDataSet sds = new SubsetDataSet(ds);
                if (xrange == null && yrange == null) {
                    return ds;
                }
                if (xrange == null) {
                    return ds;
                }
                if (yrange == null) {
                    QDataSet ok = Ops.where(xinside);
                    sds.applyIndex(0, ok);
                } else {
                    logger.fine("yds is being ignored, not sure why...");
                    QDataSet ok = Ops.where(xinside);
                    sds.applyIndex(0, ok);
                }
                return sds;
            }
            QDataSet xds = SemanticOps.xtagsDataSet(ds);
            QDataSet yds = SemanticOps.getDependentDataSet(ds);
            QDataSet xinside = xrange == null ? null : Ops.and(Ops.ge(xds, DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
            SubsetDataSet sds = new SubsetDataSet(ds);
            if (xrange == null && yrange == null) {
                return ds;
            }
            if (xrange == null) {
                return ds;
            }
            if (yrange == null) {
                QDataSet ok = Ops.where(xinside);
                sds.applyIndex(0, ok);
            } else {
                logger.fine("yds is being ignored, not sure why...");
                QDataSet ok = Ops.where(xinside);
                sds.applyIndex(0, ok);
            }
            return sds;
        }
        if (rank == 1) {
            QDataSet yinside;
            QDataSet xds = SemanticOps.xtagsDataSet(ds);
            QDataSet yds = SemanticOps.getDependentDataSet(ds);
            QDataSet xinside = null;
            if (DataSetUtil.isMonotonic(xds) && xds.property("FILL_VALUE") == null) {
                if (xrange != null) {
                    int j;
                    int i = DataSetUtil.xTagBinarySearch(xds, xrange.min(), 0, xds.length() - 1);
                    if (i < 0) {
                        i = -1 * (i + 1);
                    }
                    if ((j = DataSetUtil.xTagBinarySearch(xds, xrange.max(), i, xds.length() - 1)) < 0) {
                        j = -1 * (j + 1);
                    }
                    if (yrange == null) {
                        return ds.trim(i, j);
                    }
                    int[] back = new int[xds.length()];
                    if (j == xds.length()) {
                        j = xds.length() - 1;
                    }
                    for (int ii = i; ii <= j; ++ii) {
                        back[ii] = 1;
                    }
                    xinside = IDataSet.wrap(back);
                }
            } else {
                xinside = xrange == null ? null : Ops.and(Ops.ge(xds, DataSetUtil.asDataSet(xrange.min())), Ops.le(xds, DataSetUtil.asDataSet(xrange.max())));
            }
            QDataSet qDataSet = yinside = yrange == null ? null : Ops.and(Ops.ge(yds, DataSetUtil.asDataSet(yrange.min())), Ops.le(yds, DataSetUtil.asDataSet(yrange.max())));
            QDataSet ok = xrange == null ? Ops.where(yinside) : (yrange == null ? Ops.where(xinside) : Ops.where(Ops.and(xinside, yinside)));
            SubsetDataSet sds = new SubsetDataSet(ds);
            sds.applyIndex(0, ok);
            return sds;
        }
        throw new IllegalArgumentException("not supported: " + ds);
    }

    public static QDataSet cadenceCheck(QDataSet tds, QDataSet ds) {
        Datum cadence = SemanticOps.guessXTagWidth(tds, ds);
        cadence = cadence.multiply(1.1);
        QDataSet diffs = Ops.diff(tds);
        QDataSet result = (MutablePropertyDataSet)Ops.lt(diffs, DataSetUtil.asDataSet(cadence));
        if (!(result instanceof ArrayDataSet)) {
            result = ArrayDataSet.copy(result);
        }
        ArrayDataSet aresult = (ArrayDataSet)result;
        ArrayDataSet one = ArrayDataSet.createRank1(aresult.getComponentType(), 1);
        one.putValue(0, 1.0);
        DataSetUtil.copyDimensionProperties(aresult, one);
        result = ArrayDataSet.append(aresult, one);
        result = Ops.link(tds, result);
        return result;
    }

    public static boolean checkPropertyType(String prop, Object value, boolean throwException) {
        Class typ = propertyTypes.get(prop);
        if (typ == null || value == null || typ.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (throwException) {
            String styp = typ.toString();
            if (typ == Number.class) {
                styp = "Number";
            } else if (typ == QDataSet.class) {
                styp = "QDataSet";
            }
            if (value instanceof String) {
                throw new IllegalArgumentException("bad value for property " + prop + ": \"" + value + "\", expected " + styp);
            }
            throw new IllegalArgumentException("bad value for property " + prop + ": " + value + ", expected " + styp);
        }
        return false;
    }

    static {
        propertyTypes.put("UNITS", Units.class);
        propertyTypes.put("TYPICAL_MIN", Number.class);
        propertyTypes.put("TYPICAL_MAX", Number.class);
        propertyTypes.put("VALID_MIN", Number.class);
        propertyTypes.put("VALID_MAX", Number.class);
        propertyTypes.put("FILL_VALUE", Number.class);
        propertyTypes.put("ELEMENT_DIMENSIONS", int[].class);
        propertyTypes.put("CACHE_TAG", CacheTag.class);
        propertyTypes.put("CADENCE", QDataSet.class);
        propertyTypes.put("DEPEND_0", QDataSet.class);
        propertyTypes.put("DEPEND_1", QDataSet.class);
        propertyTypes.put("DEPEND_2", QDataSet.class);
        propertyTypes.put("DEPEND_3", QDataSet.class);
        propertyTypes.put("BUNDLE_0", QDataSet.class);
        propertyTypes.put("BUNDLE_1", QDataSet.class);
        propertyTypes.put("DELTA_PLUS", QDataSet.class);
        propertyTypes.put("DELTA_MINUS", QDataSet.class);
        propertyTypes.put("BIN_PLUS", QDataSet.class);
        propertyTypes.put("BIN_MINUS", QDataSet.class);
    }
}

