/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.QDataSet;

public class ReverseDataSet
extends AbstractDataSet {
    QDataSet source;
    int len;

    public ReverseDataSet(QDataSet source) {
        this.source = source;
        this.len = source.length();
        if (source.rank() != 1) {
            throw new IllegalArgumentException("only rank 1 supported");
        }
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public double value(int i) {
        return this.source.value(this.len - 1 - i);
    }

    @Override
    public int rank() {
        return 1;
    }

    @Override
    public Object property(String name) {
        if (name.equals("DEPEND_0")) {
            QDataSet dep0 = (QDataSet)this.source.property("DEPEND_0");
            if (dep0 != null) {
                return new ReverseDataSet(dep0);
            }
            return null;
        }
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.source.property(name);
    }
}

