/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.QDataSet;

public class ReplicateDataSet
extends AbstractDataSet {
    int len0;
    QDataSet source;

    public ReplicateDataSet(QDataSet s, int len0) {
        this.len0 = len0;
        this.source = s;
        if (s.rank() > 3) {
            throw new IllegalArgumentException("rank must be less than 4");
        }
    }

    @Override
    public int rank() {
        return this.source.rank() + 1;
    }

    @Override
    public double value(int il) {
        return this.source.value();
    }

    @Override
    public double value(int i0, int i1) {
        return this.source.value(i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.source.value(i1, i2);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.source.value(i1, i2, i3);
    }

    @Override
    public int length() {
        return this.len0;
    }

    @Override
    public int length(int i) {
        return this.source.length();
    }

    @Override
    public int length(int i0, int i1) {
        return this.source.length(i1);
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.source.length(i1, i2);
    }

    @Override
    public Object property(String name) {
        if (name.equals("DEPEND_0")) {
            return super.property(name);
        }
        if (name.matches("DEPEND_\\d")) {
            return this.source.property("DEPEND_" + (Integer.parseInt(name.substring(7)) - 1));
        }
        if (name.matches("BINS_\\d")) {
            return this.source.property("BINS_" + (Integer.parseInt(name.substring(5)) - 1));
        }
        if (name.matches("BUNDLE_\\d")) {
            return this.source.property("BUNDLE_" + (Integer.parseInt(name.substring(7)) - 1));
        }
        Object o = super.property(name);
        return o == null ? this.source.property(name) : o;
    }

    @Override
    public Object property(String name, int i) {
        return this.source.property(name);
    }
}

