/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.LoggerManager;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetIterator;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public final class QubeDataSetIterator
implements DataSetIterator {
    private static final Logger logger = LoggerManager.getLogger("qdataset.iterator");
    private DimensionIterator[] it;
    private DimensionIteratorFactory[] fit;
    private boolean isAllIndexLists;
    private int rank;
    private int[] qube;
    private QDataSet ds;
    private boolean allnext = true;
    private ProgressMonitor monitor;

    public QubeDataSetIterator(QDataSet ds) {
        logger.log(Level.FINE, "new dataset iterator for {0}", ds);
        ArrayList<String> problems = new ArrayList<String>();
        if (!DataSetUtil.validate(ds, problems)) {
            throw new IllegalArgumentException("data doesn't validate: " + problems);
        }
        this.it = new DimensionIterator[ds.rank()];
        this.fit = new DimensionIteratorFactory[ds.rank()];
        if (Boolean.TRUE.equals(ds.property("QUBE"))) {
            this.qube = DataSetUtil.qubeDims(ds);
            this.ds = ds;
        } else {
            this.ds = ds;
        }
        this.rank = ds.rank();
        for (int i = 0; i < ds.rank(); ++i) {
            this.fit[i] = new StartStopStepIteratorFactory(0, null, 1);
        }
        this.initialize();
    }

    private QubeDataSetIterator(QDataSet ds, DimensionIteratorFactory[] fits) {
        if (Boolean.TRUE.equals(ds.property("QUBE"))) {
            this.qube = DataSetUtil.qubeDims(ds);
            this.ds = ds;
        } else {
            this.ds = ds;
        }
        this.rank = ds.rank();
        this.ds = ds;
        this.fit = fits;
        this.it = new DimensionIterator[fits.length];
        this.initialize();
    }

    public void setMonitor(ProgressMonitor mon) {
        this.monitor = mon;
        this.monitor.setTaskSize(this.rank == 0 ? 1L : (long)this.dimLength(0));
        this.monitor.started();
    }

    public static QubeDataSetIterator sliceIterator(QDataSet ds, int sliceIndex) {
        QubeDataSetIterator result;
        if (ds.rank() == 0) {
            throw new IllegalArgumentException("can't slice rank 0");
        }
        if (ds.rank() == 1) {
            throw new IllegalArgumentException("can't slice rank 1");
        }
        if (ds.rank() == 2) {
            result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1)});
        } else if (ds.rank() == 3) {
            result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1), new StartStopStepIteratorFactory(0, null, 1)});
        } else if (ds.rank() == 4) {
            result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1), new StartStopStepIteratorFactory(0, null, 1), new StartStopStepIteratorFactory(0, null, 1)});
        } else {
            throw new IllegalArgumentException("rank limit");
        }
        return result;
    }

    public void setIndexIteratorFactory(int dim, DimensionIteratorFactory fit) {
        if (dim >= this.rank) {
            throw new IllegalArgumentException(String.format("rank limit: rank %d dataset %s has no index %d", this.ds.rank(), this.ds, dim));
        }
        this.fit[dim] = fit;
        this.initialize();
    }

    private void initialize() {
        boolean allLi = true;
        for (int i = 0; i < this.rank; ++i) {
            int dimLength = this.dimLength(i);
            this.it[i] = this.fit[i].newIterator(dimLength);
            if (this.it[i] instanceof IndexListIterator) continue;
            allLi = false;
        }
        this.isAllIndexLists = allLi;
    }

    private int dimLength(int idim) {
        if (this.qube != null) {
            return this.qube[idim];
        }
        int result = 0;
        switch (idim) {
            case 0: {
                result = this.ds.length();
                break;
            }
            case 1: {
                result = this.ds.length(Math.max(0, this.index(0)));
                break;
            }
            case 2: {
                result = this.ds.length(Math.max(0, this.index(0)), Math.max(0, this.index(1)));
                break;
            }
            case 3: {
                result = this.ds.length(Math.max(0, this.index(0)), Math.max(0, this.index(1)), Math.max(0, this.index(2)));
                break;
            }
            default: {
                throw new IllegalArgumentException("dimension not supported: " + idim);
            }
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        int i;
        if (this.rank == 0) {
            if (this.allnext) {
                return true;
            }
            if (this.monitor != null) {
                this.monitor.finished();
            }
            return false;
        }
        if (this.it[0].length() == 0) {
            if (this.monitor != null) {
                this.monitor.finished();
            }
            return false;
        }
        if (this.qube != null) {
            for (i = 1; i < this.rank; ++i) {
                if (this.it[i].length() != 0) continue;
                if (this.monitor != null) {
                    this.monitor.finished();
                }
                return false;
            }
        }
        if (this.it[i = this.rank - 1].hasNext()) {
            return true;
        }
        if (i > 0) {
            for (int j = i - 1; j >= 0; --j) {
                if (!this.it[j].hasNext()) continue;
                return true;
            }
        }
        if (this.monitor != null) {
            this.monitor.finished();
        }
        return false;
    }

    @Override
    public void next() {
        int i;
        if (this.allnext) {
            for (i = 0; i < this.rank - 1; ++i) {
                if (this.isAllIndexLists && this.it[i] instanceof IndexListIterator) continue;
                this.it[i].nextIndex();
                if (i != 0 || this.monitor == null) continue;
                this.monitor.setTaskProgress(this.it[0].index());
            }
            this.allnext = false;
            if (this.rank == 0) {
                return;
            }
        }
        if (this.it[i = this.rank - 1].hasNext()) {
            this.it[i].nextIndex();
            if (this.it[i] instanceof IndexListIterator) {
                for (int k = 0; k < i; ++k) {
                    if (!this.isAllIndexLists || !(this.it[k] instanceof IndexListIterator)) continue;
                    if (k == 0 && this.monitor != null) {
                        this.monitor.setTaskProgress(this.it[0].index());
                    }
                    this.it[k].nextIndex();
                }
            }
        } else if (i > 0) {
            for (int j = i - 1; j >= 0; --j) {
                int k;
                if (!this.it[j].hasNext()) continue;
                this.it[j].nextIndex();
                if (j == 0 && this.monitor != null) {
                    this.monitor.setTaskProgress(this.it[0].index());
                }
                if (this.it[j] instanceof IndexListIterator) {
                    for (k = 0; k < j; ++k) {
                        if (!this.isAllIndexLists || !(this.it[k] instanceof IndexListIterator)) continue;
                        this.it[k].nextIndex();
                    }
                }
                for (k = j + 1; k <= i; ++k) {
                    this.it[k] = this.fit[k].newIterator(this.dimLength(k));
                    this.it[k].nextIndex();
                }
                break;
            }
        } else {
            throw new IllegalArgumentException("no more elements");
        }
    }

    @Override
    public int index(int dim) {
        return this.it[dim].index();
    }

    @Override
    public int length(int dim) {
        return this.it[dim].length();
    }

    @Override
    public int rank() {
        int result = this.rank;
        for (DimensionIterator it1 : this.it) {
            if (!(it1 instanceof SingletonIterator)) continue;
            --result;
        }
        return result;
    }

    public String toString() {
        if (this.rank == 0) {
            return "Iter hasNext=" + this.hasNext();
        }
        StringBuilder its = new StringBuilder(this.it[0].toString());
        StringBuilder ats = new StringBuilder("" + this.it[0].index());
        for (int i = 1; i < this.rank; ++i) {
            its.append(",").append(this.it[i]);
            ats.append(",").append(this.it[i].index());
        }
        return "Iter [" + its + "] @ [" + ats + "] ";
    }

    @Override
    public DDataSet createEmptyDs() {
        int[] qube1;
        ArrayList<Integer> qqube = new ArrayList<Integer>();
        ArrayList<Integer> dimMap = new ArrayList<Integer>();
        for (int i = 0; i < this.it.length; ++i) {
            boolean reform;
            if (this.it[i] == null || (reform = this.it[i] instanceof SingletonIterator)) continue;
            qqube.add(this.it[i].length());
            dimMap.add(i);
        }
        if (this.isAllIndexLists) {
            qube1 = new int[]{this.it[0].length()};
        } else {
            qube1 = new int[qqube.size()];
            for (int i = 0; i < qqube.size(); ++i) {
                qube1[i] = (Integer)qqube.get(i);
            }
        }
        DDataSet result = DDataSet.create(qube1);
        for (int i = 0; i < dimMap.size(); ++i) {
            QubeDataSetIterator itOut;
            DDataSet depNew;
            QubeDataSetIterator iter2;
            DimensionIterator ili;
            StartStopStepIterator sssi;
            DimensionIteratorFactory[] dif;
            Object sssi2;
            int idim = (Integer)dimMap.get(i);
            QDataSet dep = (QDataSet)this.ds.property("DEPEND_" + idim);
            QDataSet bund = (QDataSet)this.ds.property("BUNDLE_" + idim);
            String bins = (String)this.ds.property("BINS_" + idim);
            if (this.fit[idim] instanceof StartStopStepIteratorFactory) {
                if (dep != null && dep.rank() == 1) {
                    sssi2 = (StartStopStepIterator)this.it[idim];
                    if (((StartStopStepIterator)sssi2).step == 1 && ((StartStopStepIterator)sssi2).start == 0 && ((StartStopStepIterator)sssi2).stop == dep.length()) {
                        result.putProperty("DEPEND_" + i, dep);
                    } else if (((StartStopStepIterator)sssi2).step == 1) {
                        result.putProperty("DEPEND_" + i, dep.trim(((StartStopStepIterator)sssi2).start, ((StartStopStepIterator)sssi2).stop));
                    } else {
                        MutablePropertyDataSet depSlice = DataSetOps.trim(dep, ((StartStopStepIterator)sssi2).start, ((StartStopStepIterator)sssi2).stop, ((StartStopStepIterator)sssi2).step);
                        result.putProperty("DEPEND_" + i, depSlice);
                    }
                } else if (dep != null && dep.rank() == 2) {
                    dif = new DimensionIteratorFactory[2];
                    if (this.it[0] instanceof StartStopStepIterator) {
                        sssi = (StartStopStepIterator)this.it[0];
                        dif[0] = new StartStopStepIteratorFactory(sssi.start, sssi.stop, sssi.step);
                    } else if (this.it[0] instanceof IndexListIterator) {
                        ili = (IndexListIterator)this.it[0];
                        dif[0] = new IndexListIteratorFactory(ili.ds);
                    } else if (this.it[0] instanceof SingletonIterator) {
                        ili = (SingletonIterator)this.it[0];
                        dif[0] = new SingletonIteratorFactory(((SingletonIterator)ili).index);
                    }
                    dif[1] = this.fit[idim];
                    iter2 = new QubeDataSetIterator(dep, dif);
                    depNew = iter2.createEmptyDs();
                    itOut = new QubeDataSetIterator(depNew);
                    while (iter2.hasNext()) {
                        iter2.next();
                        itOut.next();
                        itOut.putValue(depNew, iter2.getValue(dep));
                    }
                    result.putProperty("DEPEND_" + i, depNew);
                }
                if (bund != null) {
                    sssi2 = (StartStopStepIterator)this.it[idim];
                    if (((StartStopStepIterator)sssi2).step == 1 && ((StartStopStepIterator)sssi2).start == 0 && ((StartStopStepIterator)sssi2).stop == bund.length()) {
                        result.putProperty("BUNDLE_" + i, bund);
                    } else if (((StartStopStepIterator)sssi2).step == 1) {
                        // empty if block
                    }
                }
                if (bins == null || this.it[idim].length() != bins.split(",").length) continue;
                result.putProperty("BINS_" + i, bins);
                continue;
            }
            if (!(this.fit[idim] instanceof IndexListIteratorFactory) || this.isAllIndexLists) continue;
            if (dep != null && dep.rank() == 2) {
                dif = new DimensionIteratorFactory[2];
                if (this.it[0] instanceof StartStopStepIterator) {
                    sssi = (StartStopStepIterator)this.it[0];
                    dif[0] = new StartStopStepIteratorFactory(sssi.start, sssi.stop, sssi.step);
                } else if (this.it[0] instanceof IndexListIterator) {
                    ili = (IndexListIterator)this.it[0];
                    dif[0] = new IndexListIteratorFactory(ili.ds);
                } else if (this.it[0] instanceof SingletonIterator) {
                    ili = (SingletonIterator)this.it[0];
                    dif[0] = new SingletonIteratorFactory(((SingletonIterator)ili).index);
                }
                dif[1] = this.fit[idim];
                iter2 = new QubeDataSetIterator(dep, dif);
                depNew = iter2.createEmptyDs();
                itOut = new QubeDataSetIterator(depNew);
                while (iter2.hasNext()) {
                    iter2.next();
                    itOut.next();
                    itOut.putValue(depNew, iter2.getValue(dep));
                }
                result.putProperty("DEPEND_" + i, depNew);
                continue;
            }
            if (dep == null) continue;
            sssi2 = (IndexListIteratorFactory)this.fit[idim];
            result.putProperty("DEPEND_" + i, DataSetOps.applyIndex(dep, 0, ((IndexListIteratorFactory)sssi2).getList(), false));
        }
        return result;
    }

    @Override
    public final double getValue(QDataSet ds) {
        switch (this.rank) {
            case 0: {
                return ds.value();
            }
            case 1: {
                return ds.value(this.index(0));
            }
            case 2: {
                return ds.value(this.index(0), this.index(1));
            }
            case 3: {
                return ds.value(this.index(0), this.index(1), this.index(2));
            }
            case 4: {
                return ds.value(this.index(0), this.index(1), this.index(2), this.index(3));
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    @Override
    public final void putValue(WritableDataSet ds, double v) {
        switch (this.rank) {
            case 0: {
                ds.putValue(v);
                return;
            }
            case 1: {
                ds.putValue(this.index(0), v);
                return;
            }
            case 2: {
                ds.putValue(this.index(0), this.index(1), v);
                return;
            }
            case 3: {
                ds.putValue(this.index(0), this.index(1), this.index(2), v);
                return;
            }
            case 4: {
                ds.putValue(this.index(0), this.index(1), this.index(2), this.index(3), v);
                return;
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    public static interface DimensionIterator {
        public boolean hasNext();

        public int nextIndex();

        public int index();

        public int length();
    }

    public static interface DimensionIteratorFactory {
        public DimensionIterator newIterator(int var1);
    }

    public static class IndexListIterator
    implements DimensionIterator {
        QDataSet ds;
        int index;

        public IndexListIterator(QDataSet ds) {
            if (ds.rank() == 0) {
                ds = Ops.join(null, ds);
            }
            this.ds = ds;
            if (ds.rank() != 1) {
                throw new IllegalArgumentException("list of indeces dataset must be rank 1");
            }
            this.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.ds.length() - 1;
        }

        @Override
        public int nextIndex() {
            ++this.index;
            return (int)this.ds.value(this.index);
        }

        @Override
        public int index() {
            return (int)this.ds.value(this.index);
        }

        @Override
        public int length() {
            return this.ds.length();
        }

        public String toString() {
            String dstr = this.ds.toString();
            dstr = dstr.replace("(dimensionless)", "");
            return "[" + dstr + " @ " + this.index + "]";
        }
    }

    public static class IndexListIteratorFactory
    implements DimensionIteratorFactory {
        QDataSet ds;

        public IndexListIteratorFactory(QDataSet ds) {
            if (ds.rank() == 0) {
                ds = Ops.join(null, ds);
            }
            this.ds = ds;
            if (ds.rank() != 1) {
                throw new IllegalArgumentException("list of indeces dataset must be rank 1");
            }
        }

        @Override
        public DimensionIterator newIterator(int length) {
            ArrayDataSet list = ArrayDataSet.copy(this.ds);
            for (int i = 0; i < list.length(); ++i) {
                if (!(list.value(i) < 0.0)) continue;
                list.putValue(i, list.value(i) + (double)length);
            }
            return new IndexListIterator(list);
        }

        public QDataSet getList() {
            return this.ds;
        }
    }

    public static class SingletonIterator
    implements DimensionIterator {
        int index;
        boolean hasNext = true;

        public SingletonIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int nextIndex() {
            this.hasNext = false;
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int length() {
            return 1;
        }

        public String toString() {
            return "" + this.index;
        }
    }

    public static class SingletonIteratorFactory
    implements DimensionIteratorFactory {
        int index;

        public SingletonIteratorFactory(int index) {
            this.index = index;
        }

        @Override
        public DimensionIterator newIterator(int length) {
            if (this.index < 0) {
                return new SingletonIterator(length + this.index);
            }
            return new SingletonIterator(this.index);
        }
    }

    public static class StartStopStepIterator
    implements DimensionIterator {
        int start;
        int stop;
        int step;
        int index;
        boolean all;

        public StartStopStepIterator(int start, int stop, int step, boolean all) {
            this.start = start;
            this.stop = stop;
            this.step = step;
            this.index = start - step;
            this.all = all;
        }

        @Override
        public boolean hasNext() {
            return this.index + this.step < this.stop;
        }

        @Override
        public int nextIndex() {
            this.index += this.step;
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int length() {
            int remainder = (this.stop - this.start) % this.step;
            return (this.stop - this.start) / this.step + (remainder > 0 ? 1 : 0);
        }

        public String toString() {
            return this.all ? ":" : "" + this.start + ":" + this.stop + (this.step == 1 ? "" : ":" + this.step);
        }
    }

    public static class StartStopStepIteratorFactory
    implements DimensionIteratorFactory {
        Number start;
        Number stop;
        Number step;

        public StartStopStepIteratorFactory(Number start, Number stop, Number step) {
            this.start = start;
            this.stop = stop;
            this.step = step;
        }

        @Override
        public DimensionIterator newIterator(int length) {
            int step1;
            int start1 = this.start == null ? 0 : this.start.intValue();
            int stop1 = this.stop == null ? length : this.stop.intValue();
            int n = step1 = this.step == null ? 1 : this.step.intValue();
            if (start1 < 0) {
                start1 = length + start1;
            }
            if (stop1 < 0) {
                stop1 = length + stop1;
            }
            return new StartStopStepIterator(start1, stop1, step1, this.start == null && this.stop == null && this.step == null);
        }
    }
}

