/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetIterator;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;

public class IndexListDataSetIterator
implements DataSetIterator {
    QDataSet indeces;
    int dsrank;
    int index;

    public IndexListDataSetIterator(QDataSet indeces) {
        if (indeces.rank() == 1) {
            indeces = new BundleDataSet(indeces);
        }
        this.indeces = indeces;
        this.index = -1;
        if (indeces.length() > 0) {
            this.dsrank = indeces.length(0);
        }
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.indeces.length();
    }

    @Override
    public int index(int dim) {
        return (int)this.indeces.value(this.index, dim);
    }

    @Override
    public int length(int dim) {
        return this.indeces.length();
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int rank() {
        return 1;
    }

    @Override
    public final double getValue(QDataSet ds) {
        switch (this.dsrank) {
            case 1: {
                return ds.value(this.index(0));
            }
            case 2: {
                return ds.value(this.index(0), this.index(1));
            }
            case 3: {
                return ds.value(this.index(0), this.index(1), this.index(2));
            }
            case 4: {
                return ds.value(this.index(0), this.index(1), this.index(2), this.index(3));
            }
        }
        throw new IllegalArgumentException("rank limit: " + this.dsrank + " is not supported");
    }

    @Override
    public final void putValue(WritableDataSet ds, double v) {
        switch (this.dsrank) {
            case 1: {
                ds.putValue(this.index(0), v);
                return;
            }
            case 2: {
                ds.putValue(this.index(0), this.index(1), v);
                return;
            }
            case 3: {
                ds.putValue(this.index(0), this.index(1), this.index(2), v);
                return;
            }
            case 4: {
                ds.putValue(this.index(0), this.index(1), this.index(2), this.index(3), v);
                return;
            }
        }
        throw new IllegalArgumentException("rank limit: " + this.dsrank + " is not supported");
    }

    public String toString() {
        StringBuilder ats;
        String its = "" + this.index + " of " + this.indeces.length();
        if (this.index == -1) {
            ats = new StringBuilder("-1");
            for (int i = 1; i < this.dsrank; ++i) {
                ats.append(",").append(this.index(i));
            }
        } else {
            ats = new StringBuilder(String.valueOf(this.index(0)));
        }
        return "ListIter [" + its + "] @ [" + ats + "] ";
    }

    @Override
    public DDataSet createEmptyDs() {
        return DDataSet.createRank1(this.indeces.length());
    }
}

