/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;

public class FlattenWaveformDataSet
extends AbstractDataSet {
    QDataSet ds;
    final int n;
    private static final Logger logger = LoggerManager.getLogger("qdataset.ops");

    public FlattenWaveformDataSet(QDataSet ds) {
        this.ds = ds;
        if (!SemanticOps.isRank2Waveform(ds)) {
            throw new IllegalArgumentException("dataset must be rank 2 waveform");
        }
        this.n = ds.length(0);
        this.setupDep0();
    }

    @Override
    public int rank() {
        return 1;
    }

    @Override
    public int length() {
        return this.n * this.ds.length();
    }

    @Override
    public double value(int i0) {
        return this.ds.value(i0 / this.n, i0 % this.n);
    }

    @Override
    public Object property(String name) {
        Object v = super.property(name);
        if (v == null) {
            if (DataSetUtil.isInheritedProperty(name)) {
                return this.ds.property(name);
            }
            return null;
        }
        return v;
    }

    private void setupDep0() {
        Units dep0units;
        final QDataSet dsdep0 = (QDataSet)this.ds.property("DEPEND_0");
        final QDataSet dsdep1 = (QDataSet)this.ds.property("DEPEND_1");
        Units newDep0Units = dep0units = SemanticOps.getUnits(dsdep0);
        if (UnitsUtil.isTimeLocation(dep0units)) {
            Datum t0 = DataSetUtil.asDatum(dsdep0.slice(0));
            int[] timeArray = TimeUtil.fromDatum(t0);
            timeArray[2] = 1;
            timeArray[3] = 0;
            timeArray[4] = 0;
            timeArray[5] = 0;
            timeArray[6] = 0;
            t0 = TimeUtil.toDatum(timeArray);
            newDep0Units = Units.lookupTimeUnits(t0, (Units)dsdep1.property("UNITS"));
        }
        final UnitsConverter ucbase = UnitsConverter.getConverter(dep0units, newDep0Units);
        final Units fnewDep0Units = newDep0Units;
        final UnitsConverter uc = UnitsConverter.getConverter(SemanticOps.getUnits(dsdep1), fnewDep0Units.getOffsetUnits());
        double waveformLength = uc.convert(dsdep1.value(dsdep1.length() - 1));
        boolean monotonic = true;
        for (int k = 1; k < dsdep0.length(); ++k) {
            if (!(ucbase.convert(dsdep0.value(k)) < ucbase.convert(dsdep0.value(k - 1)) + waveformLength)) continue;
            monotonic = false;
        }
        if (!DataSetUtil.isMonotonicAndIncreasing(dsdep1)) {
            logger.warning("waveform data dep1 should be monotonic");
        }
        final Boolean fmonotonic = monotonic;
        AbstractDataSet dep0 = new AbstractDataSet(){

            @Override
            public int rank() {
                return 1;
            }

            @Override
            public int length() {
                return FlattenWaveformDataSet.this.n * FlattenWaveformDataSet.this.ds.length();
            }

            @Override
            public double value(int i0) {
                return ucbase.convert(dsdep0.value(i0 / FlattenWaveformDataSet.this.n)) + uc.convert(dsdep1.value(i0 % FlattenWaveformDataSet.this.n));
            }

            @Override
            public Object property(String name) {
                switch (name) {
                    case "CADENCE": {
                        return dsdep1.property("CADENCE");
                    }
                    case "MONOTONIC": {
                        return fmonotonic;
                    }
                    case "UNITS": {
                        return fnewDep0Units;
                    }
                    case "VALID_MIN": {
                        return null;
                    }
                    case "VALID_MAX": {
                        return null;
                    }
                    case "TYPICAL_MIN": {
                        return null;
                    }
                    case "TYPICAL_MAX": {
                        return null;
                    }
                    case "FILL_VALUE": {
                        return null;
                    }
                }
                if (DataSetUtil.isInheritedProperty(name)) {
                    return dsdep0.property(name);
                }
                return null;
            }
        };
        this.putProperty("DEPEND_0", dep0);
    }
}

