/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.lang.reflect.Array;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FloatReadAccess;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;

public final class FDataSet
extends ArrayDataSet {
    float[] back;
    private static final boolean RANGE_CHECK = "true".equals(System.getProperty("rangeChecking", "true"));
    public static final String version = "20150219";

    public static FDataSet createRank1(int len0) {
        return new FDataSet(1, len0, 1, 1, 1);
    }

    public static FDataSet createRank2(int len0, int len1) {
        return new FDataSet(2, len0, len1, 1, 1);
    }

    public static FDataSet createRank3(int len0, int len1, int len2) {
        return new FDataSet(3, len0, len1, len2, 1);
    }

    public static FDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new FDataSet(4, len0, len1, len2, len3);
    }

    public static FDataSet create(int[] qube) {
        if (qube.length == 0) {
            return new FDataSet(0, 1, 1, 1, 1);
        }
        if (qube.length == 1) {
            return FDataSet.createRank1(qube[0]);
        }
        if (qube.length == 2) {
            return FDataSet.createRank2(qube[0], qube[1]);
        }
        if (qube.length == 3) {
            return FDataSet.createRank3(qube[0], qube[1], qube[2]);
        }
        if (qube.length == 4) {
            return FDataSet.createRank4(qube[0], qube[1], qube[2], qube[3]);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static FDataSet wrap(float[] data, int[] qube) {
        if (qube.length == 1) {
            return new FDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new FDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new FDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new FDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
        }
        if (qube.length == 0) {
            return new FDataSet(0, 1, 1, 1, 1, data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static FDataSet wrap(float[] back, int rank, int len0, int len1, int len2) {
        return new FDataSet(rank, len0, len1, len2, 1, back);
    }

    protected FDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new float[len0 * len1 * len2 * len3]);
    }

    protected FDataSet(int rank, int len0, int len1, int len2, int len3, float[] back) {
        super(Float.TYPE);
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        if (this.back.length < len0 * len1 * len2 * len3) {
            logger.warning("backing array appears to be too short");
        }
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    @Override
    protected Object getBack() {
        this.checkImmutable();
        return this.back;
    }

    @Override
    protected int getBackJvmMemory() {
        return this.back.length * 4;
    }

    @Override
    protected Object getBackReadOnly() {
        return this.back;
    }

    @Override
    protected Object getBackCopy() {
        Object newback = Array.newInstance(this.back.getClass().getComponentType(), this.back.length);
        System.arraycopy(this.back, 0, newback, 0, this.back.length);
        return newback;
    }

    @Override
    protected void setBack(Object back) {
        this.checkImmutable();
        this.back = (float[])back;
    }

    @Override
    public double value() {
        if (RANGE_CHECK && this.rank != 0) {
            throw new IllegalArgumentException("rank 0 access on rank " + this.rank + " dataset");
        }
        float v = this.back[0];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0) {
        float v;
        if (RANGE_CHECK) {
            if (this.rank != 1) {
                throw new IllegalArgumentException("rank 1 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
        }
        return (v = this.back[i0]) == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1) {
        float v;
        if (RANGE_CHECK) {
            if (this.rank != 2) {
                throw new IllegalArgumentException("rank 2 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
        }
        return (v = this.back[i0 * this.len1 + i1]) == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1, int i2) {
        float v;
        if (RANGE_CHECK) {
            if (this.rank != 3) {
                throw new IllegalArgumentException("rank 3 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
        }
        return (v = this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2]) == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        float v;
        if (RANGE_CHECK) {
            if (this.rank != 4) {
                throw new IllegalArgumentException("rank 4 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
            if (i3 < 0 || i3 >= this.len3) {
                throw new IndexOutOfBoundsException("i3=" + i3 + " " + this);
            }
        }
        return (v = this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3]) == this.fill ? this.dfill : (double)v;
    }

    @Override
    public void putValue(double value) {
        this.checkImmutable();
        if (this.rank != 0) {
            throw new IllegalArgumentException("rank 0 putValue called on dataset that is rank " + this.rank + ".");
        }
        this.back[0] = (float)value;
    }

    @Override
    public void putValue(int i0, double value) {
        this.checkImmutable();
        if (RANGE_CHECK && (i0 < 0 || i0 >= this.len0)) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        this.back[i0] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        this.checkImmutable();
        if (RANGE_CHECK) {
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
        }
        this.back[i0 * this.len1 + i1] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        this.checkImmutable();
        if (RANGE_CHECK) {
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
        }
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.checkImmutable();
        if (RANGE_CHECK) {
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
            if (i3 < 0 || i3 >= this.len3) {
                throw new IndexOutOfBoundsException("i3=" + i3 + " " + this);
            }
        }
        this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3] = (float)value;
    }

    public void addValue(int i0, double value) {
        this.checkImmutable();
        int n = i0;
        this.back[n] = this.back[n] + (float)((short)value);
    }

    public void addValue(int i0, int i1, double value) {
        this.checkImmutable();
        int n = i0 * this.len1 + i1;
        this.back[n] = this.back[n] + (float)((short)value);
    }

    public static FDataSet wrap(float[] back) {
        return new FDataSet(1, back.length, 1, 1, 1, back);
    }

    public static FDataSet wrap(float[] back, int nx, int ny) {
        return new FDataSet(2, nx, ny, 1, 1, back);
    }

    public static FDataSet wrap(float[] back, int nx, int ny, int nz) {
        return new FDataSet(3, nx, ny, nz, 1, back);
    }

    @Override
    public void putProperty(String name, Object value) {
        if (name.equals("UNITS") && UnitsUtil.isTimeLocation((Units)value)) {
            logger.warning("float array is being used to store times, which typically lacks sufficient resolution to represent data.");
        }
        super.putProperty(name, value);
        if (name.equals("FILL_VALUE")) {
            this.checkFill();
        }
    }

    @Override
    public QDataSet slice(int i) {
        if (this.rank < 1) {
            throw new IllegalArgumentException("slice called on rank 0 dataset");
        }
        int nrank = this.rank - 1;
        int noff1 = i * this.len1 * this.len2 * this.len3;
        int noff2 = (i + 1) * this.len1 * this.len2 * this.len3;
        float[] newback = new float[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        Map<String, Object> props = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, i, props);
        FDataSet result = new FDataSet(nrank, this.len1, this.len2, this.len3, 1, newback);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public QDataSet trim(int start, int end) {
        if (this.rank == 0) {
            throw new IllegalArgumentException("trim called on rank 0 dataset");
        }
        if (start == 0 && end == this.len0) {
            return this;
        }
        if (RANGE_CHECK) {
            if (start > this.len0) {
                throw new IndexOutOfBoundsException("start=" + start + " > " + this.len0);
            }
            if (start < 0) {
                throw new IndexOutOfBoundsException("start=" + start + " < 0");
            }
            if (end > this.len0) {
                throw new IndexOutOfBoundsException("end=" + end + " > " + this.len0);
            }
            if (end < 0) {
                throw new IndexOutOfBoundsException("end=" + end + " < 0");
            }
            if (start > end) {
                throw new IllegalArgumentException("trim called with start>end: " + start + ">" + end);
            }
        }
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        float[] newback = new float[noff2 - noff1];
        if (noff2 - noff1 > 0) {
            System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        }
        FDataSet result = new FDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map<String, Object> props = DataSetUtil.getProperties(this);
        Map<String, Object> depProps = DataSetUtil.trimProperties(this, start, end);
        props.putAll(depProps);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            if (this.isImmutable()) {
                return null;
            }
            return (T)this;
        }
        if (clazz == FloatReadAccess.class) {
            return clazz.cast(new FDataSetFloatReadAccess());
        }
        return super.capability(clazz);
    }

    public class FDataSetFloatReadAccess
    implements FloatReadAccess {
        @Override
        public float fvalue() {
            if (RANGE_CHECK && FDataSet.this.rank != 0) {
                throw new IllegalArgumentException("rank 0 access on rank " + FDataSet.this.rank + " dataset");
            }
            return FDataSet.this.back[0];
        }

        @Override
        public float fvalue(int i0) {
            if (RANGE_CHECK) {
                if (FDataSet.this.rank != 1) {
                    throw new IllegalArgumentException("rank 1 access on rank " + FDataSet.this.rank + " dataset");
                }
                if (i0 < 0 || i0 >= FDataSet.this.len0) {
                    throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
                }
            }
            return FDataSet.this.back[i0];
        }

        @Override
        public float fvalue(int i0, int i1) {
            if (RANGE_CHECK) {
                if (FDataSet.this.rank != 2) {
                    throw new IllegalArgumentException("rank 2 access on rank " + FDataSet.this.rank + " dataset");
                }
                if (i0 < 0 || i0 >= FDataSet.this.len0) {
                    throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
                }
                if (i1 < 0 || i1 >= FDataSet.this.len1) {
                    throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
                }
            }
            return FDataSet.this.back[i0 * FDataSet.this.len1 + i1];
        }

        @Override
        public float fvalue(int i0, int i1, int i2) {
            if (RANGE_CHECK) {
                if (FDataSet.this.rank != 3) {
                    throw new IllegalArgumentException("rank 3 access on rank " + FDataSet.this.rank + " dataset");
                }
                if (i0 < 0 || i0 >= FDataSet.this.len0) {
                    throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
                }
                if (i1 < 0 || i1 >= FDataSet.this.len1) {
                    throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
                }
                if (i2 < 0 || i2 >= FDataSet.this.len2) {
                    throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
                }
            }
            return FDataSet.this.back[i0 * FDataSet.this.len1 * FDataSet.this.len2 + i1 * FDataSet.this.len2 + i2];
        }

        @Override
        public float fvalue(int i0, int i1, int i2, int i3) {
            if (RANGE_CHECK) {
                if (FDataSet.this.rank != 4) {
                    throw new IllegalArgumentException("rank 4 access on rank " + FDataSet.this.rank + " dataset");
                }
                if (i0 < 0 || i0 >= FDataSet.this.len0) {
                    throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
                }
                if (i1 < 0 || i1 >= FDataSet.this.len1) {
                    throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
                }
                if (i2 < 0 || i2 >= FDataSet.this.len2) {
                    throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
                }
                if (i3 < 0 || i3 >= FDataSet.this.len3) {
                    throw new IndexOutOfBoundsException("i3=" + i3 + " " + this);
                }
            }
            return FDataSet.this.back[i0 * FDataSet.this.len1 * FDataSet.this.len2 * FDataSet.this.len3 + i1 * FDataSet.this.len2 * FDataSet.this.len3 + i2 * FDataSet.this.len3 + i3];
        }
    }
}

