/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.LocationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatter;
import org.das2.datum.format.EnumerationDatumFormatterFactory;
import org.das2.datum.format.FormatStringFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.BDataSet;
import org.das2.qds.ConstantDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetAnnotations;
import org.das2.qds.DataSetOps;
import org.das2.qds.FDataSet;
import org.das2.qds.IDataSet;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.LDataSet;
import org.das2.qds.LengthsDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.WeightsDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AutoHistogram;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qds.util.LinFit;
import org.das2.util.LoggerManager;

public class DataSetUtil {
    private static final Logger logger = LoggerManager.getLogger("qdataset.ops");
    private static final String LOGGING_SOURCE_CLASS = "org.das2.qds.DataSetUtil";
    private static final String[] DIMENSION_PROPERTIES = new String[]{"UNITS", "FORMAT", "SCALE_TYPE", "TYPICAL_MIN", "TYPICAL_MAX", "VALID_MIN", "VALID_MAX", "FILL_VALUE", "NAME", "LABEL", "TITLE", "USER_PROPERTIES", "NOTES"};
    public static final String PROPERTY_TYPE_STRING = "String";
    public static final String PROPERTY_TYPE_NUMBER = "Number";
    public static final String PROPERTY_TYPE_BOOLEAN = "Boolean";
    public static final String PROPERTY_TYPE_MAP = "Map";
    public static final String PROPERTY_TYPE_QDATASET = "QDataSet";
    public static final String PROPERTY_TYPE_CACHETAG = "CacheTag";
    public static final String PROPERTY_TYPE_UNITS = "Units";

    public static MutablePropertyDataSet indexGenDataSet(int n) {
        return new IndexGenDataSet(n);
    }

    public static MutablePropertyDataSet tagGenDataSet(int n, double start, double cadence) {
        return new TagGenDataSet(n, cadence, start);
    }

    public static MutablePropertyDataSet tagGenDataSet(int n, double start, double cadence, Units units) {
        return new TagGenDataSet(n, cadence, start, units);
    }

    public static MutablePropertyDataSet replicateDataSet(int n, double value) {
        return new TagGenDataSet(n, 0.0, value, Units.dimensionless);
    }

    public static boolean isMonotonic(QDataSet ds) {
        int i;
        if (ds.rank() != 1) {
            return false;
        }
        if (ds.length() == 0) {
            return false;
        }
        if (Boolean.TRUE.equals(ds.property("MONOTONIC"))) {
            return true;
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        for (i = 0; i < ds.length() && wds.value(i) == 0.0; ++i) {
        }
        if (i == ds.length()) {
            return false;
        }
        double last = ds.value(i);
        ++i;
        while (i < ds.length()) {
            double d = ds.value(i);
            double w = wds.value(i);
            if (w != 0.0) {
                if (d < last) {
                    return false;
                }
                last = d;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMonotonicAndIncreasing(QDataSet ds) {
        int i;
        logger.finest("enter isMonotonicAndIncreasing test for MONOTONIC");
        if (ds.rank() != 1) {
            return false;
        }
        if (ds.length() == 0) {
            return false;
        }
        if (ds instanceof IndexGenDataSet) {
            return true;
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        for (i = 0; i < ds.length() && wds.value(i) == 0.0; ++i) {
        }
        if (i == ds.length()) {
            return false;
        }
        double last = ds.value(i);
        ++i;
        while (i < ds.length()) {
            double d = ds.value(i);
            double w = wds.value(i);
            if (w != 0.0) {
                if (d <= last) {
                    return false;
                }
                last = d;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMonotonicQuick(QDataSet ds) {
        logger.finest("enter isMonotonicQuick test for MONOTONIC");
        if (ds instanceof IndexGenDataSet) {
            return true;
        }
        if (ds.rank() == 1) {
            if (ds.length() < 100) {
                return DataSetUtil.isMonotonic(ds);
            }
            QDataSet wds = DataSetUtil.weightsDataSet(ds);
            Random r = new Random(0L);
            double last = -1.7976931348623157E308;
            int n = ds.length();
            int jump = n / 20;
            for (int i = 0; i < n; i += 1 + (int)((double)jump * r.nextDouble())) {
                double d = ds.value(i);
                double w = wds.value(i);
                while (w == 0.0 && i < n) {
                    d = ds.value(i);
                    w = wds.value(i);
                    ++i;
                }
                if (i == n) break;
                if (d < last) {
                    return false;
                }
                last = d;
            }
            return true;
        }
        return false;
    }

    public static boolean isMonotonicAndIncreasingQuick(QDataSet ds) {
        logger.finest("enter isMonotonicAndIncreasingQuick test for MONOTONIC");
        if (ds instanceof IndexGenDataSet) {
            return true;
        }
        if (ds.rank() == 1) {
            if (ds.length() < 100) {
                return DataSetUtil.isMonotonicAndIncreasing(ds);
            }
            QDataSet wds = DataSetUtil.weightsDataSet(ds);
            Random r = new Random(0L);
            double last = -1.7976931348623157E308;
            int n = ds.length();
            int jump = n / 20;
            for (int i = 0; i < n; i += 1 + (int)((double)jump * r.nextDouble())) {
                double d = ds.value(i);
                double w = wds.value(i);
                while (w == 0.0 && i < n) {
                    d = ds.value(i);
                    w = wds.value(i);
                    ++i;
                }
                if (i == n) break;
                if (d <= last) {
                    return false;
                }
                last = d;
            }
            return true;
        }
        return false;
    }

    public static int binarySearch(QDataSet ds, double key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = ds.value(mid);
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int closest(QDataSet ds, double d, int guess) {
        int result = DataSetUtil.binarySearch(ds, d, 0, ds.length() - 1);
        if (result == -1) {
            result = 0;
        } else if (result < 0) {
            double x1;
            double x0;
            double x;
            result = (result ^= 0xFFFFFFFF) >= ds.length() - 1 ? ds.length() - 1 : (((x = d) - (x0 = ds.value(result - 1))) / ((x1 = ds.value(result)) - x0) < 0.5 ? result - 1 : result);
        }
        return result;
    }

    public static Object getUserProperty(QDataSet ds, String name) {
        Map userProps = (Map)ds.property("USER_PROPERTIES");
        if (userProps == null) {
            return null;
        }
        return userProps.get(name);
    }

    public static String[] propertyNames() {
        return new String[]{"UNITS", "VALID_MIN", "VALID_MAX", "FILL_VALUE", "FORMAT", "CADENCE", "MONOTONIC", "SCALE_TYPE", "TYPICAL_MIN", "TYPICAL_MAX", "RENDER_TYPE", "QUBE", "NAME", "LABEL", "TITLE", "CACHE_TAG", "COORDINATE_FRAME", "DELTA_MINUS", "DELTA_PLUS", "BIN_MINUS", "BIN_PLUS", "BIN_MIN", "BIN_MAX", "WEIGHTS", "USER_PROPERTIES", "NOTES", "METADATA", "METADATA_MODEL"};
    }

    public static void copyDimensionProperties(QDataSet source, MutablePropertyDataSet dest) {
        String[] names;
        for (String n : names = DIMENSION_PROPERTIES) {
            Object p = source.property(n);
            if (p == null) continue;
            dest.putProperty(n, p);
        }
    }

    public static void maybeCopyRenderType(QDataSet source, MutablePropertyDataSet dest) {
        String rt = (String)source.property("RENDER_TYPE");
        if (rt == null) {
            return;
        }
        if ((rt.equals("spectrogram") || rt.equals("nnSpectrogram")) && dest.rank() > 1) {
            dest.putProperty("RENDER_TYPE", rt);
        }
    }

    public static String[] dimensionProperties() {
        return Arrays.copyOf(DIMENSION_PROPERTIES, DIMENSION_PROPERTIES.length);
    }

    public static Class getPropertyClass(String name) {
        if (name.equals("TITLE") || name.equals("LABEL")) {
            return String.class;
        }
        if (name.equals("UNITS")) {
            return Units.class;
        }
        if (name.equals("NAME") || name.equals("FORMAT") || name.equals("RENDER_TYPE") || name.equals("SCALE_TYPE")) {
            return String.class;
        }
        if (name.equals("TYPICAL_MIN") || name.equals("TYPICAL_MAX") || name.startsWith("VALID_MIN") || name.startsWith("VALID_MAX") || name.equals("FILL_VALUE")) {
            return Number.class;
        }
        if (name.equals("MONOTONIC") || name.equals("QUBE")) {
            return Boolean.class;
        }
        if (name.equals("CACHE_TAG")) {
            return CacheTag.class;
        }
        if (name.equals("USER_PROPERTIES") || name.equals("METADATA")) {
            return Map.class;
        }
        if (name.startsWith("JOIN_") || name.startsWith("BINS_")) {
            return String.class;
        }
        if (name.startsWith("SOURCE") || name.startsWith("VERSION") || name.equals("METADATA_MODEL")) {
            return String.class;
        }
        if (name.equals("CADENCE")) {
            return QDataSet.class;
        }
        if (name.startsWith("DEPEND_") || name.startsWith("BUNDLE_") || name.startsWith("DELTA_") || name.startsWith("BIN_") || name.startsWith("CONTEXT_")) {
            return QDataSet.class;
        }
        if (name.equals("START_INDEX")) {
            return Integer.class;
        }
        return null;
    }

    public static String getPropertyType(String name) {
        switch (name) {
            case "LABEL": 
            case "TITLE": 
            case "DESCRIPTION": {
                return PROPERTY_TYPE_STRING;
            }
            case "UNITS": {
                return PROPERTY_TYPE_UNITS;
            }
            case "NAME": 
            case "FORMAT": 
            case "RENDER_TYPE": 
            case "SCALE_TYPE": {
                return PROPERTY_TYPE_STRING;
            }
            case "TYPICAL_MIN": 
            case "TYPICAL_MAX": 
            case "VALID_MIN": 
            case "VALID_MAX": 
            case "FILL_VALUE": {
                return PROPERTY_TYPE_NUMBER;
            }
            case "MONOTONIC": 
            case "QUBE": {
                return PROPERTY_TYPE_BOOLEAN;
            }
            case "CACHE_TAG": {
                return PROPERTY_TYPE_CACHETAG;
            }
            case "USER_PROPERTIES": 
            case "METADATA": {
                return PROPERTY_TYPE_MAP;
            }
            case "CADENCE": 
            case "WEIGHTS": {
                return PROPERTY_TYPE_QDATASET;
            }
            case "SOURCE": 
            case "VERSION": 
            case "METADATA_MODEL": 
            case "COORDINATE_FRAME": {
                return PROPERTY_TYPE_STRING;
            }
        }
        if (name.startsWith("JOIN_") || name.startsWith("BINS_")) {
            return PROPERTY_TYPE_STRING;
        }
        if (name.startsWith("DEPEND_") || name.startsWith("BUNDLE_") || name.startsWith("DELTA_") || name.startsWith("BIN_") || name.startsWith("CONTEXT_")) {
            return PROPERTY_TYPE_QDATASET;
        }
        return null;
    }

    public static boolean isDimensionProperty(String name) {
        for (String n : DIMENSION_PROPERTIES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String[] globalProperties() {
        return new String[]{"USER_PROPERTIES", "NOTES", "VERSION", "METADATA", "METADATA_MODEL", "SOURCE"};
    }

    public static String[] correlativeProperties() {
        return new String[]{"DELTA_MINUS", "DELTA_PLUS", "BIN_MINUS", "BIN_PLUS", "WEIGHTS"};
    }

    public static boolean isInheritedProperty(String prop) {
        switch (prop) {
            case "DEPEND_0": 
            case "DEPEND_1": 
            case "DEPEND_2": 
            case "DEPEND_3": {
                return false;
            }
            case "BUNDLE_0": 
            case "BUNDLE_1": 
            case "BUNDLE_2": 
            case "BUNDLE_3": {
                return false;
            }
            case "BINS_0": 
            case "BINS_1": {
                return false;
            }
            case "JOIN_0": 
            case "JOIN_1": {
                return false;
            }
            case "START_INDEX": 
            case "RENDER_TYPE": {
                return false;
            }
        }
        boolean indexProp = prop.startsWith("PLANE_");
        return !indexProp;
    }

    public static Map<String, Object> sliceProperties(QDataSet ds, int index, Map<String, Object> result) {
        String[] names;
        if (result == null) {
            result = new LinkedHashMap<String, Object>();
        }
        if (ds.property("BUNDLE_0") != null) {
            logger.fine("sliceProperties is not allowed when BUNDLE_0 is set");
            return result;
        }
        for (String name : names = DIMENSION_PROPERTIES) {
            Object val = ds.property(name, index);
            if (val == null) continue;
            result.put(name, val);
        }
        return result;
    }

    public static Map<String, Object> trimProperties(QDataSet ds, int start, int stop) {
        QDataSet p;
        int i;
        Map<String, Object> result = new LinkedHashMap<String, Object>();
        result = DataSetUtil.getDimensionProperties(ds, result);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            result.put("DEPEND_0", dep0.trim(start, stop));
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            String prop = "DEPEND_" + i2;
            Object dep = (QDataSet)ds.property(prop);
            if (dep == null) continue;
            if (dep.rank() > 1 && !Schemes.isRank2Bins((QDataSet)dep)) {
                dep = dep.trim(start, stop);
            }
            result.put(prop, dep);
        }
        String[] props = DataSetUtil.correlativeProperties();
        for (String s : props) {
            QDataSet dsp = (QDataSet)ds.property(s);
            if (dsp == null) continue;
            if (dsp.rank() > 0) {
                result.put(s, dsp.trim(start, stop));
                continue;
            }
            result.put(s, dsp);
        }
        for (i = 0; i < 50 && (p = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            if (p.rank() > 0) {
                result.put("PLANE_" + i, p.trim(start, stop));
                continue;
            }
            result.put("PLANE_" + i, p);
        }
        if (ds.length() < 50) {
            for (i = 0; i < stop - start; ++i) {
                int ips = i + start;
                Object o = ds.property("NAME", ips);
                if (o != null) {
                    result.put("NAME__" + i, o);
                }
                if ((o = ds.property("UNITS", ips)) != null) {
                    result.put("UNITS__" + i, o);
                }
                if ((o = ds.property("FORMAT", ips)) == null) continue;
                result.put("FORMAT__" + i, o);
            }
        }
        return result;
    }

    public static Map<String, Object> getDimensionProperties(QDataSet ds, Map<String, Object> def) {
        return DataSetUtil.getProperties(ds, DIMENSION_PROPERTIES, def);
    }

    public static Map<String, Object> getProperties(QDataSet ds, String[] names, Map def) {
        def = def == null ? new LinkedHashMap<String, Object>() : new LinkedHashMap(def);
        for (String name : names) {
            Object val = ds.property(name);
            if (val == null) continue;
            def.put(name, val);
        }
        return def;
    }

    public static Map<String, Object> getProperties(QDataSet ds, Map<String, Object> def) {
        String[] names;
        Object cds;
        Object plane;
        Object dep;
        int i;
        Map<String, Object> result = def;
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("DEPEND_" + i);
            if (dep == null) continue;
            result.put("DEPEND_" + i, dep);
        }
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("BUNDLE_" + i);
            if (dep == null) continue;
            result.put("BUNDLE_" + i, dep);
        }
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("BINS_" + i);
            if (dep == null) continue;
            result.put("BINS_" + i, dep);
        }
        for (i = 0; i <= ds.rank(); ++i) {
            dep = ds.property("JOIN_" + i);
            if (dep == null) continue;
            result.put("JOIN_" + i, dep);
        }
        for (i = 0; i < 50 && (plane = ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, plane);
        }
        for (i = 0; i < 50 && (cds = ds.property("CONTEXT_" + i)) != null; ++i) {
            result.put("CONTEXT_" + i, cds);
        }
        for (String name : names = DataSetUtil.propertyNames()) {
            if (ds.property(name) == null) continue;
            result.put(name, ds.property(name));
        }
        return result;
    }

    public static Map<String, Object> getProperties(QDataSet ds) {
        return DataSetUtil.getProperties(ds, new LinkedHashMap<String, Object>());
    }

    public static void putProperties(Map<String, Object> properties, MutablePropertyDataSet ds) {
        if (ds.isImmutable()) {
            logger.warning("ds is immutable, an exception will be thrown.");
        }
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            MutablePropertyDataSet mdep;
            QDataSet dep;
            if (e.getKey().startsWith("DEPEND_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getKey().startsWith("PLANE_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getKey().startsWith("BUNDLE_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getKey().startsWith("CONTEXT_") && e.getValue() instanceof Map) {
                dep = (QDataSet)ds.property(e.getKey());
                if (!(dep instanceof MutablePropertyDataSet)) continue;
                mdep = (MutablePropertyDataSet)dep;
                DataSetUtil.putProperties((Map)e.getValue(), mdep);
                continue;
            }
            if (e.getValue() == null) continue;
            ds.putProperty(e.getKey(), e.getValue());
        }
    }

    public static String toString(QDataSet ds) {
        int[] qubeDims;
        String name;
        if (ds == null) {
            throw new IllegalArgumentException("null dataset");
        }
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            if (ds.property("JOIN_0") != null && ds.length() > 0) {
                u = (Units)ds.property("UNITS", 0);
            }
            if (u == null) {
                u = Units.dimensionless;
            }
        }
        if ((name = (String)ds.property("NAME")) == null) {
            name = "dataset";
        }
        if (ds.rank() == 0) {
            try {
                if (name.equals("dataset")) {
                    Datum d = DataSetUtil.asDatum(ds);
                    return String.valueOf(d);
                }
                return name + "=" + DataSetUtil.asDatum(ds);
            }
            catch (IllegalArgumentException ex) {
                return "Error: " + ex;
            }
        }
        if (ds.rank() == 1 && "min,max".equals(ds.property("BINS_0"))) {
            if (ds.value(0) <= ds.value(1)) {
                if (u != Units.dimensionless) {
                    DatumRange dr = new DatumRange(ds.value(0), ds.value(1), u);
                    return dr.toString();
                }
                DatumRange dr = new DatumRange(Ops.datum(ds.slice(0)), Ops.datum(ds.slice(1)));
                return dr.toString();
            }
            return String.format("%s %s (invalid because BINS_0=min,max)", ds.slice(0), ds.slice(1));
        }
        if (ds.rank() == 1 && "min,maxInclusive".equals(ds.property("BINS_0"))) {
            if (ds.value(0) <= ds.value(1)) {
                DatumRange dr = new DatumRange(ds.value(0), ds.value(1), u);
                return dr.toString() + "  (inclusive)";
            }
            return String.format("%s %s (invalid because BINS_0=min,maxInclusive)", ds.slice(0), ds.slice(1));
        }
        if (ds.rank() == 1 && Schemes.isComplexNumbers(ds)) {
            DecimalFormat df = new DecimalFormat("0.000E0");
            String rs = String.valueOf(ds.value(0));
            String is = String.valueOf(ds.value(1));
            if (rs.length() > 7) {
                rs = df.format(ds.value(0));
            }
            if (is.length() > 7) {
                is = df.format(ds.value(1));
            }
            return "(" + rs + "+" + is + "j)";
        }
        if (ds.rank() == 1 && Ops.isLegacyBundle(ds) && ds.length() < 8) {
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            StringBuilder str = new StringBuilder("");
            try {
                str.append(dep0.slice(0)).append("=").append(ds.slice(0));
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                str.append("Exception");
            }
            for (int i = 1; i < ds.length(); ++i) {
                str.append(", ").append(dep0.slice(i)).append("=").append(ds.slice(i));
            }
            return str.toString();
        }
        if (ds.rank() == 2 && ds.length() == 2 && ds.length(0) == 2 && "min,maxInclusive".equals(ds.property("BINS_1"))) {
            Units u1 = (Units)ds.property("UNITS", 0);
            Units u2 = (Units)ds.property("UNITS", 1);
            DatumRange dr1 = new DatumRange(ds.value(0, 0), ds.value(0, 1), u1 == null ? Units.dimensionless : u1);
            DatumRange dr2 = new DatumRange(ds.value(1, 0), ds.value(1, 1), u2 == null ? Units.dimensionless : u2);
            return dr1.toString() + "; " + dr2.toString() + "  (inclusive)";
        }
        if (ds.rank() == 2 && ds.length() == 2 && ds.length(0) == 2 && "min,max".equals(ds.property("BINS_1"))) {
            Units u1 = (Units)ds.property("UNITS", 0);
            Units u2 = (Units)ds.property("UNITS", 1);
            DatumRange dr1 = new DatumRange(ds.value(0, 0), ds.value(0, 1), u1 == null ? Units.dimensionless : u1);
            DatumRange dr2 = new DatumRange(ds.value(1, 0), ds.value(1, 1), u2 == null ? Units.dimensionless : u2);
            return dr1.toString() + "; " + dr2.toString();
        }
        String qubeStr = DataSetUtil.isQube(ds) ? "" : "*";
        String[] depNames = new String[ds.rank()];
        for (int i = 0; i < depNames.length; ++i) {
            String dname;
            depNames[i] = "";
            Object dep0o = ds.property("DEPEND_" + i);
            if (dep0o == null) continue;
            if (dep0o instanceof QDataSet) {
                QDataSet dep0 = (QDataSet)dep0o;
                dname = (String)dep0.property("NAME");
            } else {
                dname = String.valueOf(dep0o) + "(Str)";
            }
            if (dname != null) {
                if (dname.length() > 6) {
                    dname = dname.substring(0, 6) + "...";
                }
                depNames[i] = dname + "=";
                continue;
            }
            depNames[i] = "DEPEND_" + i + "=";
        }
        if (ds.property("BINS_0") != null) {
            depNames[0] = ((String)ds.property("BINS_0")).replaceAll(",", " ");
        }
        if (ds.property("BINS_1") != null) {
            depNames[1] = ((String)ds.property("BINS_1")).replaceAll(",", " ");
        }
        if (ds.property("JOIN_0") != null) {
            // empty if block
        }
        if (ds.property("BUNDLE_0") != null && depNames[0].length() == 0) {
            depNames[0] = "BUNDLE_0=";
        }
        if (ds.property("BUNDLE_1") != null && depNames[0].length() == 0) {
            depNames[1] = "BUNDLE_1=";
        }
        if (DataSetUtil.isQube(ds)) {
            try {
                qubeDims = DataSetUtil.qubeDims(ds);
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, null, ex);
                qubeDims = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            }
        } else {
            qubeDims = new int[ds.rank()];
            qubeDims[0] = ds.length();
            if (ds.rank() > 1) {
                qubeDims[1] = ds.length(0);
            }
            if (ds.rank() > 2) {
                qubeDims[2] = ds.length(0, 0);
            }
            if (ds.rank() > 3) {
                qubeDims[3] = ds.length(0, 0, 0);
            }
        }
        StringBuilder dimStr = new StringBuilder("" + depNames[0] + ds.length());
        for (int i = 1; i < ds.rank(); ++i) {
            if (depNames[i].length() == 0 || depNames[i].endsWith("=")) {
                dimStr.append(",").append(depNames[i]).append(qubeDims[i]).append(qubeStr);
                continue;
            }
            dimStr.append(",").append(depNames[i]);
        }
        String su = String.valueOf(u);
        if (su.equals("")) {
            su = "dimensionless";
        }
        return name + "[" + dimStr.toString() + "] (" + su + ")";
    }

    public static QDataSet firstValidPoint(QDataSet ds) {
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        double offset = u.getFillDouble();
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            double w = iter.getValue(wds);
            if (!(w > 0.0)) continue;
            offset = iter.getValue(ds);
            break;
        }
        if (offset == u.getFillDouble()) {
            return null;
        }
        return DataSetUtil.asDataSet(offset, u);
    }

    public static QDataSet validPoints(QDataSet ds) {
        int lenmax = DataSetUtil.totalLength(ds);
        DDataSet result = DDataSet.createRank1(lenmax);
        int i = 0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            double w = iter.getValue(wds);
            if (!(w > 0.0)) continue;
            result.putValue(i, iter.getValue(ds));
            ++i;
        }
        for (String s : DataSetUtil.propertyNames()) {
            result.putProperty(s, ds.property(s));
        }
        return result;
    }

    public static QDataSet gcd(QDataSet ds, QDataSet d, QDataSet limit) {
        while (true) {
            int lastNonZeroPeakIndex;
            QDataSet r = Ops.mod(ds, d);
            QDataSet hist = Ops.autoHistogram(r);
            QDataSet peaks = AutoHistogram.peaks(hist);
            double stop = d.property("DELTA_MINUS") != null ? ((QDataSet)d.property("DELTA_MINUS")).value() : 0.0;
            stop = Math.max(stop, DataSetUtil.asDatum(limit).doubleValue(SemanticOps.getUnits(peaks)));
            double top = d.value() - stop;
            int nonZeroPeakIndex = peaks.value(0) - stop < 0.0 ? 1 : 0;
            for (lastNonZeroPeakIndex = peaks.length() - 1; lastNonZeroPeakIndex >= 0 && peaks.value(lastNonZeroPeakIndex) > top; --lastNonZeroPeakIndex) {
            }
            if (lastNonZeroPeakIndex < nonZeroPeakIndex) break;
            d = peaks.slice(nonZeroPeakIndex);
        }
        return d;
    }

    public static QDataSet gcd(QDataSet ds, QDataSet limit) {
        QDataSet ds1 = DataSetUtil.validPoints(ds);
        if (ds1.length() == 0) {
            throw new IllegalArgumentException("no valid points");
        }
        if (ds1.length() == 1) {
            return ds.slice(0);
        }
        QDataSet guess = ds.slice(1);
        return DataSetUtil.gcd(ds, guess, limit);
    }

    public static RankZeroDataSet courserCadence(RankZeroDataSet yTagWidth0, RankZeroDataSet yTagWidth1) {
        if (yTagWidth0 == null || yTagWidth1 == null) {
            return null;
        }
        if ("log".equals(yTagWidth0.property("SCALE_TYPE")) == "log".equals(yTagWidth1.property("SCALE_TYPE"))) {
            if (DataSetUtil.asDatum(yTagWidth1).gt(DataSetUtil.asDatum(yTagWidth0))) {
                return yTagWidth1;
            }
            return yTagWidth0;
        }
        if ("log".equals(yTagWidth0.property("SCALE_TYPE"))) {
            return yTagWidth0;
        }
        return yTagWidth1;
    }

    public static String toSparkline(QDataSet ds, QDataSet extent, boolean bar) {
        if (ds.length() > 1000) {
            throw new IllegalArgumentException("dataset is too large (ds.length()>1000)");
        }
        if (extent == null) {
            extent = Ops.extent(ds);
        }
        String charsScatter = "\u28c0\u2824\u2812\u2809";
        String charsBar = "\u2581\u2582\u2583\u2584\u2585\u2586\u2587\u2588";
        String bb = bar ? charsBar : charsScatter;
        int maxn = bb.length();
        StringBuilder build = new StringBuilder(DataSetUtil.totalLength(ds));
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double min = extent.value(0);
        double range = extent.value(1) - min;
        while (it.hasNext()) {
            it.next();
            if (!(it.getValue(wds) > 0.0)) continue;
            int n = (int)((double)maxn * (it.getValue(ds) - min) / range);
            if (bar) {
                n = Math.max(0, Math.min(n, maxn - 1));
            }
            if (n >= 0 && n < maxn) {
                char c = bb.charAt(n);
                build.append(c);
                continue;
            }
            build.append("\u2800");
        }
        return build.toString();
    }

    public static boolean samePopulation(QDataSet ds1, QDataSet ds2) {
        RankZeroDataSet stats1 = DataSetOps.moment(ds1);
        RankZeroDataSet stats2 = DataSetOps.moment(ds2);
        QDataSet stddev1 = (QDataSet)stats1.property("stddev");
        QDataSet stddev2 = (QDataSet)stats2.property("stddev");
        Units u1 = SemanticOps.getUnits(stats1);
        Units u2 = SemanticOps.getUnits(stats2);
        DatumRange dr1 = DatumRangeUtil.rescale(DatumRange.newDatumRange(Ops.subtract(stats1, stddev1).value(), Ops.add(stats1, stddev1).value(), u1), 0.2, 0.8);
        DatumRange dr2 = DatumRangeUtil.rescale(DatumRange.newDatumRange(Ops.subtract(stats2, stddev2).value(), Ops.add(stats2, stddev2).value(), u2), 0.2, 0.8);
        return dr1.intersects(dr2);
    }

    public static boolean isLogSpacing(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("rank 1 only");
        }
        QDataSet c = (QDataSet)ds.property("CADENCE");
        if (c != null) {
            return UnitsUtil.isRatiometric(SemanticOps.getUnits(ds));
        }
        QDataSet lindiff = Ops.diff(ds);
        QDataSet logdiff = Ops.diff(Ops.log(ds));
        int l = lindiff.length();
        int h = l / 2;
        if (DataSetUtil.samePopulation(lindiff.trim(0, h), lindiff.trim(h, l))) {
            return false;
        }
        return DataSetUtil.samePopulation(logdiff.trim(0, h), logdiff.trim(h, l));
    }

    public static QDataSet[] inferBinsRank2(QDataSet ydss) {
        QDataSet lastYds = null;
        QDataSet lastYds0 = null;
        QDataSet lastYds1 = null;
        JoinDataSet yds0 = new JoinDataSet(2);
        JoinDataSet yds1 = new JoinDataSet(2);
        for (int i = 0; i < ydss.length(); ++i) {
            QDataSet yds = ydss.slice(i);
            if (lastYds != null && Ops.equivalent(lastYds, yds)) {
                yds0.join(lastYds0);
                yds1.join(lastYds1);
                continue;
            }
            QDataSet rr = DataSetUtil.inferBins(yds);
            lastYds0 = Ops.slice1(rr, 0);
            lastYds1 = Ops.slice1(rr, 1);
            yds0.join(lastYds0);
            yds1.join(lastYds1);
            lastYds = yds;
        }
        QDataSet[] result = new QDataSet[]{yds0, yds1};
        return result;
    }

    public static QDataSet inferBins(QDataSet yds) {
        QDataSet yds1;
        QDataSet yds0;
        if (yds.rank() != 1) {
            throw new IllegalArgumentException("yds must be rank 1");
        }
        QDataSet dy = DataSetUtil.guessCadenceNew(yds, null);
        if (dy == null) {
            if (DataSetUtil.isLogSpacing(yds)) {
                QDataSet diff1 = yds.trim(0, yds.length() - 1);
                QDataSet diff2 = yds.trim(1, yds.length());
                QDataSet delta = Ops.log(Ops.divide(diff2, diff1));
                delta = Ops.putProperty(delta, "UNITS", (Object)Units.logERatio);
                delta = Ops.convertUnitsTo(delta, Units.percentIncrease);
                delta = Ops.interpolate(delta, Ops.linspace(-0.5, (double)diff1.length() - 0.5, diff1.length() + 1));
                QDataSet v = Ops.divide((Object)delta, 100.0);
                v = Ops.putProperty(v, "UNITS", null);
                QDataSet ddy = Ops.sqrt(Ops.add(1.0, (Object)v));
                yds0 = Ops.divide(yds, ddy);
                yds1 = Ops.multiply(yds, ddy);
            } else {
                QDataSet diff1 = yds.trim(0, yds.length() - 1);
                QDataSet diff2 = yds.trim(1, yds.length());
                QDataSet delta = Ops.interpolate(Ops.subtract(diff2, diff1), Ops.linspace(-0.5, (double)diff1.length() - 0.5, diff1.length() + 1));
                yds0 = Ops.subtract(yds, delta);
                yds1 = Ops.add(yds, delta);
            }
        } else if (UnitsUtil.isRatiometric(SemanticOps.getUnits(dy))) {
            dy = Ops.convertUnitsTo(dy, Units.percentIncrease);
            double ddy = Math.sqrt(1.0 + dy.value() / 100.0);
            yds0 = Ops.divide(yds, DataSetUtil.asDataSet(ddy));
            yds1 = Ops.multiply(yds, DataSetUtil.asDataSet(ddy));
        } else {
            dy = Ops.divide(dy, DataSetUtil.asDataSet(2.0));
            yds0 = Ops.subtract(yds, dy);
            yds1 = Ops.add(yds, dy);
        }
        MutablePropertyDataSet mpds = (MutablePropertyDataSet)Ops.bundle(yds0, yds1);
        mpds.putProperty("BINS_1", "min,max");
        return mpds;
    }

    public static RankZeroDataSet getCadenceWaveform(QDataSet ds) {
        RankZeroDataSet xlimit;
        if (Schemes.isRank2Waveform(ds)) {
            QDataSet offsets = (QDataSet)ds.property("DEPEND_1");
            xlimit = offsets.rank() == 1 ? DataSetUtil.guessCadenceNew(offsets, null) : DataSetUtil.guessCadenceNew(offsets.slice(0), null);
        } else if (Schemes.isRank3Waveform(ds)) {
            xlimit = DataSetUtil.getCadenceWaveform(ds.slice(0));
            for (int i = 1; i < ds.length(); ++i) {
                RankZeroDataSet xlimit1 = DataSetUtil.getCadenceWaveform(ds.slice(i));
                if (Ops.gt(xlimit1, xlimit).value() != 1.0) continue;
                xlimit = xlimit1;
            }
        } else {
            throw new IllegalArgumentException("data is not waveform");
        }
        return xlimit;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static RankZeroDataSet guessCadenceNew(QDataSet xds, QDataSet yds) {
        int i;
        Units xunits;
        QDataSet hist;
        long total;
        QDataSet r;
        double everIncreasing;
        int repeatValues;
        int count;
        int monoDecreasing;
        Logger logger;
        block74: {
            double monoMag;
            QDataSet wds;
            block73: {
                double last;
                boolean xHasFill;
                int monoIncreasing;
                block72: {
                    block71: {
                        Datum rw;
                        RankZeroDataSet r1;
                        block70: {
                            QDataSet dd;
                            block69: {
                                Units u;
                                Object o;
                                block67: {
                                    block68: {
                                        logger = LoggerManager.getLogger("qdataset.ops.guesscadence");
                                        logger.entering(LOGGING_SOURCE_CLASS, "guessCadenceNew");
                                        o = xds.property("CADENCE");
                                        if (yds == null || yds.rank() <= 1) break block67;
                                        if (!Schemes.isRank2Waveform(yds)) break block68;
                                        r1 = DataSetUtil.guessCadenceNew(xds, null);
                                        dd = (QDataSet)yds.property("DEPEND_1");
                                        rw = null;
                                        if (dd.rank() != 1) break block69;
                                        QDataSet ee = Ops.extent(dd);
                                        rw = DataSetUtil.asDatum(Ops.subtract(ee.slice(1), ee.slice(0)));
                                        break block70;
                                    }
                                    if (Schemes.isRank3Waveform(yds)) break block71;
                                }
                                if (UnitsUtil.isNominalMeasurement(u = SemanticOps.getUnits(xds))) {
                                    return null;
                                }
                                if (o != null && o instanceof QDataSet) {
                                    QDataSet q = (QDataSet)o;
                                    Units qu = SemanticOps.getUnits(q);
                                    if (UnitsUtil.isRatiometric(qu) || qu.isConvertibleTo(u.getOffsetUnits())) {
                                        if (q.rank() == 0) {
                                            if (q instanceof RankZeroDataSet) {
                                                return (RankZeroDataSet)q;
                                            }
                                            logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
                                            return DRank0DataSet.create(q.value(), qu);
                                        }
                                        while (true) {
                                            if (q.rank() <= 0) {
                                                logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
                                                return DRank0DataSet.create(DataSetUtil.asDatum(q));
                                            }
                                            logger.log(Level.SEVERE, "averaging CADENCE rank 0: {0}", q);
                                            q = Ops.reduceMax(q, 0);
                                        }
                                    }
                                    logger.log(Level.INFO, "CADENCE units ({0}) are inconvertible to {1}", new Object[]{qu, u.getOffsetUnits()});
                                }
                                if (yds == null) {
                                    yds = DataSetUtil.replicateDataSet(xds.length(), 1.0);
                                } else if (xds.length() != yds.length()) {
                                    throw new IllegalArgumentException("xds.length()!=yds.length()");
                                }
                                if (yds.rank() > 1) {
                                    yds = DataSetUtil.replicateDataSet(xds.length(), 1.0);
                                }
                                if (xds.length() < 2) {
                                    logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
                                    return null;
                                }
                                if (xds.rank() == 2 && xds.property("BINS_1") != null) {
                                    xds = DataSetOps.slice1(xds, 0);
                                }
                                wds = DataSetUtil.weightsDataSet(xds);
                                monoDecreasing = 0;
                                monoIncreasing = 0;
                                count = 0;
                                xHasFill = false;
                                repeatValues = 0;
                                last = Double.NaN;
                                break block72;
                            }
                            for (int i2 = 0; i2 < dd.length(); ++i2) {
                                QDataSet ee = Ops.extent(dd);
                                Datum t1 = DataSetUtil.asDatum(Ops.subtract(ee.slice(1), ee.slice(0)));
                                rw = rw == null ? t1 : (rw.lt(t1) ? t1 : rw);
                            }
                        }
                        if (rw == null) {
                            return r1;
                        }
                        if (r1 == null) {
                            return DataSetUtil.asDataSet(rw);
                        }
                        Datum rt = DataSetUtil.asDatum(r1);
                        if (!rw.getUnits().isConvertibleTo(rt.getUnits())) return DataSetUtil.asDataSet(rw);
                        if (!rw.multiply(2.0).gt(rt)) return DataSetUtil.asDataSet(rw);
                        return r1;
                    }
                    Datum dresult = null;
                    int i3 = 0;
                    while (i3 < yds.length()) {
                        QDataSet yds1 = yds.slice(i3);
                        QDataSet xds1 = (QDataSet)yds1.property("DEPEND_0");
                        Datum t1 = DataSetUtil.asDatum(DataSetUtil.guessCadenceNew(xds1, yds1));
                        dresult = dresult == null ? t1 : (dresult.lt(t1) ? t1 : dresult);
                        ++i3;
                    }
                    return DataSetUtil.asDataSet(dresult);
                }
                for (int i4 = 0; i4 < xds.length(); ++i4) {
                    if (wds.value(i4) == 0.0) {
                        xHasFill = true;
                        continue;
                    }
                    if (Double.isNaN(last)) {
                        last = xds.value(i4);
                        continue;
                    }
                    ++count;
                    double sp = xds.value(i4) - last;
                    if (sp < 0.0) {
                        ++monoDecreasing;
                    } else if (sp > 0.0) {
                        ++monoIncreasing;
                    } else {
                        ++repeatValues;
                    }
                    last = xds.value(i4);
                }
                monoMag = repeatValues + monoIncreasing > 90 * count / 100 ? 1.0 : (repeatValues + monoDecreasing > 90 * count / 100 ? -1.0 : 0.0);
                if (xHasFill && monoMag == 0.0) {
                    logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
                    return null;
                }
                if (monoMag == 0.0) {
                    logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
                    return null;
                }
                everIncreasing = 0.0;
                if (xds.length() >= 100 || xds.rank() != 1) break block73;
                LinFit f = new LinFit(Ops.findgen(xds.length()), xds);
                double chilin = f.getChi2();
                QDataSet r2 = Ops.where(Ops.gt(Ops.abs(xds), DataSetUtil.asDataSet(0.0)));
                if (r2.length() < 2) {
                    everIncreasing = 0.0;
                    break block74;
                } else {
                    WritableDataSet xdsr = DataSetOps.applyIndex(xds, 0, r2, false);
                    f = new LinFit(Ops.findgen(xdsr.length()), Ops.log(xdsr));
                    double chilog = f.getChi2();
                    if (chilog < chilin / 2.0) {
                        QDataSet ext = Ops.extent(xdsr);
                        everIncreasing = ext.value(1) / ext.value(0);
                    }
                }
                break block74;
            }
            if (xds.length() > 2) {
                double sp = monoMag * (xds.value(2) - xds.value(0));
                everIncreasing = xds.value(2) / xds.value(0);
                double sp0 = sp;
                if (xds.value(2) <= 0.0 || xds.value(0) <= 0.0 || xds.value(1) > xds.value(0) + xds.value(2)) {
                    everIncreasing = 0.0;
                }
                for (int i5 = 3; everIncreasing > 0.0 && i5 < xds.length(); ++i5) {
                    if (wds.value(i5) == 0.0 || wds.value(i5 - 3) == 0.0) continue;
                    if (xds.value(i5) <= 0.0 || xds.value(i5 - 3) <= 0.0) {
                        everIncreasing = 0.0;
                        continue;
                    }
                    double sp1 = monoMag * (xds.value(i5) - xds.value(i5 - 3));
                    if (sp1 > sp0 * 1.00001) {
                        everIncreasing = xds.value(i5) / xds.value(0);
                        sp0 = sp1;
                        continue;
                    }
                    everIncreasing = 0.0;
                }
            }
            if (everIncreasing > 0.0 && monoMag == -1.0) {
                everIncreasing = 1.0 / everIncreasing;
            }
        }
        boolean logScaleType = "log".equals(xds.property("SCALE_TYPE"));
        QDataSet extent = Ops.extent(xds);
        AutoHistogram ah = new AutoHistogram();
        QDataSet diffs = yds.rank() == 1 && xds.rank() == 1 ? ((r = Ops.where(Ops.valid(yds))).length() < 2 ? Ops.diff(xds) : (r.length() == yds.length() ? Ops.diff(xds) : Ops.diff(DataSetOps.applyIndex(xds, 0, r, false)))) : Ops.diff(xds);
        if (monoDecreasing > 9 * count / 10) {
            diffs = Ops.multiply(diffs, DataSetUtil.asDataSet(-1.0));
        }
        if (repeatValues > 0) {
            r = Ops.where(Ops.ne(diffs, DataSetUtil.asDataSet(0.0)));
            diffs = DataSetOps.applyIndex(diffs, 0, r, false);
        }
        if ((total = ((Long)((Map)(hist = ah.doit(diffs)).property("USER_PROPERTIES")).get("total")).longValue()) == 0L) {
            logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
            return null;
        }
        int everIncreasingLimit = total < 10L ? 25 : 100;
        int ipeak = 0;
        int peakv = (int)hist.value(0);
        int linHighestPeak = 0;
        int linMedian = -1;
        int t = 0;
        double mean = AutoHistogram.mean(hist).value();
        int firstPositiveBin = Integer.MAX_VALUE;
        QDataSet dep0 = (QDataSet)hist.property("DEPEND_0");
        for (int i6 = 0; i6 < hist.length(); ++i6) {
            t = (int)((double)t + hist.value(i6));
            if (hist.value(i6) > (double)peakv) {
                ipeak = i6;
                peakv = (int)hist.value(i6);
            }
            if (hist.value(i6) > (double)peakv / 10.0) {
                linHighestPeak = i6;
            }
            if (linMedian == -1 && (long)t > total / 2L) {
                linMedian = i6;
            }
            if (!(dep0.value(i6) > 0.0) || firstPositiveBin != Integer.MAX_VALUE) continue;
            firstPositiveBin = i6;
        }
        int linLowestPeak = 0;
        for (int i7 = 0; i7 < hist.length(); ++i7) {
            if (!(hist.value(i7) > (double)peakv / 10.0)) continue;
            linLowestPeak = i7;
            break;
        }
        if ((xunits = (Units)xds.property("UNITS")) == null) {
            xunits = Units.dimensionless;
        }
        boolean log = false;
        double firstBin = ((Number)((Map)hist.property("USER_PROPERTIES")).get("binStart")).doubleValue();
        double binWidth = ((Number)((Map)hist.property("USER_PROPERTIES")).get("binWidth")).doubleValue();
        boolean bunch0 = firstPositiveBin < Integer.MAX_VALUE && ipeak == firstPositiveBin && extent.value(0) - Math.abs(mean) < 0.0 && (total < 10L || (firstBin -= binWidth) <= 0.0);
        boolean isratiomeas = UnitsUtil.isRatioMeasurement(xunits);
        QDataSet logDiff = null;
        logger.log(Level.FINER, "consider log: isratio={0} allPositive={1} bunch0={2}", new Object[]{isratiomeas, extent.value(0) > 0.0, bunch0});
        if (isratiomeas && extent.value(0) > 0.0 && (logScaleType || everIncreasing > (double)everIncreasingLimit || bunch0)) {
            QDataSet diffs2;
            ah = new AutoHistogram();
            logDiff = diffs2 = Ops.diff(Ops.log(xds));
            QDataSet yy = DataSetUtil.weightsDataSet(yds);
            if (repeatValues > 0) {
                QDataSet r3 = Ops.where(Ops.ne(diffs2, DataSetUtil.asDataSet(0.0)));
                diffs2 = DataSetOps.applyIndex(diffs2, 0, r3, false);
                yy = DataSetOps.applyIndex(yy, 0, r3, false);
            }
            QDataSet loghist = ah.doit(diffs2, yy);
            long ltotal = (Long)((Map)loghist.property("USER_PROPERTIES")).get("total");
            int logPeak = 0;
            int logPeakv = (int)loghist.value(0);
            int logMedian = -1;
            int logHighestPeak = 0;
            t = 0;
            for (int i8 = 0; i8 < loghist.length(); ++i8) {
                t = (int)((double)t + loghist.value(i8));
                if (loghist.value(i8) > (double)logPeakv) {
                    logPeak = i8;
                    logPeakv = (int)loghist.value(i8);
                }
                if (loghist.value(i8) > (double)logPeakv / 100.0) {
                    logHighestPeak = i8;
                }
                if (logMedian != -1 || (long)t <= ltotal / 2L) continue;
                logMedian = i8;
            }
            int highestPeak = linHighestPeak;
            if (everIncreasing > (double)everIncreasingLimit || logPeak > 1 && 1.0 * (double)logMedian / (double)loghist.length() > 1.0 * (double)linMedian / (double)hist.length()) {
                logger.finer(String.format("switch to log everIncreasing=%s logPeak=%s logMedianPerc=%5.1f linMedianPerc=%5.1f", everIncreasing, logPeak, 1.0 * (double)logMedian / (double)loghist.length(), 1.0 * (double)linMedian / (double)hist.length()));
                hist = loghist;
                ipeak = logPeak;
                peakv = logPeakv;
                highestPeak = logHighestPeak;
                log = true;
            } else {
                logger.finer(String.format("stay linear everIncreasing=%s logPeak=%s logMedianPerc=%5.1f linMedianPerc=%5.1f", everIncreasing, logPeak, 1.0 * (double)logMedian / (double)loghist.length(), 1.0 * (double)linMedian / (double)hist.length()));
            }
            if (peakv < 20) {
                ipeak = highestPeak;
                peakv = (int)hist.value(ipeak);
            } else if (ipeak >= logHighestPeak) {
                // empty if block
            }
        } else if (peakv < 20) {
            ipeak = linHighestPeak;
            peakv = (int)hist.value(ipeak);
        } else if (ipeak < linHighestPeak && hist.value(linHighestPeak) > Math.max(Math.ceil(hist.value(linLowestPeak) / 10.0), 1.0)) {
            ipeak = linHighestPeak;
            peakv = (int)hist.value(ipeak);
        }
        double ss = 0.0;
        double nn = 0.0;
        RankZeroDataSet theResult = null;
        boolean haveResult = false;
        QDataSet sss = (QDataSet)hist.property("PLANE_0");
        for (i = ipeak; i >= 0 && hist.value(i) > (double)(peakv / 4); ss += sss.value(i) * hist.value(i), nn += hist.value(i), --i) {
        }
        for (i = ipeak + 1; i < hist.length() && hist.value(i) > (double)(peakv / 4); ss += sss.value(i) * hist.value(i), nn += hist.value(i), ++i) {
        }
        if (t < 65 && log) {
            double s = Math.abs(ss / nn);
            int skip = 0;
            int bigSkip = 0;
            for (int i9 = 0; i9 < t - 1; ++i9) {
                double d = Math.abs(Math.log(xds.value(i9 + 1) / xds.value(i9)));
                if (!(d > s * 1.5)) continue;
                ++skip;
                if (!(d > s * 7.0)) continue;
                ++bigSkip;
            }
            logger.log(Level.FINE, "guessCadence({0})->null because of log,skip,not bigSkip", new Object[]{xds});
            if (bigSkip == 0 && skip > 0) {
                logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
                theResult = null;
                haveResult = true;
            }
        }
        if (haveResult) return theResult;
        DRank0DataSet result = DRank0DataSet.create(ss / nn);
        if (t < 65) {
            QDataSet tresult = Ops.multiply((Object)result, 1.1);
            QDataSet r4 = log && logDiff != null ? Ops.where(Ops.gt(logDiff, tresult)) : Ops.where(Ops.gt(diffs, tresult));
            if (r4.length() > t / 4) {
                theResult = null;
                haveResult = true;
            }
        }
        if (haveResult) return theResult;
        if (log) {
            result.putProperty("UNITS", Units.logERatio);
            result.putProperty("SCALE_TYPE", "log");
            logger.log(Level.FINE, "guessCadence({0})->{1} (log)", new Object[]{xds, result});
            logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
            return result;
        }
        result.putProperty("UNITS", xunits.getOffsetUnits());
        logger.log(Level.FINE, "guessCadence({0})->{1} (linear)", new Object[]{xds, result});
        logger.exiting(LOGGING_SOURCE_CLASS, "guessCadenceNew");
        return result;
    }

    public static QDataSet kmeansCadence(QDataSet xds, int n) {
        boolean done = false;
        QDataSet ext = Ops.extent(xds);
        double min = ext.value(0);
        double max = ext.value(1);
        double[] boundaries = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            boundaries[i] = min + (double)(i + 1) * (max - min) / (double)n;
        }
        double[] means = null;
        int[] bs = new int[xds.length()];
        int b = 0;
        while (!done) {
            int j;
            means = new double[n];
            double[] ww = new double[n];
            for (int i = 0; i < xds.length(); ++i) {
                double d = xds.value(i);
                while (b < n - 1 && d >= boundaries[b]) {
                    ++b;
                }
                while (b > 0 && d < boundaries[b - 1]) {
                    --b;
                }
                int n2 = b;
                means[n2] = means[n2] + d;
                int n3 = b;
                ww[n3] = ww[n3] + 1.0;
                bs[i] = b;
            }
            done = true;
            for (j = 0; j < n; ++j) {
                if (ww[j] == 0.0) {
                    for (int i = 0; i < n - 1; ++i) {
                        boundaries[i] = min + (double)(i + 1) * (max - min) / (double)n;
                    }
                    done = false;
                    throw new IllegalArgumentException("algorithm fails");
                }
                means[j] = means[j] / ww[j];
            }
            if (!done) continue;
            for (j = 0; j < n - 1; ++j) {
                double bb = (means[j] + means[j + 1]) / 2.0;
                if (bb == boundaries[j]) continue;
                done = false;
                boundaries[j] = bb;
            }
            System.err.println("boundaries[0]=" + boundaries[0]);
        }
        IDataSet result = IDataSet.wrap(bs);
        result.putProperty("DEPEND_0", xds);
        HashMap<String, double[]> userProps = new HashMap<String, double[]>();
        userProps.put("means", means);
        result.putProperty("USER_PROPERTIES", userProps);
        return result;
    }

    public static QDataSet guessCadence(QDataSet xds, QDataSet yds) {
        QDataSet dxds = Ops.diff(xds);
        dxds = Ops.divide(Ops.add(Ops.append(dxds.slice(0), dxds), Ops.append(dxds, dxds.slice(dxds.length() - 1))), Ops.dataset(2));
        QDataSet hh = Ops.autoHistogram(dxds);
        int maxhh = -1;
        int imaxhh = -1;
        for (int i = 0; i < hh.length(); ++i) {
            if (!(hh.value(i) > (double)maxhh)) continue;
            maxhh = (int)hh.value(i);
            imaxhh = i;
        }
        QDataSet dephh = (QDataSet)hh.property("DEPEND_0");
        return dephh.slice(imaxhh);
    }

    public static QDataSet guessCadence(QDataSet xds, QDataSet yds, QDataSet zds) {
        QDataSet dxds = Ops.diff(xds);
        if (yds.rank() == 1 && xds.rank() == 1 && yds.length() == xds.length()) {
            DataSetBuilder dataSetBuilder = new DataSetBuilder(1, 100);
        }
        dxds = Ops.divide(Ops.add(Ops.append(dxds.slice(0), dxds), Ops.append(dxds, dxds.slice(dxds.length() - 1))), Ops.dataset(2));
        QDataSet hh = Ops.autoHistogram(dxds);
        int maxhh = -1;
        int imaxhh = -1;
        for (int i = 0; i < hh.length(); ++i) {
            if (!(hh.value(i) > (double)maxhh)) continue;
            maxhh = (int)hh.value(i);
            imaxhh = i;
        }
        QDataSet dephh = (QDataSet)hh.property("DEPEND_0");
        return dephh.slice(imaxhh);
    }

    public static boolean isConstant(QDataSet ds) {
        if (ds.rank() == 0 || ds.length() == 0) {
            return true;
        }
        QDataSet s1 = ds.slice(0);
        for (int i = 1; i < ds.length(); ++i) {
            if (Ops.equivalent(s1, ds.slice(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkQubeJoin(QDataSet ds) {
        QDataSet d0 = ds.slice(0);
        Map<String, Object> p0 = DataSetUtil.getProperties(d0);
        int n = p0.size();
        for (int i = 1; i < ds.length(); ++i) {
            QDataSet d1 = ds.slice(i);
            if (d0.length() != d1.length()) {
                return false;
            }
            Map<String, Object> p1 = DataSetUtil.getProperties(d1);
            HashMap<String, Object> eqp = Ops.equalProperties(p0, p1);
            if (eqp.size() == n) continue;
            return false;
        }
        if (ds instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)ds).isImmutable()) {
            logger.fine("putProperty(QDataSet.QUBE,Boolean.TRUE)");
            ((MutablePropertyDataSet)ds).putProperty("QUBE", Boolean.TRUE);
        }
        return true;
    }

    public static boolean checkQube(QDataSet ds) {
        if (ds.rank() < 2) {
            return true;
        }
        Boolean q = (Boolean)ds.property("QUBE");
        if (q == null || q.equals(Boolean.FALSE)) {
            if (SemanticOps.isJoin(ds)) {
                return DataSetUtil.checkQubeJoin(ds);
            }
            for (int i = 1; i < ds.rank(); ++i) {
                QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
                if (dep == null || dep.rank() <= 1 || DataSetUtil.isConstant(dep)) continue;
                return false;
            }
            if (ds instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)ds).isImmutable()) {
                logger.fine("putProperty(QDataSet.QUBE,Boolean.TRUE)");
                ((MutablePropertyDataSet)ds).putProperty("QUBE", Boolean.TRUE);
            }
            return true;
        }
        return true;
    }

    public static boolean isQube(QDataSet ds) {
        if (ds.rank() <= 1) {
            return true;
        }
        Boolean q = (Boolean)ds.property("QUBE");
        if (q == null || q.equals(Boolean.FALSE)) {
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            return ds.rank() == 2 && dep1 != null && dep1.rank() == 1;
        }
        return true;
    }

    public static int[] qubeDims(QDataSet ds) {
        boolean q;
        if (ds.rank() > 4) {
            int[] qube = new int[ds.rank()];
            int rank = ds.rank();
            for (int i = 0; i < rank; ++i) {
                qube[i] = ds.length();
                ds = ds.slice(0);
            }
            return qube;
        }
        if (ds.rank() == 2) {
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 != null && dep1.rank() == 1) {
                return new int[]{ds.length(), dep1.length()};
            }
        } else {
            if (ds.rank() == 1) {
                return new int[]{ds.length()};
            }
            if (ds.rank() == 0) {
                return new int[0];
            }
        }
        if (!(q = DataSetUtil.checkQube(ds))) {
            return null;
        }
        int[] qube = new int[ds.rank()];
        qube[0] = ds.length();
        if (ds.rank() > 1) {
            qube[1] = ds.length(0);
            if (ds.rank() > 2) {
                qube[2] = ds.length(0, 0);
                if (ds.rank() > 3) {
                    qube[3] = ds.length(0, 0, 0);
                    if (ds.rank() > 4) {
                        throw new IllegalArgumentException("rank limit");
                    }
                }
            }
        }
        return qube;
    }

    public static int product(int[] qube) {
        switch (qube.length) {
            case 0: {
                return 1;
            }
            case 1: {
                return qube[0];
            }
            case 2: {
                return qube[0] * qube[1];
            }
            case 3: {
                return qube[0] * qube[1] * qube[2];
            }
            case 4: {
                return qube[0] * qube[1] * qube[2] * qube[3];
            }
        }
        int result = qube[0];
        for (int i = 1; i < qube.length; ++i) {
            result *= qube[i];
        }
        return result;
    }

    public static int sum(int[] qube) {
        switch (qube.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return qube[0];
            }
            case 2: {
                return qube[0] + qube[1];
            }
            case 3: {
                return qube[0] + qube[1] + qube[2];
            }
            case 4: {
                return qube[0] + qube[1] + qube[2] + qube[3];
            }
        }
        int result = qube[0];
        for (int i = 1; i < qube.length; ++i) {
            result += qube[i];
        }
        return result;
    }

    public static String toString(int[] qube) {
        switch (qube.length) {
            case 0: {
                return "[]";
            }
            case 1: {
                return "[" + qube[0] + "]";
            }
            case 2: {
                return "[" + qube[0] + "," + qube[1] + "]";
            }
            case 3: {
                return "[" + qube[0] + "," + qube[1] + "," + qube[2] + "]";
            }
            case 4: {
                return "[" + qube[0] + "," + qube[1] + "," + qube[2] + "," + qube[3] + "]";
            }
        }
        throw new IllegalArgumentException("qube is too long");
    }

    public static void addQube(MutablePropertyDataSet ds) throws IllegalArgumentException {
        int[] qube = null;
        switch (ds.rank()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                qube = new int[]{ds.length(), ds.length(0)};
                if (ds.length() <= 0) break;
                for (int i = 1; i < ds.length(); ++i) {
                    if (ds.length(i) == ds.length(0)) continue;
                    throw new IllegalArgumentException("dataset is not a qube");
                }
                break;
            }
            case 3: {
                qube = new int[]{ds.length(), ds.length(0), ds.length(0, 0)};
                if (ds.length() <= 0 || ds.length(0) <= 0) break;
                for (int i = 1; i < ds.length(); ++i) {
                    if (ds.length(i) != ds.length(0)) {
                        throw new IllegalArgumentException("dataset is not a qube");
                    }
                    for (int j = 1; j < ds.length(0); ++j) {
                        if (ds.length(i, j) == ds.length(0, 0)) continue;
                        throw new IllegalArgumentException("dataset is not a qube");
                    }
                }
                break;
            }
            case 4: {
                qube = new int[]{ds.length(), ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)};
                if (ds.length() <= 0 || ds.length(0) <= 0 || ds.length(0, 0) <= 0) break;
                for (int i = 1; i < ds.length(); ++i) {
                    if (ds.length(i) != ds.length(0)) {
                        throw new IllegalArgumentException("dataset is not a qube");
                    }
                    for (int j = 1; j < ds.length(0); ++j) {
                        if (ds.length(i, j) != ds.length(0, 0)) {
                            throw new IllegalArgumentException("dataset is not a qube");
                        }
                        for (int k = 1; k < ds.length(0, 0); ++k) {
                            if (ds.length(i, j, k) == ds.length(0, 0, 0)) continue;
                            throw new IllegalArgumentException("dataset is not a qube");
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("rank not supported");
            }
        }
        if (qube != null) {
            ds.putProperty("QUBE", Boolean.TRUE);
        }
    }

    public static String format(QDataSet ds) {
        return DataSetUtil.format(ds, true);
    }

    public static String format(QDataSet ds, boolean showContext) {
        int i;
        if (ds.property("BUNDLE_0") != null) {
            StringBuilder result = new StringBuilder();
            for (int i2 = 0; i2 < ds.length(); ++i2) {
                QDataSet cds = ds.slice(i2);
                result.append(DataSetUtil.format(cds));
                if (i2 >= ds.length() - 1) continue;
                result.append(", ");
            }
            return result.toString();
        }
        if ("min,max".equals(ds.property("BINS_0")) && ds.rank() == 1) {
            StringBuilder result = new StringBuilder();
            Units u = (Units)ds.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            result.append(new DatumRange(ds.value(0), ds.value(1), u).toString());
            String[] ss = ((String)ds.property("BINS_0")).split(",", -2);
            if (ss.length != ds.length()) {
                throw new IllegalArgumentException("bins count != length in ds");
            }
            return result.toString();
        }
        if ("min,maxInclusive".equals(ds.property("BINS_0")) && ds.rank() == 1) {
            StringBuilder result = new StringBuilder();
            Units u = (Units)ds.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            result.append(new DatumRange(ds.value(0), ds.value(1), u).toString());
            result.append("(inclusive)");
            String[] ss = ((String)ds.property("BINS_0")).split(",", -2);
            if (ss.length != ds.length()) {
                throw new IllegalArgumentException("bins count != length in ds");
            }
            return result.toString();
        }
        if (ds.property("BINS_0") != null && ds.rank() == 1) {
            String[] ss;
            StringBuilder result = new StringBuilder();
            Units u = (Units)ds.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            if ((ss = ((String)ds.property("BINS_0")).split(",", -2)).length != ds.length()) {
                throw new IllegalArgumentException("bins count != length in ds");
            }
            for (int i3 = 0; i3 < ds.length(); ++i3) {
                result.append(ss[i3]).append("=").append(u.createDatum(ds.value(i3)));
                if (i3 >= ds.length() - 1) continue;
                result.append(", ");
            }
            if (ds.property("SCALE_TYPE") != null) {
                result.append("SCALE_TYPE=").append(ds.property("SCALE_TYPE"));
            }
            return result.toString();
        }
        if (ds.rank() == 1 && Schemes.isComplexNumbers(ds)) {
            DecimalFormat df = new DecimalFormat("0.000E0");
            String rs = String.valueOf(ds.value(0));
            String is = String.valueOf(ds.value(1));
            if (rs.length() > 7) {
                rs = df.format(ds.value(0));
            }
            if (is.length() > 7) {
                is = df.format(ds.value(1));
            }
            return "(" + rs + "+" + is + "j)";
        }
        if (ds.rank() == 0) {
            QDataSet context0;
            String name = (String)ds.property("NAME");
            Units u = (Units)ds.property("UNITS");
            String format = (String)ds.property("FORMAT");
            StringBuilder result = new StringBuilder();
            if (name != null) {
                result.append(name).append("=");
            }
            if (format != null && format.trim().length() > 0) {
                FormatStringFormatter fsf = new FormatStringFormatter(format, true);
                if (u != null) {
                    if (UnitsUtil.isTimeLocation(u)) {
                        double millis = u.convertDoubleTo(Units.t1970, ds.value());
                        Calendar cal = Calendar.getInstance();
                        cal.setTimeInMillis((long)millis);
                        result.append(String.format(Locale.US, format, cal));
                    } else {
                        result.append(fsf.format(DataSetUtil.asDatum(ds)));
                    }
                } else {
                    result.append(fsf.format(DataSetUtil.asDatum(ds)));
                }
            } else if (u != null) {
                result.append(u.createDatum(ds.value()).toString());
            } else {
                result.append(ds.value());
            }
            if (showContext && (context0 = (QDataSet)ds.property("CONTEXT_0")) != null) {
                result.append(" @ ").append(DataSetUtil.format(context0));
            }
            return result.toString();
        }
        StringBuilder buf = new StringBuilder(ds.toString() + ":\n");
        if (ds.rank() == 1) {
            for (i = 0; i < Math.min(40, ds.length()); ++i) {
                buf.append(" ").append(ds.value(i));
            }
            if (ds.length() >= 40) {
                buf.append(" ...");
            }
        }
        if (ds.rank() == 2) {
            for (i = 0; i < Math.min(10, ds.length()); ++i) {
                for (int j = 0; j < Math.min(20, ds.length(i)); ++j) {
                    buf.append(" ").append(ds.value(i, j));
                }
                if (ds.length() >= 40) {
                    buf.append(" ...");
                }
                buf.append("\n");
            }
            if (ds.length() >= 10) {
                buf.append(" ... ... ... \n");
            }
        }
        return buf.toString();
    }

    public static String statsString(QDataSet ds) {
        RankZeroDataSet stats = DataSetOps.moment(ds);
        return "" + stats.value() + "+/-" + stats.property("stddev") + " N=" + stats.property("validCount");
    }

    public static boolean validate(QDataSet ds, List<String> problems) {
        if (problems == null) {
            problems = new ArrayList<String>();
        }
        return DataSetUtil.validate(ds, problems, 0);
    }

    public static boolean validate(QDataSet xds, QDataSet yds, List<String> problems) {
        if (xds.length() != yds.length()) {
            if (problems != null) {
                problems.add(String.format("DEPEND_%d length is %d, should be %d.", 0, xds.length(), yds.length()));
            }
            return false;
        }
        return DataSetUtil.validate(Ops.link(xds, yds), problems, 0);
    }

    public static boolean validate(QDataSet xds, QDataSet yds, QDataSet zds, List<String> problems) {
        if (xds.length() != zds.length()) {
            if (problems != null) {
                problems.add(String.format("DEPEND_%d length is %d, should be %d.", 0, xds.length(), zds.length()));
            }
            return false;
        }
        return DataSetUtil.validate(Ops.link(xds, yds, zds), problems, 0);
    }

    public static int totalLength(QDataSet ds) {
        if (ds.rank() == 0) {
            return 1;
        }
        int[] qube = DataSetUtil.qubeDims(ds);
        if (qube == null) {
            LengthsDataSet lds = new LengthsDataSet(ds);
            QubeDataSetIterator it = new QubeDataSetIterator(lds);
            int total = 0;
            while (it.hasNext()) {
                it.next();
                total = (int)((double)total + it.getValue(lds));
            }
            return total;
        }
        int total = qube[0];
        for (int i = 1; i < qube.length; ++i) {
            total *= qube[i];
        }
        return total;
    }

    private static boolean validate(QDataSet ds, List<String> problems, int dimOffset) {
        QDataSet plane0;
        Object o;
        QDataSet bds1;
        Object obds;
        int i;
        QDataSet dep;
        if (problems == null) {
            problems = new ArrayList<String>();
        }
        if ((dep = (QDataSet)ds.property("DEPEND_0")) != null) {
            if (dep.length() != ds.length()) {
                problems.add(String.format("DEPEND_%d length is %d while data length is %d.", dimOffset, dep.length(), ds.length()));
            }
            if (dep.rank() > 1 && !Schemes.isRank2Bins(dep) && !Schemes.isXYScatter(dep)) {
                problems.add("DEPEND_0 is greater than rank 1 and is not bins dataset.");
            }
            if (ds.rank() > 1 && ds.length() > 0) {
                QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
                if (dep1 != null && dep1.rank() > 1 && dep1.length() != ds.length() && !SemanticOps.isBins(dep1)) {
                    problems.add(String.format("rank 2 DEPEND_1 length is %d while data length is %d.", dep1.length(), ds.length()));
                }
                if (ds.rank() > 4) {
                    DataSetUtil.validate(ds.slice(0), problems, dimOffset + 1);
                } else {
                    DataSetUtil.validate((QDataSet)DataSetOps.slice0(ds, 0), problems, dimOffset + 1);
                }
            }
        }
        if (ds.property("JOIN_0") != null) {
            if (dimOffset > 0) {
                problems.add("JOIN_0 must only be on zeroth dimension: " + dimOffset);
            } else {
                Units u = null;
                boolean onceNotify = false;
                for (i = 0; i < ds.length(); ++i) {
                    MutablePropertyDataSet ds1 = DataSetOps.slice0(ds, i);
                    if (!DataSetUtil.validate((QDataSet)ds1, problems, dimOffset + 1)) {
                        problems.add("join(" + i + ") not valid JOINED dataset.");
                    }
                    if (u == null) {
                        u = SemanticOps.getUnits(ds1);
                        continue;
                    }
                    if (u == SemanticOps.getUnits(ds1) || onceNotify) continue;
                    problems.add("units change in joined datasets");
                    onceNotify = true;
                }
            }
        }
        if ((obds = ds.property("BUNDLE_0")) != null) {
            if (!QDataSet.class.isInstance(obds)) {
                problems.add("BUNDLE_0 is defined but not a QDataSet");
            } else if (((QDataSet)obds).rank() < 1) {
                problems.add("BUNDLE_0 found but dataset is only rank 0");
            } else if (ds.length() == ((QDataSet)obds).length()) {
                QDataSet bds = (QDataSet)obds;
                for (i = 0; i < Math.min(1, bds.length()); ++i) {
                    bds1 = DataSetOps.unbundle(ds, i, true);
                    o = bds1.property("DEPEND_1");
                    if (o == null || o instanceof QDataSet) continue;
                    DataSetUtil.validate(bds1, problems, 1);
                }
            }
        }
        if ((obds = ds.property("BUNDLE_1")) != null && !(obds instanceof QDataSet)) {
            throw new IllegalArgumentException("BUNDLE_1 property is not a QDataSet");
        }
        if (obds != null) {
            QDataSet bds = (QDataSet)obds;
            if (ds.rank() < 2) {
                problems.add("BUNDLE_1 found but dataset is only rank 1");
            } else {
                for (i = 0; i < Math.min(1, bds.length()); ++i) {
                    bds1 = DataSetOps.unbundle(ds, i, true);
                    o = bds1.property("DEPEND_1");
                    if (o == null || o instanceof QDataSet) continue;
                    DataSetUtil.validate(bds1, problems, 1);
                }
            }
        }
        if (ds.property("PLANE_0") != null && (plane0 = (QDataSet)ds.property("PLANE_0")) != null && plane0.rank() > 0 && plane0.length() != ds.length()) {
            problems.add(String.format("PLANE_0 length is %d, should be %d", plane0.length(), ds.length()));
        }
        return problems.isEmpty();
    }

    public static void makeValid(MutablePropertyDataSet ds) {
        int[] qubeDims = null;
        if (DataSetUtil.isQube(ds)) {
            qubeDims = DataSetUtil.qubeDims(ds);
        }
        int i = 0;
        QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
        if (dep != null && dep.length() != ds.length()) {
            ds.putProperty("DEPEND_" + i, null);
        }
        if (qubeDims != null) {
            for (i = 1; i < qubeDims.length; ++i) {
                dep = (QDataSet)ds.property("DEPEND_" + i);
                if (dep == null || dep.length() == qubeDims[i]) continue;
                ds.putProperty("DEPEND_" + i, null);
            }
        }
    }

    public static QDataSet bundleWeightsDataSet(QDataSet ds) {
        QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
        if (bds == null) {
            throw new IllegalArgumentException("dataset must be bundle");
        }
        QDataSet result = null;
        int nb = ds.length(0);
        if (nb == 0) {
            throw new IllegalArgumentException("bundle is empty");
        }
        for (int i = 0; i < nb; ++i) {
            result = Ops.bundle(result, DataSetUtil.weightsDataSet(DataSetOps.unbundle(ds, i, false)));
        }
        assert (result != null);
        ((MutablePropertyDataSet)result).putProperty("FILL_VALUE", -1.0E38);
        ((MutablePropertyDataSet)result).putProperty("SUGGEST_FILL", -1.0E38);
        return result;
    }

    public static QDataSet weightsDataSet(QDataSet ds) {
        Object o = ds.property("WEIGHTS");
        if (o != null) {
            if (!(o instanceof QDataSet)) {
                logger.log(Level.WARNING, "WEIGHTS_PLANE contained something that was not a qdataset: {0}", o);
                o = null;
            } else if (ds.rank() == 0) {
                if (((QDataSet)o).rank() != 0) {
                    o = null;
                }
            } else if (((QDataSet)o).length() != ds.length()) {
                o = null;
            }
        }
        if (UnitsUtil.isNominalMeasurement(SemanticOps.getUnits(ds))) {
            EnumerationUnits eu = (EnumerationUnits)SemanticOps.getUnits(ds);
            if (eu.hasFillDatum()) {
                if (ds.property("FILL_VALUE") == null) {
                    MutablePropertyDataSet ds1 = Ops.putProperty(ds, "FILL_VALUE", (Object)eu.getFillDatum().doubleValue(eu));
                    return new WeightsDataSet.FillFinite(ds1);
                }
                return new WeightsDataSet.FillFinite(ds);
            }
            return new WeightsDataSet.Finite(ds);
        }
        QDataSet result = (QDataSet)o;
        if (result != null) {
            Number ofill = (Number)result.property("FILL_VALUE");
            if (ofill == null) {
                MutablePropertyDataSet mpds = DataSetOps.makePropertiesMutable(result);
                mpds.putProperty("FILL_VALUE", -1.0E31);
                mpds.putProperty("SUGGEST_FILL", -1.0E31);
                return mpds;
            }
            MutablePropertyDataSet mresult = DataSetOps.makePropertiesMutable(result);
            mresult.putProperty("SUGGEST_FILL", ofill);
            return result;
        }
        if (result == null) {
            boolean check;
            QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
            if (bds != null && ds.rank() == 2 && ds.length() > 0 && ds.length(0) > 0) {
                return DataSetUtil.bundleWeightsDataSet(ds);
            }
            Number validMin = (Number)ds.property("VALID_MIN");
            Number validMax = (Number)ds.property("VALID_MAX");
            Units u = (Units)ds.property("UNITS");
            Number ofill = (Number)ds.property("FILL_VALUE");
            if (validMin == null) {
                validMin = Double.NEGATIVE_INFINITY;
            }
            if (validMax == null) {
                validMax = Double.POSITIVE_INFINITY;
            }
            double fill = ofill == null ? Double.NaN : ofill.doubleValue();
            boolean bl = check = validMin.doubleValue() > -1.7976931348623157E308 || validMax.doubleValue() < Double.MAX_VALUE || !Double.isNaN(fill);
            result = check ? (validMin.doubleValue() > -1.7976931348623157E308 || validMax.doubleValue() < Double.MAX_VALUE ? new WeightsDataSet.ValidRangeFillFinite(ds) : new WeightsDataSet.ValidRangeFillFinite(ds)) : (u != null ? new WeightsDataSet.FillFinite(ds) : new WeightsDataSet.Finite(ds));
        }
        return result;
    }

    public static WritableDataSet canonizeFill(QDataSet ds) {
        if (!(ds instanceof WritableDataSet)) {
            ds = DDataSet.copy(ds);
        }
        WritableDataSet wrds = (WritableDataSet)ds;
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = -1.0E31;
        while (it.hasNext()) {
            it.next();
            if (it.getValue(wds) != 0.0) continue;
            it.putValue(wrds, fill);
        }
        wrds.putProperty("FILL_VALUE", fill);
        return wrds;
    }

    public static QDataSet convertTo(QDataSet ds, Units u) {
        Number fill;
        Number vmax;
        Units su = (Units)ds.property("UNITS");
        if (su == null) {
            su = Units.dimensionless;
        }
        UnitsConverter uc = su.getConverter(u);
        DDataSet result = (DDataSet)ArrayDataSet.copy(ds);
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        while (it.hasNext()) {
            it.next();
            it.putValue(result, uc.convert(it.getValue(ds)));
        }
        Number vmin = (Number)ds.property("VALID_MIN");
        if (vmin != null) {
            result.putProperty("VALID_MIN", uc.convert(vmin));
        }
        if ((vmax = (Number)ds.property("VALID_MAX")) != null) {
            result.putProperty("VALID_MAX", uc.convert(vmax));
        }
        if ((fill = (Number)ds.property("FILL_VALUE")) != null) {
            result.putProperty("FILL_VALUE", uc.convert(fill));
        }
        result.putProperty("UNITS", u);
        return result;
    }

    public static double value(RankZeroDataSet ds, Units tu) {
        Units u = (Units)ds.property("UNITS");
        if (tu == null && u == null) {
            return ds.value();
        }
        return u.convertDoubleTo(tu, ds.value());
    }

    public static Datum asDatum(RankZeroDataSet ds) {
        return DataSetUtil.asDatum((QDataSet)ds);
    }

    public static Datum asDatum(QDataSet ds) {
        if (ds.rank() > 0) {
            throw new IllegalArgumentException("dataset is not rank 0");
        }
        Units u = SemanticOps.getUnits(ds);
        String format = (String)ds.property("FORMAT");
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        if (wds.value() == 0.0) {
            return u.getFillDatum();
        }
        if (format == null || format.trim().length() == 0) {
            return Datum.create(ds.value(), u);
        }
        return Datum.create(ds.value(), u, new FormatStringFormatter(format, true));
    }

    public static DatumRange asDatumRange(QDataSet ds, boolean sloppy) {
        Units u = SemanticOps.getUnits(ds);
        double dmin = ds.value(0);
        double dmax = ds.value(1);
        QDataSet bds = (QDataSet)ds.property("BUNDLE_0");
        if (bds != null) {
            Units u0 = (Units)bds.property("UNITS", 0);
            Units u1 = (Units)bds.property("UNITS", 1);
            if (u0 != null && u1 != null) {
                if (u0 == u1) {
                    u = u0;
                } else {
                    logger.finest("accommodating bundle of min,delta.");
                    u = u0;
                    dmax = u1.convertDoubleTo(u0.getOffsetUnits(), dmax) + dmin;
                }
            }
        }
        if (!sloppy && !ds.property("BINS_0").equals("min,max")) {
            throw new IllegalArgumentException("expected min,max for BINS_0 because we are not allowing sloppy.");
        }
        return new DatumRange(dmin, dmax, u);
    }

    public static DatumRange asDatumRange(QDataSet ds) {
        return DataSetUtil.asDatumRange(ds, true);
    }

    public static DatumVector asDatumVector(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("Rank must be 1");
        }
        double[] dd = new double[ds.length()];
        for (int i = 0; i < dd.length; ++i) {
            dd[i] = ds.value(i);
        }
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        return DatumVector.newDatumVector(dd, u);
    }

    public static QDataSet asDataSet(DatumVector dv) {
        DDataSet result = DDataSet.wrap(dv.toDoubleArray(dv.getUnits()));
        result.putProperty("UNITS", dv.getUnits());
        return result;
    }

    public static QDataSet asDataSet(DatumRange dr) {
        DDataSet result = DDataSet.createRank1(2);
        Units u = dr.getUnits();
        result.putValue(0, dr.min().doubleValue(u));
        result.putValue(1, dr.max().doubleValue(u));
        result.putProperty("UNITS", u);
        result.putProperty("BINS_0", "min,max");
        return result;
    }

    public static DRank0DataSet asDataSet(double d, Units u) {
        return DRank0DataSet.create(d, u);
    }

    public static DRank0DataSet asDataSet(double d) {
        return DRank0DataSet.create(d);
    }

    public static DRank0DataSet asDataSet(Datum d) {
        return DRank0DataSet.create(d);
    }

    public static double[] asArrayOfDoubles(QDataSet d) {
        if (d.rank() != 1) {
            throw new IllegalArgumentException("only rank 1 supported");
        }
        DDataSet ds = (DDataSet)ArrayDataSet.maybeCopy(Double.TYPE, d);
        double[] back = ds.back;
        double[] result = new double[d.length()];
        System.arraycopy(back, 0, result, 0, d.length());
        return result;
    }

    public static double[][] as2DArrayOfDoubles(QDataSet d) {
        double[][] result;
        if (d.rank() == 2) {
            DDataSet ds = (DDataSet)ArrayDataSet.maybeCopy(Double.TYPE, d);
            double[] back = ds.back;
            int l1 = d.length(0);
            result = new double[d.length()][l1];
            for (int i = 0; i < ds.length(); ++i) {
                System.arraycopy(back, i * l1, result[i], 0, l1);
            }
        } else {
            throw new IllegalArgumentException("only rank 2 supported");
        }
        return result;
    }

    private static void flatten(double[][] data, double[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            double[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(float[][] data, float[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            float[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(long[][] data, long[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            long[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(int[][] data, int[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            int[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(short[][] data, short[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            short[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(byte[][] data, byte[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            byte[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    public static QDataSet asDataSet(Object arr) {
        if (arr.getClass().isArray()) {
            Class<?> c = arr.getClass().getComponentType();
            if (c.isArray()) {
                if ((c = c.getComponentType()).isArray()) {
                    throw new IllegalArgumentException("3-D arrays not supported");
                }
                int ny = Array.getLength(Array.get(arr, 0));
                int nx = Array.getLength(arr);
                if (c == Double.TYPE) {
                    double[] dd = new double[nx * ny];
                    DataSetUtil.flatten((double[][])arr, dd, 0, nx, ny);
                    return DDataSet.wrap(dd, nx, ny);
                }
                if (c == Float.TYPE) {
                    float[] dd = new float[nx * ny];
                    DataSetUtil.flatten((float[][])arr, dd, 0, nx, ny);
                    return FDataSet.wrap(dd, nx, ny);
                }
                if (c == Long.TYPE) {
                    long[] dd = new long[nx * ny];
                    DataSetUtil.flatten((long[][])arr, dd, 0, nx, ny);
                    return LDataSet.wrap(dd, nx, ny);
                }
                if (c == Integer.TYPE) {
                    int[] dd = new int[nx * ny];
                    DataSetUtil.flatten((int[][])arr, dd, 0, nx, ny);
                    return IDataSet.wrap(dd, nx, ny);
                }
                if (c == Short.TYPE) {
                    short[] dd = new short[nx * ny];
                    DataSetUtil.flatten((short[][])arr, dd, 0, nx, ny);
                    return SDataSet.wrap(dd, nx, ny);
                }
                if (c == Byte.TYPE) {
                    byte[] dd = new byte[nx * ny];
                    DataSetUtil.flatten((byte[][])arr, dd, 0, nx, ny);
                    return BDataSet.wrap(dd, nx, ny);
                }
                throw new IllegalArgumentException("Array component type not supported: " + c);
            }
            if (c == Double.TYPE) {
                return DDataSet.wrap((double[])arr);
            }
            if (c == Float.TYPE) {
                return FDataSet.wrap((float[])arr);
            }
            if (c == Long.TYPE) {
                return LDataSet.wrap((long[])arr);
            }
            if (c == Integer.TYPE) {
                return IDataSet.wrap((int[])arr);
            }
            if (c == Short.TYPE) {
                return SDataSet.wrap((short[])arr);
            }
            if (c == Byte.TYPE) {
                return BDataSet.wrap((byte[])arr);
            }
            throw new IllegalArgumentException("unsupported type: " + arr.getClass());
        }
        if (arr instanceof QDataSet) {
            return (QDataSet)arr;
        }
        if (arr instanceof Datum) {
            return DataSetUtil.asDataSet((Datum)arr);
        }
        if (arr.getClass().isPrimitive()) {
            return DataSetUtil.asDataSet((Double)arr);
        }
        if (arr instanceof String) {
            try {
                return DataSetUtil.asDataSet(DatumUtil.parse((String)arr));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        throw new IllegalArgumentException("unsupported type: " + arr.getClass());
    }

    public static QDataSet asDataSet(Object x, Object y) {
        QDataSet xds = DataSetUtil.asDataSet(x);
        QDataSet yds = DataSetUtil.asDataSet(y);
        return Ops.link(xds, yds);
    }

    public static QDataSet asDataSet(Object x, Object y, Object z) {
        QDataSet xds = DataSetUtil.asDataSet(x);
        QDataSet yds = DataSetUtil.asDataSet(y);
        QDataSet zds = DataSetUtil.asDataSet(z);
        return Ops.link(xds, yds, zds);
    }

    public static void addContext(MutablePropertyDataSet ds, QDataSet cds) {
        int idx = 0;
        while (ds.property("CONTEXT_" + idx) != null) {
            ++idx;
        }
        ds.putProperty("CONTEXT_" + idx, cds);
    }

    public static void addContext(Map<String, Object> props, QDataSet cds) {
        int idx = 0;
        while (props.get("CONTEXT_" + idx) != null) {
            ++idx;
        }
        props.put("CONTEXT_" + idx, cds);
    }

    public static String contextAsString(QDataSet ds) {
        return DataSetUtil.contextAsString(ds, ", ");
    }

    public static String contextAsString(QDataSet ds, String delim) {
        StringBuilder result = new StringBuilder();
        QDataSet cds = (QDataSet)ds.property("CONTEXT_0");
        logger.log(Level.FINE, "contextAsString {0} CONTEXT_0={1}", new Object[]{ds, cds});
        int idx = 0;
        while (cds != null) {
            if (cds.rank() > 0) {
                if (cds.rank() == 1 && cds.property("BINS_0") != null) {
                    if (cds.value(1) - cds.value(0) > 0.0) {
                        QDataSet fcds = DataSetUtil.asDataSet(DatumRangeUtil.roundSections(DataSetUtil.asDatumRange(cds, true), 1000));
                        result.append(DataSetUtil.format(fcds, false));
                    } else {
                        result.append(DataSetUtil.format(cds, false));
                    }
                } else {
                    QDataSet extent = Ops.extentSimple(cds, null, null);
                    if (extent.value(1) == extent.value(0)) {
                        result.append(DataSetUtil.format(cds.slice(0), false));
                    } else {
                        String name = (String)cds.property("NAME");
                        if (name == null) {
                            name = "data";
                        }
                        String label = name + " varies from " + extent.slice(0) + " to " + extent.slice(1);
                        result.append(label);
                    }
                }
            } else {
                result.append(DataSetUtil.format(cds, false));
            }
            if ((cds = (QDataSet)ds.property("CONTEXT_" + ++idx)) == null) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static int[] rangeOfMonotonic(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("must be rank 1");
        }
        if (DataSetUtil.isMonotonic(ds)) {
            int lastValid;
            int firstValid;
            QDataSet wds = DataSetUtil.weightsDataSet(ds);
            for (firstValid = 0; firstValid < wds.length() && wds.value(firstValid) == 0.0; ++firstValid) {
            }
            if (firstValid == wds.length()) {
                throw new IllegalArgumentException("data contains no valid measurements");
            }
            for (lastValid = wds.length() - 1; lastValid >= 0 && wds.value(lastValid) == 0.0; --lastValid) {
            }
            if (lastValid - firstValid + 1 == 0) {
                throw new IllegalArgumentException("special case where monotonic dataset contains no valid data");
            }
            return new int[]{firstValid, lastValid};
        }
        throw new IllegalArgumentException("expected monotonic dataset");
    }

    public static int xTagBinarySearch(QDataSet ds, Datum datum, int low, int high) {
        Units toUnits = SemanticOps.getUnits(ds);
        double key = datum.doubleValue(toUnits);
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("data must be rank 1");
        }
        if (high >= ds.length()) {
            throw new IndexOutOfBoundsException("high index must be within the data");
        }
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = ds.value(mid);
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int closestIndex(QDataSet ds, Datum datum) {
        QDataSet r;
        logger.entering(LOGGING_SOURCE_CLASS, "closestIndex");
        if (ds.rank() != 1) {
            if (ds.rank() == 2 && SemanticOps.isBins(ds)) {
                ds = Ops.reduceMean(ds, 1);
            } else {
                throw new IllegalArgumentException("ds rank should be 1");
            }
        }
        if (ds.length() == 0) {
            throw new IllegalArgumentException("ds length is zero");
        }
        boolean handleFill = false;
        QDataSet wds = Ops.valid(ds);
        if (UnitsUtil.isNominalMeasurement(datum.getUnits())) {
            throw new IllegalArgumentException("datum cannot have ordinal units: " + datum);
        }
        if (UnitsUtil.isNominalMeasurement(SemanticOps.getUnits(ds))) {
            throw new IllegalArgumentException("ds cannot have ordinal units: " + datum);
        }
        boolean mono = DataSetUtil.isMonotonic(ds);
        if (mono) {
            if (wds.value(0) > 0.0 && datum.le(DataSetUtil.asDatum(ds.slice(0)))) {
                logger.exiting(LOGGING_SOURCE_CLASS, "closestIndex");
                return 0;
            }
            int n = ds.length() - 1;
            if (wds.value(n) > 0.0 && datum.ge(DataSetUtil.asDatum(ds.slice(n)))) {
                logger.exiting(LOGGING_SOURCE_CLASS, "closestIndex");
                return n;
            }
        }
        if (wds instanceof ConstantDataSet && wds.value(0) == 1.0) {
            r = null;
        } else if (DataSetAnnotations.VALUE_0.equals(DataSetAnnotations.getInstance().getAnnotation(ds, "invalidCount"))) {
            r = null;
        } else if (ds instanceof IndexGenDataSet && wds instanceof WeightsDataSet.Finite) {
            DataSetAnnotations.getInstance().putAnnotation(ds, "invalidCount", DataSetAnnotations.VALUE_0);
            r = null;
        } else {
            r = Ops.where(wds);
            if (r.length() < ds.length()) {
                if (r.length() == 0) {
                    throw new IllegalArgumentException("dataset is all fill");
                }
                handleFill = true;
                ds = DataSetOps.applyIndex(ds, 0, r, false);
            } else {
                DataSetAnnotations.getInstance().putAnnotation(ds, "invalidCount", DataSetAnnotations.VALUE_0);
            }
        }
        double ddatum = datum.doubleValue(SemanticOps.getUnits(ds));
        if (!mono) {
            int closest = 0;
            double v = Math.abs(ds.value(closest) - ddatum);
            for (int i = 1; i < ds.length(); ++i) {
                double tv = Math.abs(ds.value(i) - ddatum);
                if (!(tv < v)) continue;
                closest = i;
                v = tv;
            }
            if (handleFill) {
                assert (r != null);
                closest = (int)r.value(closest);
            }
            logger.exiting(LOGGING_SOURCE_CLASS, "closestIndex");
            return closest;
        }
        int result = DataSetUtil.xTagBinarySearch(ds, datum, 0, ds.length() - 1);
        if (result == -1) {
            result = 0;
        } else if (result < 0) {
            if ((result ^= 0xFFFFFFFF) > ds.length() - 1) {
                result = ds.length() - 1;
            } else {
                double x1;
                double x = ddatum;
                double x0 = ds.value(result - 1);
                int n = result = (x - x0) / ((x1 = ds.value(result)) - x0) < 0.5 ? result - 1 : result;
            }
        }
        if (handleFill) {
            assert (r != null);
            result = (int)r.value(result);
        }
        logger.exiting(LOGGING_SOURCE_CLASS, "closestIndex");
        return result;
    }

    public static int closestIndex(QDataSet table, double x, Units units) {
        return DataSetUtil.closestIndex(table, units.createDatum(x));
    }

    public static Integer getPreviousIndexStrict(QDataSet ds, Datum datum) {
        int i;
        if (ds.length() == 0) {
            return null;
        }
        if (SemanticOps.isBins(ds) && ds.rank() == 2) {
            ds = Ops.slice1(ds, 1);
        }
        if (Ops.gt((Object)ds.slice(i = DataSetUtil.getPreviousIndex(ds, datum)), datum).value() > 0.0) {
            return null;
        }
        return i;
    }

    public static Integer getNextIndexStrict(QDataSet ds, Datum datum) {
        int i;
        if (ds.length() == 0) {
            return null;
        }
        if (SemanticOps.isBins(ds) && ds.rank() == 2) {
            ds = Ops.slice1(ds, 0);
        }
        if (Ops.le((Object)ds.slice(i = DataSetUtil.getNextIndex(ds, datum)), datum).value() > 0.0) {
            return null;
        }
        return i;
    }

    public static int getPreviousIndex(QDataSet ds, Datum datum) {
        int i = DataSetUtil.closestIndex(ds, datum);
        Units dsUnits = SemanticOps.getUnits(ds);
        if (i > 0 && ds.value(i) >= datum.doubleValue(dsUnits)) {
            return i - 1;
        }
        return i;
    }

    public static int getNextIndex(QDataSet ds, Datum datum) {
        int i = DataSetUtil.closestIndex(ds, datum);
        Units dsUnits = SemanticOps.getUnits(ds);
        if (i < ds.length() - 1 && ds.value(i) <= datum.doubleValue(dsUnits)) {
            return i + 1;
        }
        return i;
    }

    public static Object getProperty(QDataSet ds, String name, Object deflt) {
        Object o = ds.property(name);
        if (o != null) {
            return o;
        }
        return deflt;
    }

    public static String getStringValue(QDataSet ds, double value, int i) {
        QDataSet bds = (QDataSet)ds.property("BUNDLE_0");
        if (bds != null) {
            Units u = (Units)bds.property("UNITS", i);
            if (u == null) {
                u = Units.dimensionless;
            }
            Datum d = u.createDatum(value);
            return d.toString();
        }
        return DataSetUtil.getStringValue(ds, value);
    }

    public static DatumFormatter bestFormatter(QDataSet datums) {
        QDataSet gcd;
        if (datums.rank() == 0) {
            return DataSetUtil.bestFormatter(Ops.join(null, datums));
        }
        if (datums.rank() > 1 && (datums.rank() != 2 || datums.property("BINS_1") == null)) {
            return DataSetUtil.bestFormatter(datums.slice(0));
        }
        Units units = SemanticOps.getUnits(datums);
        if (Schemes.isBundleDataSet(datums) && datums.length() > 0) {
            throw new IllegalArgumentException("dataset is a bundle");
        }
        if (units instanceof EnumerationUnits) {
            return EnumerationDatumFormatterFactory.getInstance().defaultFormatter();
        }
        if (units instanceof TimeLocationUnits) {
            Datum gcd2 = DataSetUtil.asDatum(DataSetUtil.gcd(Ops.subtract(datums, datums.slice(0)), DataSetUtil.asDataSet(Units.microseconds.createDatum(1))));
            try {
                if (gcd2.lt(Units.nanoseconds.createDatum(1))) {
                    return new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSSSS)");
                }
                if (gcd2.lt(Units.nanoseconds.createDatum(1000))) {
                    return new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS)");
                }
                if (gcd2.lt(Units.microseconds.createDatum(1000))) {
                    return new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSSSSS)");
                }
                if (gcd2.lt(Units.milliseconds.createDatum(1000))) {
                    return new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS)");
                }
                if (gcd2.lt(Units.seconds.createDatum(60))) {
                    return new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS)");
                }
                if (gcd2.lt(Units.seconds.createDatum(600))) {
                    return new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss)");
                }
                return new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm");
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (units instanceof LocationUnits) {
            units = units.getOffsetUnits();
            datums = Ops.subtract(datums, datums.slice(0));
        }
        QDataSet limit = Ops.dataset(Math.pow(10.0, (int)Math.log10(Ops.reduceMax(datums, 0).value()) - 7), units);
        datums = Ops.round(Ops.divide(datums, limit));
        try {
            gcd = DataSetUtil.gcd(datums, DataSetUtil.asDataSet(1.0));
            datums = Ops.multiply(datums, limit);
            gcd = Ops.multiply(gcd, limit);
        }
        catch (IllegalArgumentException ex) {
            gcd = limit;
            datums = Ops.multiply(datums, limit);
        }
        int smallestExp = 99;
        int ismallestExp = -1;
        for (int j = 0; j < datums.length(); ++j) {
            int ee;
            double d = datums.value(j);
            if (!(Math.abs(d) > gcd.value() * 0.1) || (ee = (int)Math.floor(0.05 + Math.log10(Math.abs(d)))) >= smallestExp) continue;
            smallestExp = ee;
            ismallestExp = j;
        }
        Datum resolution = DataSetUtil.asDatum(gcd);
        Datum base = DataSetUtil.asDatum(datums.slice(ismallestExp));
        if (base.lt(units.createDatum(0.0))) {
            base = base.multiply(-1.0);
        }
        return DatumUtil.bestFormatter(base, base.add(resolution), 1);
    }

    public static String getStringValue(QDataSet yds, double value) {
        String s;
        block11: {
            Units u = SemanticOps.getUnits(yds);
            String form = (String)yds.property("FORMAT");
            double vmin = ((Number)DataSetUtil.getProperty(yds, "VALID_MIN", -1.7976931348623157E308)).doubleValue();
            double vmax = ((Number)DataSetUtil.getProperty(yds, "VALID_MAX", Double.MAX_VALUE)).doubleValue();
            double fill = ((Number)DataSetUtil.getProperty(yds, "FILL_VALUE", -1.0E31)).doubleValue();
            if (!(value >= vmin) || !(value <= vmax) || value == fill) {
                return "****";
            }
            Datum d = u.createDatum(value);
            DatumFormatter df = d.getFormatter();
            if (df instanceof DefaultDatumFormatter) {
                if (form == null || form.trim().length() == 0) {
                    if ("log".equals(yds.property("SCALE_TYPE"))) {
                        s = String.format(Locale.US, "%9.3e", value).trim();
                    } else {
                        QDataSet bounds = null;
                        if (yds.rank() > 0) {
                            bounds = SemanticOps.bounds(yds);
                        }
                        s = bounds != null && bounds.rank() == 2 ? (Math.abs(bounds.value(1, 0)) < 1.0E-4 || Math.abs(bounds.value(1, 1)) < 1.0E-4 ? String.format(Locale.US, "%9.3e", value).trim() : String.format(Locale.US, "%9.3f", value).trim()) : String.format(Locale.US, "%9.3f", value).trim();
                    }
                } else {
                    try {
                        s = String.format(Locale.US, form, value);
                    }
                    catch (IllegalFormatConversionException ex) {
                        char c = ex.getConversion();
                        if (c == 'X' || c == 'x' || c == 'd' || c == 'o' || c == 'c' || c == 'C') {
                            s = String.format(Locale.US, form, (long)value);
                            break block11;
                        }
                        s = df.format(d);
                    }
                }
            } else {
                s = df.format(d, u);
            }
        }
        return s;
    }

    public static String getStringValue(QDataSet ds) {
        if (ds.rank() == 0) {
            return DataSetUtil.getStringValue(ds, ds.value());
        }
        return DataSetUtil.format(ds);
    }

    public static MutablePropertyDataSet toBundleDs(QDataSet labels) {
        String label;
        if (labels.rank() != 1) {
            throw new IllegalArgumentException("labels must be rank 1");
        }
        IDataSet result = IDataSet.createRank2(labels.length(), 0);
        Units u = SemanticOps.getUnits(labels);
        for (int i = 0; i < labels.length(); ++i) {
            label = u.createDatum(labels.value(i)).toString();
            result.putProperty("NAME", i, Ops.safeName(label));
            result.putProperty("LABEL", i, label);
        }
        String name = (String)labels.property("NAME");
        if (name != null) {
            result.putProperty("NAME", name);
        }
        if ((label = (String)labels.property("LABEL")) != null) {
            result.putProperty("LABEL", label);
        }
        return result;
    }

    public static String[] bundleNames(QDataSet ds) {
        return SemanticOps.getComponentNames(ds);
    }

    public static void checkListOfIndeces(QDataSet ds, QDataSet indices) {
        Number len;
        Units u = (Units)indices.property("UNITS");
        if (u != null && !u.isConvertibleTo(Units.dimensionless)) {
            throw new IllegalArgumentException("indices must not contain units");
        }
        if (ds.rank() == 1 && (len = (Number)indices.property("VALID_MAX")) != null && len.intValue() != ds.length()) {
            logger.warning("indices appear to be from a dataset with different length");
        }
    }
}

