/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.DataSetWrapper;
import org.das2.qds.FlattenWaveformDataSet;
import org.das2.qds.GridDataSet;
import org.das2.qds.IDataSet;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.LeafTrimDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.OperationsProcessor;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.Slice1DataSet;
import org.das2.qds.Slice2DataSet;
import org.das2.qds.Slice3DataSet;
import org.das2.qds.SortDataSet;
import org.das2.qds.TransposeRank2DataSet;
import org.das2.qds.TrimDataSet;
import org.das2.qds.TrimStrideWrapper;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class DataSetOps {
    private static final Logger logger = LoggerManager.getLogger("qdataset.ops");
    public static final int DS_LENGTH_LIMIT = 10000000;

    public static MutablePropertyDataSet makePropertiesMutable(QDataSet dataset) {
        if (dataset instanceof MutablePropertyDataSet) {
            MutablePropertyDataSet mpds = (MutablePropertyDataSet)dataset;
            if (mpds.isImmutable()) {
                return new DataSetWrapper(dataset);
            }
            return (MutablePropertyDataSet)dataset;
        }
        return new DataSetWrapper(dataset);
    }

    public static WritableDataSet makeWritable(QDataSet dataset) {
        if (dataset instanceof WritableDataSet) {
            WritableDataSet wds = (WritableDataSet)dataset;
            if (wds.isImmutable()) {
                return ArrayDataSet.copy(dataset);
            }
            return (WritableDataSet)dataset;
        }
        return ArrayDataSet.copy(dataset);
    }

    public static MutablePropertyDataSet slice0(QDataSet ds, int index) {
        return new Slice0DataSet(ds, index, true);
    }

    public static MutablePropertyDataSet slice1(QDataSet ds, int index) {
        return new Slice1DataSet(ds, index, true, false);
    }

    public static MutablePropertyDataSet slice2(QDataSet ds, int index) {
        return new Slice2DataSet(ds, index, true);
    }

    public static MutablePropertyDataSet slice3(QDataSet ds, int index) {
        return new Slice3DataSet(ds, index, true);
    }

    public static MutablePropertyDataSet trim(QDataSet ds, int offset, int len) {
        return new TrimDataSet(ds, offset, offset + len);
    }

    public static MutablePropertyDataSet trim(QDataSet dep, int start, int stop, int stride) {
        String[] names;
        if (dep.rank() != 1) {
            throw new IllegalArgumentException("only rank 1 supported");
        }
        QubeDataSetIterator itIn = new QubeDataSetIterator(dep);
        itIn.setIndexIteratorFactory(0, new QubeDataSetIterator.StartStopStepIteratorFactory(start, stop, stride));
        DDataSet depSlice = itIn.createEmptyDs();
        QubeDataSetIterator itOut = new QubeDataSetIterator(depSlice);
        while (itIn.hasNext()) {
            itIn.next();
            itOut.next();
            itOut.putValue(depSlice, itIn.getValue(dep));
        }
        for (String name : names = DataSetUtil.dimensionProperties()) {
            if (dep.property(name) == null) continue;
            depSlice.putProperty(name, dep.property(name));
        }
        return depSlice;
    }

    public static QDataSet flattenRank2(QDataSet ds) {
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        QDataSet dep0offset = (QDataSet)ds.property("OFFSETS_1");
        if (dep0 == null) {
            dep0 = Ops.findgen(ds.length(0));
        }
        if (dep1 == null) {
            dep1 = Ops.findgen(ds.length(0));
        }
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        DataSetBuilder xbuilder = new DataSetBuilder(1, 100);
        DataSetBuilder ybuilder = new DataSetBuilder(1, 100);
        if (dep1.rank() == 2 && Schemes.isRank2Bins(dep1)) {
            dep1 = Ops.reduceBins(dep1);
        }
        boolean dep1rank2 = dep1 != null && dep1.rank() == 2;
        for (int i = 0; i < ds.length(); ++i) {
            for (int j = 0; j < ds.length(i); ++j) {
                if (dep0 != null) {
                    if (dep0offset != null) {
                        xbuilder.putValue(-1, Ops.add(dep0.slice(i), dep0offset.slice(j)));
                    } else {
                        xbuilder.putValue(-1, dep0.value(i));
                    }
                    xbuilder.nextRecord();
                }
                if (dep1 != null) {
                    ybuilder.putValue(-1, dep1rank2 ? dep1.value(i, j) : dep1.value(j));
                    ybuilder.nextRecord();
                }
                builder.putValue(-1, ds.value(i, j));
                builder.nextRecord();
            }
        }
        DDataSet zds = builder.getDataSet();
        DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(ds, null), zds);
        if (dep1 != null && dep0 != null) {
            DDataSet xds = xbuilder.getDataSet();
            DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(dep0, null), xds);
            DDataSet yds = ybuilder.getDataSet();
            DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(dep1, null), yds);
            return Ops.link(xds, yds, zds);
        }
        return zds;
    }

    public static QDataSet flattenRank3(QDataSet ds) {
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        QDataSet dep2 = (QDataSet)ds.property("DEPEND_2");
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        DataSetBuilder xbuilder = new DataSetBuilder(1, 100);
        DataSetBuilder ybuilder = new DataSetBuilder(1, 100);
        DataSetBuilder zbuilder = new DataSetBuilder(1, 100);
        boolean dep1rank2 = dep1 != null && dep1.rank() == 2;
        boolean dep2rank2 = dep2 != null && dep2.rank() == 2;
        for (int i = 0; i < ds.length(); ++i) {
            for (int j = 0; j < ds.length(i); ++j) {
                for (int k = 0; k < ds.length(i, j); ++k) {
                    if (dep0 != null) {
                        xbuilder.nextRecord(dep0.value(i));
                    }
                    if (dep1 != null) {
                        ybuilder.nextRecord(dep1rank2 ? dep1.value(i, j) : dep1.value(j));
                    }
                    if (dep2 != null) {
                        zbuilder.nextRecord(dep2rank2 ? dep2.value(i, k) : dep2.value(k));
                    }
                    builder.nextRecord(ds.value(i, j, k));
                }
            }
        }
        DDataSet fds = builder.getDataSet();
        DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(ds, null), fds);
        if (dep1 != null && dep0 != null) {
            DDataSet xds = xbuilder.getDataSet();
            DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(dep0, null), xds);
            DDataSet yds = ybuilder.getDataSet();
            DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(dep1, null), yds);
            DDataSet zds = zbuilder.getDataSet();
            DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(dep2, null), zds);
            return Ops.link(xds, yds, zds, fds);
        }
        return fds;
    }

    public static QDataSet flattenWaveform(QDataSet ds) {
        if (ds.rank() == 1) {
            throw new IllegalArgumentException("data is rank 1 and already flat.");
        }
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 == null) {
            throw new IllegalArgumentException("data does not have DEPEND_1, and is not a rank 2 waveform.");
        }
        if (dep1.rank() == 1) {
            return new FlattenWaveformDataSet(ds);
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet result = null;
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet ds1 = ds.slice(i);
            QDataSet xtags = (QDataSet)ds1.property("DEPEND_0");
            xtags = Ops.add(dep0.slice(i), xtags);
            result = Ops.append(result, Ops.link(xtags, ds1));
        }
        return result;
    }

    public static QDataSet grid(QDataSet ds) {
        GridDataSet result = new GridDataSet();
        result.add(ds);
        return result;
    }

    public static int[] removeElement(int[] array, int index) {
        int[] result = new int[array.length - 1];
        System.arraycopy(array, 0, result, 0, index);
        for (int i = index + 1; i < array.length; ++i) {
            result[i - 1] = array[i];
        }
        return result;
    }

    public static MutablePropertyDataSet leafTrim(QDataSet ds, int start, int end) {
        return new LeafTrimDataSet(ds, start, end);
    }

    public static QDataSet sort(final QDataSet ds) {
        logger.entering("org.das2.qds.DataSetOps", "sort", ds);
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("dataset must be rank 1");
        }
        Integer[] indeces = new Integer[ds.length()];
        int i0 = 0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        for (int i = 0; i < ds.length(); ++i) {
            if (!(wds.value(i) > 0.0)) continue;
            indeces[i0] = i;
            ++i0;
        }
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int i1 = o1;
                int i2 = o2;
                return Double.compare(ds.value(i1), ds.value(i2));
            }
        };
        Arrays.sort(indeces, 0, i0, c);
        int[] data = new int[i0];
        boolean monotonic = true;
        int lastData = 0;
        if (i0 > 0) {
            data[0] = indeces[0];
            lastData = data[0];
        }
        for (int i = 1; i < i0; ++i) {
            data[i] = indeces[i];
            if (monotonic && data[i] < lastData) {
                monotonic = false;
            }
            lastData = data[i];
        }
        IDataSet result = IDataSet.wrap(data);
        result.putProperty("NAME", "sort" + ds.length());
        if (monotonic) {
            result.putProperty("MONOTONIC", Boolean.TRUE);
        }
        logger.exiting("org.das2.qds.DataSetOps", "sort", ds);
        return result;
    }

    public static void applyIndexInSitu(WritableDataSet ds, QDataSet sort) {
        QDataSet m;
        QDataSet dep0;
        int j;
        int i;
        logger.entering("org.virbo.dataset", "applyIndexInSitu");
        if (ds.isImmutable()) {
            throw new IllegalArgumentException("ds is immutable: " + ds);
        }
        WritableDataSet ssort = Ops.copy(sort);
        if (ds.rank() == 1) {
            for (i = 0; i < ssort.length(); ++i) {
                j = (int)ssort.value(i);
                if (j == i) continue;
                double d = ds.value(i);
                ds.putValue(i, ds.value(j));
                ds.putValue(j, d);
                ssort.putValue(j, j);
            }
        } else if (ds.rank() == 2) {
            for (i = 0; i < ssort.length(); ++i) {
                j = (int)ssort.value(i);
                if (j == i) continue;
                for (int i2 = 0; i2 < ds.length(0); ++i2) {
                    double d = ds.value(i, i2);
                    ds.putValue(i, i2, ds.value(j, i2));
                    ds.putValue(j, i2, d);
                }
                ssort.putValue(j, j);
            }
        } else if (ds.rank() == 3) {
            for (i = 0; i < ssort.length(); ++i) {
                j = (int)ssort.value(i);
                if (j == i) continue;
                for (int i2 = 0; i2 < ds.length(0); ++i2) {
                    for (int i3 = 0; i3 < ds.length(0); ++i3) {
                        double d = ds.value(i, i2, i3);
                        ds.putValue(i, i2, i3, ds.value(j, i2, i3));
                        ds.putValue(j, i2, i3, d);
                    }
                }
                ssort.putValue(j, j);
            }
        } else if (ds.rank() == 4) {
            for (i = 0; i < ssort.length(); ++i) {
                j = (int)ssort.value(i);
                if (j == i) continue;
                for (int i2 = 0; i2 < ds.length(0); ++i2) {
                    for (int i3 = 0; i3 < ds.length(0); ++i3) {
                        for (int i4 = 0; i4 < ds.length(0); ++i4) {
                            double d = ds.value(i, i2, i3, i4);
                            ds.putValue(i, i2, i3, i4, ds.value(j, i2, i3, i4));
                            ds.putValue(j, i2, i3, i4, d);
                        }
                    }
                }
                ssort.putValue(j, j);
            }
        }
        if ((dep0 = (QDataSet)ds.property("DEPEND_0")) != null) {
            if (dep0 instanceof WritableDataSet) {
                DataSetOps.applyIndexInSitu((WritableDataSet)dep0, sort);
            } else {
                throw new IllegalArgumentException("dep0 should be mutable");
            }
        }
        if ((m = (QDataSet)ds.property("BIN_PLUS")) != null) {
            if (m instanceof WritableDataSet) {
                DataSetOps.applyIndexInSitu((WritableDataSet)m, sort);
            } else {
                throw new IllegalArgumentException("bin_plus should be mutable");
            }
        }
        if ((m = (QDataSet)ds.property("BIN_MINUS")) != null) {
            if (m instanceof WritableDataSet) {
                DataSetOps.applyIndexInSitu((WritableDataSet)m, sort);
            } else {
                throw new IllegalArgumentException("bin_plus should be mutable");
            }
        }
        if ((m = (QDataSet)ds.property("BINS_0")) != null) {
            if (m instanceof WritableDataSet) {
                DataSetOps.applyIndexInSitu((WritableDataSet)m, sort);
            } else {
                throw new IllegalArgumentException("bin_plus should be mutable");
            }
        }
        for (int i2 = 1; i2 < ds.rank(); ++i2) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i2);
            if (dep == null || dep.rank() != 2) continue;
            if (dep instanceof WritableDataSet) {
                DataSetOps.applyIndexInSitu((WritableDataSet)dep, sort);
                continue;
            }
            throw new IllegalArgumentException("dep0 should be mutable");
        }
        logger.exiting("org.virbo.dataset", "applyIndexInSitu");
    }

    public static Class getComponentType(QDataSet ds) {
        if (ds instanceof ArrayDataSet) {
            return ((ArrayDataSet)ds).getComponentType();
        }
        if (ds instanceof BufferDataSet) {
            return ((BufferDataSet)ds).getCompatibleComponentType();
        }
        if (ds instanceof IndexGenDataSet) {
            return Integer.TYPE;
        }
        if (ds instanceof JoinDataSet && ds.length() > 0) {
            return DataSetOps.getComponentType(ds.slice(0));
        }
        return Double.TYPE;
    }

    public static double suggestFillForComponentType(Class c) {
        if (c == Double.TYPE) {
            return -1.0E38;
        }
        if (c == Float.TYPE) {
            return -1.0E38;
        }
        if (c == Long.TYPE) {
            return -9.223372036854776E18;
        }
        if (c == Integer.TYPE) {
            return -2.147483648E9;
        }
        if (c == Short.TYPE) {
            return -32768.0;
        }
        if (c == Byte.TYPE) {
            return -128.0;
        }
        return -1.0E38;
    }

    public static QDataSet applyIndex(QDataSet ds, QDataSet indices) {
        return DataSetOps.applyIndex(ds, 0, indices, true);
    }

    public static WritableDataSet applyIndex(QDataSet ds, int idim, QDataSet sort, boolean deps) {
        ArrayDataSet cds;
        block16: {
            int[] qube;
            block15: {
                if (idim > 2) {
                    throw new IllegalArgumentException("idim must be <=2 ");
                }
                if (idim == 0) {
                    return ArrayDataSet.copy(DataSetOps.getComponentType(ds), new SortDataSet(ds, sort));
                }
                if (ds.rank() > 3) {
                    throw new IllegalArgumentException("rank limit");
                }
                qube = DataSetUtil.qubeDims(ds);
                if (qube == null) {
                    throw new IllegalArgumentException("dataset is not a qube and index is not on first dimension");
                }
                qube[idim] = sort.length();
                cds = ArrayDataSet.create(DataSetOps.getComponentType(ds), qube);
                Map<String, Object> props = DataSetUtil.getDimensionProperties(ds, null);
                DataSetUtil.putProperties(props, cds);
                if (deps) {
                    String bundleprop;
                    QDataSet bds;
                    String depprop = "DEPEND_" + idim;
                    QDataSet depds = (QDataSet)ds.property(depprop);
                    if (depds != null) {
                        depds = DataSetOps.applyIndex(depds, 0, sort, false);
                        cds.putProperty(depprop, depds);
                    }
                    if ((bds = (QDataSet)ds.property(bundleprop = "BUNDLE_" + idim)) != null) {
                        JoinDataSet jds = new JoinDataSet(2);
                        for (int i = 0; i < sort.length(); ++i) {
                            jds.join(bds.slice((int)sort.value(i)));
                        }
                        cds.putProperty(bundleprop, jds);
                    }
                }
                if (idim != 1) break block15;
                for (int i = 0; i < qube[0]; ++i) {
                    for (int j = 0; j < qube[1]; ++j) {
                        if (ds.rank() > 2) {
                            for (int k = 0; k < qube[2]; ++k) {
                                double d = ds.value(i, (int)sort.value(j), k);
                                cds.putValue(i, j, k, d);
                            }
                            continue;
                        }
                        double d = ds.value(i, (int)sort.value(j));
                        cds.putValue(i, j, d);
                    }
                }
                break block16;
            }
            if (idim != 2) break block16;
            for (int i = 0; i < qube[0]; ++i) {
                for (int j = 0; j < qube[1]; ++j) {
                    for (int k = 0; k < qube[2]; ++k) {
                        double d = ds.value(i, j, (int)sort.value(k));
                        cds.putValue(i, j, k, d);
                    }
                }
            }
        }
        return cds;
    }

    public static QDataSet histogram(QDataSet ds, double min, double max, double binsize) {
        if (min == -1.0 && max == -1.0) {
            QDataSet range = Ops.extent(ds);
            min = Math.floor(range.value(0) / binsize) * binsize;
            max = Math.ceil(range.value(1) / binsize) * binsize;
        }
        int n = (int)Math.ceil((max - min) / binsize);
        MutablePropertyDataSet tags = DataSetUtil.tagGenDataSet(n, min + binsize / 2.0, binsize, (Units)ds.property("UNITS"));
        tags.putProperty("NAME", ds.property("NAME"));
        tags.putProperty("LABEL", ds.property("LABEL"));
        tags.putProperty("TITLE", ds.property("TITLE"));
        tags.putProperty("TYPICAL_MAX", ds.property("TYPICAL_MAX"));
        tags.putProperty("TYPICAL_MIN", ds.property("TYPICAL_MIN"));
        int[] hits = new int[n];
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double positiveMin = Double.MAX_VALUE;
        int count = 0;
        while (count < 10000000 && iter.hasNext()) {
            iter.next();
            double d = iter.getValue(ds);
            double w = iter.getValue(wds);
            if (!(w > 0.0)) continue;
            int ibin = (int)Math.floor((d - min) / binsize);
            if (ibin >= 0 && ibin < n) {
                int n2 = ibin;
                hits[n2] = hits[n2] + 1;
            }
            if (d > 0.0 && d < positiveMin) {
                positiveMin = d;
            }
            ++count;
        }
        IDataSet result = IDataSet.wrap(hits);
        result.putProperty("DEPEND_0", tags);
        result.putProperty("count", count);
        result.putProperty("positiveMin", positiveMin);
        result.putProperty("RENDER_TYPE", "stairSteps");
        return result;
    }

    public static RankZeroDataSet moment(QDataSet ds) {
        double[] moment = new double[2];
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        int validCount = 0;
        int invalidCount = 0;
        double approxMean = 0.0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            double d = iter.getValue(ds);
            double w = iter.getValue(wds);
            if (w == 0.0) {
                ++invalidCount;
                continue;
            }
            ++validCount;
            approxMean += d;
        }
        if (validCount > 0) {
            approxMean /= (double)validCount;
        }
        double mean = 0.0;
        double stddev = 0.0;
        if (validCount > 0) {
            iter = new QubeDataSetIterator(ds);
            while (iter.hasNext()) {
                iter.next();
                double d = iter.getValue(ds);
                double w = iter.getValue(wds);
                if (!(w > 0.0)) continue;
                mean += d - approxMean;
                stddev += Math.pow(d - approxMean, 2.0);
            }
            mean /= (double)validCount;
            moment[0] = mean += approxMean;
            if (validCount > 1) {
                stddev /= (double)(validCount - 1);
                moment[1] = stddev = Math.sqrt(stddev);
            } else {
                moment[1] = u.getFillDouble();
            }
        } else {
            moment[0] = u.getFillDouble();
        }
        DRank0DataSet result = DataSetUtil.asDataSet(moment[0]);
        result.putProperty("UNITS", u);
        DRank0DataSet stddevds = DataSetUtil.asDataSet(moment[1]);
        stddevds.putProperty("UNITS", u.getOffsetUnits());
        result.putProperty("stddev", stddevds);
        result.putProperty("validCount", validCount);
        result.putProperty("invalidCount", invalidCount);
        return result;
    }

    public static QDataSet transpose2(QDataSet ds) {
        return new TransposeRank2DataSet(ds);
    }

    public static Map<String, Object> sliceProperties0(int index, Map<String, Object> props) {
        String[] stringArray;
        String[] p;
        String string;
        Object o;
        QDataSet bundle0;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        QDataSet dep0 = (QDataSet)props.get("DEPEND_0");
        QDataSet dep1 = (QDataSet)props.get("DEPEND_1");
        QDataSet dep2 = (QDataSet)props.get("DEPEND_2");
        QDataSet dep3 = (QDataSet)props.get("DEPEND_3");
        String bins1 = (String)props.get("BINS_1");
        Object sbundle = props.get("BUNDLE_1");
        QDataSet bundle1 = sbundle instanceof QDataSet ? (QDataSet)sbundle : null;
        sbundle = props.get("BUNDLE_0");
        QDataSet qDataSet = bundle0 = sbundle instanceof QDataSet ? (QDataSet)sbundle : null;
        if (dep0 != null && dep1 != null && dep0.rank() > 1 && dep1.rank() > 1) {
            throw new IllegalArgumentException("both DEPEND_0 and DEPEND_1 have rank>1");
        }
        for (int i = 0; i < 50 && (o = props.get(string = "PLANE_" + i)) != null && o instanceof QDataSet; ++i) {
            QDataSet plane = (QDataSet)o;
            if (plane.rank() < 1) {
                result.put(string, plane);
                continue;
            }
            result.put(string, plane.slice(index));
        }
        for (String p1 : p = DataSetUtil.correlativeProperties()) {
            Object o2 = props.get(p1);
            if (o2 == null) continue;
            if (o2 instanceof QDataSet) {
                QDataSet d = (QDataSet)o2;
                if (d.rank() <= 0) continue;
                result.put(p1, d.slice(index));
                continue;
            }
            logger.log(Level.INFO, "property is not a QDataSet: {0}", p1);
        }
        for (String s : stringArray = DataSetUtil.dimensionProperties()) {
            Object o3 = props.get(s);
            if (o3 == null) continue;
            result.put(s, o3);
        }
        if (props.containsKey("CONTEXT_0")) {
            for (int i = 0; i < 4; ++i) {
                QDataSet con = (QDataSet)props.get("CONTEXT_" + i);
                if (con == null) continue;
                result.put("CONTEXT_" + i, con);
            }
        }
        if (dep1 != null) {
            if (dep1.rank() == 2 && !Schemes.isRank2Bins(dep1)) {
                result.put("DEPEND_0", dep1.slice(index));
            } else {
                result.put("DEPEND_0", dep1);
            }
        }
        if (dep0 != null && dep0.rank() == 1) {
            DataSetUtil.addContext(result, dep0.slice(index));
        } else if (dep1 == null && props.get("DEPEND_0__" + index) == null) {
            result.put("DEPEND_0", null);
        }
        for (Map.Entry<String, Object> sse : props.entrySet()) {
            int islice;
            int iii;
            String ss = sse.getKey();
            int ii = ss.indexOf("__");
            if (ii <= -1) continue;
            String hd = ss.substring(ii + 2);
            for (iii = 0; iii < hd.length() && Character.isDigit(hd.charAt(iii)); ++iii) {
            }
            if (iii <= 0 || (islice = Integer.parseInt(hd.substring(0, iii))) != index) continue;
            String slicePropName = iii < hd.length() ? ss.substring(0, ii) + "__" + hd.substring(iii + 1) : ss.substring(0, ii);
            result.put(slicePropName, sse.getValue());
        }
        if (dep2 != null) {
            if (dep2.rank() == 2) {
                result.put("DEPEND_1", dep2.slice(index));
            } else {
                result.put("DEPEND_1", dep2);
            }
        }
        if (dep3 != null) {
            if (dep3.rank() == 2) {
                result.put("DEPEND_2", dep3.slice(index));
            } else {
                result.put("DEPEND_2", dep3);
            }
        }
        if (bins1 != null) {
            result.put("BINS_0", bins1);
        }
        if (bundle1 != null) {
            result.put("BUNDLE_0", bundle1);
        }
        if (bundle0 != null) {
            QDataSet bundle0ds = bundle0.slice(index);
            result.putAll(DataSetUtil.getProperties(bundle0ds));
        }
        return result;
    }

    public static Map<String, Object> sliceProperties(Map<String, Object> properties, int sliceDimension) {
        int i;
        String[] ss;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String s : ss = DataSetUtil.dimensionProperties()) {
            Object val = properties.get(s);
            if (val == null) continue;
            result.put(s, val);
        }
        if (sliceDimension >= 8) {
            throw new IllegalArgumentException("sliceDimension > MAX_HIGH_RANK");
        }
        ArrayList<Object> deps = new ArrayList<Object>(8);
        ArrayList<Object> bund = new ArrayList<Object>(8);
        ArrayList<Object> bins = new ArrayList<Object>(8);
        for (i = 0; i < 4; ++i) {
            deps.add(i, properties.get("DEPEND_" + i));
            bund.add(i, properties.get("BUNDLE_" + i));
            bins.add(i, properties.get("BINS_" + i));
        }
        if (sliceDimension < 4) {
            deps.remove(sliceDimension);
            bund.remove(sliceDimension);
            bins.remove(sliceDimension);
        }
        for (i = 0; i < 3; ++i) {
            if (deps.get(i) != null) {
                result.put("DEPEND_" + i, deps.get(i));
            }
            if (bund.get(i) != null) {
                result.put("BUNDLE_" + i, bund.get(i));
            }
            if (bins.get(i) == null) continue;
            result.put("BINS_" + i, bins.get(i));
        }
        if (properties.containsKey("CONTEXT_0")) {
            for (i = 0; i < 4; ++i) {
                QDataSet con = (QDataSet)properties.get("CONTEXT_" + i);
                if (con == null) continue;
                result.put("CONTEXT_" + i, con);
            }
        }
        return result;
    }

    public static QDataSet flattenBundleDescriptor(QDataSet bundle1) {
        int nr1 = 0;
        final ArrayList<String> names = new ArrayList<String>();
        final ArrayList<Units> units = new ArrayList<Units>();
        for (int j = 0; j < bundle1.length(); ++j) {
            int rank = bundle1.length(j);
            int n = 1;
            for (int k = 1; k < rank; ++k) {
                n = (int)((double)n * bundle1.value(j, k - 1));
            }
            nr1 += n;
            String name = (String)bundle1.property("NAME", j);
            Units unit = (Units)bundle1.property("UNITS", j);
            String bins = (String)bundle1.property("BINS_1", j);
            for (int i = 0; i < n; ++i) {
                String theName;
                String binName = null;
                if (bins != null) {
                    String[] ss = bins.split(",", -2);
                    binName = ss[i];
                }
                if ((theName = name) != null && binName != null) {
                    theName = theName + "_" + binName;
                }
                if (theName != null) {
                    names.add(theName);
                } else {
                    names.add("");
                }
                if (unit != null) {
                    units.add(unit);
                    continue;
                }
                units.add(Units.dimensionless);
            }
        }
        final int fnr1 = nr1;
        AbstractDataSet bundleDescriptor = new AbstractDataSet(){

            @Override
            public int rank() {
                return 2;
            }

            @Override
            public int length() {
                return fnr1;
            }

            @Override
            public int length(int i) {
                return 0;
            }

            @Override
            public Object property(String name, int i) {
                if (i > names.size()) {
                    throw new IllegalArgumentException("index too large:" + i);
                }
                if (name.equals("NAME")) {
                    return names.get(i);
                }
                if (name.equals("UNITS")) {
                    return units.get(i);
                }
                return null;
            }
        };
        return bundleDescriptor;
    }

    private static String[] backupBundleNames(int len) {
        String[] result = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            result[i2] = "ch_" + i2;
        }
        return result;
    }

    public static String[] bundleNames(QDataSet bundleDs) {
        List<Object> result = new ArrayList(bundleDs.length(0));
        QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_1");
        if (bundle1 == null) {
            bundle1 = (QDataSet)bundleDs.property("DEPEND_1");
            if (bundle1 != null && bundle1.rank() > 1) {
                if (bundle1.rank() != 2) {
                    throw new IllegalArgumentException("high rank DEPEND_1 found where rank 1 was expected");
                }
                result = Arrays.asList(DataSetOps.backupBundleNames(bundle1.length(0)));
            } else if (bundle1 != null) {
                Units u = SemanticOps.getUnits(bundle1);
                for (int i2 = 0; i2 < bundle1.length(); ++i2) {
                    result.add(Ops.saferName(u.createDatum(bundle1.value(i2)).toString()));
                }
            } else {
                result = Arrays.asList(DataSetOps.backupBundleNames(bundleDs.length(0)));
            }
        } else {
            for (int j = 0; j < bundle1.length(); ++j) {
                String n1 = (String)bundle1.property("NAME", j);
                if (n1 != null) {
                    n1 = Ops.saferName(n1);
                    result.add(n1);
                    continue;
                }
                n1 = (String)bundle1.property("LABEL", j);
                if (n1 != null) {
                    n1 = Ops.saferName(n1);
                    result.add(n1);
                    continue;
                }
                n1 = (String)bundle1.property("ELEMENT_LABEL", j);
                if (n1 != null) {
                    n1 = Ops.saferName(n1);
                    result.add(n1);
                    continue;
                }
                result.add("ch_" + j);
            }
        }
        return result.toArray(new String[0]);
    }

    public static int indexOfBundledDataSet(QDataSet bundleDs, String name) {
        String n1;
        int j;
        int rank = bundleDs.rank();
        QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_" + (rank - 1));
        int ib = -1;
        int i = name.indexOf("[");
        if (i > 0) {
            name = name.substring(i);
            name = Ops.saferName(name);
        } else {
            name = Ops.saferName(name);
        }
        if (name.matches("ch_\\d+")) {
            int ich = Integer.parseInt(name.substring(3));
            return ich;
        }
        if (bundle1 == null) {
            bundle1 = (QDataSet)bundleDs.property("DEPEND_" + (rank - 1));
            if (bundle1 != null && bundle1.rank() > 1) {
                throw new IllegalArgumentException("high rank DEPEND_1 found where rank 1 was expected");
            }
            if (bundle1 != null) {
                Units u = SemanticOps.getUnits(bundle1);
                for (int i2 = 0; i2 < bundle1.length(); ++i2) {
                    if (!name.equals(Ops.saferName(u.createDatum(bundle1.value(i2)).toString()))) continue;
                    return i2;
                }
                throw new IllegalArgumentException("unable to find dataset with name \"" + name + "\" in bundle " + bundleDs);
            }
            throw new IllegalArgumentException("expected to find BUNDLE_1 or DEPEND_1 with ordinal units.");
        }
        boolean highRank = false;
        for (j = 0; j < bundle1.length(); ++j) {
            n1 = (String)bundle1.property("NAME", j);
            if (n1 != null) {
                n1 = Ops.saferName(n1);
            }
            if (n1 != null && n1.equals(name)) {
                ib = j;
            }
            int[] dims = (int[])bundle1.property("ELEMENT_DIMENSIONS", j);
            if (bundle1.length(j) <= 0 && (dims == null || dims.length <= 0)) continue;
            n1 = (String)bundle1.property("ELEMENT_NAME", j);
            if (n1 != null) {
                n1 = Ops.saferName(n1);
            }
            if (n1 == null || !n1.equals(name)) continue;
            ib = j;
            highRank = true;
            break;
        }
        for (j = 0; j < bundle1.length(); ++j) {
            n1 = (String)bundle1.property("LABEL", j);
            if (n1 != null) {
                n1 = Ops.saferName(n1);
            }
            if (n1 != null && n1.equals(name)) {
                ib = j;
            }
            if (bundle1.length(j) <= 0) continue;
            n1 = (String)bundle1.property("ELEMENT_LABEL", j);
            if (n1 != null) {
                n1 = Ops.saferName(n1);
            }
            if (n1 == null || !n1.equals(name)) continue;
            ib = j;
            highRank = true;
            break;
        }
        if (ib == -1) {
            name = name.replaceAll("_| ", "");
            for (j = 0; j < bundle1.length(); ++j) {
                n1 = (String)bundle1.property("NAME", j);
                if (n1 != null) {
                    n1 = Ops.saferName(n1);
                }
                if (n1 != null) {
                    n1 = n1.replaceAll("_| ", "");
                }
                if (n1 != null && n1.equals(name)) {
                    ib = j;
                }
                if (bundle1.length(j) <= 0) continue;
                n1 = (String)bundle1.property("ELEMENT_NAME", j);
                if (n1 != null) {
                    n1 = Ops.saferName(n1);
                }
                if (n1 == null || !n1.equals(name)) continue;
                ib = j;
                highRank = true;
                break;
            }
        }
        if (highRank) {
            logger.log(Level.FINER, "index of bundled dataset \"{0}\" is {1} (highrank={2})", new Object[]{name, ib, highRank});
        }
        return ib;
    }

    public static QDataSet unbundle(QDataSet bundleDs, String name) {
        QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_1");
        int ib = DataSetOps.indexOfBundledDataSet(bundleDs, name);
        boolean highRank = false;
        int[] dims = null;
        if (ib > -1 && bundle1 != null) {
            dims = (int[])bundle1.property("ELEMENT_DIMENSIONS", ib);
        }
        if (bundle1 != null && (bundle1.length(ib) > 0 || dims != null && dims.length > 0)) {
            String n1 = (String)bundle1.property("ELEMENT_NAME", ib);
            if (n1 != null) {
                n1 = Ops.saferName(n1);
            }
            if (n1 != null && n1.equals(name)) {
                highRank = true;
            }
            if (!highRank) {
                n1 = (String)bundle1.property("ELEMENT_LABEL", ib);
                if (n1 != null) {
                    n1 = Ops.saferName(n1);
                }
                if (n1 != null && n1.equals(name)) {
                    highRank = true;
                }
            }
        }
        if (ib == -1) {
            if (name.matches("ch_\\d+")) {
                int ich = Integer.parseInt(name.substring(3));
                return DataSetOps.unbundle(bundleDs, ich, false);
            }
            throw new IllegalArgumentException("unable to find dataset with name \"" + name + "\" in bundle " + bundleDs);
        }
        return DataSetOps.unbundle(bundleDs, ib, highRank);
    }

    public static QDataSet unbundleDefaultDataSet(QDataSet bundleDs) {
        QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_1");
        if (bundle1 == null && (bundle1 = (QDataSet)bundleDs.property("DEPEND_1")) != null && bundle1.rank() > 1) {
            throw new IllegalArgumentException("high rank DEPEND_1 found where rank 1 was expected");
        }
        int ids = -1;
        if (bundle1 != null) {
            for (int i = 0; i < bundle1.length(); ++i) {
                if (bundle1.property("DEPEND_0", i) != null) {
                    ids = i;
                }
                if (bundle1.property("CONTEXT_0", i) == null) continue;
                ids = i;
            }
            if (ids == -1) {
                ids = bundle1.length() - 1;
            }
        } else {
            ids = bundleDs.length(0) - 1;
        }
        return DataSetOps.unbundle(bundleDs, ids);
    }

    public static QDataSet unbundle(QDataSet bundleDs, int ib) {
        return DataSetOps.unbundle(bundleDs, ib, false);
    }

    public static QDataSet unbundle(QDataSet bundleDs, int ib, boolean highRank) {
        QDataSet bundle = null;
        if (bundleDs.rank() >= 2) {
            QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_1");
            if (bundle1 == null) {
                bundle1 = (QDataSet)bundleDs.property("DEPEND_1");
                if (bundle1 == null) {
                    if (bundleDs.rank() == 2) {
                        return new Slice1DataSet(bundleDs, ib);
                    }
                    if (bundleDs.rank() == 3) {
                        return new Slice2DataSet(bundleDs, ib);
                    }
                    throw new IllegalArgumentException("rank must be 2 or 3");
                }
                if (bundle1.rank() == 2) {
                    return new Slice1DataSet(bundleDs, ib);
                }
                if (bundle1.rank() > 1) {
                    throw new IllegalArgumentException("high rank DEPEND_1 found where rank 1 was expected");
                }
            }
            bundle = bundle1;
        } else if (bundleDs.rank() == 1) {
            QDataSet bundle0 = (QDataSet)bundleDs.property("BUNDLE_0");
            if (bundle0 == null) {
                bundle0 = (QDataSet)bundleDs.property("DEPEND_0");
                if (bundle0 == null) {
                    return new Slice0DataSet(bundleDs, ib);
                }
                if (bundle0.rank() > 1) {
                    throw new IllegalArgumentException("high rank DEPEND_0 found where rank 1 was expected");
                }
                Units u = SemanticOps.getUnits(bundle0);
                if (!(u instanceof EnumerationUnits)) {
                    throw new IllegalArgumentException("dataset is not a bundle, and units of DEPEND_0 are not enumeration");
                }
            }
            bundle = bundle0;
        } else {
            throw new IllegalArgumentException("bundle must be rank 1 or rank 2");
        }
        if (ib < 0 || ib >= bundle.length()) {
            throw new IndexOutOfBoundsException("in " + bundleDs + " no such data set at index=" + ib + " bundle.length()=" + bundle.length());
        }
        if (bundle.rank() == 1) {
            MutablePropertyDataSet result = bundleDs.rank() == 2 ? DataSetOps.slice1(bundleDs, ib) : DataSetOps.slice0(bundleDs, ib);
            Units enumunits = (Units)bundle.property("UNITS");
            if (enumunits == null) {
                enumunits = Units.dimensionless;
            }
            String label = String.valueOf(enumunits.createDatum(bundle.value(ib)));
            result.putProperty("NAME", Ops.safeName(label));
            result.putProperty("LABEL", label);
            return result;
        }
        if (bundle.rank() != 2) {
            throw new IllegalArgumentException("rank limit: >2 not supported");
        }
        int len = 1;
        int j = ib;
        int is = ib;
        int[] dimensions = (int[])bundle.property("ELEMENT_DIMENSIONS", ib);
        if (dimensions == null && bundle.length(j) > 0) {
            dimensions = new int[bundle.length(j)];
            for (int ii = 0; ii < bundle.length(j); ++ii) {
                dimensions[ii] = (int)bundle.value(j, ii);
            }
        }
        if (dimensions != null && dimensions.length == 0) {
            dimensions = null;
        }
        if (highRank) {
            Integer s = (Integer)bundle.property("START_INDEX", ib);
            if (s == null) {
                s = ib;
            }
            if (dimensions != null) {
                is = s;
                int n = 1;
                for (int k = 0; k < dimensions.length; ++k) {
                    n *= dimensions[k];
                }
                len = n;
                j = ib;
            }
        }
        if (dimensions == null || !highRank) {
            Units u;
            String[] names1;
            if (bundleDs instanceof BundleDataSet) {
                QDataSet r = ((BundleDataSet)bundleDs).unbundle(j);
                QDataSet dep0 = (QDataSet)bundleDs.property("DEPEND_0");
                String dependName = (String)r.property("DEPENDNAME_0");
                if (dependName != null) {
                    dep0 = DataSetOps.unbundle(bundleDs, dependName);
                }
                if (dep0 != null && r.property("DEPEND_0") == null) {
                    DataSetWrapper rc = new DataSetWrapper(r);
                    rc.putProperty("DEPEND_0", dep0);
                    return rc;
                }
                if (r.property("BUNDLE_1") != null) {
                    logger.warning("unbundled dataset still has BUNDLE_1");
                }
                return r;
            }
            MutablePropertyDataSet result = null;
            if (bundleDs.rank() == 1) {
                result = DataSetOps.makePropertiesMutable(bundleDs.slice(j));
            } else if (bundleDs.rank() >= 2) {
                result = new Slice1DataSet(bundleDs, j, true);
            } else {
                throw new IllegalArgumentException("BundleDs must be rank 1 or rank 2");
            }
            for (String names11 : names1 = DataSetUtil.dimensionProperties()) {
                Object v = bundle.property(names11, j);
                if (v == null) continue;
                result.putProperty(names11, v);
            }
            Map<String, Object> props3 = DataSetUtil.getProperties(bundle, DataSetUtil.globalProperties(), null);
            for (Map.Entry<String, Object> ss1 : props3.entrySet()) {
                String ss = ss1.getKey();
                Object vv = result.property(ss);
                if (vv != null) continue;
                result.putProperty(ss, ss1.getValue());
            }
            if (result.property("DEPEND_0") == null && ib > 0 && (u = (Units)bundle.property("UNITS", 0)) != null && UnitsUtil.isTimeLocation(u)) {
                result.putProperty("DEPEND_0", DataSetOps.unbundle(bundleDs, 0, false));
            }
            return result;
        }
        if (dimensions.length == 1 || dimensions.length == 2) {
            Units u;
            int last;
            int first;
            if (bundleDs.rank() == 1) {
                return bundleDs.trim(is, is + len);
            }
            TrimStrideWrapper result = new TrimStrideWrapper(bundleDs);
            result.setTrim(1, is, is + len, 1);
            Integer ifirst = (Integer)bundle.property("START_INDEX", j);
            if (ifirst != null) {
                first = ifirst;
                last = first + len - 1;
            } else {
                first = j;
                last = j;
            }
            Map<String, Object> props = DataSetUtil.getProperties(DataSetOps.slice0(bundle, first));
            Map<String, Object> props2 = DataSetUtil.getProperties(DataSetOps.slice0(bundle, last));
            for (Map.Entry<String, Object> e : props2.entrySet()) {
                String string = e.getKey();
                Object vv = props.get(string);
                if (vv == null || vv.equals(e.getValue())) continue;
                props.put(string, null);
            }
            if (last != first) {
                QDataSet bundleTrim = bundle.trim(first, last + 1);
                MutablePropertyDataSet mds = DataSetOps.makePropertiesMutable(bundleTrim);
                Ops.copyIndexedProperties(bundleTrim, mds);
                props.put("BUNDLE_1", mds);
            }
            if (bundleDs.rank() > 1) {
                if (bundle.property("DEPEND_1", first) != null && bundle.property("DEPEND_1", first) == bundle.property("DEPEND_1", last)) {
                    props.put("DEPEND_1", bundle.property("DEPEND_1", first));
                }
                if (bundle.property("BINS_1", first) != null && bundle.property("BINS_1", first).equals(bundle.property("BINS_1", last))) {
                    props.put("BINS_1", bundle.property("BINS_1", first));
                    props.remove("BUNDLE_1");
                }
                if (bundle.property("BUNDLE_1", first) != null && bundle.property("BUNDLE_1", first) == bundle.property("BUNDLE_1", last)) {
                    props.put("BUNDLE_1", bundle.property("BUNDLE_1", first));
                }
            }
            Map<String, Object> props3 = DataSetUtil.getProperties(bundle, DataSetUtil.globalProperties(), null);
            for (Map.Entry entry : props3.entrySet()) {
                String ss = (String)entry.getKey();
                Object vv = props.get(ss);
                if (vv != null) continue;
                props.put(ss, entry.getValue());
            }
            Object o = bundle.property("ELEMENT_NAME", j);
            if (o != null) {
                props.put("NAME", o);
            }
            if ((o = bundle.property("ELEMENT_LABEL", j)) != null) {
                props.put("LABEL", o);
            }
            DataSetUtil.putProperties(props, result);
            String[] stringArray = DataSetUtil.correlativeProperties();
            for (int i = -1; i < stringArray.length; ++i) {
                String prop = i == -1 ? "DEPEND_0" : stringArray[i];
                Object dep0 = result.property(prop);
                if (dep0 == null || !(dep0 instanceof String)) continue;
                try {
                    QDataSet dep0ds = DataSetOps.unbundle(bundleDs, (String)dep0);
                    result.putProperty(prop, dep0ds);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("unable to find DEPEND_0 reference to \"" + dep0 + "\"");
                }
            }
            if (result.property("DEPEND_0") == null && ib > 0 && (u = (Units)bundle.property("UNITS", 0)) != null && UnitsUtil.isTimeLocation(u)) {
                result.putProperty("DEPEND_0", DataSetOps.unbundle(bundleDs, 0, false));
            }
            if (dimensions.length == 2) {
                int[] qube = new int[]{result.length(), dimensions[0], dimensions[1]};
                return Ops.reform(result, qube);
            }
            return result;
        }
        throw new IllegalArgumentException("rank limit: >2 not supported");
    }

    protected static QDataSet getContextForUnbundle(QDataSet bundle1, int index) {
        String tname = (String)bundle1.property("NAME");
        if (tname == null) {
            tname = (String)bundle1.property("NAME", index);
        }
        String tlabel = (String)bundle1.property("LABEL", index);
        tname = String.valueOf(tname);
        tlabel = String.valueOf(tlabel);
        MutablePropertyDataSet context = (MutablePropertyDataSet)Ops.labelsDataset(new String[]{tlabel}).slice(0);
        if (!Ops.safeName(tlabel).equals(tname)) {
            if (context.isImmutable()) {
                logger.warning("action not taken because dataset is immutable.  This needs review.");
            } else {
                context.putProperty("NAME", tname);
            }
        }
        return context;
    }

    public static QDataSet getNthPercentileSort(QDataSet ds, double n) {
        if (n < 0.0) {
            throw new IllegalArgumentException("n<0");
        }
        if (n > 100.0) {
            throw new IllegalArgumentException("n>=100");
        }
        QDataSet sort = Ops.sort(ds);
        if (sort.length() == 0) {
            return DataSetUtil.asDataSet(Units.dimensionless.getFillDatum());
        }
        int idx = n == 100.0 ? (int)sort.value(sort.length() - 1) : (int)sort.value((int)((double)sort.length() * n / 100.0));
        return ds.slice(idx);
    }

    public static QDataSet getBackgroundLevel(QDataSet ds, double level) {
        if (ds.rank() == 1) {
            return DataSetOps.getNthPercentileSort(ds, level);
        }
        if (ds.rank() == 2) {
            DDataSet result = DDataSet.createRank1(ds.length(0));
            result.putProperty("DEPEND_0", ds.property("DEPEND_1"));
            for (int jj = 0; jj < ds.length(0); ++jj) {
                QDataSet b1 = DataSetOps.getNthPercentileSort(DataSetOps.slice1(ds, jj), level);
                result.putValue(jj, b1.value());
            }
            result.putProperty("FILL_VALUE", Units.dimensionless.getFillDouble());
            return result;
        }
        if (ds.rank() > 2) {
            JoinDataSet result = new JoinDataSet(ds.rank() - 1);
            for (int i = 0; i < ds.length(); ++i) {
                QDataSet ds1 = ds.slice(i);
                QDataSet r1 = DataSetOps.getBackgroundLevel(ds1, level);
                result.join(r1);
            }
            return result;
        }
        throw new IllegalArgumentException("rank 0 dataset");
    }

    public static QDataSet dbAboveBackgroundDim1(QDataSet ds, double level) {
        return DataSetOps.dbAboveBackgroundDim1(ds, level, false);
    }

    public static QDataSet dbAboveBackgroundDim1(QDataSet ds, double level, boolean power) {
        MutablePropertyDataSet result;
        double fill = -1.0E31;
        boolean hasFill = false;
        double mult = power ? 10.0 : 20.0;
        switch (ds.rank()) {
            case 1: {
                QDataSet back = DataSetOps.getBackgroundLevel(ds, level);
                result = Ops.copy(ds);
                boolean db = ds.property("UNITS") == Units.dB;
                MutablePropertyDataSet wds = result;
                QDataSet validDs = Ops.valid(back);
                QDataSet vds2 = DataSetUtil.weightsDataSet(ds);
                if (validDs.value() > 0.0) {
                    for (int ii = 0; ii < ds.length(); ++ii) {
                        if (vds2.value(ii) > 0.0) {
                            double v = db ? ds.value(ii) - back.value() : mult * Math.log10(ds.value(ii) / back.value());
                            wds.putValue(ii, Math.max(0.0, v));
                            continue;
                        }
                        wds.putValue(ii, fill);
                    }
                } else {
                    for (int ii = 0; ii < ds.length(); ++ii) {
                        wds.putValue(ii, fill);
                    }
                    hasFill = true;
                }
                result.putProperty("USER_PROPERTIES", Collections.singletonMap("background", back));
                break;
            }
            case 2: {
                QDataSet back = DataSetOps.getBackgroundLevel(ds, level);
                result = Ops.copy(ds);
                boolean db = ds.property("UNITS") == Units.dB;
                MutablePropertyDataSet wds = result;
                WritableDataSet validDs = Ops.copy(Ops.valid(back));
                QDataSet vds2 = DataSetUtil.weightsDataSet(ds);
                for (int jj = 0; jj < ds.length(0); ++jj) {
                    for (int ii = 0; ii < ds.length(); ++ii) {
                        if (validDs.value(jj) > 0.0 && vds2.value(ii, jj) > 0.0) {
                            double v = db ? ds.value(ii, jj) - back.value(jj) : mult * Math.log10(ds.value(ii, jj) / back.value(jj));
                            wds.putValue(ii, jj, Math.max(0.0, v));
                            continue;
                        }
                        wds.putValue(ii, jj, fill);
                        hasFill = true;
                    }
                }
                result.putProperty("USER_PROPERTIES", Collections.singletonMap("background", back));
                break;
            }
            default: {
                JoinDataSet result1 = new JoinDataSet(ds.rank());
                for (int i = 0; i < ds.length(); ++i) {
                    QDataSet ds1 = ds.slice(i);
                    QDataSet r1 = DataSetOps.dbAboveBackgroundDim1(ds1, level, power);
                    result1.join(r1);
                    if (r1.property("FILL_VALUE") == null) continue;
                    hasFill = true;
                }
                result = result1;
            }
        }
        result.putProperty("UNITS", Units.dB);
        result.putProperty("TYPICAL_MIN", 0);
        result.putProperty("TYPICAL_MAX", 120);
        result.putProperty("SCALE_TYPE", "linear");
        result.putProperty("VALID_MIN", null);
        result.putProperty("VALID_MAX", null);
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        return result;
    }

    public static QDataSet dbAboveBackgroundDim0(QDataSet ds, double level) {
        MutablePropertyDataSet result;
        double fill = -1.0E31;
        boolean hasFill = false;
        switch (ds.rank()) {
            case 1: {
                QDataSet back = DataSetOps.getBackgroundLevel(ds, level);
                result = Ops.copy(ds);
                boolean db = ds.property("UNITS") == Units.dB;
                QDataSet validDs = Ops.valid(back);
                QDataSet vds2 = DataSetUtil.weightsDataSet(ds);
                WritableDataSet wds = (WritableDataSet)result;
                if (validDs.value() > 0.0) {
                    for (int ii = 0; ii < ds.length(); ++ii) {
                        if (vds2.value(ii) > 0.0) {
                            double v = db ? wds.value(ii) - back.value() : 20.0 * Math.log10(wds.value(ii) / back.value());
                            wds.putValue(ii, Math.max(0.0, v));
                            continue;
                        }
                        wds.putValue(ii, fill);
                    }
                } else {
                    for (int ii = 0; ii < ds.length(); ++ii) {
                        wds.putValue(ii, fill);
                    }
                    hasFill = true;
                }
                result.putProperty("USER_PROPERTIES", Collections.singletonMap("background", back));
                break;
            }
            case 2: {
                boolean db = ds.property("UNITS") == Units.dB;
                JoinDataSet result1 = new JoinDataSet(ds.rank());
                for (int ii = 0; ii < ds.length(); ++ii) {
                    int jj;
                    QDataSet ds1 = ds.slice(ii);
                    QDataSet back = DataSetOps.getBackgroundLevel(ds1, level);
                    QDataSet validDs = Ops.valid(back);
                    QDataSet vds2 = DataSetUtil.weightsDataSet(ds1);
                    ds1 = Ops.copy(ds1);
                    WritableDataSet wds = (WritableDataSet)ds1;
                    if (validDs.value() > 0.0) {
                        for (jj = 0; jj < ds1.length(); ++jj) {
                            if (vds2.value(jj) > 0.0) {
                                double v = db ? wds.value(jj) - back.value() : 20.0 * Math.log10(wds.value(jj) / back.value());
                                wds.putValue(jj, Math.max(0.0, v));
                                continue;
                            }
                            wds.putValue(jj, fill);
                        }
                    } else {
                        for (jj = 0; jj < ds1.length(); ++jj) {
                            wds.putValue(jj, fill);
                        }
                        hasFill = true;
                    }
                    result1.join(wds);
                }
                result1.putProperty("DEPEND_0", ds.property("DEPEND_0"));
                result = result1;
                break;
            }
            default: {
                JoinDataSet result1 = new JoinDataSet(ds.rank());
                for (int i = 0; i < ds.length(); ++i) {
                    QDataSet ds1 = ds.slice(i);
                    QDataSet r1 = DataSetOps.dbAboveBackgroundDim0(ds1, level);
                    result1.join(r1);
                    if (r1.property("FILL_VALUE") == null) continue;
                    hasFill = true;
                }
                result = result1;
                break;
            }
        }
        result.putProperty("UNITS", Units.dB);
        result.putProperty("TYPICAL_MIN", 0);
        result.putProperty("TYPICAL_MAX", 120);
        result.putProperty("SCALE_TYPE", "linear");
        result.putProperty("VALID_MIN", null);
        result.putProperty("VALID_MAX", null);
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        return result;
    }

    public static boolean isProcessAsync(String c) {
        return c.contains("copy") || c.contains("fft") || c.contains("contour") || c.contains("dbAboveBackgroundDim") || c.contains("reducex") || c.contains("total") || c.contains("collapse");
    }

    private static String getStringArg(String s) {
        String comp = s.trim();
        if (comp.startsWith("'") && comp.endsWith("'")) {
            comp = comp.substring(1, comp.length() - 1);
        } else if (comp.startsWith("\"") && comp.endsWith("\"")) {
            comp = comp.substring(1, comp.length() - 1);
        }
        return comp;
    }

    public static QDataSet processDataSet(String c, QDataSet fillDs, ProgressMonitor mon) throws RuntimeException, Exception {
        if ((c = c.trim()).length() > 0 && !c.startsWith("|")) {
            int idx;
            if (!c.equals("") && fillDs.length() > 0 && fillDs.rank() == 2) {
                String[] labels = SemanticOps.getComponentNames(fillDs);
                String comp = c;
                int ip = comp.indexOf("|");
                if (ip != -1) {
                    comp = comp.substring(0, ip);
                }
                comp = Ops.saferName(comp);
                if (fillDs.property("BUNDLE_1") != null) {
                    fillDs = DataSetOps.unbundle(fillDs, comp);
                } else {
                    boolean found = false;
                    for (int i = 0; i < labels.length; ++i) {
                        if (!Ops.saferName(labels[i]).equals(comp)) continue;
                        fillDs = DataSetOps.slice1(fillDs, i);
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new IllegalArgumentException("component not found: " + comp);
                    }
                }
            }
            c = (idx = c.indexOf("|")) == -1 ? "" : c.substring(idx);
        }
        if (c.length() > 5 && c.startsWith("|")) {
            fillDs = DataSetOps.sprocess(c, fillDs, mon);
        }
        return fillDs;
    }

    public static QDataSet sprocess(String c, QDataSet fillDs, ProgressMonitor mon) throws Exception {
        return OperationsProcessor.sprocess(c, fillDs, mon);
    }

    public static boolean changesDimensions(String p) {
        int j = p.indexOf(40);
        if (j > -1) {
            p = p.substring(0, j);
        }
        switch (p) {
            case "|smooth": 
            case "|nop": 
            case "|trim": 
            case "|magnitude": 
            case "|abs": 
            case "|hanning": 
            case "|butterworth": 
            case "|detrend": 
            case "|medianFilter": 
            case "|copy": 
            case "|setDepend0Cadence": {
                return false;
            }
        }
        return true;
    }

    private static String nextDimensionChangingCommand(Scanner s0) {
        while (s0.hasNext()) {
            String cmd = s0.next();
            if (!cmd.startsWith("|") || !DataSetOps.changesDimensions(cmd)) continue;
            return cmd;
        }
        return null;
    }

    public static boolean changesDimensions(String c0, String c1) {
        if (c0 == null || c1 == null) {
            return true;
        }
        Scanner s0 = new Scanner(c0);
        s0.useDelimiter("[\\(\\),]");
        Scanner s1 = new Scanner(c1);
        s1.useDelimiter("[\\(\\),]");
        boolean slicesChangesDim = false;
        String cmd0 = DataSetOps.nextDimensionChangingCommand(s0);
        String cmd1 = DataSetOps.nextDimensionChangingCommand(s1);
        while (cmd0 != null && cmd1 != null) {
            if (!cmd1.equals(cmd0)) {
                return true;
            }
            if (cmd0.startsWith("|slices") && cmd0.length() == 7) {
                Pattern skipPattern = Pattern.compile("\\'\\:?\\'");
                while (s0.hasNextInt() || s0.hasNext(skipPattern)) {
                    if (s0.hasNextInt() && s1.hasNextInt()) {
                        s0.nextInt();
                        s1.nextInt();
                        continue;
                    }
                    if (s0.hasNext(skipPattern) && s1.hasNext(skipPattern)) {
                        s0.next();
                        s1.next();
                        continue;
                    }
                    slicesChangesDim = true;
                    s0.next();
                    s1.next();
                }
            }
            cmd0 = DataSetOps.nextDimensionChangingCommand(s0);
            cmd1 = DataSetOps.nextDimensionChangingCommand(s1);
        }
        boolean res = slicesChangesDim || cmd0 != null || cmd1 != null;
        logger.log(Level.FINE, "  changesDimensions {0} , {1} ->{2}", new Object[]{c0, c1, res});
        return res;
    }

    public static QDataSet dependBoundsSimple(QDataSet ds) {
        QDataSet yrange;
        QDataSet xrange;
        logger.entering("org.das2.qds.DataSetOps", "dependBoundsSimple");
        if (ds.rank() == 1) {
            xrange = Ops.extentSimple(SemanticOps.xtagsDataSet(ds), null);
            yrange = Ops.extentSimple(ds, null);
        } else if (ds.rank() == 2) {
            if (SemanticOps.isRank2Waveform(ds)) {
                xrange = Ops.extentSimple(SemanticOps.xtagsDataSet(ds), null);
                yrange = Ops.extentSimple(ds, null);
            } else {
                xrange = Ops.extentSimple(SemanticOps.xtagsDataSet(ds), null);
                yrange = Ops.extentSimple(SemanticOps.ytagsDataSet(ds), null);
            }
        } else if (ds.rank() == 3) {
            QDataSet ds1 = ds.slice(0);
            xrange = Ops.extentSimple(SemanticOps.xtagsDataSet(ds1), null);
            yrange = Ops.extentSimple(SemanticOps.ytagsDataSet(ds1), null);
            for (int i = 1; i < ds.length(); ++i) {
                ds1 = ds.slice(i);
                xrange = Ops.extentSimple(SemanticOps.xtagsDataSet(ds1), xrange);
                yrange = Ops.extentSimple(SemanticOps.ytagsDataSet(ds1), yrange);
            }
        } else {
            throw new IllegalArgumentException("bad rank");
        }
        MutablePropertyDataSet result = DataSetOps.makePropertiesMutable(Ops.join(xrange, yrange));
        result.putProperty("BINS_1", "min,max");
        logger.exiting("org.das2.qds.DataSetOps", "dependBoundsSimple");
        return result;
    }

    public static QDataSet dependBounds(QDataSet ds) {
        QDataSet yrange;
        QDataSet xrange;
        logger.entering("org.das2.qds.DataSetOps", "dependBounds");
        if (ds.rank() == 1) {
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds));
            yrange = Ops.extent(ds);
        } else if (ds.rank() == 2) {
            if (SemanticOps.isRank2Waveform(ds)) {
                xrange = Ops.extent(SemanticOps.xtagsDataSet(ds));
                yrange = Ops.extent(ds);
            } else {
                xrange = Ops.extent(SemanticOps.xtagsDataSet(ds));
                yrange = Ops.extent(SemanticOps.ytagsDataSet(ds));
            }
        } else if (ds.rank() == 3) {
            QDataSet ds1 = ds.slice(0);
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1));
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1));
            for (int i = 1; i < ds.length(); ++i) {
                ds1 = ds.slice(i);
                xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1), xrange);
                yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1), yrange);
            }
        } else {
            throw new IllegalArgumentException("bad rank");
        }
        MutablePropertyDataSet result = DataSetOps.makePropertiesMutable(Ops.join(xrange, yrange));
        result.putProperty("BINS_1", "min,max");
        logger.exiting("org.das2.qds.DataSetOps", "dependBounds");
        return result;
    }

    public static boolean boundsContains(QDataSet bounds, Datum xValue, Datum yValue) {
        if (bounds.property("BINS_1") == null && bounds.property("BINS_0", 0) == null) {
            throw new IllegalArgumentException("expected BINS_1");
        }
        DatumRange xrange = DataSetUtil.asDatumRange(bounds.slice(0), true);
        DatumRange yrange = DataSetUtil.asDatumRange(bounds.slice(1), true);
        return xrange.contains(xValue) && yrange.contains(yValue);
    }
}

