/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.ArrayList;
import java.util.List;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;

public final class BundleDataSet
extends AbstractDataSet {
    List<QDataSet> datasets;
    int rank;
    int len0 = -1;

    public static BundleDataSet createRank0Bundle() {
        return new BundleDataSet(1);
    }

    public static BundleDataSet createRank1Bundle() {
        return new BundleDataSet(2);
    }

    public BundleDataSet() {
        this(2);
    }

    public BundleDataSet(int rank) {
        this.rank = rank;
        this.datasets = new ArrayList<QDataSet>();
        if (rank >= 2) {
            this.putProperty("BUNDLE_1", new BundleDescriptor());
            this.putProperty("QUBE", Boolean.TRUE);
        } else {
            this.putProperty("BUNDLE_0", new BundleDescriptor());
        }
    }

    public BundleDataSet(QDataSet ds) {
        this(ds.rank() + 1);
        this.bundle(ds);
    }

    public void bundle(QDataSet ds) {
        if (ds.rank() != this.rank - 1) {
            throw new IllegalArgumentException("dataset rank must be " + (this.rank - 1));
        }
        if (this.rank > 1) {
            if (this.len0 == -1) {
                this.len0 = ds.length();
            } else if (ds.length() != this.len0) {
                throw new IllegalArgumentException(String.format("dataset length (%d) is not consistent with the bundle's length (%d)", ds.length(), this.len0));
            }
        }
        this.datasets.add(ds);
    }

    public QDataSet unbundle(int i) {
        return this.datasets.get(i);
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public double value(int i0) {
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank 1 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i0).value();
    }

    @Override
    public double value(int i0, int i1) {
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank 2 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i1).value(i0);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank 3 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i1).value(i0, i2);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank 4 access on rank " + this.rank + " bundle dataset");
        }
        return this.datasets.get(i1).value(i0, i2, i3);
    }

    @Override
    public Object property(String name, int i0) {
        if (this.rank == 1) {
            return this.datasets.get(i0).property(name);
        }
        Object result = super.property(name);
        if (result == null) {
            return null;
        }
        return result;
    }

    @Override
    public int length() {
        return this.rank == 2 ? this.len0 : this.datasets.size();
    }

    @Override
    public int length(int i0) {
        return this.datasets.size();
    }

    @Override
    public int length(int i0, int i1) {
        return this.datasets.get(i0).length(i1);
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.datasets.get(i0).length(i1, i2);
    }

    @Override
    public String toString() {
        if (this.rank == 1) {
            return DataSetUtil.format(this);
        }
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        String dep0name = "";
        if (dep0 != null) {
            dep0name = (String)dep0.property("NAME");
            dep0name = dep0name == null ? "" : dep0name + "=";
        }
        return "BundleDataSet[" + dep0name + this.len0 + "," + this.datasets.size() + " datasets]";
    }

    public class BundleDescriptor
    extends AbstractDataSet {
        @Override
        public int rank() {
            return 2;
        }

        @Override
        public int length() {
            return BundleDataSet.this.datasets.size();
        }

        @Override
        public int length(int i) {
            return 0;
        }

        @Override
        public Object property(String name, int i) {
            Object v = super.property(name, i);
            if (i >= BundleDataSet.this.datasets.size()) {
                throw new IndexOutOfBoundsException("No dataset at index " + i + " only " + BundleDataSet.this.datasets.size() + " datasets.");
            }
            if (v == null) {
                if (DataSetUtil.isInheritedProperty(name)) {
                    return BundleDataSet.this.datasets.get(i).property(name);
                }
                return null;
            }
            return v;
        }

        @Override
        public double value(int i0, int i1) {
            throw new IndexOutOfBoundsException("length=0");
        }

        @Override
        public String toString() {
            StringBuilder names = new StringBuilder();
            String s = (String)BundleDataSet.this.datasets.get(0).property("NAME");
            names.append(s == null ? "data" : s);
            for (int i = 1; i < BundleDataSet.this.datasets.size(); ++i) {
                s = (String)BundleDataSet.this.datasets.get(i).property("NAME");
                names.append(",").append(s == null ? "data" : s);
            }
            return "BundleDescriptor[ " + names.toString() + "]";
        }
    }
}

