/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.CacheTag;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.BDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FDataSet;
import org.das2.qds.IDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.LDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SortDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.ByteDataSet;
import org.das2.qds.buffer.FloatDataSet;
import org.das2.qds.buffer.IntDataSet;
import org.das2.qds.buffer.ShortDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public abstract class ArrayDataSet
extends AbstractDataSet
implements WritableDataSet {
    protected static final Logger logger = LoggerManager.getLogger("qdataset.array");
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    float fill = Float.NaN;
    double dfill = Double.NaN;
    private static final boolean RANGE_CHECK = "true".equals(System.getProperty("rangeChecking", "true"));
    Class componentType;

    protected ArrayDataSet(Class componentType) {
        this.componentType = componentType;
    }

    protected static ArrayDataSet create(int rank, int len0, int len1, int len2, int len3, Object back) {
        Class<?> c = back.getClass().getComponentType();
        if (c == Double.TYPE) {
            return new DDataSet(rank, len0, len1, len2, len3, (double[])back);
        }
        if (c == Float.TYPE) {
            return new FDataSet(rank, len0, len1, len2, len3, (float[])back);
        }
        if (c == Long.TYPE) {
            return new LDataSet(rank, len0, len1, len2, len3, (long[])back);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(rank, len0, len1, len2, len3, (int[])back);
        }
        if (c == Short.TYPE) {
            return new SDataSet(rank, len0, len1, len2, len3, (short[])back);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(rank, len0, len1, len2, len3, (byte[])back);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet create(Class c, int[] qube) {
        if (c == Double.TYPE) {
            return DDataSet.create(qube);
        }
        if (c == Float.TYPE) {
            return FDataSet.create(qube);
        }
        if (c == Long.TYPE) {
            return LDataSet.create(qube);
        }
        if (c == Integer.TYPE) {
            return IDataSet.create(qube);
        }
        if (c == Short.TYPE) {
            return SDataSet.create(qube);
        }
        if (c == Byte.TYPE) {
            return BDataSet.create(qube);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank0(Class c) {
        if (c == Double.TYPE) {
            return new DDataSet(0, 1, 1, 1, 1);
        }
        if (c == Float.TYPE) {
            return new FDataSet(0, 1, 1, 1, 1);
        }
        if (c == Long.TYPE) {
            return new LDataSet(0, 1, 1, 1, 1);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(0, 1, 1, 1, 1);
        }
        if (c == Short.TYPE) {
            return new SDataSet(0, 1, 1, 1, 1);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(0, 1, 1, 1, 1);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank1(Class c, int len0) {
        if (c == Double.TYPE) {
            return new DDataSet(1, len0, 1, 1, 1);
        }
        if (c == Float.TYPE) {
            return new FDataSet(1, len0, 1, 1, 1);
        }
        if (c == Long.TYPE) {
            return new LDataSet(1, len0, 1, 1, 1);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(1, len0, 1, 1, 1);
        }
        if (c == Short.TYPE) {
            return new SDataSet(1, len0, 1, 1, 1);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(1, len0, 1, 1, 1);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank2(Class c, int len0, int len1) {
        if (c == Double.TYPE) {
            return new DDataSet(2, len0, len1, 1, 1);
        }
        if (c == Float.TYPE) {
            return new FDataSet(2, len0, len1, 1, 1);
        }
        if (c == Long.TYPE) {
            return new LDataSet(2, len0, len1, 1, 1);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(2, len0, len1, 1, 1);
        }
        if (c == Short.TYPE) {
            return new SDataSet(2, len0, len1, 1, 1);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(2, len0, len1, 1, 1);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank3(Class c, int len0, int len1, int len2) {
        if (c == Double.TYPE) {
            return new DDataSet(3, len0, len1, len2, 1);
        }
        if (c == Float.TYPE) {
            return new FDataSet(3, len0, len1, len2, 1);
        }
        if (c == Long.TYPE) {
            return new LDataSet(3, len0, len1, len2, 1);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(3, len0, len1, len2, 1);
        }
        if (c == Short.TYPE) {
            return new SDataSet(3, len0, len1, len2, 1);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(3, len0, len1, len2, 1);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet createRank4(Class c, int len0, int len1, int len2, int len3) {
        if (c == Double.TYPE) {
            return new DDataSet(4, len0, len1, len2, len3);
        }
        if (c == Float.TYPE) {
            return new FDataSet(4, len0, len1, len2, len3);
        }
        if (c == Long.TYPE) {
            return new LDataSet(4, len0, len1, len2, len3);
        }
        if (c == Integer.TYPE) {
            return new IDataSet(4, len0, len1, len2, len3);
        }
        if (c == Short.TYPE) {
            return new SDataSet(4, len0, len1, len2, len3);
        }
        if (c == Byte.TYPE) {
            return new BDataSet(4, len0, len1, len2, len3);
        }
        throw new IllegalArgumentException("class not supported: " + c);
    }

    public static ArrayDataSet wrap(Object array, int[] qube, boolean copy) {
        Object arr;
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("input must be an array");
        }
        Class<?> c = array.getClass().getComponentType();
        if (c.isArray()) {
            throw new IllegalArgumentException("input must be 1-D array");
        }
        if (copy) {
            arr = Array.newInstance(c, Array.getLength(array));
            System.arraycopy(array, 0, arr, 0, Array.getLength(array));
        } else {
            arr = array;
        }
        if (c == Double.TYPE) {
            return DDataSet.wrap((double[])arr, qube);
        }
        if (c == Float.TYPE) {
            return FDataSet.wrap((float[])arr, qube);
        }
        if (c == Long.TYPE) {
            return LDataSet.wrap((long[])arr, qube);
        }
        if (c == Integer.TYPE) {
            return IDataSet.wrap((int[])arr, qube);
        }
        if (c == Short.TYPE) {
            return SDataSet.wrap((short[])arr, qube);
        }
        if (c == Byte.TYPE) {
            return BDataSet.wrap((byte[])arr, qube);
        }
        throw new IllegalArgumentException("component type not supported: " + c);
    }

    public static ArrayDataSet monotonicSubset2(ArrayDataSet ds) {
        QDataSet ssdep0 = (QDataSet)ds.property("DEPEND_0");
        if (ssdep0 == null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(ds))) {
            ssdep0 = ds;
        } else if (ssdep0 == null) {
            return ds;
        }
        int mid = ssdep0.length() / 2;
        int start = 0;
        for (int i = mid - 1; i > 0; --i) {
            if (!(ssdep0.value(i) >= ssdep0.value(i + 1))) continue;
            start = i + 1;
            break;
        }
        int stop = ssdep0.length();
        for (int i = mid + 1; i < ssdep0.length(); ++i) {
            if (!(ssdep0.value(i - 1) >= ssdep0.value(i))) continue;
            stop = i - 1;
            break;
        }
        if (start > 0 || stop < ssdep0.length()) {
            ds = (ArrayDataSet)ds.trim(start, stop);
            return ds;
        }
        return ds;
    }

    public static ArrayDataSet monotonicSubset(ArrayDataSet ds) {
        QDataSet sdep0;
        if (ds.isImmutable()) {
            ds = ArrayDataSet.copy(ds);
            logger.warning("immutabilty forced copy.");
        }
        if ((sdep0 = (QDataSet)ds.property("DEPEND_0")) == null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(ds))) {
            sdep0 = ds;
        } else if (sdep0 == null) {
            return ds;
        }
        ArrayDataSet dep0 = ArrayDataSet.maybeCopy(sdep0);
        if (!UnitsUtil.isTimeLocation(SemanticOps.getUnits(dep0))) {
            return ds;
        }
        if (dep0.length() < 2) {
            return ds;
        }
        if (dep0.rank() != 1) {
            return ds;
        }
        QDataSet vdep0 = Ops.valid(dep0);
        int[] rback = new int[dep0.length()];
        rback[dep0.length() / 2] = dep0.length() / 2;
        int rindex = dep0.length() / 2 + 1;
        double a = dep0.value(rindex - 1);
        for (int i = rindex; i < dep0.length(); ++i) {
            if (!(vdep0.value(i) > 0.0)) continue;
            double a1 = dep0.value(i);
            if (a1 > a) {
                rback[rindex] = i;
                a = a1;
                ++rindex;
                continue;
            }
            logger.log(Level.FINER, "data point breaks monotonic rule: {0}", i);
        }
        int lindex = dep0.length() / 2;
        a = dep0.value(lindex + 1);
        for (int i = lindex; i >= 0; --i) {
            if (!(vdep0.value(i) > 0.0)) continue;
            double a1 = dep0.value(i);
            if (a1 < a) {
                rback[lindex] = i;
                a = a1;
                --lindex;
                continue;
            }
            logger.log(Level.FINER, "data point breaks monotonic rule: {0}", i);
        }
        int nrm = dep0.length() - (rindex - ++lindex);
        if (nrm > 0) {
            if (rindex == 1) {
                logger.log(Level.FINE, "ensureMono removes all points, assume it's monotonic decreasing");
                return ds;
            }
            logger.log(Level.FINE, "ensureMono removes {0} points", nrm);
            Class c = ds.getComponentType();
            int[] idx = new int[rindex - lindex];
            System.arraycopy(rback, lindex, idx, 0, rindex - lindex);
            ds.putProperty("DEPEND_0", null);
            ds = ArrayDataSet.copy(c, new SortDataSet(ds, Ops.dataset(idx)));
            Class depclass = dep0.getComponentType();
            ArrayDataSet dep0copy = ArrayDataSet.copy(depclass, new SortDataSet(dep0, Ops.dataset(idx)));
            dep0copy.putProperty("MONOTONIC", Boolean.TRUE);
            ds.putProperty("DEPEND_0", dep0copy);
        }
        return ds;
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public final int length() {
        return this.len0;
    }

    @Override
    public final int length(int i) {
        return this.len1;
    }

    @Override
    public final int length(int i0, int i1) {
        return this.len2;
    }

    @Override
    public final int length(int i0, int i1, int i2) {
        return this.len3;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public void putLength(int len) {
        int limit = Array.getLength(this.getBack()) / (this.len1 * this.len2 * this.len3);
        if (len > limit) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    public void grow(int newRecCount) {
        Object[] newBack;
        if (newRecCount < this.len0) {
            throw new IllegalArgumentException("new recsize for grow smaller than old");
        }
        int newSize = newRecCount * this.len1 * this.len2 * this.len3;
        Object back = this.getBackReadOnly();
        int oldSize = Array.getLength(back);
        if (newSize < oldSize) {
            return;
        }
        if (back instanceof double[]) {
            newBack = new double[newSize];
        } else if (back instanceof float[]) {
            newBack = new float[newSize];
        } else if (back instanceof long[]) {
            newBack = new long[newSize];
        } else if (back instanceof int[]) {
            newBack = new int[newSize];
        } else if (back instanceof short[]) {
            newBack = new short[newSize];
        } else if (back instanceof byte[]) {
            newBack = new byte[newSize];
        } else {
            throw new IllegalArgumentException("shouldn't happen bad type");
        }
        System.arraycopy(back, 0, newBack, 0, Array.getLength(back));
        this.setBack(newBack);
    }

    public synchronized void append(ArrayDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (this.getBackReadOnly().getClass() != ds.getBackReadOnly().getClass()) {
            throw new IllegalArgumentException("backing type mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2 * this.len3;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        if (Array.getLength(this.getBack()) < myLength + dsLength) {
            throw new IllegalArgumentException("unable to append dataset, not enough room");
        }
        System.arraycopy(ds.getBackReadOnly(), 0, this.getBack(), myLength, dsLength);
        Units u1 = SemanticOps.getUnits(this);
        Units u2 = SemanticOps.getUnits(ds);
        if (u1 != u2) {
            if (u1 instanceof EnumerationUnits && u2 instanceof EnumerationUnits) {
                for (int i = myLength; i < myLength + dsLength; ++i) {
                    double d = Array.getDouble(this.getBack(), i);
                    d = ((EnumerationUnits)u1).createDatum(u2.createDatum(d).toString()).doubleValue(u1);
                    Array.set(this.getBack(), i, d);
                }
            } else {
                UnitsConverter uc = UnitsConverter.getConverter(u2, u1);
                Class<?> backClass = this.getBack().getClass().getComponentType();
                for (int i = myLength; i < myLength + dsLength; ++i) {
                    Double nv = uc.convert(Array.getDouble(this.getBack(), i));
                    if (backClass == Double.TYPE) {
                        Array.set(this.getBack(), i, (double)nv);
                        continue;
                    }
                    if (backClass == Float.TYPE) {
                        Array.set(this.getBack(), i, Float.valueOf(((Number)nv).floatValue()));
                        continue;
                    }
                    if (backClass == Long.TYPE) {
                        Array.set(this.getBack(), i, ((Number)nv).longValue());
                        continue;
                    }
                    if (backClass == Integer.TYPE) {
                        Array.set(this.getBack(), i, ((Number)nv).intValue());
                        continue;
                    }
                    if (backClass == Short.TYPE) {
                        Array.set(this.getBack(), i, ((Number)nv).shortValue());
                        continue;
                    }
                    if (backClass == Byte.TYPE) {
                        Array.set(this.getBack(), i, ((Number)nv).byteValue());
                        continue;
                    }
                    throw new IllegalArgumentException("unsupported type: " + backClass);
                }
            }
        }
        this.len0 += ds.len0;
        this.properties.putAll(ArrayDataSet.joinProperties(this, ds));
    }

    public boolean canAppend(ArrayDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (this.getBackReadOnly().getClass() != ds.getBackReadOnly().getClass()) {
            Class<?> a1 = ds.getBackReadOnly().getClass();
            Class<?> a2 = this.getBack().getClass();
            String s1 = "" + a1.getComponentType();
            String s2 = "" + a2.getComponentType();
            throw new IllegalArgumentException("backing type mismatch: " + s2 + "[" + ds.length() + ",*] can't be appended to " + s1 + "[" + this.length() + ",*]");
        }
        int trec = Array.getLength(this.getBack()) / this.len1 / this.len2 / this.len3;
        return trec - this.len0 > ds.length();
    }

    public static ArrayDataSet maybeCopy(QDataSet ds) {
        if (ds instanceof ArrayDataSet && !((ArrayDataSet)ds).isImmutable()) {
            return (ArrayDataSet)ds;
        }
        return ArrayDataSet.copy(ds);
    }

    public static ArrayDataSet maybeCopy(Class c, QDataSet ds) {
        if (ds instanceof ArrayDataSet && ((ArrayDataSet)ds).getComponentType() == c) {
            return (ArrayDataSet)ds;
        }
        return ArrayDataSet.copy(c, ds);
    }

    protected abstract Object getBack();

    protected abstract int getBackJvmMemory();

    protected abstract Object getBackCopy();

    protected abstract Object getBackReadOnly();

    protected abstract void setBack(Object var1);

    private static ArrayDataSet internalCopy(ArrayDataSet ds) {
        Object newback = ds.getBackCopy();
        ArrayDataSet result = ArrayDataSet.create(ds.rank, ds.len0, ds.len1, ds.len2, ds.len3, newback);
        result.properties.putAll(Ops.copyProperties(ds));
        result.checkFill();
        return result;
    }

    public static ArrayDataSet copy(Class c, QDataSet ds) {
        ArrayDataSet result;
        if (ds instanceof ArrayDataSet && ((ArrayDataSet)ds).getBackReadOnly().getClass().getComponentType() == c) {
            return ArrayDataSet.internalCopy((ArrayDataSet)ds);
        }
        int rank = ds.rank();
        switch (rank) {
            case 0: {
                result = ArrayDataSet.createRank0(c);
                result.putValue(ds.value());
                break;
            }
            case 1: {
                result = ArrayDataSet.createRank1(c, ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                result = ArrayDataSet.createRank2(c, ds.length(), ds.length(0));
                int i0 = ds.length() > 0 ? ds.length(0) : -1;
                for (int i = 0; i < ds.length(); ++i) {
                    if (ds.length(i) != i0) {
                        throw new IllegalArgumentException("Attempt to copy non-qube into ArrayDataSet which must be qube: " + ds);
                    }
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                result = ArrayDataSet.createRank3(c, ds.length(), ds.length(0), ds.length(0, 0));
                int i0_ = ds.length() > 0 ? ds.length(0) : -1;
                for (int i = 0; i < ds.length(); ++i) {
                    if (ds.length(i) != i0_) {
                        throw new IllegalArgumentException("Attempt to copy non-qube into ArrayDataSet which must be qube: " + ds);
                    }
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            case 4: {
                result = ArrayDataSet.createRank4(c, ds.length(), ds.length(0), ds.length(0, 0), ds.length(0, 0, 0));
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            for (int l = 0; l < ds.length(i, j, k); ++l) {
                                result.putValue(i, j, k, l, ds.value(i, j, k, l));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(Ops.copyProperties(ds));
        result.checkFill();
        return result;
    }

    public static ArrayDataSet copy(QDataSet ds) {
        if (ds instanceof ArrayDataSet) {
            return ArrayDataSet.internalCopy((ArrayDataSet)ds);
        }
        if (ds instanceof JoinDataSet && ds.length() > 0) {
            QDataSet ds1 = ds.slice(0);
            if (ds1 instanceof ArrayDataSet) {
                Class<?> c = ((ArrayDataSet)ds1).getBackReadOnly().getClass().getComponentType();
                return ArrayDataSet.copy(c, ds);
            }
            return ArrayDataSet.copy(ArrayDataSet.guessBackingStore(ds), ds);
        }
        return ArrayDataSet.copy(ArrayDataSet.guessBackingStore(ds), ds);
    }

    public static Class guessBackingStore(QDataSet ds) {
        if (ds instanceof BDataSet || ds instanceof ByteDataSet) {
            return Byte.TYPE;
        }
        if (ds instanceof SDataSet || ds instanceof ShortDataSet) {
            return Short.TYPE;
        }
        if (ds instanceof IDataSet || ds instanceof IntDataSet) {
            return Integer.TYPE;
        }
        if (ds instanceof FDataSet || ds instanceof FloatDataSet) {
            return Float.TYPE;
        }
        return Double.TYPE;
    }

    protected void checkFill() {
        Number f = (Number)this.properties.get("FILL_VALUE");
        if (f != null) {
            this.fill = f.floatValue();
            this.dfill = f.doubleValue();
        } else {
            this.fill = Float.NaN;
            this.dfill = Double.NaN;
        }
    }

    public static ArrayDataSet append(ArrayDataSet ds1, ArrayDataSet ds2) {
        Units u2;
        Units u1;
        Units u;
        if (ds1 == null) {
            if (ds2.rank > 0) {
                return ds2;
            }
            ArrayDataSet result = ArrayDataSet.createRank1(ArrayDataSet.guessBackingStore(ds2), 1);
            result.putValue(ds2.value());
            DataSetUtil.copyDimensionProperties(ds2, result);
            QDataSet c = (QDataSet)ds2.property("CONTEXT_0");
            if (c != null && c.rank() == 0) {
                result.putProperty("DEPEND_0", Ops.append(null, c));
            }
            return result;
        }
        if (ds2 == null) {
            throw new NullPointerException("ds is null");
        }
        if (ds1.rank() == ds2.rank() - 1) {
            u = SemanticOps.getUnits(ds1);
            ds1 = ArrayDataSet.create(ds1.rank() + 1, 1, ds1.len0, ds1.len1, ds1.len2, ds1.getBack());
            ds1.putProperty("UNITS", u);
        }
        if (ds1.rank() - 1 == ds2.rank()) {
            u = SemanticOps.getUnits(ds2);
            QDataSet c = (QDataSet)ds2.property("CONTEXT_0");
            ds2 = ArrayDataSet.create(ds2.rank() + 1, 1, ds2.len0, ds2.len1, ds2.len2, ds2.getBack());
            ds2.putProperty("UNITS", u);
            if (ds2.rank == 1 && c != null && c.rank() == 0) {
                ds2.putProperty("DEPEND_0", Ops.append(null, c));
            }
        }
        if (ds2.rank() != ds1.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds2.len1 != ds1.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds2.len2 != ds1.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds2.len3 != ds1.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        if (ds1.getBackReadOnly().getClass() != ds2.getBackReadOnly().getClass()) {
            throw new IllegalArgumentException("backing type mismatch");
        }
        int myLength = ds1.len0 * ds1.len1 * ds1.len2 * ds1.len3;
        int dsLength = ds2.len0 * ds2.len1 * ds2.len2 * ds2.len3;
        Object newback = Array.newInstance(ds1.getBackReadOnly().getClass().getComponentType(), myLength + dsLength);
        System.arraycopy(ds1.getBackReadOnly(), 0, newback, 0, myLength);
        System.arraycopy(ds2.getBackReadOnly(), 0, newback, myLength, dsLength);
        if (SemanticOps.isBundle(ds1) && SemanticOps.isBundle(ds2)) {
            QDataSet bds1 = (QDataSet)ds1.property("BUNDLE_1");
            QDataSet bds2 = (QDataSet)ds2.property("BUNDLE_1");
            for (int j = 0; j < ds1.length(0); ++j) {
                Units u22;
                Units u12 = (Units)bds1.property("UNITS", j);
                if (u12 == null) {
                    u12 = Units.dimensionless;
                }
                if ((u22 = (Units)bds2.property("UNITS", j)) == null) {
                    u22 = Units.dimensionless;
                }
                if (u12 == u22) continue;
                logger.log(Level.WARNING, "unable to properly append two bundle datasets with different units: \"{0}\" \"{1}\"", new Object[]{u12, u22});
            }
        }
        if ((u1 = SemanticOps.getUnits(ds1)) != (u2 = SemanticOps.getUnits(ds2))) {
            UnitsConverter uc = UnitsConverter.getConverter(u2, u1);
            Class<?> backClass = ds1.getBackReadOnly().getClass().getComponentType();
            for (int i = myLength; i < myLength + dsLength; ++i) {
                Double nv = uc.convert(Array.getDouble(newback, i));
                if (backClass == Double.TYPE) {
                    Array.set(newback, i, (double)nv);
                    continue;
                }
                if (backClass == Float.TYPE) {
                    Array.set(newback, i, Float.valueOf(((Number)nv).floatValue()));
                    continue;
                }
                if (backClass == Long.TYPE) {
                    Array.set(newback, i, ((Number)nv).longValue());
                    continue;
                }
                if (backClass == Integer.TYPE) {
                    Array.set(newback, i, ((Number)nv).intValue());
                    continue;
                }
                if (backClass == Short.TYPE) {
                    Array.set(newback, i, ((Number)nv).shortValue());
                    continue;
                }
                if (backClass == Byte.TYPE) {
                    Array.set(newback, i, ((Number)nv).byteValue());
                    continue;
                }
                throw new IllegalArgumentException("unsupported type: " + backClass);
            }
        }
        int len0 = ds1.len0 + ds2.len0;
        int rank = ds1.rank == 0 ? 1 : ds1.rank;
        ArrayDataSet result = ArrayDataSet.create(rank, len0, ds1.len1, ds1.len2, ds1.len3, newback);
        result.properties.putAll(ArrayDataSet.joinProperties(ds1, ds2));
        result.properties.put("UNITS", u1);
        return result;
    }

    protected static Map joinProperties(ArrayDataSet ds1, ArrayDataSet ds2) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < ds2.rank(); ++i) {
            QDataSet thatDep = (QDataSet)ds2.property("DEPEND_" + i);
            if (thatDep != null && (i == 0 || thatDep.rank() > 1)) {
                QDataSet thisDep = (QDataSet)ds1.property("DEPEND_" + i);
                if (thisDep == null) {
                    throw new IllegalArgumentException("DEPEND_" + i + " missing from first argument: " + ds1);
                }
                ArrayDataSet djoin = ArrayDataSet.copy(thisDep);
                ArrayDataSet ddep1 = thatDep instanceof ArrayDataSet ? (ArrayDataSet)thatDep : ArrayDataSet.maybeCopy(thatDep);
                djoin = ArrayDataSet.append(djoin, ddep1);
                result.put("DEPEND_" + i, djoin);
            } else if (thatDep != null && thatDep.rank() == 1) {
                result.put("DEPEND_" + i, thatDep);
            }
            QDataSet thatBundle = (QDataSet)ds2.property("BUNDLE_" + i);
            QDataSet thisBundle = (QDataSet)ds1.property("BUNDLE_" + i);
            if (i <= 0 || thatBundle == null || thisBundle == null) continue;
            if (thisBundle.length() != thatBundle.length()) {
                throw new IllegalArgumentException("BUNDLE_" + i + " should be the same length to append, but they are not");
            }
            for (int j = 0; j < thatBundle.length(); ++j) {
                Units thatu = (Units)thatBundle.property("UNITS", j);
                Units thisu = (Units)thisBundle.property("UNITS", j);
                if (thisu == thatu) continue;
                throw new IllegalArgumentException("units in BUNDLE_" + i + " change...");
            }
            result.put("BUNDLE_" + i, thatBundle);
        }
        String[] props = DataSetUtil.correlativeProperties();
        for (int iprop = -1; iprop < props.length; ++iprop) {
            String prop = iprop == -1 ? "PLANE_0" : props[iprop];
            QDataSet w1 = (QDataSet)ds2.property(prop);
            if (w1 == null) continue;
            QDataSet propds = (QDataSet)ds1.property(prop);
            if (propds != null) {
                ArrayDataSet djoin = ArrayDataSet.copy(propds);
                ArrayDataSet dd1 = ArrayDataSet.maybeCopy(w1);
                if (djoin.rank > 0 || ds1.rank == 0) {
                    djoin = ArrayDataSet.append(djoin, dd1);
                }
                result.put(prop, djoin);
                continue;
            }
            logger.log(Level.INFO, "dataset doesn''t have property \"{0}\" but other dataset does: {1}", new Object[]{prop, ds1});
        }
        for (String prop : props = DataSetUtil.dimensionProperties()) {
            Object value = ds1.property(prop);
            if (value == null || !value.equals(ds2.property(prop))) continue;
            result.put(prop, ds1.property(prop));
        }
        for (String prop : props = new String[]{"CADENCE", "BINS_1"}) {
            Object o = ds1.property(prop);
            if (o == null || !o.equals(ds2.property(prop))) continue;
            result.put(prop, o);
        }
        Boolean m = (Boolean)ds1.property("MONOTONIC");
        if (m != null && m.equals(Boolean.TRUE) && m.equals(ds2.property("MONOTONIC"))) {
            try {
                int[] fl1 = DataSetUtil.rangeOfMonotonic(ds1);
                int[] fl2 = DataSetUtil.rangeOfMonotonic(ds2);
                Units u1 = SemanticOps.getUnits(ds2);
                Units u2 = SemanticOps.getUnits(ds1);
                UnitsConverter uc = u2.getConverter(u1);
                if (ds2.value(fl2[0]) - uc.convert(ds1.value(fl1[1])) >= 0.0) {
                    result.put("MONOTONIC", Boolean.TRUE);
                }
            }
            catch (IllegalArgumentException ex) {
                logger.fine("rte_1282463981: can't show that result has monotonic timetags because each dataset is not monotonic.");
            }
        }
        CacheTag ct0 = (CacheTag)ds1.property("CACHE_TAG");
        CacheTag ct1 = (CacheTag)ds2.property("CACHE_TAG");
        if (ct0 != null && ct1 != null) {
            CacheTag newTag = null;
            try {
                newTag = CacheTag.append(ct0, ct1);
            }
            catch (IllegalArgumentException ex) {
                logger.fine("append of two datasets that have CACHE_TAGs and are not adjacent, dropping CACHE_TAG");
            }
            if (newTag != null) {
                result.put("CACHE_TAG", newTag);
            }
        }
        Number dmin0 = (Number)ds1.property("TYPICAL_MIN");
        Number dmax0 = (Number)ds1.property("TYPICAL_MAX");
        Number dmin1 = (Number)ds2.property("TYPICAL_MIN");
        Number dmax1 = (Number)ds2.property("TYPICAL_MAX");
        if (dmin0 != null && dmin1 != null) {
            result.put("TYPICAL_MIN", Math.min(dmin0.doubleValue(), dmin1.doubleValue()));
        }
        if (dmax0 != null && dmax1 != null) {
            result.put("TYPICAL_MAX", Math.max(dmax0.doubleValue(), dmax1.doubleValue()));
        }
        return result;
    }

    public QDataSet setUnits(Units units) {
        this.checkImmutable();
        this.putProperty("UNITS", units);
        return this;
    }

    @Override
    public String toString() {
        return DataSetUtil.toString(this);
    }

    public int jvmMemory() {
        return this.getBackJvmMemory();
    }

    public void about() {
        System.err.println("== " + this.toString() + "==");
        System.err.println("back is array of " + this.getComponentType());
    }
}

