/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.filter;

import java.util.Arrays;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.FlattenWaveformDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;

public class AbstractFilter {
    QDataSet source;
    private int px;
    private int py;
    private double[] xv;
    private double[] yv;
    private double[] a;
    private double[] b;

    AbstractFilter(QDataSet source) {
        this.source = source;
    }

    protected Units getTimeOffsetUnits() {
        QDataSet timeDomainTags = (QDataSet)this.source.property("DEPEND_0");
        Units u = SemanticOps.getUnits(timeDomainTags);
        return u.getOffsetUnits();
    }

    protected double getSampleRate(QDataSet source, Units units) {
        QDataSet timeDomainTags = (QDataSet)source.property("DEPEND_0");
        Units u = this.getTimeOffsetUnits();
        u = UnitsUtil.getInverseUnit(u);
        return u.convertDoubleTo(units, 1.0 / (timeDomainTags.value(1) - timeDomainTags.value(0)));
    }

    public void setCoefficients(double[] b, double[] a) {
        this.b = Arrays.copyOf(b, b.length);
        this.a = Arrays.copyOf(a, a.length);
        this.xv = new double[this.b.length + 1];
        this.yv = new double[this.a.length + 1];
        if (this.a[0] == 1.0) {
            int i = 1;
            while (i < this.a.length) {
                int n = i++;
                this.a[n] = this.a[n] / this.a[0];
            }
            i = 0;
            while (i < this.b.length) {
                int n = i++;
                this.b[n] = this.b[n] / this.a[0];
            }
        }
    }

    public QDataSet filter() {
        if (this.source.rank() == 2) {
            this.source = new FlattenWaveformDataSet(this.source);
        }
        ArrayDataSet buf = ArrayDataSet.copy(this.source);
        for (int i = 0; i < this.source.length(); ++i) {
            int j;
            this.xv[this.px] = this.source.value(i);
            buf.putValue(i, this.b[0] * this.xv[this.px]);
            for (j = 1; j < this.b.length; ++j) {
                buf.putValue(i, buf.value(i) + this.b[j] * this.xv[(this.px - j + this.xv.length) % this.xv.length]);
            }
            for (j = 1; j < this.a.length; ++j) {
                buf.putValue(i, buf.value(i) - this.a[j] * this.yv[(this.py - j + this.yv.length) % this.yv.length]);
            }
            this.yv[this.py] = buf.value(i);
            this.px = (this.px + 1) % this.xv.length;
            this.py = (this.py + 1) % this.yv.length;
        }
        return buf;
    }

    public String toString() {
        return "b = " + Arrays.toString(this.b) + " a = " + Arrays.toString(this.a);
    }
}

