/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion.ui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.nbadapt.BaseDocument;
import org.das2.jythoncompletion.nbadapt.GuardedDocument;
import org.das2.jythoncompletion.nbadapt.Utilities;
import org.das2.jythoncompletion.support.CompletionItem;
import org.das2.jythoncompletion.support.CompletionProvider;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.jythoncompletion.support.LazyCompletionItem;
import org.das2.jythoncompletion.ui.CompletionItemComparator;
import org.das2.jythoncompletion.ui.CompletionLayout;
import org.das2.jythoncompletion.ui.CompletionResultSetImpl;
import org.das2.jythoncompletion.ui.CompletionSettings;
import org.das2.jythoncompletion.ui.LazyListModel;

public class CompletionImpl
extends MouseAdapter
implements DocumentListener,
CaretListener,
KeyListener,
FocusListener,
ListSelectionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger("jython.editor");
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.editor.completion.debug");
    private static final boolean alphaSort = Boolean.getBoolean("org.netbeans.modules.editor.completion.alphabeticalSort");
    private static final Logger UI_LOG = Logger.getLogger("org.netbeans.ui.editor.completion");
    private static CompletionImpl singleton = null;
    private static final String NO_SUGGESTIONS = "no suggestions";
    private static final String PLEASE_WAIT = "please wait";
    private static final String COMPLETION_SHOW = "completion-show";
    private static final String COMPLETION_ALL_SHOW = "completion-all-show";
    private static final String DOC_SHOW = "doc-show";
    private static final String TOOLTIP_SHOW = "tooltip-show";
    private static final int PLEASE_WAIT_TIMEOUT = 750;
    private static final int PRESCAN = 25;
    static LazyListModel.Filter filter = new LazyListModel.Filter(){

        @Override
        public boolean accept(Object obj) {
            if (obj instanceof LazyCompletionItem) {
                return ((LazyCompletionItem)obj).accept();
            }
            return true;
        }

        @Override
        public void scheduleUpdate(Runnable run) {
            SwingUtilities.invokeLater(run);
        }
    };
    private WeakReference<JTextComponent> activeComponent = null;
    private WeakReference<Document> activeDocument = null;
    private InputMap inputMap;
    private ActionMap actionMap;
    private final CompletionLayout layout = new CompletionLayout();
    private CompletionProvider[] activeProviders = null;
    private HashMap<String, CompletionProvider[]> providersCache = new HashMap();
    private Result completionResult;
    private Result docResult;
    private Result toolTipResult;
    private Timer completionAutoPopupTimer = new Timer(0, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Result localCompletionResult;
            2 var3_2 = this;
            synchronized (var3_2) {
                localCompletionResult = CompletionImpl.this.completionResult;
            }
            if (localCompletionResult != null && !localCompletionResult.isQueryInvoked()) {
                CompletionImpl.this.pleaseWaitTimer.restart();
                CompletionImpl.queryResultSets(localCompletionResult.getResultSets());
                localCompletionResult.queryInvoked();
            }
        }
    });
    private Timer docAutoPopupTimer;
    private Timer pleaseWaitTimer;
    private boolean refreshedQuery = false;
    private boolean explicitQuery = false;
    private WeakReference<CompletionItem> lastSelectedItem = null;
    private int autoModEndOffset;
    private boolean pleaseWaitDisplayed = false;
    private String completionShortcut = null;
    boolean tabIsCompletion = true;

    public static CompletionImpl get() {
        if (singleton == null) {
            singleton = new CompletionImpl();
        }
        return singleton;
    }

    private CompletionImpl() {
        this.completionAutoPopupTimer.setRepeats(false);
        this.docAutoPopupTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CompletionImpl.this.lastSelectedItem == null || CompletionImpl.this.lastSelectedItem.get() != CompletionImpl.this.layout.getSelectedCompletionItem()) {
                    CompletionImpl.this.showDocumentation();
                }
            }
        });
        this.docAutoPopupTimer.setRepeats(false);
        this.pleaseWaitTimer = new Timer(750, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                List<CompletionResultSetImpl> resultSets;
                Result localCompletionResult;
                String waitText = CompletionImpl.PLEASE_WAIT;
                4 var4_3 = this;
                synchronized (var4_3) {
                    localCompletionResult = CompletionImpl.this.completionResult;
                }
                if (localCompletionResult != null && (resultSets = localCompletionResult.getResultSets()) != null) {
                    for (CompletionResultSetImpl resultSet : resultSets) {
                        if (resultSet == null || resultSet.getWaitText() == null) continue;
                        waitText = resultSet.getWaitText();
                        break;
                    }
                }
                CompletionImpl.this.layout.showCompletion(Collections.singletonList(waitText), null, -1, CompletionImpl.this, null, 0);
                CompletionImpl.this.pleaseWaitDisplayed = true;
            }
        });
        this.pleaseWaitTimer.setRepeats(false);
    }

    private JTextComponent getActiveComponent() {
        return this.activeComponent != null ? (JTextComponent)this.activeComponent.get() : null;
    }

    private Document getActiveDocument() {
        return this.activeDocument != null ? (Document)this.activeDocument.get() : null;
    }

    int getSortType() {
        return alphaSort ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (this.activeProviders != null) {
            try {
                int modEndOffset = e.getOffset() + e.getLength();
                if (this.getActiveComponent().getSelectionStart() != modEndOffset) {
                    return;
                }
                String typedText = e.getDocument().getText(e.getOffset(), e.getLength());
                for (int i = 0; i < this.activeProviders.length; ++i) {
                    boolean tooltipResultNull;
                    boolean completionResultNull;
                    int type = this.activeProviders[i].getAutoQueryTypes(this.getActiveComponent(), typedText);
                    CompletionImpl completionImpl = this;
                    synchronized (completionImpl) {
                        completionResultNull = this.completionResult == null;
                    }
                    if ((type & 1) != 0 && CompletionSettings.INSTANCE.completionAutoPopup()) {
                        completionImpl = this;
                        synchronized (completionImpl) {
                            this.autoModEndOffset = modEndOffset;
                        }
                        if (completionResultNull) {
                            this.showCompletion(false, true, 1);
                        }
                    }
                    CompletionImpl completionImpl2 = this;
                    synchronized (completionImpl2) {
                        tooltipResultNull = this.toolTipResult == null;
                    }
                    if (!tooltipResultNull || (type & 4) == 0) continue;
                    this.showToolTip();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.completionAutoPopupTimer.isRunning()) {
                this.restartCompletionAutoPopupTimer();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public synchronized void caretUpdate(CaretEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.activeProviders != null) {
            Result localCompletionResult = this.completionResult;
            if (!(!this.completionAutoPopupTimer.isRunning() && localCompletionResult == null || this.layout.isCompletionVisible() && !this.pleaseWaitDisplayed || e.getDot() == this.autoModEndOffset)) {
                this.hideCompletion(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompletionImpl.this.completionRefresh();
                    CompletionImpl.this.toolTipRefresh();
                }
            });
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.dispatchKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.dispatchKeyEvent(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.dispatchKeyEvent(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hideAll();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.hideAll();
    }

    public void hideAll() {
        this.hideToolTip();
        this.hideCompletion(true);
        this.hideDocumentation(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.layout.isDocumentationVisible() || CompletionSettings.INSTANCE.documentationAutoPopup()) {
            this.restartDocumentationAutoPopupTimer();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    private void restartCompletionAutoPopupTimer() {
        assert (SwingUtilities.isEventDispatchThread());
        int completionDelay = CompletionSettings.INSTANCE.completionAutoPopupDelay();
        this.completionAutoPopupTimer.setInitialDelay(completionDelay);
        this.completionAutoPopupTimer.restart();
    }

    private void restartDocumentationAutoPopupTimer() {
        assert (SwingUtilities.isEventDispatchThread());
        int docDelay = CompletionSettings.INSTANCE.documentationAutoPopupDelay();
        this.docAutoPopupTimer.setInitialDelay(docDelay);
        this.docAutoPopupTimer.restart();
    }

    private CompletionProvider[] getCompletionProvidersForComponent(JTextComponent component) {
        assert (SwingUtilities.isEventDispatchThread());
        if (component == null) {
            return null;
        }
        return new CompletionProvider[]{JythonCompletionProvider.getInstance()};
    }

    private void dispatchKeyEvent(KeyEvent e) {
        Action action;
        if (e == null) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        JTextComponent comp = this.getActiveComponent();
        boolean compEditable = comp != null && comp.isEditable();
        boolean guardedPos = false;
        Object obj = this.inputMap.get(ks);
        if (obj != null && (action = this.actionMap.get(obj)) != null) {
            if (compEditable) {
                action.actionPerformed(null);
            }
            e.consume();
            return;
        }
        if (this.layout.isCompletionVisible()) {
            CompletionItem item = this.layout.getSelectedCompletionItem();
            if (item != null) {
                LogRecord r;
                if (compEditable && !guardedPos) {
                    r = new LogRecord(Level.FINE, "COMPL_KEY_SELECT");
                    r.setParameters(new Object[]{Character.valueOf(e.getKeyChar()), this.layout.getSelectedIndex(), item.getClass().getSimpleName()});
                    item.processKeyEvent(e);
                    if (e.isConsumed()) {
                        CompletionImpl.uilog(r);
                        return;
                    }
                }
                if (e.getKeyCode() == 10 && e.getID() == 401) {
                    e.consume();
                    if (guardedPos) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (compEditable) {
                        r = new LogRecord(Level.FINE, "COMPL_KEY_SELECT_DEFAULT");
                        r.setParameters(new Object[]{Character.valueOf('\n'), this.layout.getSelectedIndex(), item.getClass().getSimpleName()});
                        item.defaultAction(this.getActiveComponent());
                        CompletionImpl.uilog(r);
                    }
                    return;
                }
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 33 || e.getKeyCode() == 34 || e.getKeyCode() == 36 || e.getKeyCode() == 35 || e.getKeyCode() == 10) {
                this.hideCompletion(false);
            }
            if (this.tabIsCompletion && e.getKeyCode() == 9) {
                e.consume();
                if (guardedPos) {
                    Toolkit.getDefaultToolkit().beep();
                } else if (compEditable && e.getID() == 401) {
                    this.insertCommonPrefix();
                }
                return;
            }
        }
        this.layout.processKeyEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionQuery(boolean delayQuery, int queryType) {
        this.refreshedQuery = false;
        Result newCompletionResult = new Result(this.activeProviders.length);
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            assert (this.completionResult == null);
            this.completionResult = newCompletionResult;
        }
        List<CompletionResultSetImpl> completionResultSets = newCompletionResult.getResultSets();
        for (int i = 0; i < this.activeProviders.length; ++i) {
            CompletionTask compTask = this.activeProviders[i].createTask(queryType, this.getActiveComponent());
            if (compTask == null) continue;
            CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newCompletionResult, compTask, queryType);
            completionResultSets.add(resultSet);
        }
        if (completionResultSets.size() > 0) {
            if (delayQuery) {
                this.restartCompletionAutoPopupTimer();
            } else {
                this.pleaseWaitTimer.restart();
                CompletionImpl.queryResultSets(completionResultSets);
                newCompletionResult.queryInvoked();
            }
        } else {
            this.completionCancel();
            this.layout.showCompletion(Collections.singletonList(NO_SUGGESTIONS), null, -1, this, null, 0);
            this.pleaseWaitDisplayed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionRefresh() {
        Result localCompletionResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            localCompletionResult = this.completionResult;
        }
        if (localCompletionResult != null) {
            this.refreshedQuery = true;
            Result refreshResult = localCompletionResult.createRefreshResult();
            CompletionImpl completionImpl2 = this;
            synchronized (completionImpl2) {
                this.completionResult = refreshResult;
            }
            refreshResult.invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionCancel() {
        Result oldCompletionResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            oldCompletionResult = this.completionResult;
            this.completionResult = null;
        }
        if (oldCompletionResult != null) {
            oldCompletionResult.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCommonPrefix() {
        int caretOffset;
        Result localCompletionResult;
        JTextComponent c = this.getActiveComponent();
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            localCompletionResult = this.completionResult;
            if (localCompletionResult == null) {
                return;
            }
            if (!CompletionImpl.isAllResultsFinished(localCompletionResult.resultSets)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        CharSequence commonText = null;
        int anchorOffset = -1;
        block8: for (CompletionResultSetImpl resultSet : localCompletionResult.getResultSets()) {
            List<? extends CompletionItem> resultItems = resultSet.getItems();
            if (resultItems.size() <= 0) continue;
            if (anchorOffset >= -1) {
                anchorOffset = anchorOffset > -1 && anchorOffset != resultSet.getAnchorOffset() ? -2 : resultSet.getAnchorOffset();
            }
            Iterator<? extends CompletionItem> itt = resultItems.iterator();
            block9: while (itt.hasNext()) {
                CharSequence text = itt.next().getInsertPrefix();
                if (text == null) {
                    commonText = null;
                    break block8;
                }
                if (commonText == null) {
                    commonText = text;
                    continue;
                }
                int minLen = Math.min(text.length(), commonText.length());
                for (int commonInd = 0; commonInd < minLen; ++commonInd) {
                    if (text.charAt(commonInd) == commonText.charAt(commonInd)) continue;
                    if (commonInd == 0) {
                        commonText = null;
                        break block8;
                    }
                    commonText = commonText.subSequence(0, commonInd);
                    continue block9;
                }
            }
        }
        if (commonText != null && anchorOffset >= 0 && (caretOffset = c.getSelectionStart()) - anchorOffset < commonText.length()) {
            Document doc = this.getActiveDocument();
            BaseDocument baseDoc = null;
            if (doc instanceof BaseDocument) {
                baseDoc = (BaseDocument)doc;
            }
            if (baseDoc != null) {
                baseDoc.atomicLock();
            }
            try {
                doc.remove(anchorOffset, caretOffset - anchorOffset);
                doc.insertString(anchorOffset, commonText.toString(), null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (baseDoc != null) {
                    baseDoc.atomicUnlock();
                }
            }
        }
    }

    public void showCompletion() {
        this.showCompletion(true, false, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCompletion(boolean explicitQuery, boolean delayQuery, int queryType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(0, explicitQuery, delayQuery, queryType));
            return;
        }
        this.getActiveComponent().putClientProperty("completion-active", Boolean.TRUE);
        LogRecord r = new LogRecord(Level.FINE, "COMPL_INVOCATION");
        r.setParameters(new Object[]{explicitQuery});
        CompletionImpl.uilog(r);
        this.explicitQuery = explicitQuery;
        if (this.activeProviders != null) {
            this.completionAutoPopupTimer.stop();
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                if (explicitQuery && this.completionResult != null) {
                    CompletionResultSetImpl rSet;
                    Iterator iterator = this.completionResult.resultSets.iterator();
                    if (iterator.hasNext() && (rSet = (CompletionResultSetImpl)iterator.next()).getQueryType() == 9) {
                        return;
                    }
                    queryType = 9;
                }
            }
            this.completionCancel();
            this.completionQuery(delayQuery, queryType);
        }
    }

    void requestShowCompletionPane(Result result) {
        boolean noSuggestions;
        this.pleaseWaitTimer.stop();
        int size = 0;
        int qType = 0;
        List<CompletionResultSetImpl> completionResultSets = result.getResultSets();
        for (int i = completionResultSets.size() - 1; i >= 0; --i) {
            CompletionResultSetImpl resultSet = completionResultSets.get(i);
            size += resultSet.getItems().size();
            qType = resultSet.getQueryType();
        }
        ArrayList<? extends CompletionItem> resultItems = new ArrayList<CompletionItem>(size);
        String title = null;
        int anchorOffset = -1;
        boolean hasAdditionalItems = false;
        if (size > 0) {
            for (int i = 0; i < completionResultSets.size(); ++i) {
                CompletionResultSetImpl resultSet = completionResultSets.get(i);
                List<? extends CompletionItem> items = resultSet.getItems();
                if (items.size() <= 0) continue;
                resultItems.addAll(items);
                if (title == null) {
                    title = resultSet.getTitle();
                }
                if (!hasAdditionalItems) {
                    hasAdditionalItems = resultSet.hasAdditionalItems();
                }
                if (anchorOffset != -1) continue;
                anchorOffset = resultSet.getAnchorOffset();
            }
        }
        size = resultItems.size();
        final ArrayList<CompletionItem> sortedResultItems = new ArrayList<CompletionItem>(size);
        if (size > 0) {
            Collections.sort(resultItems, CompletionItemComparator.get(this.getSortType()));
            int cnt = 0;
            for (int i = 0; i < size; ++i) {
                CompletionItem item = (CompletionItem)resultItems.get(i);
                if (cnt < 25) {
                    if (!filter.accept(item)) continue;
                    sortedResultItems.add(item);
                } else {
                    sortedResultItems.add(item);
                }
                ++cnt;
            }
        }
        boolean bl = noSuggestions = sortedResultItems.size() == 0;
        if (noSuggestions && qType == 1) {
            this.showCompletion(this.explicitQuery, false, 9);
            return;
        }
        final String displayTitle = title;
        final int displayAnchorOffset = anchorOffset;
        final boolean displayAdditionalItems = hasAdditionalItems;
        Runnable requestShowRunnable = new Runnable(){

            @Override
            public void run() {
                JTextComponent c = CompletionImpl.this.getActiveComponent();
                int caretOffset = c.getSelectionStart();
                if (sortedResultItems.size() == 1 && !CompletionImpl.this.refreshedQuery && CompletionImpl.this.explicitQuery && CompletionSettings.INSTANCE.completionInstantSubstitution() && c.isEditable() && (!(c.getDocument() instanceof GuardedDocument) || !((GuardedDocument)c.getDocument()).isPosGuarded(caretOffset))) {
                    try {
                        CompletionItem item;
                        int[] block = Utilities.getIdentifierBlock(c, caretOffset);
                        if ((block == null || block[1] == caretOffset) && (item = (CompletionItem)sortedResultItems.get(0)).instantSubstitution(c)) {
                            return;
                        }
                    }
                    catch (BadLocationException block) {
                        // empty catch block
                    }
                }
                int selectedIndex = CompletionImpl.this.getCompletionPreSelectionIndex(sortedResultItems);
                CompletionImpl.this.getActiveComponent().putClientProperty("completion-visible", Boolean.TRUE);
                CompletionImpl.this.layout.showCompletion(noSuggestions ? Collections.singletonList(CompletionImpl.NO_SUGGESTIONS) : sortedResultItems, displayTitle, displayAnchorOffset, CompletionImpl.this, displayAdditionalItems ? CompletionImpl.this.completionShortcut : null, selectedIndex);
                CompletionImpl.this.pleaseWaitDisplayed = false;
                if (CompletionSettings.INSTANCE.documentationAutoPopup()) {
                    if (noSuggestions) {
                        CompletionImpl.this.docAutoPopupTimer.stop();
                        CompletionImpl.this.documentationCancel();
                        CompletionImpl.this.layout.hideDocumentation();
                    } else {
                        CompletionImpl.this.restartDocumentationAutoPopupTimer();
                    }
                }
            }
        };
        CompletionImpl.runInAWT(requestShowRunnable);
    }

    private int getCompletionPreSelectionIndex(List<CompletionItem> items) {
        String prefix = null;
        if (this.getActiveDocument() instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)this.getActiveDocument();
            int caretOffset = this.getActiveComponent().getSelectionStart();
            try {
                int[] block = Utilities.getIdentifierBlock(doc, caretOffset);
                if (block != null) {
                    block[1] = caretOffset;
                    prefix = doc.getText(block[0], block[1]);
                }
            }
            catch (BadLocationException block) {
                // empty catch block
            }
        }
        if (prefix != null && prefix.length() > 0) {
            int idx = 0;
            for (CompletionItem item : items) {
                CharSequence text = item.getInsertPrefix();
                if (text != null && text.toString().startsWith(prefix)) {
                    return idx;
                }
                ++idx;
            }
        }
        return 0;
    }

    public boolean hideCompletion() {
        return this.hideCompletion(true);
    }

    public boolean hideCompletion(boolean completionOnly) {
        this.completionCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(3, completionOnly));
            return false;
        }
        return this.hideCompletionPane(completionOnly);
    }

    private boolean hideCompletionPane(boolean completionOnly) {
        this.completionAutoPopupTimer.stop();
        this.pleaseWaitTimer.stop();
        boolean hidePerformed = this.layout.hideCompletion();
        this.pleaseWaitDisplayed = false;
        if (!completionOnly && hidePerformed && CompletionSettings.INSTANCE.documentationAutoPopup()) {
            this.hideDocumentation(true);
        }
        this.getActiveComponent().putClientProperty("completion-visible", Boolean.FALSE);
        this.getActiveComponent().putClientProperty("completion-active", Boolean.FALSE);
        return hidePerformed;
    }

    public void showDocumentation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(1));
            return;
        }
        if (this.activeProviders != null) {
            this.documentationCancel();
            this.layout.clearDocumentationHistory();
            this.documentationQuery();
        }
    }

    void requestShowDocumentationPane(Result result) {
        final CompletionResultSetImpl resultSet = CompletionImpl.findFirstValidResult(result.getResultSets());
        CompletionImpl.runInAWT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompletionImpl completionImpl = CompletionImpl.this;
                synchronized (completionImpl) {
                    if (resultSet != null) {
                        CompletionImpl.this.layout.showDocumentation(resultSet.getDocumentation(), resultSet.getAnchorOffset());
                    } else {
                        CompletionImpl.this.documentationCancel();
                        CompletionImpl.this.layout.hideDocumentation();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationQuery() {
        CompletionTask docTask;
        List<CompletionResultSetImpl> documentationResultSets;
        Result newDocumentationResult = new Result(1);
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            assert (this.docResult == null);
            this.docResult = newDocumentationResult;
            documentationResultSets = this.docResult.getResultSets();
        }
        CompletionItem selectedItem = this.layout.getSelectedCompletionItem();
        if (selectedItem != null) {
            this.lastSelectedItem = new WeakReference<CompletionItem>(selectedItem);
            docTask = selectedItem.createDocumentationTask();
            if (docTask != null) {
                CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newDocumentationResult, docTask, 2);
                documentationResultSets.add(resultSet);
            }
        } else {
            this.lastSelectedItem = null;
            for (int i = 0; i < this.activeProviders.length; ++i) {
                docTask = this.activeProviders[i].createTask(2, this.getActiveComponent());
                if (docTask == null) continue;
                CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newDocumentationResult, docTask, 2);
                documentationResultSets.add(resultSet);
            }
        }
        if (documentationResultSets.size() > 0) {
            CompletionImpl.queryResultSets(documentationResultSets);
            newDocumentationResult.queryInvoked();
        } else {
            this.documentationCancel();
            this.layout.hideDocumentation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationCancel() {
        Result oldDocumentationResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            oldDocumentationResult = this.docResult;
            this.docResult = null;
        }
        if (oldDocumentationResult != null) {
            oldDocumentationResult.cancel();
        }
    }

    public boolean hideDocumentation() {
        return this.hideDocumentation(true);
    }

    boolean hideDocumentation(boolean documentationOnly) {
        this.documentationCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(4, documentationOnly));
            return false;
        }
        return this.hideDocumentationPane(documentationOnly);
    }

    boolean hideDocumentationPane(boolean documentationOnly) {
        this.docAutoPopupTimer.stop();
        boolean hidePerformed = this.layout.hideDocumentation();
        if (!documentationOnly && hidePerformed && CompletionSettings.INSTANCE.documentationAutoPopup()) {
            this.hideCompletion(true);
        }
        return hidePerformed;
    }

    public void showToolTip() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(2));
            return;
        }
        if (this.activeProviders != null) {
            this.toolTipCancel();
            this.toolTipQuery();
        }
    }

    void requestShowToolTipPane(Result result) {
        final CompletionResultSetImpl resultSet = CompletionImpl.findFirstValidResult(result.getResultSets());
        CompletionImpl.runInAWT(new Runnable(){

            @Override
            public void run() {
                if (resultSet != null) {
                    CompletionImpl.this.layout.showToolTip(resultSet.getToolTip(), resultSet.getAnchorOffset());
                } else {
                    CompletionImpl.this.hideToolTip();
                }
            }
        });
    }

    public void startPopup(JTextComponent component) {
        Document document;
        boolean cancel = false;
        if (component != this.getActiveComponent()) {
            this.activeProviders = this.getCompletionProvidersForComponent(component);
            if (debug) {
                StringBuffer sb = new StringBuffer("Completion PROVIDERS:\n");
                if (this.activeProviders != null) {
                    for (int i = 0; i < this.activeProviders.length; ++i) {
                        sb.append("providers[");
                        sb.append(i);
                        sb.append("]: ");
                        sb.append(this.activeProviders[i].getClass());
                        sb.append('\n');
                    }
                }
                logger.fine(sb.toString());
            }
            if (this.getActiveComponent() != null) {
                this.getActiveComponent().removeCaretListener(this);
                this.getActiveComponent().removeKeyListener(this);
                this.getActiveComponent().removeFocusListener(this);
                this.getActiveComponent().removeMouseListener(this);
            }
            if (component != null && this.activeProviders != null) {
                component.addCaretListener(this);
                component.addKeyListener(this);
                component.addFocusListener(this);
                component.addMouseListener(this);
            }
            this.activeComponent = component != null ? new WeakReference<JTextComponent>(component) : null;
            CompletionSettings.INSTANCE.notifyEditorComponentChange(this.getActiveComponent());
            this.layout.setEditorComponent(this.getActiveComponent());
            this.installKeybindings();
            cancel = true;
        }
        Document document2 = document = component == null ? null : component.getDocument();
        if (component != null && document != this.getActiveDocument()) {
            this.activeProviders = this.getCompletionProvidersForComponent(component);
            if (debug) {
                StringBuffer sb = new StringBuffer("Completion PROVIDERS:\n");
                if (this.activeProviders != null) {
                    for (int i = 0; i < this.activeProviders.length; ++i) {
                        sb.append("providers[");
                        sb.append(i);
                        sb.append("]: ");
                        sb.append(this.activeProviders[i].getClass());
                        sb.append('\n');
                    }
                }
                logger.fine(sb.toString());
            }
            this.activeDocument = new WeakReference<Document>(document);
            cancel = true;
        }
        if (cancel) {
            this.completionCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipQuery() {
        CompletionTask toolTipTask;
        Result newToolTipResult = new Result(1);
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            assert (this.toolTipResult == null);
            this.toolTipResult = newToolTipResult;
        }
        List<CompletionResultSetImpl> toolTipResultSets = newToolTipResult.getResultSets();
        CompletionItem selectedItem = this.layout.getSelectedCompletionItem();
        if (selectedItem != null && (toolTipTask = selectedItem.createToolTipTask()) != null) {
            CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newToolTipResult, toolTipTask, 4);
            toolTipResultSets.add(resultSet);
        } else {
            for (int i = 0; i < this.activeProviders.length; ++i) {
                toolTipTask = this.activeProviders[i].createTask(4, this.getActiveComponent());
                if (toolTipTask == null) continue;
                CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newToolTipResult, toolTipTask, 4);
                toolTipResultSets.add(resultSet);
            }
        }
        CompletionImpl.queryResultSets(toolTipResultSets);
        newToolTipResult.queryInvoked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipRefresh() {
        Result localToolTipResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            localToolTipResult = this.toolTipResult;
        }
        if (localToolTipResult != null) {
            Result refreshResult = localToolTipResult.createRefreshResult();
            CompletionImpl completionImpl2 = this;
            synchronized (completionImpl2) {
                this.toolTipResult = refreshResult;
            }
            refreshResult.invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipCancel() {
        Result oldToolTipResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            oldToolTipResult = this.toolTipResult;
            this.toolTipResult = null;
        }
        if (oldToolTipResult != null) {
            oldToolTipResult.cancel();
        }
    }

    public boolean hideToolTip() {
        this.toolTipCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(5));
            return false;
        }
        return this.hideToolTipPane();
    }

    boolean hideToolTipPane() {
        return this.layout.hideToolTip();
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke ... defaultKey) {
        KeyStroke[] ret = defaultKey;
        if (editorActionName != null && this.getActiveComponent() != null) {
            TextUI ui = this.getActiveComponent().getUI();
            Keymap km = this.getActiveComponent().getKeymap();
            if (ui == null || km != null) {
                // empty if block
            }
        }
        return ret;
    }

    private void installKeybindings() {
        this.actionMap = new ActionMap();
        this.inputMap = new InputMap();
        this.completionShortcut = null;
        KeyStroke[] keys = JythonCompletionProvider.getInstance().settings().isTabIsCompletion() ? this.findEditorKeys("completion", KeyStroke.getKeyStroke(32, 2), KeyStroke.getKeyStroke(9, 0)) : this.findEditorKeys("completion", KeyStroke.getKeyStroke(32, 2));
        for (int i = 0; i < keys.length; ++i) {
            this.inputMap.put(keys[i], COMPLETION_SHOW);
            if (this.completionShortcut != null) continue;
            this.completionShortcut = CompletionImpl.getKeyStrokeAsText(keys[i]);
        }
        if (this.completionShortcut == null) {
            this.completionShortcut = "'Ctrl+SPACE'";
        }
        this.actionMap.put(COMPLETION_SHOW, new CompletionShowAction(1));
    }

    private static String getKeyStrokeAsText(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        StringBuffer sb = new StringBuffer();
        sb.append('\'');
        if ((modifiers & 0x80) > 0) {
            sb.append("Ctrl+");
        }
        if ((modifiers & 0x200) > 0) {
            sb.append("Alt+");
        }
        if ((modifiers & 0x40) > 0) {
            sb.append("Shift+");
        }
        if ((modifiers & 0x100) > 0) {
            sb.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            sb.append("" + KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0));
        }
        sb.append('\'');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishNotify(CompletionResultSetImpl finishedResult) {
        boolean finished = false;
        switch (finishedResult.getQueryType()) {
            case 1: 
            case 9: {
                Result localResult;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    localResult = this.completionResult;
                    if (finishedResult.getResultId() == localResult) {
                        finished = CompletionImpl.isAllResultsFinished(localResult.getResultSets());
                    }
                }
                if (!finished) break;
                this.requestShowCompletionPane(localResult);
                break;
            }
            case 2: {
                Result localResult;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    localResult = this.docResult;
                    if (finishedResult.getResultId() == localResult) {
                        finished = CompletionImpl.isAllResultsFinished(localResult.getResultSets());
                    }
                }
                if (!finished) break;
                this.requestShowDocumentationPane(localResult);
                break;
            }
            case 4: {
                Result localResult;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    localResult = this.toolTipResult;
                    if (finishedResult.getResultId() == localResult) {
                        finished = CompletionImpl.isAllResultsFinished(localResult.getResultSets());
                    }
                }
                if (!finished) break;
                this.requestShowToolTipPane(localResult);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean isAllResultsFinished(List<CompletionResultSetImpl> resultSets) {
        for (int i = resultSets.size() - 1; i >= 0; --i) {
            CompletionResultSetImpl result = resultSets.get(i);
            if (result.isFinished()) continue;
            if (debug) {
                logger.fine("CompletionTask: " + result.getTask() + " not finished yet");
            }
            return false;
        }
        if (debug) {
            logger.fine("----- All tasks finished -----");
        }
        return true;
    }

    private static CompletionResultSetImpl findFirstValidResult(List<CompletionResultSetImpl> resultSets) {
        block4: for (int i = 0; i < resultSets.size(); ++i) {
            CompletionResultSetImpl result = resultSets.get(i);
            switch (result.getQueryType()) {
                case 2: {
                    if (result.getDocumentation() == null) continue block4;
                    return result;
                }
                case 4: {
                    if (result.getToolTip() == null) continue block4;
                    return result;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return null;
    }

    private static void runInAWT(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    CompletionLayout testGetCompletionLayout() {
        return this.layout;
    }

    void testSetActiveComponent(JTextComponent component) {
        this.activeComponent = new WeakReference<JTextComponent>(component);
    }

    public void setTabIsCompletion(boolean b) {
        this.tabIsCompletion = b;
        if (!b) {
            this.inputMap.remove(KeyStroke.getKeyStroke(9, 0));
        } else {
            this.inputMap.put(KeyStroke.getKeyStroke(9, 0), COMPLETION_SHOW);
        }
    }

    private static void queryResultSets(List<CompletionResultSetImpl> resultSets) {
        for (int i = 0; i < resultSets.size(); ++i) {
            CompletionResultSetImpl resultSet = resultSets.get(i);
            resultSet.getTask().query(resultSet.getResultSet());
        }
    }

    private static void createRefreshResultSets(List<CompletionResultSetImpl> resultSets, Result refreshResult) {
        List<CompletionResultSetImpl> refreshResultSets = refreshResult.getResultSets();
        int size = resultSets.size();
        for (int i = 0; i < size; ++i) {
            CompletionResultSetImpl result = resultSets.get(i);
            result.markInactive();
            result = new CompletionResultSetImpl(result.getCompletionImpl(), refreshResult, result.getTask(), result.getQueryType());
            refreshResultSets.add(result);
        }
    }

    private static void refreshResultSets(List<CompletionResultSetImpl> resultSets, boolean beforeQuery) {
        try {
            int size = resultSets.size();
            for (int i = 0; i < size; ++i) {
                CompletionResultSetImpl result = resultSets.get(i);
                result.getTask().refresh(beforeQuery ? null : result.getResultSet());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void cancelResultSets(List<CompletionResultSetImpl> resultSets) {
        int size = resultSets.size();
        for (int i = 0; i < size; ++i) {
            CompletionResultSetImpl result = resultSets.get(i);
            result.markInactive();
            result.getTask().cancel();
        }
    }

    public CompletionResultSetImpl createTestResultSet(CompletionTask task, int queryType) {
        return new CompletionResultSetImpl(this, "TestResult", task, queryType);
    }

    static void uilog(LogRecord rec) {
        UI_LOG.log(rec);
    }

    private final class CompletionShowAction
    extends AbstractAction {
        private int queryType;

        private CompletionShowAction(int queryType) {
            this.queryType = queryType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompletionImpl.this.showCompletion(true, false, this.queryType);
        }
    }

    private final class DocShowAction
    extends AbstractAction {
        private DocShowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompletionImpl.this.showDocumentation();
        }
    }

    private final class ParamRunnable
    implements Runnable {
        private static final int SHOW_COMPLETION = 0;
        private static final int SHOW_DOCUMENTATION = 1;
        private static final int SHOW_TOOL_TIP = 2;
        private static final int HIDE_COMPLETION_PANE = 3;
        private static final int HIDE_DOCUMENTATION_PANE = 4;
        private static final int HIDE_TOOL_TIP_PANE = 5;
        private final int opCode;
        private final boolean explicit;
        private final boolean delayQuery;
        private final int type;

        ParamRunnable(int opCode) {
            this(opCode, false);
        }

        ParamRunnable(int opCode, boolean explicit) {
            this(opCode, explicit, false, 1);
        }

        ParamRunnable(int opCode, boolean explicit, boolean delayQuery, int type) {
            this.opCode = opCode;
            this.explicit = explicit;
            this.delayQuery = delayQuery;
            this.type = type;
        }

        @Override
        public void run() {
            switch (this.opCode) {
                case 0: {
                    CompletionImpl.this.showCompletion(CompletionImpl.this.explicitQuery, this.delayQuery, this.type);
                    break;
                }
                case 1: {
                    CompletionImpl.this.showDocumentation();
                    break;
                }
                case 2: {
                    CompletionImpl.this.showToolTip();
                    break;
                }
                case 3: {
                    CompletionImpl.this.hideCompletionPane(this.explicit);
                    break;
                }
                case 4: {
                    CompletionImpl.this.hideDocumentationPane(this.explicit);
                    break;
                }
                case 5: {
                    CompletionImpl.this.hideToolTipPane();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    static final class Result {
        private final List<CompletionResultSetImpl> resultSets;
        private boolean invoked;
        private boolean cancelled;
        private boolean beforeQuery = true;

        Result(int resultSetsSize) {
            this.resultSets = new ArrayList<CompletionResultSetImpl>(resultSetsSize);
        }

        List<CompletionResultSetImpl> getResultSets() {
            return this.resultSets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            boolean fin;
            Result result = this;
            synchronized (result) {
                assert (!this.cancelled);
                fin = this.invoked;
                if (!this.invoked) {
                    this.cancelled = true;
                }
            }
            if (fin) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
        }

        synchronized boolean isQueryInvoked() {
            return this.invoked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean queryInvoked() {
            boolean canc;
            Result result = this;
            synchronized (result) {
                assert (!this.invoked);
                this.invoked = true;
                canc = this.cancelled;
                this.beforeQuery = false;
            }
            if (canc) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
            return canc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result createRefreshResult() {
            Result result = this;
            synchronized (result) {
                if (this.cancelled) {
                    return null;
                }
                if (this.beforeQuery) {
                    return this;
                }
                assert (this.invoked);
                this.invoked = false;
            }
            Result refreshResult = new Result(this.getResultSets().size());
            refreshResult.beforeQuery = this.beforeQuery;
            CompletionImpl.createRefreshResultSets(this.resultSets, refreshResult);
            return refreshResult;
        }

        void invokeRefresh() {
            CompletionImpl.refreshResultSets(this.getResultSets(), this.beforeQuery);
            if (!this.beforeQuery) {
                this.queryInvoked();
            }
        }
    }

    private final class ToolTipShowAction
    extends AbstractAction {
        private ToolTipShowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompletionImpl.this.showToolTip();
        }
    }
}

