/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.SimplifyScriptSupport;
import org.autoplot.jythonsupport.Util;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.CompletionSupport;
import org.das2.jythoncompletion.DataSetUrlCompletionTask;
import org.das2.jythoncompletion.DefaultCompletionItem;
import org.das2.jythoncompletion.JavadocLookup;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.MessageCompletionItem;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.python.core.PyClass;
import org.python.core.PyClassPeeker;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaClassPeeker;
import org.python.core.PyJavaInstance;
import org.python.core.PyJavaInstancePeeker;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyMethodPeeker;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PyReflectedFunctionPeeker;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTableCode;
import org.python.util.PythonInterpreter;

public class JythonCompletionTask
implements CompletionTask {
    private static final Logger logger = LoggerManager.getLogger("jython.editor.completion");
    public static final String CLIENT_PROPERTY_INTERPRETER_PROVIDER = "JYTHON_INTERPRETER_PROVIDER";
    JTextComponent editor;
    private final JythonInterpreterProvider jythonInterpreterProvider;

    public JythonCompletionTask(JTextComponent t) {
        this.editor = t;
        this.jythonInterpreterProvider = (JythonInterpreterProvider)t.getClientProperty(CLIENT_PROPERTY_INTERPRETER_PROVIDER);
    }

    private Method getReadMethod(PyObject context, PyObject po, Class dc, String propName) {
        try {
            String methodName = "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Method m = dc.getMethod(methodName, new Class[0]);
            return m;
        }
        catch (NoSuchMethodException ex) {
            if (po instanceof PyInteger) {
                String methodName = "is" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                try {
                    Method m = dc.getMethod(methodName, new Class[0]);
                    return m;
                }
                catch (NoSuchMethodException | SecurityException ex2) {
                    return null;
                }
            }
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public void query(CompletionResultSet arg0) throws PyException {
        try {
            JythonCompletionProvider.getInstance().setMessage("busy: getting completions");
            CompletionContext cc = CompletionSupport.getCompletionContext(this.editor);
            if (cc == null) {
                logger.fine("no completion context");
            } else {
                this.doQuery(cc, arg0);
            }
        }
        catch (BadLocationException ex) {
            logger.log(Level.WARNING, null, ex);
            arg0.addItem(new MessageCompletionItem(ex.getMessage()));
        }
        finally {
            JythonCompletionProvider.getInstance().setMessage("done getting completions");
            arg0.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doQuery(CompletionContext cc, CompletionResultSet arg0) {
        int c = 0;
        try {
            switch (cc.contextType) {
                case "module": {
                    c = this.queryModules(cc, arg0);
                    break;
                }
                case "package": {
                    c = this.queryPackages(cc, arg0);
                    break;
                }
                case "default": {
                    c = this.queryNames(cc, arg0);
                    break;
                }
                case "method": {
                    c = this.queryMethods(cc, arg0);
                    break;
                }
                case "stringLiteralArgument": {
                    c = this.queryStringLiteralArgument(cc, arg0);
                    break;
                }
                case "commandArgument": {
                    c = this.queryCommandArgument(cc, arg0);
                    c += this.queryNames(cc, arg0);
                    break;
                }
            }
        }
        catch (BadLocationException ex) {
            logger.log(Level.WARNING, null, ex);
            if (arg0 != null) {
                arg0.addItem(new MessageCompletionItem(ex.getMessage()));
            }
        }
        return c;
    }

    private Method getJavaMethod(PyMethod m, int i) {
        PyMethodPeeker mpeek = new PyMethodPeeker(m);
        return new PyReflectedFunctionPeeker(mpeek.getReflectedFunction()).getMethod(i);
    }

    private int getMethodCount(PyMethod m) {
        PyMethodPeeker mpeek = new PyMethodPeeker(m);
        return new PyReflectedFunctionPeeker(mpeek.getReflectedFunction()).getArgsCount();
    }

    private int queryMethods(CompletionContext cc, CompletionResultSet rs) throws BadLocationException {
        PyList po2;
        PyObject lcontext;
        String eval;
        logger.fine("queryMethods");
        PythonInterpreter interp = this.getInterpreter();
        if (JythonCompletionProvider.getInstance().settings().isSafeCompletions()) {
            String eval1;
            eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
            eval = eval1 = SimplifyScriptSupport.removeSideEffects(eval);
        } else {
            eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
        }
        if (eval.endsWith(":\n")) {
            eval = eval + "  pass\n";
        }
        this.putInGetDataSetStub(interp);
        try {
            interp.exec(JythonRefactory.fixImports(eval));
        }
        catch (PyException ex) {
            String eval1;
            eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
            eval = eval1 = SimplifyScriptSupport.removeSideEffects(eval);
            if (eval.endsWith(":\n")) {
                eval = eval + "  pass\n";
            }
            try {
                eval = JythonCompletionTask.sanitizeLeaveImports(eval);
                interp.exec(eval);
            }
            catch (PyException ex2) {
                rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex2.toString()));
                return 0;
            }
        }
        catch (IOException ex) {
            rs.addItem(new MessageCompletionItem("Exception occurred: " + ex.toString()));
            return 0;
        }
        try {
            lcontext = interp.eval(cc.contextString);
        }
        catch (PyException ex) {
            rs.addItem(new MessageCompletionItem("Eval error: " + cc.contextString, ex.toString()));
            return 0;
        }
        try {
            po2 = (PyList)lcontext.__dir__();
        }
        catch (PyException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return 0;
        }
        int count = 0;
        for (int i = 0; i < po2.__len__(); ++i) {
            String args;
            String signature;
            String label;
            boolean notAlreadyAdded;
            String ss;
            block60: {
                Class dc;
                Object peek;
                Object m;
                PyObject po;
                PyString s = (PyString)po2.__getitem__(i);
                ss = s.toString();
                logger.log(Level.FINEST, "does {0} start {1}", new Object[]{cc.completable, ss});
                if (!ss.startsWith(cc.completable)) continue;
                notAlreadyAdded = true;
                try {
                    po = lcontext.__getattr__(s);
                }
                catch (PyException e) {
                    logger.log(Level.FINE, "PyException from \"{0}\":", ss);
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                label = ss;
                signature = null;
                args = "";
                if (lcontext instanceof PyJavaClass) {
                    if (po.getClass().toString().equals("class org.python.core.PyReflectedConstructor")) {
                        args = "()";
                        signature = "";
                    } else if (po instanceof PyReflectedFunction) {
                        m = new PyReflectedFunctionPeeker((PyReflectedFunction)po).getMethod(0);
                        signature = JythonCompletionTask.methodSignature((Method)m);
                        args = JythonCompletionTask.methodArgs((Method)m);
                    } else if (po instanceof PyString || po instanceof PyJavaInstance) {
                        Class c = new PyClassPeeker((PyClass)((PyJavaClass)lcontext)).getJavaClass();
                        try {
                            Field f = c.getField(ss);
                            signature = this.fieldSignature(f);
                        }
                        catch (NoSuchFieldException f) {}
                    }
                } else if (lcontext instanceof PyJavaPackage) {
                    if (po instanceof PyJavaClass) {
                        Class dc2 = new PyJavaClassPeeker((PyJavaClass)po).getProxyClass();
                        if (dc2.getConstructors().length > 0) {
                            Constructor<?> constructor = dc2.getConstructors()[0];
                            signature = this.constructorSignature(constructor);
                            args = JythonCompletionTask.argsList(constructor.getParameterTypes());
                            signature = signature + args;
                        } else {
                            signature = dc2.getCanonicalName().replaceAll("\\.", "/") + ".html";
                        }
                    } else if (po instanceof PyJavaPackage) {
                        // empty if block
                    }
                } else if (lcontext instanceof PyClass) {
                    peek = new PyClassPeeker((PyClass)lcontext);
                    dc = ((PyClassPeeker)peek).getJavaClass();
                    Field f = null;
                    try {
                        f = dc.getField(label);
                    }
                    catch (NoSuchFieldException | SecurityException exception) {
                        // empty catch block
                    }
                    if (f == null) continue;
                    signature = this.fieldSignature(f);
                } else if (lcontext instanceof PyJavaInstance) {
                    if (po instanceof PyMethod) {
                        m = (PyMethod)po;
                        try {
                            for (int im = 0; im < this.getMethodCount((PyMethod)m); ++im) {
                                Method jm = this.getJavaMethod((PyMethod)m, im);
                                signature = JythonCompletionTask.methodSignature(jm);
                                args = JythonCompletionTask.methodArgs(jm);
                                label = ss + args;
                                String link = JythonCompletionTask.getLinkForJavaSignature(signature);
                                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link));
                                ++count;
                                notAlreadyAdded = false;
                            }
                            break block60;
                        }
                        catch (RuntimeException ex) {
                            logger.fine(ex.toString());
                            continue;
                        }
                    }
                    peek = new PyJavaInstancePeeker((PyJavaInstance)lcontext);
                    dc = ((PyJavaInstancePeeker)peek).getInstanceClass();
                    Method propReadMethod = this.getReadMethod(lcontext, po, dc, label);
                    if (propReadMethod != null) {
                        signature = JythonCompletionTask.methodSignature(propReadMethod);
                        args = "";
                        String type = propReadMethod.getReturnType().getCanonicalName();
                        label = ss + " <i>(" + type + ")</i>";
                    } else {
                        Field f = null;
                        try {
                            f = dc.getField(label);
                        }
                        catch (NoSuchFieldException ex) {
                            logger.log(Level.FINEST, "NoSuchFieldException for item {0}", s);
                        }
                        catch (SecurityException ex) {
                            logger.log(Level.FINEST, "SecurityException for item {0}", s);
                        }
                        if (f == null) continue;
                        signature = this.fieldSignature(f);
                        label = ss;
                    }
                } else if (lcontext instanceof PyObject) {
                    label = ss;
                    signature = null;
                    if (po instanceof PyMethod) {
                        PyObject doc;
                        PyMethod pm = (PyMethod)po;
                        PyObject pm2 = pm.im_func;
                        if (pm2 instanceof PyFunction && (doc = ((PyFunction)pm2).__doc__) != null) {
                            signature = doc instanceof PyNone ? "(No documentation)" : doc.toString();
                            String[] ss2 = signature.split("\n");
                            if (ss2.length > 1) {
                                for (int jj = 0; jj < ss2.length; ++jj) {
                                    ss2[jj] = JythonCompletionTask.escapeHtml(ss2[jj]);
                                }
                                String sig = JythonCompletionTask.getPyFunctionSignature((PyFunction)pm2);
                                signature = !signature.startsWith("<html>") ? "<html><b>" + sig + "</b><br><br>" + JythonCompletionTask.join(ss2, "<br>") + "</html>" : "<html><b>" + sig + "</b><br><br>" + signature.substring(6) + "</html>";
                            }
                            signature = "inline:" + signature;
                        }
                    }
                } else if (po instanceof PyReflectedFunction) {
                    label = ss + "() STATIC JAVA";
                } else if (po.isCallable()) {
                    label = ss + "() " + (lcontext instanceof PyJavaInstance ? "JAVA" : "");
                    m = (PyMethod)po;
                    signature = JythonCompletionTask.methodSignature(this.getJavaMethod((PyMethod)m, 0));
                } else {
                    logger.fine("");
                }
            }
            if (!notAlreadyAdded) continue;
            if (signature != null && signature.startsWith("inline:")) {
                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, signature));
            } else {
                String link = JythonCompletionTask.getLinkForJavaSignature(signature);
                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link));
            }
            ++count;
        }
        return count;
    }

    private int queryModules(CompletionContext cc, CompletionResultSet rs) {
        logger.fine("queryModules");
        PythonInterpreter interp = this.getInterpreter();
        String eval = "targetComponents = '" + cc.contextString + "'.split('.')\nbase = targetComponents[0]\nbaseModule = __import__(base, globals(), locals())\nmodule = baseModule    \nfor component in targetComponents[1:]:\n    module = getattr(module, component)\nlist = dir(module)\nif ( list.count('__name__')>0 ):\n    list.remove('__name__')\nlist.append('*')\nlist";
        try {
            interp.exec(eval);
        }
        catch (PyException ex) {
            if (rs != null) {
                rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
            }
            return 0;
        }
        int count = 0;
        PyList po2 = (PyList)interp.eval("list");
        for (int i = 0; i < po2.__len__(); ++i) {
            String link;
            String signature;
            PyString s = (PyString)po2.__getitem__(i);
            String ss = s.toString();
            if (!ss.startsWith(cc.completable)) continue;
            String javaClass = cc.contextString + "." + ss;
            if (ss.length() > 0 && Character.isUpperCase(ss.charAt(0))) {
                signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + ".html";
                link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
            } else {
                signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + "/package-summary.html";
                link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
            }
            if (link != null) {
                link = link + "#skip.navbar.top";
            }
            if (rs != null) {
                rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss, ss, link));
            }
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryPackages(CompletionContext cc, CompletionResultSet rs) {
        logger.fine("queryPackages");
        PythonInterpreter interp = this.getInterpreter();
        HashSet<String> results = new HashSet<String>();
        int count = 0;
        if (!cc.contextString.equals(cc.completable)) {
            String eval = "import " + cc.contextString + "\ntargetComponents = '" + cc.contextString + "'.split('.')\nbase = targetComponents[0]\nbaseModule = __import__(base, globals(), locals(), [], -1 )\nmodule = baseModule    \nname= base\nfor component in targetComponents[1:]:\n    name= name + '.' + component\n    baseModule = __import__( name, None, None )\n    module = getattr(module, component)\nlist = dir(module)\nif ( '__name__' in list ): list.remove('__name__')\nlist\n";
            try {
                interp.exec(eval);
            }
            catch (PyException ex) {
                if (rs != null) {
                    rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
                }
                return 0;
            }
            PyList po2 = (PyList)interp.eval("list");
            for (int i = 0; i < po2.__len__(); ++i) {
                String link;
                String signature;
                PyString s = (PyString)po2.__getitem__(i);
                String ss = s.toString();
                if (!ss.startsWith(cc.completable)) continue;
                String javaClass = cc.contextString + "." + ss;
                if (ss.length() > 0 && Character.isUpperCase(ss.charAt(0))) {
                    signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + ".html";
                    link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
                } else {
                    signature = JythonCompletionTask.join(javaClass.split("\\."), "/") + "/package-summary.html";
                    link = JavadocLookup.getInstance().getLinkForJavaSignature(signature);
                }
                if (link != null) {
                    link = link + "#skip.navbar.top";
                }
                if (rs != null) {
                    rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss, ss, link));
                }
                ++count;
                results.add(ss);
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(JythonCompletionTask.class.getResourceAsStream("packagelist.txt")));
            String ss = reader.readLine();
            String search = cc.contextString + "." + cc.completable;
            int plen = cc.contextString.length() + 1;
            if (cc.contextString.equals(cc.completable)) {
                search = cc.contextString;
                plen = search.length();
            }
            while (ss != null) {
                if (!ss.startsWith("#") && ss.length() > 0 && ss.startsWith(search) && !results.contains(ss.substring(plen))) {
                    String link = "http://www-pw.physics.uiowa.edu/~jbf/autoplot/javadoc/" + ss.replaceAll("\\.", "/") + "/package-summary.html";
                    if (rs != null) {
                        rs.addItem(new DefaultCompletionItem(ss, search.length(), ss, ss, link));
                    }
                    ++count;
                }
                ss = reader.readLine();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
        return count;
    }

    private static String join(String[] list, String delim) {
        return JythonCompletionTask.join(Arrays.asList(list), delim);
    }

    private static String join(List<String> list, String delim) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            result.append(delim).append(list.get(i));
        }
        return result.toString();
    }

    private static String popOffComments(String s) {
        char inString = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            if (inString == '\u0000' && s.charAt(i) == '#') {
                return s.substring(0, i);
            }
            if (s.charAt(i) != '\'' && s.charAt(i) != '\"') continue;
            inString = s.charAt(i) == inString ? (char)'\u0000' : s.charAt(i);
        }
        return s;
    }

    private static String popDoc(String line, BufferedReader read) throws IOException {
        String lin = line.trim();
        if (lin.startsWith("\"") && lin.endsWith("\"")) {
            return line;
        }
        if (lin.startsWith("'") && lin.endsWith("'")) {
            return line;
        }
        if (lin.startsWith("\"\"\"") || lin.startsWith("'''")) {
            String term = lin.substring(0, 3);
            if (lin.endsWith(term)) {
                return line;
            }
            StringBuilder build = new StringBuilder(line);
            build.append("\n");
            line = read.readLine();
            while (line != null) {
                build.append(line).append("\n");
                lin = line.trim();
                if (lin.endsWith(term)) break;
                line = read.readLine();
            }
            if (line == null) {
                throw new IllegalArgumentException("unterminated string");
            }
            return build.toString();
        }
        return null;
    }

    private static String sanitizeLeaveImports(String src) {
        return SimplifyScriptSupport.simplifyScriptToCompletions(src);
    }

    private void putInGetDataSetStub(PythonInterpreter interp) {
        String ss2 = "def getDataSet( st, tr=None, mon=None ):\n   return findgen(100)\n\n";
        logger.finer(ss2);
        interp.exec(ss2);
    }

    private int queryNames(CompletionContext cc, CompletionResultSet rs) throws BadLocationException {
        String[] keywords;
        logger.fine("queryNames");
        int count = 0;
        for (String kw : keywords = new String[]{"assert", "def", "elif", "except", "from", "for", "finally", "import", "while", "print", "raise"}) {
            if (!kw.startsWith(cc.completable)) continue;
            if (rs != null) {
                rs.addItem(new DefaultCompletionItem(kw, cc.completable.length(), kw, kw, null, 0));
            }
            ++count;
        }
        PythonInterpreter interp = this.getInterpreter();
        int eolnCarot = Utilities.getRowStart(this.editor, this.editor.getCaretPosition());
        String eval = this.editor.getText(0, eolnCarot);
        if (eolnCarot > 0) {
            int startLastLine = Utilities.getRowStart(this.editor, eolnCarot - 1);
            String lastLine = this.editor.getText(startLastLine, eolnCarot - startLastLine);
            Matcher m = Pattern.compile("def .*").matcher(lastLine.trim());
            if (m.matches()) {
                int i = lastLine.indexOf("def ");
                String indent = lastLine.substring(0, i);
                eval = eval + indent + "\t__dummy__=1\n";
            }
        }
        if (JythonCompletionProvider.getInstance().settings().isSafeCompletions()) {
            eval = JythonCompletionTask.sanitizeLeaveImports(eval);
        }
        try {
            interp.exec(JythonRefactory.fixImports(eval));
        }
        catch (PyException ex) {
            if (rs != null) {
                rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
            }
            return 0;
        }
        catch (IOException ex) {
            if (rs != null) {
                rs.addItem(new MessageCompletionItem("Error with completions", ex.toString()));
            }
            return 0;
        }
        return count + JythonCompletionTask.getLocalsCompletions(interp, cc, rs);
    }

    private static String argsList(Class[] classes) {
        String LPAREN = "(";
        String RPAREN = ")";
        String SPACE = " ";
        StringBuilder sig = new StringBuilder();
        sig.append(LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class arg : classes) {
            sargs.add(arg.getSimpleName());
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private static String methodArgs(Method javaMethod) {
        return JythonCompletionTask.argsList(javaMethod.getParameterTypes());
    }

    private static String constructorSignatureNew(Constructor c) {
        String n = c.getName();
        String javadocPath = JythonCompletionTask.join(n.split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        String LPAREN = "(";
        String RPAREN = ")";
        String name = c.getName();
        int i = name.lastIndexOf(".");
        if (i > -1) {
            name = name.substring(i + 1);
        }
        sig.append("#").append(name).append(LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class<?> arg : c.getParameterTypes()) {
            sargs.add(arg.getCanonicalName());
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private static String getCanonicalName(Class clas) {
        Package p = clas.getPackage();
        if (p != null && p.getName().endsWith("org.python.core")) {
            return clas.getSimpleName();
        }
        return clas.getCanonicalName();
    }

    private static String methodSignature(Method javaMethod) {
        String n = javaMethod.getDeclaringClass().getCanonicalName();
        if (n == null) {
            return "<inner>";
        }
        String javadocPath = JythonCompletionTask.join(n.split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        String LPAREN = "(";
        String RPAREN = ")";
        String SPACE = " ";
        sig.append("#").append(javaMethod.getName()).append(LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class<?> arg : javaMethod.getParameterTypes()) {
            sargs.add(JythonCompletionTask.getCanonicalName(arg));
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private String fieldSignature(Field f) {
        String javadocPath = JythonCompletionTask.join(f.getDeclaringClass().getCanonicalName().split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        sig.append("#").append(f.getName());
        return sig.toString();
    }

    private String constructorSignature(Constructor f) {
        String javadocPath = JythonCompletionTask.join(f.getDeclaringClass().getCanonicalName().split("\\."), "/") + ".html";
        StringBuilder sig = new StringBuilder(javadocPath);
        int i = f.getName().lastIndexOf(".");
        sig.append("#").append(f.getName().substring(i + 1));
        return sig.toString();
    }

    private int queryStringLiteralArgument(CompletionContext cc, CompletionResultSet arg0) {
        String method = cc.contextString;
        int[] pos = new int[2];
        String s = DataSetUrlCompletionTask.popString(this.editor, pos);
        if (method.equals("getDataSet") || method.equals("plot") || method.equals("plotx") || method.equals("getCompletions")) {
            DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
            task.query(arg0);
        } else if (method.equals("File") && s.startsWith("/")) {
            DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
            task.query(arg0);
        } else if (s.startsWith("/")) {
            DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
            task.query(arg0);
        }
        return 0;
    }

    private int queryCommandArgument(CompletionContext cc, CompletionResultSet result) throws BadLocationException {
        logger.fine("queryCommandArgument");
        String method = cc.contextString;
        PythonInterpreter interp = this.getInterpreter();
        String eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
        if (JythonCompletionProvider.getInstance().settings().isSafeCompletions()) {
            eval = JythonCompletionTask.sanitizeLeaveImports(eval);
        }
        try {
            interp.exec(eval);
        }
        catch (PyException ex) {
            result.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
            return 0;
        }
        PyObject po = interp.eval(method);
        PyObject doc = interp.eval(method + ".__doc__");
        if (po instanceof PyFunction) {
            method = JythonCompletionTask.getPyFunctionSignature((PyFunction)po);
            String signature = JythonCompletionTask.makeInlineSignature(po, doc);
            result.addItem(new MessageCompletionItem(method, signature));
        } else if (po instanceof PyReflectedFunction) {
            PyReflectedFunction prf = (PyReflectedFunction)po;
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<String> signatures = new ArrayList<String>();
            ArrayList<String> argss = new ArrayList<String>();
            JythonCompletionTask.doPyReflectedFunction(eval, prf, labels, signatures, argss);
            for (int jj = 0; jj < labels.size(); ++jj) {
                String signature = (String)signatures.get(jj);
                if (signature == null) continue;
                String link = JythonCompletionTask.getLinkForJavaSignature(signature);
                DefaultCompletionItem item = new DefaultCompletionItem(method, 0, signature, (String)labels.get(jj), link);
                item.setReferenceOnly(true);
                result.addItem(item);
            }
        } else {
            String signature = JythonCompletionTask.makeInlineSignature(po, doc);
            result.addItem(new MessageCompletionItem(method, signature));
        }
        return 1;
    }

    private PythonInterpreter getInterpreter() {
        try {
            PythonInterpreter interp = this.jythonInterpreterProvider != null ? this.jythonInterpreterProvider.createInterpreter() : new PythonInterpreter();
            if (Util.isLegacyImports()) {
                URL imports = JythonOps.class.getResource("/imports2017.py");
                try (InputStream in = imports.openStream();){
                    interp.execfile(in, "imports2017.py");
                }
            }
            return interp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void refresh(CompletionResultSet arg0) {
    }

    @Override
    public void cancel() {
    }

    public static int getLocalsCompletions(PythonInterpreter interp, CompletionContext cc, CompletionResultSet rs) {
        int count = 0;
        List<DefaultCompletionItem> rr = JythonCompletionTask.getLocalsCompletions(interp, cc);
        for (DefaultCompletionItem item : rr) {
            if (rs != null) {
                rs.addItem(item);
            }
            ++count;
        }
        return count;
    }

    private static String hideJavaPaths(String label) {
        StringBuffer build = new StringBuffer();
        Pattern p = Pattern.compile("(org.das2.qds.QDataSet|java.lang.String|java.lang.Object|org.das2.util.monitor.ProgressMonitor|org.das2.datum.DatumRange|org.das2.datum.Datum)");
        Matcher m = p.matcher(label);
        while (m.find()) {
            String s;
            switch (s = m.group(1)) {
                case "org.das2.qds.QDataSet": {
                    m.appendReplacement(build, "QDataSet");
                    break;
                }
                case "java.lang.String": {
                    m.appendReplacement(build, "String");
                    break;
                }
                case "java.lang.Object": {
                    m.appendReplacement(build, "Object");
                    break;
                }
                case "org.das2.util.monitor.ProgressMonitor": {
                    m.appendReplacement(build, "Monitor");
                    break;
                }
                case "org.das2.datum.DatumRange": {
                    m.appendReplacement(build, "DatumRange");
                    break;
                }
                case "org.das2.datum.Datum": {
                    m.appendReplacement(build, "Datum");
                    break;
                }
            }
        }
        m.appendTail(build);
        return build.toString();
    }

    public static String escapeHtml(String s) {
        StringBuffer out = new StringBuffer();
        Pattern p = Pattern.compile("([\\<\\>])");
        Matcher m = p.matcher(s);
        while (m.find()) {
            m.appendReplacement(out, "");
            String ss = m.group(1);
            if (ss.equals("<")) {
                out.append("&lt;");
                continue;
            }
            if (!ss.equals(">")) continue;
            out.append("&gt;");
        }
        m.appendTail(out);
        return out.toString();
    }

    private static String getPyFunctionSignature(PyFunction pf) {
        PyObject[] defaults = pf.func_defaults;
        String[] vars = ((PyTableCode)pf.func_code).co_varnames;
        int count = ((PyTableCode)pf.func_code).co_argcount;
        StringBuilder sig = new StringBuilder(pf.__name__ + "(");
        if (count > 0) {
            if (defaults.length == vars.length) {
                sig.append(vars[0]).append("=").append(defaults[0]);
            } else {
                sig.append(vars[0]);
            }
        }
        int nreq = vars.length - defaults.length;
        for (int i = 1; i < count; ++i) {
            if (i >= nreq) {
                sig.append(",").append(vars[i]).append("=").append(defaults[i - nreq]);
                continue;
            }
            sig.append(",").append(vars[i]);
        }
        if (count + defaults.length == vars.length - 2) {
            sig.append(",...");
        }
        sig.append(")");
        return sig.toString();
    }

    private static String makeInlineSignature(PyObject po, PyObject doc) {
        String[] ss2;
        String signature;
        String sig = po instanceof PyFunction ? JythonCompletionTask.getPyFunctionSignature((PyFunction)po) : "";
        String string = signature = doc instanceof PyNone ? "(No documentation)" : doc.toString();
        if (sig.length() > 0) {
            sig = "<b>" + sig + "</b><br><br>";
        }
        if ((ss2 = signature.split("\n")).length > 1) {
            for (int jj = 0; jj < ss2.length; ++jj) {
                ss2[jj] = JythonCompletionTask.escapeHtml(ss2[jj]);
            }
            signature = !signature.startsWith("<html>") ? "<html>" + sig + JythonCompletionTask.join(ss2, "<br>") + "</html>" : "<html>" + sig + signature.substring(6) + "</html>";
        } else {
            signature = "<html>" + sig + signature + "</html>";
        }
        signature = "inline:" + signature;
        return signature;
    }

    private static void doPyReflectedFunction(String ss, PyReflectedFunction prf, List<String> labels, List<String> signatures, List<String> argss) {
        PyReflectedFunctionPeeker peek = new PyReflectedFunctionPeeker(prf);
        for (int jj = 0; jj < peek.getArgsCount(); ++jj) {
            String signature = JythonCompletionTask.methodSignature(peek.getMethod(jj));
            String args = JythonCompletionTask.methodArgs(peek.getMethod(jj));
            int j = signature.indexOf("#");
            String label = ss + "() JAVA";
            if (j > -1) {
                label = signature.substring(j + 1);
                label = JythonCompletionTask.hideJavaPaths(label);
                Class<?> ret = peek.getMethod(0).getReturnType();
                label = label + "->" + JythonCompletionTask.hideJavaPaths(ret.getCanonicalName());
            }
            signatures.add(signature);
            labels.add(label);
            argss.add(args);
        }
    }

    private static void doConstructors(Constructor[] constructors, List<String> labels, List<String> signatures, String ss, List<String> argss) {
        for (Constructor constructor : constructors) {
            String signature = JythonCompletionTask.constructorSignatureNew(constructor);
            if (signature.contains("$")) {
                signature = signature.replaceAll("\\$", ".");
            }
            int j = signature.indexOf("#");
            String label = ss + "() JAVA";
            if (j > -1) {
                label = signature.substring(j + 1);
                label = JythonCompletionTask.hideJavaPaths(label);
                Class ret = constructor.getDeclaringClass();
                label = label + "->" + JythonCompletionTask.hideJavaPaths(ret.getCanonicalName());
            }
            signatures.add(signature);
            labels.add(label);
            argss.add(JythonCompletionTask.argsList(constructor.getParameterTypes()));
        }
    }

    public static <T extends Comparable<T>> void keySort(final List<T> key, List<?> ... lists) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < key.size(); ++i) {
            indices.add(i);
        }
        Collections.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                return ((Comparable)key.get(i)).compareTo(key.get(j));
            }
        });
        HashMap<Integer, Integer> swapMap = new HashMap<Integer, Integer>(indices.size());
        ArrayList<Integer> swapFrom = new ArrayList<Integer>(indices.size());
        ArrayList<Integer> swapTo = new ArrayList<Integer>(indices.size());
        for (int i = 0; i < key.size(); ++i) {
            int k = (Integer)indices.get(i);
            while (i != k && swapMap.containsKey(k)) {
                k = (Integer)swapMap.get(k);
            }
            swapFrom.add(i);
            swapTo.add(k);
            swapMap.put(i, k);
        }
        for (List<?> list : lists) {
            for (int i = 0; i < list.size(); ++i) {
                Collections.swap(list, (int)((Integer)swapFrom.get(i)), (int)((Integer)swapTo.get(i)));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<DefaultCompletionItem> getLocalsCompletions(PythonInterpreter interp, CompletionContext cc) {
        ArrayList<DefaultCompletionItem> result = new ArrayList<DefaultCompletionItem>();
        PyStringMap locals = (PyStringMap)interp.getLocals();
        PyList po2 = locals.keys();
        int i = 0;
        while (true) {
            if (i >= po2.__len__()) {
                logger.log(Level.FINE, "getLocalsCompletions found {0} completions", new Object[]{result.size()});
                return result;
            }
            PyString s = (PyString)po2.__getitem__(i);
            String ss = s.toString();
            String signature = null;
            ArrayList<String> signatures = new ArrayList<String>();
            ArrayList<String> argss = new ArrayList<String>();
            if (ss.startsWith(cc.completable)) {
                logger.log(Level.FINER, "found completion item: {0}", ss);
                boolean allStatic = false;
                PyObject po = locals.get((PyObject)s);
                String label = ss;
                ArrayList<String> labels = new ArrayList<String>();
                String args = "";
                if (po instanceof PyReflectedFunction) {
                    PyReflectedFunction prf = (PyReflectedFunction)po;
                    JythonCompletionTask.doPyReflectedFunction(ss, prf, labels, signatures, argss);
                } else if (po.isCallable()) {
                    label = ss + "() ";
                    if (po instanceof PyFunction) {
                        label = JythonCompletionTask.getPyFunctionSignature((PyFunction)po);
                        args = label.substring(ss.length());
                    }
                    PyObject doc = interp.eval(ss + ".__doc__");
                    signature = JythonCompletionTask.makeInlineSignature(po, doc);
                } else if (po.isNumberType()) {
                    switch (po.getType().getFullName()) {
                        case "javaclass": 
                        case "javainnerclass": {
                            Method[] mm;
                            label = ss;
                            PyJavaClassPeeker peek = new PyJavaClassPeeker((PyJavaClass)po);
                            Class jclass = peek.getProxyClass();
                            String n = jclass.getCanonicalName();
                            allStatic = true;
                            for (Method m : mm = jclass.getMethods()) {
                                if (m.getDeclaringClass().equals(Object.class) || Modifier.isStatic(m.getModifiers())) continue;
                                allStatic = false;
                            }
                            if (allStatic) {
                                JythonCompletionTask.doConstructors(jclass.getConstructors(), labels, signatures, n, argss);
                                for (int i1 = 0; i1 < argss.size(); ++i1) {
                                    argss.set(i1, "");
                                }
                                break;
                            } else {
                                JythonCompletionTask.doConstructors(jclass.getConstructors(), labels, signatures, n, argss);
                                break;
                            }
                        }
                        case "javapackage": {
                            label = ss;
                            break;
                        }
                        default: {
                            String sss = po.toString();
                            if (po instanceof PyJavaInstance) {
                                Object jo = po.__tojava__(Object.class);
                                sss = jo instanceof QDataSet ? "dataset" : jo.toString();
                            }
                            if (sss.contains("<")) {
                                label = ss;
                                break;
                            }
                            label = ss + " = " + sss;
                            break;
                        }
                    }
                } else if (!(po instanceof PyJavaClass)) {
                    logger.log(Level.FINE, "skipping {0}", ss);
                }
                JythonCompletionTask.keySort(signatures, signatures, labels, argss);
                if (!signatures.isEmpty()) {
                    for (int jj = 0; jj < signatures.size(); ++jj) {
                        signature = (String)signatures.get(jj);
                        label = (String)labels.get(jj);
                        String link = null;
                        if (signature != null) {
                            link = JythonCompletionTask.getLinkForJavaSignature(signature);
                        }
                        if (ss.equals("dom")) {
                            link = "http://autoplot.org/developer.scripting#DOM";
                        }
                        logger.log(Level.FINER, "DefaultCompletionItem({0},{1},\n{2}{3},\n{4},\n{5})", new Object[]{ss, cc.completable.length(), ss, argss.get(jj), label, link});
                        result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + (String)argss.get(jj), label, link));
                    }
                } else {
                    String link = null;
                    if (signature != null && signature.startsWith("inline:")) {
                        link = signature;
                    } else if (ss.equals("dom")) {
                        link = "http://autoplot.org/developer.scripting#DOM";
                    } else if (signature != null) {
                        link = JythonCompletionTask.getLinkForJavaSignature(signature);
                    }
                    if (po instanceof PyString) {
                        result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label + " -> " + po + "", link));
                    } else if (allStatic) {
                        result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args + ".", label, link));
                    } else {
                        result.add(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link));
                    }
                }
            }
            ++i;
        }
    }

    private static String getLinkForJavaSignature(String signature) {
        return JavadocLookup.getInstance().getLinkForJavaSignature(signature);
    }
}

