/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.util.LinkedHashMap;
import java.util.Set;
import org.das2.jythoncompletion.JythonCompletionProvider;

public class JavadocLookup {
    private static JavadocLookup instance;
    private final LinkedHashMap<String, String> lookups = new LinkedHashMap();

    public static synchronized JavadocLookup getInstance() {
        if (instance == null) {
            instance = new JavadocLookup();
            instance.setLinkForJavaSignature("javax", "http://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("java", "http://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("org/w3c/dom", "http://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("org/xml/sax", "http://docs.oracle.com/javase/8/docs/api/");
            instance.setLinkForJavaSignature("gov/nasa/gsfc/spdf/cdfj", "https://cdaweb.sci.gsfc.nasa.gov/~nand/cdfj/docs/");
            instance.setLinkForJavaSignature("org", JythonCompletionProvider.getInstance().settings.getDocHome());
        }
        return instance;
    }

    public String getLinkForJavaSignature(String signature) {
        if (signature == null) {
            return null;
        }
        String lookfor = signature.replaceAll("\\.", "/");
        Set<String> keys = this.lookups.keySet();
        for (String key : keys) {
            if (!lookfor.startsWith(key)) continue;
            String s = this.lookups.get(key);
            if (s.startsWith("http://docs.oracle.com/javase/8/docs/api/")) {
                return this.lookups.get(key) + signature.replaceAll("[\\(\\)\\,]", "-");
            }
            if (s.startsWith("http://www-pw.physics.uiowa.edu/~jbf/autoplot/javadoc/")) {
                return this.lookups.get(key) + signature.replaceAll("[\\(\\)\\,]", "-");
            }
            return this.lookups.get(key) + signature.replaceAll(",", ", ");
        }
        return null;
    }

    public void setLinkForJavaSignature(String signatureStart, String link) {
        this.lookups.put(signatureStart + "/", link);
    }
}

