/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.autoplot.datasource.AutoplotSettings;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.util.LoggerManager;

public class CompletionSettings {
    private static final Logger logger = LoggerManager.getLogger("jython.editor");
    Preferences prefs = AutoplotSettings.settings().getPreferences(CompletionSettings.class);
    private String docHome = "http://www-pw.physics.uiowa.edu/~jbf/autoplot/javadoc/";
    public static final String PROP_DOCHOME = "docHome";
    public static final String PROP_TAB_IS_COMPLETION = "tabIsCompletion";
    private boolean tabIsCompletion = true;
    protected boolean safeCompletions = true;
    public static final String PROP_SAFE_COMPLETIONS = "safeCompletions";
    private String editorFont = "sans-12";
    public static final String PROP_EDITORFONT = "editorFont";
    private String documentationPaneSize = "640x480";
    public static final String PROP_DOCUMENTATIONPANESIZE = "documentationPaneSize";
    private boolean showTabs = true;
    public static final String PROP_SHOWTABS = "showTabs";
    private boolean tabIsSpaces;
    public static final String PROP_TABISSPACES = "tabIsSpaces";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public String getDocHome() {
        return this.docHome;
    }

    public void setDocHome(String docHome) {
        String oldDocHome = docHome;
        this.docHome = docHome;
        this.propertyChangeSupport.firePropertyChange(PROP_DOCHOME, oldDocHome, docHome);
        this.prefs.put(PROP_DOCHOME, docHome);
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public boolean isTabIsCompletion() {
        return this.tabIsCompletion;
    }

    public void setTabIsCompletion(boolean tabIsCompletion) {
        boolean old = this.tabIsCompletion;
        this.tabIsCompletion = tabIsCompletion;
        this.propertyChangeSupport.firePropertyChange(PROP_TAB_IS_COMPLETION, old, tabIsCompletion);
        try {
            this.prefs.putBoolean(PROP_TAB_IS_COMPLETION, tabIsCompletion);
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        CompletionImpl.get().setTabIsCompletion(tabIsCompletion);
    }

    public boolean isSafeCompletions() {
        return this.safeCompletions;
    }

    public void setSafeCompletions(boolean safeCompletions) {
        boolean old = safeCompletions;
        this.safeCompletions = safeCompletions;
        this.propertyChangeSupport.firePropertyChange(PROP_SAFE_COMPLETIONS, old, safeCompletions);
        this.prefs.putBoolean(PROP_SAFE_COMPLETIONS, safeCompletions);
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String getEditorFont() {
        return this.editorFont;
    }

    public void setEditorFont(String editorFont) {
        String oldEditorFont = this.editorFont;
        this.editorFont = editorFont;
        this.propertyChangeSupport.firePropertyChange(PROP_EDITORFONT, oldEditorFont, editorFont);
        this.prefs.put(PROP_EDITORFONT, editorFont);
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String getDocumentationPaneSize() {
        return this.documentationPaneSize;
    }

    public void setDocumentationPaneSize(String documentationPaneSize) {
        String oldDocumentationPaneSize = this.documentationPaneSize;
        this.documentationPaneSize = documentationPaneSize;
        this.propertyChangeSupport.firePropertyChange(PROP_DOCUMENTATIONPANESIZE, oldDocumentationPaneSize, documentationPaneSize);
        this.prefs.put(PROP_DOCUMENTATIONPANESIZE, documentationPaneSize);
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public boolean isShowTabs() {
        return this.showTabs;
    }

    public void setShowTabs(boolean showTabs) {
        boolean oldShowTabs = this.showTabs;
        this.showTabs = showTabs;
        this.propertyChangeSupport.firePropertyChange(PROP_SHOWTABS, oldShowTabs, showTabs);
        this.prefs.putBoolean(PROP_SHOWTABS, showTabs);
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public boolean isTabIsSpaces() {
        return this.tabIsSpaces;
    }

    public void setTabIsSpaces(boolean tabIsSpaces) {
        boolean oldTabIsSpaces = this.tabIsSpaces;
        this.tabIsSpaces = tabIsSpaces;
        this.propertyChangeSupport.firePropertyChange(PROP_TABISSPACES, oldTabIsSpaces, tabIsSpaces);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void loadPreferences() {
        this.docHome = this.prefs.get(PROP_DOCHOME, "http://www-pw.physics.uiowa.edu/~jbf/autoplot/javadoc/");
        this.tabIsCompletion = this.prefs.getBoolean(PROP_TAB_IS_COMPLETION, true);
        this.tabIsSpaces = this.prefs.getBoolean(PROP_TABISSPACES, false);
        this.showTabs = this.prefs.getBoolean(PROP_SHOWTABS, true);
        this.editorFont = this.prefs.get(PROP_EDITORFONT, "sans-12");
        this.documentationPaneSize = this.prefs.get(PROP_DOCUMENTATIONPANESIZE, "640x480");
    }
}

