/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;

public class TransferableCanvasComponent
implements Transferable {
    public static final DataFlavor CANVAS_COMPONENT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("org.das2.graph.DasCanvasComponent");
    public static final DataFlavor AXIS_FLAVOR = TransferableCanvasComponent.localJVMFlavor("org.das2.graph.DasAxis");
    public static final DataFlavor PLOT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("org.das2.graph.DasPlot");
    public static final DataFlavor COLORBAR_FLAVOR = TransferableCanvasComponent.localJVMFlavor("org.das2.graph.DasColorBar");
    private List flavorList;
    private DasCanvasComponent component;

    private static DataFlavor localJVMFlavor(String className) {
        try {
            String x = "application/x-java-jvm-local-objectref";
            return new DataFlavor(x + ";class=" + className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public TransferableCanvasComponent(DasAxis axis) {
        this.flavorList = Arrays.asList(AXIS_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = axis;
    }

    public TransferableCanvasComponent(DasPlot plot) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = plot;
    }

    public TransferableCanvasComponent(DasColorBar cb) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = cb;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.component;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavorList.toArray(new DataFlavor[this.flavorList.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavorList.contains(flavor);
    }
}

