/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import org.das2.datum.Units;
import org.das2.graph.Arrow;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class VectorPlotRenderer
extends Renderer {
    protected double scale = 1.0;
    public static final String PROP_SCALE = "scale";

    public static boolean acceptsData(QDataSet ds) {
        if (ds.rank() != 2) {
            return false;
        }
        return ds.length() == 0 || ds.length(0) == 4;
    }

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet xrange = VectorPlotRenderer.doRange(DataSetOps.unbundle(ds, 0), DataSetOps.unbundle(ds, 2));
        QDataSet yrange = VectorPlotRenderer.doRange(DataSetOps.unbundle(ds, 1), DataSetOps.unbundle(ds, 3));
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    private static QDataSet doRange(QDataSet xds, QDataSet dxds) {
        double scale = 1.0;
        QDataSet xrange = Ops.extent(xds);
        MutablePropertyDataSet vxds = (MutablePropertyDataSet)Ops.multiply(dxds, DataSetUtil.asDataSet(scale));
        vxds.putProperty("UNITS", xds.property("UNITS"));
        xrange = Ops.extent(Ops.add(xds, vxds), xrange);
        if (xrange.value(1) == xrange.value(0)) {
            xrange = !"log".equals(xrange.property("SCALE_TYPE")) ? DDataSet.wrap(new double[]{xrange.value(0) - 1.0, xrange.value(1) + 1.0}).setUnits(SemanticOps.getUnits(xrange)) : DDataSet.wrap(new double[]{xrange.value(0) / 10.0, xrange.value(1) * 10.0}).setUnits(SemanticOps.getUnits(xrange));
        }
        xrange = Ops.rescaleRangeLogLin(xrange, -0.1, 1.1);
        xrange = Ops.rescaleRangeLogLin(xrange, -0.1, 1.1);
        return xrange;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_SCALE, oldScale, scale);
    }

    @Override
    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g = (Graphics2D)g1;
        QDataSet lds = this.getDataSet();
        DasPlot parent = this.getParent();
        if (lds == null) {
            if (this.getLastException() != null) {
                this.renderException(g, xAxis, yAxis, this.lastException);
            } else {
                parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            }
            return;
        }
        if (lds.length() == 0) {
            parent.postException(this, new IllegalArgumentException("no data to plot"));
            return;
        }
        if (lds.rank() != 2 || lds.length(0) != 4) {
            parent.postException(this, new IllegalArgumentException("plot must be rank 2 and be of the form ds[:,4]"));
            return;
        }
        QDataSet x = DataSetOps.unbundle(lds, 0);
        QDataSet y = DataSetOps.unbundle(lds, 1);
        QDataSet dx = DataSetOps.unbundle(lds, 2);
        QDataSet dy = DataSetOps.unbundle(lds, 3);
        Units xunits = SemanticOps.getUnits(x);
        Units yunits = SemanticOps.getUnits(y);
        QDataSet wdx = SemanticOps.weightsDataSet(dx);
        QDataSet wdy = SemanticOps.weightsDataSet(dy);
        QDataSet wx = SemanticOps.weightsDataSet(x);
        QDataSet wy = SemanticOps.weightsDataSet(y);
        for (int i = 0; i < lds.length(); ++i) {
            if (wdx.value(i) * wdy.value(i) * wx.value(i) * wy.value(i) == 0.0) continue;
            double ix = xAxis.transform(x.value(i), xunits);
            double iy = yAxis.transform(y.value(i), yunits);
            double idx = xAxis.transform(x.value(i) + dx.value(i) * this.scale, xunits);
            double idy = yAxis.transform(y.value(i) + dy.value(i) * this.scale, yunits);
            Arrow.paintArrow(g, new Point((int)idx, (int)idy), new Point((int)ix, (int)iy), 10.0, Arrow.HeadStyle.DRAFTING);
        }
    }
}

