/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.Arrow;
import org.das2.graph.DasAxis;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.GrannyTickLabeller;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.graph.TickLabeller;
import org.das2.graph.TickVDescriptor;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.DasMath;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public final class TickCurveRenderer
extends Renderer {
    protected static final Logger logger = LoggerManager.getLogger("das2.graphics.renderer.tickCurveRenderer");
    TickVDescriptor tickv;
    TickVDescriptor manualTickV = null;
    DomainDivider ticksDivider;
    private String xplane;
    private String yplane;
    private QDataSet xds;
    private QDataSet yds;
    private Units xunits;
    private Units yunits;
    private double[][] ddata;
    private final int[] index = new int[3];
    TickLabeller tickLabeller;
    private TickStyle tickStyle = TickStyle.OUTER;
    private double lineWidth = 1.0;
    private Color color = Color.BLACK;
    private String tickLength = "0.66em";
    private double tickLen = 0.0;
    private GeneralPath path;
    public static final String CONTROL_TICK_LENGTH = "tickLength";
    private String fontSize = "";
    public static final String PROP_FONTSIZE = "fontSize";
    private final Object PEN_UP = "penup";
    private final Object PEN_DOWN = "pendown";
    private String tickSpacing = "";
    public static final String PROP_TICKSPACING = "tickSpacing";

    public TickCurveRenderer(QDataSet ds, String xplane, String yplane, TickVDescriptor tickv) {
        this();
        this.setDataSet(ds);
        this.xplane = xplane;
        this.yplane = yplane;
        this.tickv = tickv;
    }

    public TickCurveRenderer() {
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.lineWidth = this.getDoubleControl("lineThick", this.lineWidth);
        this.color = this.getColorControl("color", this.color);
        this.fontSize = this.getControl(PROP_FONTSIZE, this.fontSize);
        this.tickLength = this.getControl(CONTROL_TICK_LENGTH, this.tickLength);
        this.tickSpacing = this.getControl(PROP_TICKSPACING, this.tickSpacing);
        this.update();
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("lineThick", String.valueOf(this.lineWidth));
        controls.put("color", TickCurveRenderer.encodeColorControl(this.color));
        controls.put(PROP_FONTSIZE, this.fontSize);
        controls.put(CONTROL_TICK_LENGTH, this.tickLength);
        controls.put(PROP_TICKSPACING, this.tickSpacing);
        return Renderer.formatControl(controls);
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.propertyChangeSupport.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public static boolean acceptsData(QDataSet ds) {
        if (ds.rank() == 2 && ds.length(0) == 3) {
            return true;
        }
        if (ds.rank() == 1) {
            QDataSet yy = ds;
            if (yy.property("DEPEND_0") == null) {
                return false;
            }
            return UnitsUtil.isIntervalOrRatioMeasurement(SemanticOps.getUnits(ds));
        }
        return false;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        return this.selectionArea().contains(x, y);
    }

    public Shape selectionArea() {
        if (this.path == null) {
            return SelectionUtil.NULL;
        }
        Shape s = new BasicStroke(Math.min(14.0f, 9.0f), 1, 1).createStrokedShape(this.path);
        return s;
    }

    @Override
    public Icon getListIcon() {
        BufferedImage img = new BufferedImage(16, 16, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.setStroke(new BasicStroke((float)this.lineWidth));
        g.drawLine(2, 12, 14, 8);
        g.drawLine(8, 10, 6, 6);
        g.drawLine(4, 2, 4, 2);
        return new ImageIcon(img);
    }

    public static QDataSet doAutorange(QDataSet ds1) {
        QDataSet ds = TickCurveRenderer.makeCanonical(ds1);
        QDataSet xrange = Ops.rescaleRangeLogLin(Ops.extent(DataSetOps.unbundle(ds, 1)), -0.1, 1.1);
        QDataSet yrange = Ops.rescaleRangeLogLin(Ops.extent(DataSetOps.unbundle(ds, 2)), -0.1, 1.1);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    private static QDataSet makeCanonical(QDataSet ds) {
        if (ds.rank() == 2 && ds.length(0) == 3) {
            return ds;
        }
        if (ds.rank() == 1) {
            QDataSet yy = ds;
            QDataSet xx = SemanticOps.xtagsDataSet(yy);
            QDataSet tt = SemanticOps.xtagsDataSet(xx);
            return Ops.bundle(tt, xx, yy);
        }
        throw new IllegalArgumentException("dataset must be rank2[3,n] or rank 1 ds[xx[tt]]");
    }

    private static Line2D normalize(Line2D line, double len) {
        Point2D p1 = line.getP1();
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double dist = Math.sqrt(dx * dx + dy * dy);
        Line2D result = (Line2D)line.clone();
        result.setLine(p1.getX(), p1.getY(), p1.getX() + dx / dist * len, p1.getY() + dy / dist * len);
        return result;
    }

    private double turnDir(double x1, double y1, double x2, double y2, double x3, double y3) {
        double dx1 = x2 - x1;
        double dx2 = x3 - x2;
        double dy1 = y2 - y1;
        double dy2 = y3 - y2;
        return dx1 * dy2 - dx2 * dy1;
    }

    private void id3(double findex, int[] points) {
        int dd = 4;
        int nvert = this.xds.length();
        int index1 = (int)Math.floor(findex);
        int index0 = index1 - dd;
        if (index0 < 0) {
            index0 = 0;
        }
        while (index0 < index1 && (this.ddata[0][index0] == -10000.0 || this.ddata[1][index0] == 10000.0)) {
            ++index0;
        }
        int index2 = index1 + dd;
        if (index2 >= nvert) {
            index2 = nvert - 1;
        }
        while (index2 > index1 && (this.ddata[0][index2] == -10000.0 || this.ddata[1][index2] == 10000.0)) {
            --index2;
        }
        if (index2 - index1 > index1 - index0) {
            index2 = index1 + (index1 - index0);
        }
        while (index2 > index1 && (this.ddata[0][index2] == -10000.0 || this.ddata[1][index2] == 10000.0)) {
            --index2;
        }
        if (index1 - index0 > index2 - index1) {
            index0 = index1 - (index2 - index1);
        }
        while (index0 < index1 && (this.ddata[0][index0] == -10000.0 || this.ddata[1][index0] == 10000.0)) {
            ++index0;
        }
        if (index2 - index0 < 2 && index0 > 1 && Math.abs(this.ddata[0][index2 - 2]) < 10000.0) {
            index0 = index2 - 2;
            index1 = index2 - 1;
        }
        if (index2 - index0 < 2 && index2 < nvert - 2 && Math.abs(this.ddata[0][index2 + 2]) < 10000.0) {
            index1 = index0 + 1;
            index2 = index0 + 2;
        }
        points[0] = index0;
        points[1] = index1;
        points[2] = index2;
    }

    private double turnDirAt(double findex) {
        int nvert = this.xds.length();
        if (nvert < 3) {
            return 0.0;
        }
        this.id3(findex, this.index);
        return this.turnDir(this.ddata[0][this.index[0]], this.ddata[1][this.index[0]], this.ddata[0][this.index[1]], this.ddata[1][this.index[1]], this.ddata[0][this.index[2]], this.ddata[1][this.index[2]]);
    }

    private Line2D outsideNormalAt(double findex) {
        double dxNorm;
        double dyNorm;
        double turnDirTick;
        this.id3(findex, this.index);
        double x0 = this.ddata[0][this.index[0]];
        double x2 = this.ddata[0][this.index[2]];
        double y0 = this.ddata[1][this.index[0]];
        double y2 = this.ddata[1][this.index[2]];
        double xinterp = DasMath.interpolate(this.ddata[0], findex);
        double yinterp = DasMath.interpolate(this.ddata[1], findex);
        double dx = x2 - x0;
        double dy = y2 - y0;
        if (dx == 0.0 && dy == 0.0) {
            throw new IllegalArgumentException("findex as at a point that repeats");
        }
        double turnDir = this.turnDirAt(findex);
        if (turnDir * (turnDirTick = -1.0 * (dx * (dyNorm = -dx) - (dxNorm = dy) * dy)) < 0.0) {
            dxNorm = -dy;
            dyNorm = dx;
        }
        return TickCurveRenderer.normalize(new Line2D.Double(xinterp, yinterp, xinterp + dxNorm, yinterp + dyNorm), 1.0);
    }

    private void updateTickLength(Graphics2D g) {
        try {
            double[] pos = DasDevicePosition.parseLayoutStr(this.tickLength);
            Font f = g.getFont();
            this.tickLen = pos[0] == 0.0 ? (double)((int)Math.round(pos[1] * (double)f.getSize2D() + pos[2])) : (double)((int)Math.round(pos[1] * (double)f.getSize2D() + pos[2]));
        }
        catch (ParseException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void drawTick(Graphics2D g, double findex) {
        Line2D tick;
        float tl = (float)(this.tickLen * 0.66);
        try {
            tick = TickCurveRenderer.normalize(this.outsideNormalAt(findex), tl);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        if (tick.getP1().getX() < -1000.0 || tick.getP1().getY() < -1000.0 || tick.getP1().getX() > 9999.0 || tick.getP1().getY() > 9999.0) {
            return;
        }
        if (this.tickStyle == TickStyle.BOTH) {
            Line2D flipTick = TickCurveRenderer.normalize(tick, -tl);
            Line2D.Double bothTick = new Line2D.Double(flipTick.getP2(), tick.getP2());
            g.draw(bothTick);
        } else {
            g.draw(tick);
        }
    }

    private void drawLabelTick(Graphics2D g, double findex, int tickNumber) {
        Line2D tick;
        float tl = (float)this.tickLen;
        if ((double)tl < 0.001) {
            tl = 0.001f;
        }
        try {
            tick = TickCurveRenderer.normalize(this.outsideNormalAt(findex), tl);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        if (tick.getP1().getX() < -1000.0 || tick.getP1().getY() < -1000.0 || tick.getP1().getX() > 9999.0 || tick.getP1().getY() > 9999.0) {
            return;
        }
        if (this.tickStyle == TickStyle.BOTH) {
            Line2D flipTick = TickCurveRenderer.normalize(tick, -tl);
            Line2D.Double bothTick = new Line2D.Double(flipTick.getP2(), tick.getP2());
            g.draw(bothTick);
        } else {
            g.draw(tick);
        }
        tick = TickCurveRenderer.normalize(tick, (double)tl + this.lineWidth);
        this.tickLabeller.labelMajorTick(g, tickNumber, tick);
    }

    private TickVDescriptor resetTickV(QDataSet tds) {
        QDataSet trange = Ops.extent(tds);
        DatumRange dr = DataSetUtil.asDatumRange(trange, true);
        if (this.tickSpacing.length() > 0) {
            if (this.ticksDivider == null) {
                this.ticksDivider = DomainDividerUtil.getDomainDivider(dr.min(), dr.max(), false);
            }
            try {
                Datum ticksSpacingD = dr.min().getUnits().getOffsetUnits().parse(this.tickSpacing);
                while (this.ticksDivider.rangeContaining(dr.min()).width().gt(ticksSpacingD)) {
                    this.ticksDivider = this.ticksDivider.finerDivider(false);
                }
                while (this.ticksDivider.rangeContaining(dr.min()).width().lt(ticksSpacingD)) {
                    this.ticksDivider = this.ticksDivider.coarserDivider(false);
                }
            }
            catch (ParseException ex) {
                this.ticksDivider = DomainDividerUtil.getDomainDivider(dr.min(), dr.max(), false);
                logger.warning("unable to parse " + this.tickSpacing);
            }
        } else {
            if (this.ticksDivider == null) {
                this.ticksDivider = DomainDividerUtil.getDomainDivider(dr.min(), dr.max(), false);
            }
            double plen = 0.0;
            int ic = 1;
            for (int i = 1; i < this.ddata[0].length; ++i) {
                if (!(Math.abs(this.ddata[0][i]) < 10000.0) || !(Math.abs(this.ddata[0][i - 1]) < 10000.0) || !(Math.abs(this.ddata[1][i]) < 10000.0) || !(Math.abs(this.ddata[1][i - 1]) < 10000.0)) continue;
                double dx = this.ddata[0][i] - this.ddata[0][i - 1];
                double dy = this.ddata[1][i] - this.ddata[1][i - 1];
                plen += Math.sqrt(dx * dx + dy * dy);
                ++ic;
            }
            if (ic > 0) {
                plen = plen * (double)this.ddata[0].length / (double)ic;
            }
            if (plen < 100.0) {
                plen = 100.0;
            }
            while ((double)this.ticksDivider.boundaryCount(dr.min(), dr.max()) < Math.ceil(plen / 100.0)) {
                this.ticksDivider = this.ticksDivider.finerDivider(false);
            }
            while ((double)this.ticksDivider.boundaryCount(dr.min(), dr.max()) > Math.ceil(plen / 50.0)) {
                this.ticksDivider = this.ticksDivider.coarserDivider(false);
            }
        }
        DatumVector major = this.ticksDivider.boundaries(dr.min(), dr.max());
        DatumVector minor = this.ticksDivider.finerDivider(true).boundaries(dr.min(), dr.max());
        this.tickv = TickVDescriptor.newTickVDescriptor(major, minor);
        this.tickv.datumFormatter = DomainDividerUtil.getDatumFormatter(this.ticksDivider, dr);
        return this.tickv;
    }

    public double checkTickV(QDataSet tds) {
        Units tunits = SemanticOps.getUnits(tds);
        DDataSet txds = DDataSet.wrap(this.tickv.tickV.toDoubleArray(tunits), tunits);
        QDataSet findex = Ops.findex(tds, txds);
        double rmin = Double.MAX_VALUE;
        double x0 = Double.MAX_VALUE;
        double y0 = Double.MAX_VALUE;
        for (int i = 0; i < this.tickv.tickV.getLength(); ++i) {
            int index0 = (int)Math.floor(findex.value(i));
            if (index0 < 0 || index0 >= this.ddata[0].length) continue;
            if (x0 == Double.MAX_VALUE) {
                x0 = this.ddata[0][index0];
                y0 = this.ddata[1][index0];
                continue;
            }
            double x1 = this.ddata[0][index0];
            double y1 = this.ddata[1][index0];
            double r = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
            if (r < rmin) {
                rmin = Math.sqrt(r);
            }
            x0 = x1;
            y0 = y1;
        }
        return rmin;
    }

    @Override
    public void setDataSet(QDataSet ds) {
        super.setDataSet(ds);
        this.tickv = null;
    }

    @Override
    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        int i;
        double v;
        int i2;
        int i3;
        if (this.ds == null) {
            return;
        }
        QDataSet ds2 = TickCurveRenderer.makeCanonical(this.ds);
        if (ds2.length() < 2) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        BasicStroke stroke = new BasicStroke((float)this.lineWidth, 1, 1);
        g.setStroke(stroke);
        g.setFont(this.getParent().getFont());
        g.setColor(this.color);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        QDataSet ds3 = ds2;
        this.xds = this.xplane != null && !this.xplane.equals("") ? DataSetOps.unbundle(ds3, this.xplane) : DataSetOps.unbundle(ds3, 1);
        this.yds = this.yplane != null && !this.yplane.equals("") ? DataSetOps.unbundle(ds3, this.yplane) : DataSetOps.unbundle(ds3, 2);
        QDataSet tds = (QDataSet)this.xds.property("DEPEND_0");
        if (tds == null) {
            tds = DataSetOps.unbundle(ds3, 0);
        }
        this.xunits = SemanticOps.getUnits(this.xds);
        this.yunits = SemanticOps.getUnits(this.yds);
        double limit = -1.0;
        this.ddata = new double[2][this.xds.length()];
        for (int i4 = 0; i4 < this.xds.length(); ++i4) {
            this.ddata[0][i4] = xAxis.transform(this.xds.value(i4), this.xunits);
            this.ddata[1][i4] = yAxis.transform(this.yds.value(i4), this.yunits);
            if (i4 <= 0) continue;
            double len1 = Math.sqrt(Math.pow(this.ddata[0][i4] - this.ddata[0][i4 - 1], 2.0) + Math.pow(this.ddata[1][i4] - this.ddata[1][i4 - 1], 2.0));
            if (limit != -1.0 && (!(len1 > limit) || !(len1 / limit < 10.0))) continue;
            limit = len1;
        }
        if (limit == 0.0) {
            limit = 10000.0;
        }
        QDataSet wds = Ops.multiply(Ops.valid(this.xds), Ops.valid(this.yds));
        double[] len = new double[tds.length()];
        int lastValid = 0;
        GeneralPath p = new GeneralPath();
        for (i3 = 0; i3 < this.xds.length() && !(wds.value(i3) > 0.0); ++i3) {
        }
        if (i3 == this.xds.length()) {
            this.getParent().postException(this, new NoDataInIntervalException("no valid data"));
            return;
        }
        p.moveTo(this.ddata[0][i3], this.ddata[1][i3]);
        ++i3;
        boolean brk = false;
        while (i3 < this.xds.length()) {
            double w1 = wds.value(i3);
            if (w1 == 0.0) {
                brk = true;
                len[i3] = 9999.0;
            } else {
                double len1;
                len[i3] = len1 = Math.sqrt(Math.pow(this.ddata[0][i3] - this.ddata[0][i3 - 1], 2.0) + Math.pow(this.ddata[1][i3] - this.ddata[1][i3 - 1], 2.0));
                if (len1 > limit && wds.value(i3 - 1) == 1.0) {
                    p.moveTo(this.ddata[0][i3], this.ddata[1][i3]);
                    brk = true;
                } else if (brk) {
                    p.moveTo(this.ddata[0][i3], this.ddata[1][i3]);
                    brk = false;
                } else {
                    p.lineTo(this.ddata[0][i3], this.ddata[1][i3]);
                    lastValid = i3;
                }
            }
            ++i3;
        }
        GeneralPath rp = new GeneralPath();
        GraphUtil.reducePath(p.getPathIterator(null), rp, 2);
        g.draw(rp);
        this.path = rp;
        Units tunits = SemanticOps.getUnits(tds);
        if (this.manualTickV != null) {
            this.tickv = this.manualTickV;
        } else if (this.tickv == null || !this.tickv.getMinorTicks().getUnits().isConvertibleTo(tunits)) {
            this.tickv = this.resetTickV(tds);
        } else {
            double check = this.checkTickV(tds);
            if (check < 30.0) {
                this.tickv = this.resetTickV(tds);
            } else if (check > 100.0) {
                this.tickv = this.resetTickV(tds);
            }
        }
        DDataSet txds = DDataSet.wrap(this.tickv.minorTickV.toDoubleArray(tunits), tunits);
        QDataSet findex = Ops.findex(tds, txds);
        this.setUpFont(g, this.fontSize);
        this.updateTickLength(g);
        this.tickLabeller = new GrannyTickLabeller();
        this.tickLabeller.init(this.tickv);
        for (i2 = 0; i2 < this.tickv.minorTickV.getLength(); ++i2) {
            v = findex.value(i2);
            if (!(v >= 0.0) || !(v < (double)lastValid) || !(len[(int)Math.ceil(v)] <= limit)) continue;
            this.drawTick(g, v);
        }
        txds = DDataSet.wrap(this.tickv.tickV.toDoubleArray(tunits), tunits);
        findex = Ops.findex(tds, txds);
        for (i2 = 0; i2 < this.tickv.tickV.getLength(); ++i2) {
            v = findex.value(i2);
            if (!(findex.value(i2) >= 0.0) || !(findex.value(i2) < (double)lastValid) || !(len[(int)Math.ceil(v)] <= limit)) continue;
            this.drawLabelTick(g, v, i2);
        }
        int n = this.ddata[0].length;
        for (i = n - 1; i > 0 && !(wds.value(i) > 0.0); --i) {
        }
        int index1 = i--;
        while (i >= 0 && !(wds.value(i) > 0.0)) {
            --i;
        }
        int index2 = i;
        int em = 10;
        Arrow.paintArrow(g, new Point2D.Double(this.ddata[0][index1], this.ddata[1][index1]), new Point2D.Double(this.ddata[0][index2], this.ddata[1][index2]), (double)em, Arrow.HeadStyle.DRAFTING);
        this.tickLabeller.finished();
    }

    public TickStyle getTickStyle() {
        return this.tickStyle;
    }

    public void setTickStyle(TickStyle tickStyle) {
        logger.log(Level.CONFIG, "setTickStyle({0})", tickStyle);
        this.tickStyle = tickStyle;
        this.invalidateParentCacheImage();
    }

    public String getTickSpacing() {
        return this.tickSpacing;
    }

    public void setTickSpacing(String tickSpacing) {
        logger.log(Level.CONFIG, "setTickSpacing({0})", tickSpacing);
        String oldTickSpacing = this.tickSpacing;
        this.tickSpacing = tickSpacing;
        this.ticksDivider = null;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_TICKSPACING, oldTickSpacing, tickSpacing);
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        this.invalidateParentCacheImage();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.invalidateParentCacheImage();
    }

    public String getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(String tickLength) {
        this.tickLength = tickLength;
        this.invalidateParentCacheImage();
    }

    public void setTickVDescriptor(TickVDescriptor ticks) {
        this.manualTickV = ticks;
        this.invalidateParentCacheImage();
    }

    public static class TickStyle
    implements Enumeration {
        private final String name;
        public static final TickStyle OUTER = new TickStyle("Outer");
        public static final TickStyle BOTH = new TickStyle("Both");

        private TickStyle(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public Icon getListIcon() {
            return null;
        }
    }
}

