/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasException;
import org.das2.components.HorizontalSpectrogramSlicer;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.components.propertyeditor.Displayable;
import org.das2.dataset.AveragePeakTableRebinner;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.HorizontalSlicerMouseModule;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasLabelAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.RowRowConnector;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class StackedHistogramRenderer
extends Renderer
implements TableDataSetConsumer,
PropertyChangeListener,
Displayable {
    private DasAxis yAxis = null;
    private DasAxis zAxis = null;
    private RowRowConnector zAxisConnector = null;
    private DasRow littleRow = null;
    private PeaksIndicator peaksIndicator = PeaksIndicator.MaxDots;
    private boolean sliceRebinnedData;
    Image plotImage;
    DatumRange imageXRange;
    DatumRange imageYRange;
    static final Color GREY_PEAKS_COLOR = Color.lightGray.brighter();
    RebinListener rebinListener = new RebinListener();

    public StackedHistogramRenderer(DasAxis zAxis) {
        this.zAxis = zAxis;
        zAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
        zAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
        zAxis.addPropertyChangeListener("log", this.rebinListener);
        zAxis.addPropertyChangeListener("flipped", this.rebinListener);
    }

    public StackedHistogramRenderer(DasPlot parent, DataSetDescriptor dsd, DasAxis zAxis, DasAxis yAxis) {
        this(zAxis);
        this.yAxis = yAxis;
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.setPeaksIndicator(PeaksIndicator.valueOf(this.getControl("peaksIndicator", "GrayPeaks")));
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("peaksIndicator", this.peaksIndicator.toString());
        return Renderer.formatControl(controls);
    }

    @Override
    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g2 = (Graphics2D)g;
        QDataSet xtysData = this.getDataSet();
        if (xtysData == null) {
            this.getParent().postMessage((Renderer)this, "null data set", DasPlot.WARNING, null, null);
            return;
        }
        if (xtysData.length() == 0) {
            this.getParent().postMessage((Renderer)this, "empty data set", DasPlot.WARNING, null, null);
            return;
        }
        if (xtysData.rank() != 2) {
            this.getParent().postMessage((Renderer)this, "dataset is not rank 2", DasPlot.WARNING, null, null);
            return;
        }
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(g2, xAxis, yAxis, this.lastException);
        } else if (this.plotImage != null) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            Point2D.Float p = new Point2D.Float(xAxis.getColumn().getDMinimum(), yAxis.getRow().getDMinimum());
            g2.drawImage(this.plotImage, (int)(((Point2D)p).getX() + 0.5), (int)(((Point2D)p).getY() + 0.5), this.getParent());
        }
        g2.dispose();
    }

    @Override
    protected void installRenderer() {
        DasPlot parent = this.getParent();
        DasCanvas canvas = parent.getCanvas();
        this.littleRow = new DasRow(canvas, 0.5, 0.6);
        this.zAxisConnector = new RowRowConnector(canvas, this.littleRow, this.zAxis.getRow(), parent.getColumn(), this.zAxis.getColumn());
        this.zAxisConnector.setVisible(false);
        canvas.add(this.zAxisConnector);
        if (parent.getCanvas() != this.zAxis.getParent()) {
            parent.getCanvas().add(this.zAxis, parent.getRow(), this.zAxis.getColumn());
        }
        if (this.zAxis instanceof DasColorBar) {
            ((DasColorBar)this.zAxis).setShowColorBar(false);
        }
        if (this.yAxis == null) {
            this.yAxis = parent.getYAxis();
        }
        if (this.yAxis != null && this.yAxis instanceof DasLabelAxis) {
            DasLabelAxis dlAxis = (DasLabelAxis)this.yAxis;
            dlAxis.setFloppyItemSpacing(true);
            dlAxis.setOutsidePadding(1);
        }
        DasMouseInputAdapter mouseAdapter = parent.getDasMouseInputAdapter();
        VerticalSpectrogramSlicer vSlicer = VerticalSpectrogramSlicer.createSlicer(parent, this);
        VerticalSlicerMouseModule vsl = VerticalSlicerMouseModule.create(this);
        vsl.addDataPointSelectionListener(vSlicer);
        mouseAdapter.addMouseModule(vsl);
        HorizontalSpectrogramSlicer hSlicer = HorizontalSpectrogramSlicer.createSlicer(parent, this);
        HorizontalSlicerMouseModule hsl = HorizontalSlicerMouseModule.create(this);
        hsl.addDataPointSelectionListener(hSlicer);
        mouseAdapter.addMouseModule(hsl);
        CrossHairMouseModule ch = new CrossHairMouseModule(parent, this, parent.getXAxis(), parent.getYAxis());
        mouseAdapter.addMouseModule(ch);
        DasPlot p = parent;
        mouseAdapter.addMouseModule(new MouseModule(p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
    }

    @Override
    protected void uninstallRenderer() {
        DasCanvas c = this.getParent().getCanvas();
        c.remove(this.zAxisConnector);
        if (this.zAxis instanceof DasColorBar) {
            ((DasColorBar)this.zAxis).setShowColorBar(true);
        }
    }

    public void setZAxis(DasAxis zAxis) {
        this.zAxis = zAxis;
        throw new IllegalStateException("not supported");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    public void setYAxis(DasAxis yAxis) {
        if (!(yAxis instanceof DasLabelAxis)) {
            throw new IllegalArgumentException("You can't call setYAxis for stackedHistogramPlot");
        }
        this.yAxis = (DasLabelAxis)yAxis;
        yAxis.addPropertyChangeListener(this);
    }

    @Override
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis_1, ProgressMonitor monitor) throws DasException {
        super.updatePlotImage(xAxis, yAxis_1, monitor);
        Color BAR_COLOR = Color.BLACK;
        DasColumn column = xAxis.getColumn();
        DasRow row = yAxis_1.getRow();
        int w = column.getWidth();
        int h = row.getHeight();
        if (w == 0) {
            return;
        }
        BufferedImage plotImage1 = new BufferedImage(w, h, 1);
        Graphics2D g = plotImage1.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, plotImage1.getWidth(), plotImage1.getHeight());
        g.translate(-column.getDMinimum(), -row.getDMinimum());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RebinDescriptor xbins = new RebinDescriptor(xAxis.getDataMinimum(), xAxis.getDataMaximum(), Math.abs(column.getWidth()) / 1 + 1, xAxis.isLog());
        this.imageXRange = xAxis.getDatumRange();
        this.imageYRange = yAxis_1.getDatumRange();
        int xDMax = column.getDMaximum();
        int xDMin = column.getDMinimum();
        QDataSet xtysData = this.getDataSet();
        if (xtysData == null) {
            this.plotImage = null;
            this.getParent().postMessage((Renderer)this, "null data set", DasPlot.WARNING, null, null);
            return;
        }
        if (xtysData.length() == 0) {
            this.getParent().postMessage((Renderer)this, "empty data set", DasPlot.WARNING, null, null);
            return;
        }
        if (xtysData.rank() != 2) {
            this.getParent().postMessage((Renderer)this, "dataset is not rank 2", DasPlot.WARNING, null, null);
            return;
        }
        Rebinner rebinner = new Rebinner();
        QDataSet data = rebinner.rebin(xtysData, xbins, null);
        QDataSet peaks = (QDataSet)data.property("BIN_MAX");
        if (peaks == null) {
            peaks = (QDataSet)data.property("BIN_PLUS");
            peaks = peaks == null ? data : Ops.add(data, peaks);
        }
        QDataSet weights = SemanticOps.weightsDataSet(data);
        DasAxis yAxis1 = yAxis_1;
        int zmid = this.zAxis.getRow().getDMiddle();
        boolean haveLittleRow = false;
        QDataSet yds = SemanticOps.ytagsDataSet(data);
        Units yunits = SemanticOps.getUnits(yds);
        Units zunits = SemanticOps.getUnits(data);
        if (!zunits.isConvertibleTo(this.zAxis.getUnits())) {
            String msg = "dataset z units are \"" + zunits + "\" while z axis are \"" + this.zAxis.getUnits() + "\"";
            zunits = this.zAxis.getUnits();
            this.getParent().postMessage((Renderer)this, msg, DasPlot.WARNING, null, null);
        }
        int[] yBases = new int[data.length(0)];
        for (int j = 0; j < data.length(0); ++j) {
            yBases[j] = yAxis1 instanceof DasLabelAxis ? ((DasLabelAxis)yAxis1).getItemMax(yunits.createDatum(yds.value(j))) : (int)yAxis1.transform(yunits.createDatum(yds.value(j)));
        }
        int yRowHeight = yBases[0] - yBases[1];
        for (int j = 0; j < data.length(0); ++j) {
            int yBase = yBases[j];
            g.setColor(Color.lightGray);
            g.drawLine(xDMin, yBase, xDMax, yBase);
            g.setColor(BAR_COLOR);
            int yBaseTop = yBase - yRowHeight;
            if (!haveLittleRow && yBaseTop <= zmid) {
                this.littleRow.setDPosition(yBaseTop, yBase);
                haveLittleRow = true;
                this.zAxisConnector.setVisible(true);
                this.zAxisConnector.repaint();
            }
            double[] binStarts = xbins.binStarts();
            int y0 = yBase;
            int littleRowHeight = yBase - yBaseTop;
            double zAxisMax = this.zAxis.getDataMaximum().doubleValue(zunits);
            double zAxisMin = this.zAxis.getDataMinimum().doubleValue(zunits);
            if (yBase < row.getDMinimum() || yBaseTop > row.getDMaximum()) continue;
            if (this.peaksIndicator == PeaksIndicator.PeakLine && peaks != null) {
                GeneralPath p = new GeneralPath();
                boolean lastWasFill = true;
                for (int ibin = 0; ibin < data.length(); ++ibin) {
                    int x0 = (int)xAxis.transform(binStarts[ibin], xbins.getUnits());
                    double zz = peaks.value(ibin, j);
                    if (weights.value(ibin, j) != 0.0) {
                        int yMax = (int)this.zAxis.transform(zz, zunits, yBase, yBaseTop);
                        if (lastWasFill) {
                            p.moveTo(x0, Math.min(yMax, y0));
                        }
                        p.lineTo(x0, Math.min(yMax, y0));
                        lastWasFill = false;
                        continue;
                    }
                    lastWasFill = true;
                }
                g.draw(p);
            }
            for (int ibin = 0; ibin < data.length(); ++ibin) {
                double peakValue;
                int yHeight;
                int x0 = (int)xAxis.transform(binStarts[ibin], xbins.getUnits());
                double zz = data.value(ibin, j);
                if (weights.value(ibin, j) == 0.0) continue;
                int yAvg = (int)this.zAxis.transform(zz, zunits, yBase, yBaseTop);
                yAvg = yAvg > y0 - littleRowHeight ? yAvg : y0 - littleRowHeight;
                int n = yHeight = y0 - yAvg > 0 ? y0 - yAvg : 0;
                if (peaks != null && (peakValue = peaks.value(ibin, j)) <= zAxisMax) {
                    int yMax = (int)this.zAxis.transform(peakValue, zunits, yBase, yBaseTop);
                    int n2 = yMax = y0 - yMax > 0 ? yMax : y0;
                    if (this.peaksIndicator == PeaksIndicator.MaxDots) {
                        g.drawLine(x0, yMax, x0, yMax);
                    } else if (this.peaksIndicator != PeaksIndicator.PeakLine) {
                        if (this.peaksIndicator == PeaksIndicator.GrayPeaks) {
                            g.setColor(Color.gray);
                            g.drawLine(x0, yMax, x0, y0);
                            g.setColor(BAR_COLOR);
                        } else if (this.peaksIndicator == PeaksIndicator.BlackPeaks) {
                            g.setColor(BAR_COLOR);
                            g.drawLine(x0, yMax, x0, y0);
                        }
                    }
                }
                if (!(zz >= zAxisMin)) continue;
                g.drawLine(x0, yAvg, x0, yAvg + yHeight);
            }
        }
        g.dispose();
        this.plotImage = plotImage1;
        if (this.sliceRebinnedData) {
            this.ds = data;
        }
    }

    @Override
    public DasAxis getZAxis() {
        return this.zAxis;
    }

    public void setZTitle(String title) {
        this.getZAxis().setLabel(title);
    }

    public PeaksIndicator getPeaksIndicator() {
        return this.peaksIndicator;
    }

    public void setPeaksIndicator(PeaksIndicator peaksIndicator) {
        this.peaksIndicator = peaksIndicator;
        this.updateCacheImage();
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    @Override
    public String getListLabel() {
        return "stacked histogram";
    }

    @Override
    public Icon getListIcon() {
        return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/stackedHistogram.png"));
    }

    public static enum PeaksIndicator {
        NoPeaks,
        GrayPeaks,
        BlackPeaks,
        MaxDots,
        PeakLine;

    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StackedHistogramRenderer.this.update();
        }
    }

    public static class Rebinner
    implements DataSetRebinner {
        AverageTableRebinner highResRebinner = new AverageTableRebinner();
        DataSetRebinner lowResRebinner;

        Rebinner() {
            this.highResRebinner.setInterpolateType(AverageTableRebinner.Interpolate.NearestNeighbor);
            this.lowResRebinner = new AveragePeakTableRebinner();
        }

        @Override
        public QDataSet rebin(QDataSet ds, RebinDescriptor x, RebinDescriptor y) throws IllegalArgumentException, DasException {
            QDataSet xds = SemanticOps.xtagsDataSet(ds);
            Datum xwidth = SemanticOps.guessXTagWidth(xds, null);
            if (xwidth == null) {
                xwidth = DataSetUtil.asDatum(DataSetUtil.guessCadenceNew(xds, null));
            }
            try {
                QDataSet result;
                QDataSet binMax = (QDataSet)ds.property("BIN_MAX");
                QDataSet binPlus = (QDataSet)ds.property("BIN_PLUS");
                if (binPlus == null && binMax == null && x.binWidthDatum().lt(xwidth)) {
                    Renderer.logger.log(Level.FINE, "using rebinner {0}", this.highResRebinner);
                    result = this.highResRebinner.rebin(ds, x, y);
                } else {
                    Renderer.logger.log(Level.FINE, "using rebinner {0}", this.lowResRebinner);
                    result = this.lowResRebinner.rebin(ds, x, y);
                }
                return result;
            }
            catch (Exception e) {
                throw new DasException(e);
            }
        }
    }
}

