/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.components.HorizontalSpectrogramSlicer;
import org.das2.components.VerticalSpectrogramAverager;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.LanlNNRebinner;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.ScatterRebinner;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.TriScatRebinner;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.HorizontalDragRangeSelectorMouseModule;
import org.das2.event.HorizontalSlicerMouseModule;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class SpectrogramRenderer
extends Renderer
implements TableDataSetConsumer,
Displayable {
    private static final Logger logger = LoggerManager.getLogger("das2.graphics.renderer.spectrogram");
    private Image plotImage;
    private Rectangle plotImageBounds;
    private byte[] raster;
    private int rasterWidth;
    private int rasterHeight;
    private int validCount;
    DatumRange imageXRange;
    DatumRange imageYRange;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    DasAxis.Memento cmemento;
    int updateImageCount = 0;
    int renderCount = 0;
    private QDataSet rebinDataSet;
    private String xrangeWarning = null;
    private String yrangeWarning = null;
    boolean unitsWarning = false;
    private VerticalSpectrogramSlicer vSlicer;
    private HorizontalSpectrogramSlicer hSlicer;
    private VerticalSpectrogramAverager vAverager;
    RebinListener rebinListener = new RebinListener();
    private RebinnerEnum rebinnerEnum;
    int count = 0;
    private boolean sliceRebinnedData = true;
    public static final String PROP_REBINNER = "rebinner";
    private boolean print300dpi;
    private Shape selectionArea = null;
    private Color fillColor = Color.GRAY;

    @Override
    public void setControl(String s) {
        super.setControl(s);
        DasColorBar cb = this.getColorBar();
        if (cb != null) {
            String t = this.getControl("colorTable", cb.getType().toString());
            this.getColorBar().setType(DasColorBar.Type.parse(t));
        }
        this.update();
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        DasColorBar cb = this.getColorBar();
        if (cb != null) {
            controls.put("colorTable", this.getColorBar().getType().toString());
        }
        return SpectrogramRenderer.formatControl(controls);
    }

    public SpectrogramRenderer(DataSetDescriptor dsd, DasColorBar colorBar) {
        super(dsd);
        this.colorBar = colorBar;
        if (this.colorBar != null) {
            colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.addPropertyChangeListener("log", this.rebinListener);
            colorBar.addPropertyChangeListener("flipped", this.rebinListener);
            colorBar.addPropertyChangeListener("type", this.rebinListener);
            colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
        }
        this.setRebinner(RebinnerEnum.binAverage);
    }

    @Override
    public DasAxis getZAxis() {
        return this.colorBar;
    }

    @Override
    public void setColorBar(DasColorBar cb) {
        if (this.colorBar == cb) {
            return;
        }
        DasPlot parent = this.getParent();
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("flipped", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            this.colorBar.removePropertyChangeListener("fillColor", this.rebinListener);
            if (parent != null && parent.getCanvas() != null) {
                parent.getCanvas().remove(this.colorBar);
            }
        }
        this.colorBar = cb;
        if (this.colorBar != null) {
            this.colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("log", this.rebinListener);
            this.colorBar.addPropertyChangeListener("flipped", this.rebinListener);
            this.colorBar.addPropertyChangeListener("type", this.rebinListener);
            this.colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
            if (parent != null && parent.getCanvas() != null) {
                parent.getCanvas().add(this.colorBar);
            }
        }
    }

    private static QDataSet bounds(QDataSet ds) {
        if (SemanticOps.isRank2Waveform(ds)) {
            QDataSet xrange = Ops.extentSimple(SemanticOps.xtagsDataSet(ds), null);
            QDataSet yrange = Ops.extentSimple(SemanticOps.ytagsDataSet(ds), null);
            return Ops.join(xrange, yrange);
        }
        return DataSetOps.dependBoundsSimple(ds);
    }

    @Override
    public synchronized void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        logger.entering("org.das2.graph.SpectrogramRenderer", "render");
        Graphics2D g2 = (Graphics2D)g;
        DasPlot parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (this.plotImage == null) {
            if (this.lastException != null) {
                if (this.lastException instanceof NoDataInIntervalException) {
                    parent.postMessage((Renderer)this, "no data in interval:!c" + this.lastException.getMessage(), DasPlot.WARNING, null, null);
                } else {
                    parent.postException(this, this.lastException);
                }
            } else {
                QDataSet zds = this.getDataSet();
                QDataSet xds = null;
                QDataSet yds = null;
                if (zds == null) {
                    parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
                } else {
                    if (!SemanticOps.isTableDataSet(zds) && !SemanticOps.isBundle(zds) && zds.property("PLANE_0") == null) {
                        parent.postMessage((Renderer)this, "expected table dataset, got " + zds, DasPlot.INFO, null, null);
                        logger.exiting("org.das2.graph.SpectrogramRenderer", "render");
                        return;
                    }
                    if (zds.rank() == 2) {
                        xds = SemanticOps.xtagsDataSet(zds);
                        yds = SemanticOps.ytagsDataSet(zds);
                    } else if (zds.rank() == 3) {
                        xds = SemanticOps.xtagsDataSet(zds.slice(0));
                        yds = SemanticOps.ytagsDataSet(zds.slice(0));
                    } else if (zds.rank() == 1) {
                        xds = SemanticOps.xtagsDataSet(zds);
                        yds = zds;
                        zds = (QDataSet)yds.property("PLANE_0");
                    }
                    if (this.getDataSet().length() == 0) {
                        parent.postMessage((Renderer)this, "empty data set", DasPlot.INFO, null, null);
                    } else {
                        boolean xunitsOkay = SemanticOps.getUnits(xds).isConvertibleTo(xAxis.getUnits());
                        boolean yunitsOkay = SemanticOps.getUnits(yds).isConvertibleTo(yAxis.getUnits());
                        String message = null;
                        if (!xunitsOkay && !yunitsOkay) {
                            message = "xaxis and yaxis units";
                        } else if (!xunitsOkay) {
                            message = "xaxis units";
                        } else if (!yunitsOkay) {
                            message = "yaxis units";
                        }
                        if (message != null) {
                            parent.postMessage((Renderer)this, "inconvertible " + message, DasPlot.INFO, null, null);
                        }
                        if (!SemanticOps.isTableDataSet(zds) && SemanticOps.isBundle(zds)) {
                            zds = SemanticOps.getDependentDataSet(zds);
                            logger.log(Level.FINE, "spectrogram renderer will handle bundle: {0}", zds.toString());
                        }
                    }
                }
            }
        } else {
            if (this.unitsWarning) {
                QDataSet zds = this.getDataSet();
                QDataSet xds = null;
                QDataSet yds = null;
                if (zds == null) {
                    parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
                    logger.exiting("org.das2.graph.SpectrogramRenderer", "render");
                    return;
                }
                switch (zds.rank()) {
                    case 1: {
                        if (Schemes.isLegacyXYZScatter(zds)) {
                            xds = SemanticOps.xtagsDataSet(zds);
                            yds = SemanticOps.ytagsDataSet(zds);
                            break;
                        }
                        throw new IllegalArgumentException("only type rank 1 datasets with PLANE_0 supported");
                    }
                    case 2: {
                        xds = SemanticOps.xtagsDataSet(zds);
                        yds = SemanticOps.ytagsDataSet(zds);
                        break;
                    }
                    case 3: {
                        xds = SemanticOps.xtagsDataSet(zds.slice(0));
                        yds = SemanticOps.ytagsDataSet(zds.slice(0));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("only rank 2 and rank 3 supported");
                    }
                }
                if (!SemanticOps.getUnits(yds).isConvertibleTo(yAxis.getUnits())) {
                    parent.postMessage((Renderer)this, "dataset y units are \"" + SemanticOps.getUnits(yds) + "\" while yaxis is \"" + yAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                }
                if (!SemanticOps.getUnits(xds).isConvertibleTo(xAxis.getUnits())) {
                    parent.postMessage((Renderer)this, "dataset x units are \"" + SemanticOps.getUnits(xds) + "\" while xaxis is \"" + xAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                }
                if (!SemanticOps.getUnits(zds).isConvertibleTo(this.colorBar.getUnits()) && !Schemes.isLegacyXYZScatter(zds)) {
                    parent.postMessage((Renderer)this, "dataset z units are \"" + SemanticOps.getUnits(zds) + "\" while zaxis is \"" + this.colorBar.getUnits() + "\"", DasPlot.INFO, null, null);
                }
            }
            Point2D.Float p = new Point2D.Float(this.plotImageBounds.x, this.plotImageBounds.y);
            int x = (int)(((Point2D)p).getX() + 0.5);
            int y = (int)(((Point2D)p).getY() + 0.5);
            if (parent.getCanvas().isPrintingThread() && this.print300dpi) {
                AffineTransform atinv;
                AffineTransformOp atop = new AffineTransformOp(AffineTransform.getScaleInstance(4.0, 4.0), 1);
                BufferedImage image300 = atop.filter((BufferedImage)this.plotImage, null);
                try {
                    atinv = atop.getTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
                atinv.translate(x * 4, y * 4);
                g2.drawImage(image300, atinv, this.getParent());
            } else {
                try {
                    g2.drawImage(this.plotImage, x, y, this.getParent());
                }
                catch (ClassCastException ex) {
                    System.err.println("rte_1917581137: " + ex.getMessage());
                }
            }
            if (this.validCount == 0) {
                QDataSet bounds = SpectrogramRenderer.bounds(this.ds);
                DatumRange xdr = DataSetUtil.asDatumRange(bounds.slice(0), true);
                DatumRange ydr = DataSetUtil.asDatumRange(bounds.slice(1), true);
                if (xAxis.getDatumRange().intersects(xdr) && yAxis.getDatumRange().intersects(ydr)) {
                    parent.postMessage((Renderer)this, "dataset contains no valid data", DasPlot.INFO, null, null);
                } else if (this.xrangeWarning == null && this.yrangeWarning == null) {
                    parent.postMessage((Renderer)this, "dataset is outside of axis range", DasPlot.INFO, null, null);
                }
            }
            if (this.xrangeWarning != null) {
                parent.postMessage((Renderer)this, "no data in interval:!c" + this.xrangeWarning, DasPlot.WARNING, null, null);
            }
            if (this.yrangeWarning != null) {
                parent.postMessage((Renderer)this, "no data in interval:!c" + this.yrangeWarning, DasPlot.WARNING, null, null);
            }
        }
        logger.exiting("org.das2.graph.SpectrogramRenderer", "render");
    }

    private static byte[] makePixMap(QDataSet rebinData, byte[] pix) {
        logger.fine("converting to pixel map");
        int ny = rebinData.length(0);
        int nx = rebinData.length();
        pix = new byte[nx * ny];
        return pix;
    }

    private static int transformSimpleTableDataSet(QDataSet rebinData, DasColorBar cb, boolean flipY, byte[] pix) {
        if (rebinData.rank() != 2) {
            throw new IllegalArgumentException("rank 2 expected");
        }
        logger.fine("converting to pixel map");
        int ny = rebinData.length(0);
        int nx = rebinData.length();
        Units units = SemanticOps.getUnits(rebinData);
        if (!units.isConvertibleTo(cb.getUnits())) {
            units = cb.getUnits();
        }
        QDataSet wds = SemanticOps.weightsDataSet(rebinData);
        Arrays.fill(pix, (byte)cb.getFillColorIndex());
        int validCount = 0;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                if (!(wds.value(i, j) > 0.0)) continue;
                int index = flipY ? i + j * nx : i - 0 + (ny - j - 1) * nx;
                int icolor = cb.indexColorTransform(rebinData.value(i, j), units);
                pix[index] = (byte)icolor;
                ++validCount;
            }
        }
        if (validCount == 0) {
            logger.fine("dataset contains no valid data");
        }
        return validCount;
    }

    private void reportCount() {
        if (this.updateImageCount % 10 == 0) {
            // empty if block
        }
    }

    private static RebinDescriptor convertUnitsTo(RebinDescriptor in, Units newUnits) {
        RebinDescriptor result = new RebinDescriptor(newUnits.createDatum(in.binStarts()[0]), newUnits.createDatum(in.binStops()[in.numberOfBins() - 1]), in.numberOfBins(), in.isLog());
        return result;
    }

    private int compare(Datum a, Datum b) {
        if (a.getUnits().isConvertibleTo(b.getUnits())) {
            return a.compareTo(b);
        }
        if (UnitsUtil.isRatioMeasurement(a.getUnits()) && UnitsUtil.isRatioMeasurement(b.getUnits())) {
            return Double.compare(a.value(), b.value());
        }
        throw new InconvertibleUnitsException(a.getUnits(), b.getUnits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        block62: {
            SpectrogramRenderer.logger.entering("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
            super.incrementUpdateCount();
            lparent = this.getParent();
            if (lparent == null) {
                return;
            }
            fds = this.ds;
            bounds = null;
            SpectrogramRenderer.logger.log(Level.FINE, "SpectrogramRenderer is rendering dataset {0} on {1}", new Object[]{fds, Thread.currentThread().getName()});
            lraster = this.raster;
            lcolorBar = this.colorBar;
            if (lcolorBar == null) {
                return;
            }
            try {
                block63: {
                    SpectrogramRenderer.logger.log(Level.FINER, "axis units x:{0} y:{1} z:{2}", new Object[]{xAxis.getUnits(), yAxis.getUnits(), lcolorBar.getUnits()});
                    xunits = null;
                    yunits = null;
                    if (fds != null && fds.length() > 0) {
                        if (fds.rank() == 2) {
                            xunits = SemanticOps.getUnits(SemanticOps.xtagsDataSet(fds));
                            yunits = SemanticOps.isJoin(fds) ? SemanticOps.getUnits(SemanticOps.xtagsDataSet(fds.slice(0))) : SemanticOps.getUnits(SemanticOps.ytagsDataSet(fds));
                        } else if (fds.rank() < 2) {
                            xunits = SemanticOps.getUnits(SemanticOps.xtagsDataSet(fds));
                            yunits = SemanticOps.getUnits(SemanticOps.ytagsDataSet(fds));
                        } else {
                            xunits = SemanticOps.getUnits(SemanticOps.xtagsDataSet(fds.slice(0)));
                            yunits = SemanticOps.getUnits(SemanticOps.ytagsDataSet(fds.slice(0)));
                        }
                    }
                    plotImageBounds2 = lparent.getUpdateImageBounds();
                    lxmemento = xAxis.getMemento();
                    lymemento = yAxis.getMemento();
                    lcmemento = lcolorBar.getMemento();
                    if (lraster == null || this.xmemento == null || this.ymemento == null || !lxmemento.equals(this.xmemento) || !lymemento.equals(this.ymemento) || !lcmemento.equals(this.cmemento) || plotImageBounds2.width != this.rasterWidth || plotImageBounds2.height != this.rasterHeight) break block63;
                    SpectrogramRenderer.logger.finer("same xaxis, yaxis, reusing raster");
                    ** GOTO lbl157
                }
                if (plotImageBounds2 == null || plotImageBounds2.width <= 1 || plotImageBounds2.height <= 1) {
                    SpectrogramRenderer.logger.finest("canvas not useable!!!");
                    SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                    return;
                }
                if (fds == null) {
                    SpectrogramRenderer.logger.finer("got null dataset, setting image to null");
                    this.plotImage = null;
                    this.plotImageBounds = null;
                    this.rebinDataSet = null;
                    this.imageXRange = null;
                    this.imageYRange = null;
                    lparent.repaint();
                    SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                    return;
                }
                if (fds.length() == 0) {
                    SpectrogramRenderer.logger.finer("got empty dataset, setting image to null");
                    this.plotImage = null;
                    this.plotImageBounds = null;
                    this.rebinDataSet = null;
                    this.imageXRange = null;
                    this.imageYRange = null;
                    lparent.repaint();
                    SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                    return;
                }
                if (fds.rank() == 2) {
                    xunits = SemanticOps.getUnits(SemanticOps.xtagsDataSet(fds));
                    yunits = SemanticOps.isJoin(fds) ? SemanticOps.getUnits(SemanticOps.xtagsDataSet(fds.slice(0))) : SemanticOps.getUnits(SemanticOps.ytagsDataSet(fds));
                } else if (fds.rank() < 2 && !Schemes.isLegacyXYZScatter(fds)) {
                    xunits = xAxis.getUnits();
                    yunits = yAxis.getUnits();
                } else if (Schemes.isLegacyXYZScatter(fds)) {
                    yunits = SemanticOps.getUnits(SemanticOps.ytagsDataSet(fds));
                } else {
                    xunits = SemanticOps.getUnits(SemanticOps.xtagsDataSet(fds.slice(0)));
                    yunits = SemanticOps.getUnits(SemanticOps.ytagsDataSet(fds.slice(0)));
                }
                this.unitsWarning = false;
                if (!xunits.isConvertibleTo(xAxis.getUnits())) {
                    if (UnitsUtil.isRatioMeasurement(xunits) && UnitsUtil.isRatioMeasurement(xAxis.getUnits())) {
                        this.unitsWarning = true;
                    } else {
                        SpectrogramRenderer.logger.finer("dataset units are incompatable with x axis.");
                        this.plotImage = null;
                        this.plotImageBounds = null;
                        SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                        return;
                    }
                }
                if (!yunits.isConvertibleTo(yAxis.getUnits())) {
                    if (UnitsUtil.isRatioMeasurement(yunits) && UnitsUtil.isRatioMeasurement(yAxis.getUnits())) {
                        this.unitsWarning = true;
                    } else {
                        SpectrogramRenderer.logger.finer("dataset units are incompatable with y axis.");
                        this.plotImage = null;
                        this.plotImageBounds = null;
                        SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                        return;
                    }
                }
                zds = fds;
                if (!SemanticOps.isTableDataSet(fds)) {
                    if (SemanticOps.isBundle(fds)) {
                        zds = SemanticOps.getDependentDataSet(fds);
                    } else if (zds.property("PLANE_0") == null) {
                        SpectrogramRenderer.logger.finer("dataset is not TableDataSet.");
                        this.plotImage = null;
                        this.plotImageBounds = null;
                        SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                        return;
                    }
                }
                if (!(plottable = (zunits = SemanticOps.getUnits(zds)).isConvertibleTo(lcolorBar.getUnits())) && UnitsUtil.isRatioMeasurement(SemanticOps.getUnits(zds)) && UnitsUtil.isRatioMeasurement(lcolorBar.getUnits())) {
                    this.unitsWarning = true;
                }
                xRebinDescriptor = new RebinDescriptor(xAxis.invTransform(plotImageBounds2.x), xAxis.invTransform(plotImageBounds2.x + plotImageBounds2.width), plotImageBounds2.width, xAxis.isLog());
                yRebinDescriptor = new RebinDescriptor(yAxis.invTransform(plotImageBounds2.y + plotImageBounds2.height), yAxis.invTransform(plotImageBounds2.y), plotImageBounds2.height, yAxis.isLog());
                if (!xunits.isConvertibleTo(xAxis.getUnits())) {
                    xRebinDescriptor = SpectrogramRenderer.convertUnitsTo(xRebinDescriptor, xunits);
                }
                if (!yunits.isConvertibleTo(yAxis.getUnits())) {
                    yRebinDescriptor = SpectrogramRenderer.convertUnitsTo(yRebinDescriptor, yunits);
                }
                this.imageXRange = xAxis.getDatumRange();
                this.imageYRange = yAxis.getDatumRange();
                rebinner = this.rebinnerEnum.getRebinner();
                SpectrogramRenderer.logger.log(Level.FINE, "get the bounding box");
                bounds = SpectrogramRenderer.bounds(fds);
                SpectrogramRenderer.logger.log(Level.FINE, "rebinning to pixel resolution: {0}  {1}", new Object[]{xRebinDescriptor, yRebinDescriptor});
                SpectrogramRenderer.logger.log(Level.FINE, "rebinning to pixel resolution: {0}", plotImageBounds2);
                start = Datum.create(bounds.value(0, 0), xunits);
                end = Datum.create(bounds.value(0, 1), xunits);
                if (xunits.isFill(bounds.value(0, 0))) {
                    this.xrangeWarning = "no valid timetags in dataset";
                    throw new NoDataInIntervalException(this.xrangeWarning);
                }
                this.xrangeWarning = this.compare(start, this.imageXRange.max()) > 0 ? "data starts after range" : (this.compare(end, this.imageXRange.min()) < 0 ? "data ends before range" : null);
                this.yrangeWarning = yunits.isFill(bounds.value(1, 0)) != false && yunits.isFill(bounds.value(1, 1)) != false ? "no valid y tags in dataset" : (this.compare(Datum.create(bounds.value(1, 0), yunits), this.imageYRange.max()) > 0 ? "data starts above yrange" : (this.compare(Datum.create(bounds.value(1, 1), yunits), this.imageYRange.min()) < 0 ? "data ends below yrange" : null));
                try {
                    this.rebinDataSet = rebinner.rebin(fds, xRebinDescriptor, yRebinDescriptor);
                    this.rebinDataSet = Ops.putProperty(this.rebinDataSet, "UNITS", (Object)zunits);
                }
                catch (RuntimeException ex) {
                    SpectrogramRenderer.logger.log(Level.WARNING, ex.getMessage(), ex);
                    this.plotImage = null;
                    this.plotImageBounds = null;
                    this.lastException = ex;
                    lparent.postException(this, ex);
                    SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                    SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                    lparent.repaint();
                    return;
                }
                this.xmemento = lxmemento;
                this.ymemento = lymemento;
                this.cmemento = lcmemento;
                SpectrogramRenderer.logger.log(Level.FINE, "done rebinning to pixel resolution: {0}  {1}", new Object[]{this.xmemento, this.ymemento});
                lraster = SpectrogramRenderer.makePixMap(this.rebinDataSet, lraster);
                try {
                    this.validCount = SpectrogramRenderer.transformSimpleTableDataSet(this.rebinDataSet, lcolorBar, false, lraster);
                }
                catch (InconvertibleUnitsException ex) {
                    System.err.println("zunits=" + SemanticOps.getUnits(fds) + "  colorbar=" + lcolorBar.getUnits());
                    SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                    SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                    lparent.repaint();
                    return;
                }
                try {
                    this.rasterWidth = plotImageBounds2.width;
                    this.rasterHeight = plotImageBounds2.height;
                    this.raster = lraster;
lbl157:
                    // 2 sources

                    model = lcolorBar.getIndexColorModel();
                    plotImage2 = new BufferedImage(plotImageBounds2.width, plotImageBounds2.height, 13, model);
                    r = plotImage2.getRaster();
                    if (plotImageBounds2.width == this.rasterWidth && plotImageBounds2.height == this.rasterHeight) {
                        try {
                            r.setDataElements(0, 0, this.rasterWidth, this.rasterHeight, lraster);
                        }
                        catch (Exception e) {
                            SpectrogramRenderer.logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    } else {
                        System.err.println("avoided raster ArrayIndex... track this down sometime...");
                    }
                    this.plotImage = plotImage2;
                    this.plotImageBounds = plotImageBounds2;
                    this.raster = lraster;
                    rr = DasDevicePosition.toRectangle(lparent.getRow(), lparent.getColumn());
                    if (fds == null) break block62;
                    if (bounds == null) {
                        bounds = SpectrogramRenderer.bounds(fds);
                    }
                    if (Double.isInfinite(bounds.value(1, 0))) {
                        this.selectionArea = rr;
                        break block62;
                    }
                    xdr = DataSetUtil.asDatumRange(bounds.slice(0), true);
                    ydr = DataSetUtil.asDatumRange(bounds.slice(1), true);
                    if (xunits != null && !xunits.isConvertibleTo(xAxis.getUnits())) {
                        xdr = new DatumRange(xdr.min().doubleValue(xdr.getUnits()), xdr.max().doubleValue(xdr.getUnits()), xAxis.getUnits());
                    }
                    if (yunits != null && !yunits.isConvertibleTo(yAxis.getUnits())) {
                        ydr = new DatumRange(ydr.min().doubleValue(ydr.getUnits()), ydr.max().doubleValue(ydr.getUnits()), yAxis.getUnits());
                    }
                    yy = GraphUtil.transformRange(yAxis, ydr);
                    xx = GraphUtil.transformRange(xAxis, xdr);
                    this.selectionArea = rr.intersection(new Rectangle((int)xx[0], (int)yy[0], (int)(xx[1] - xx[0]), (int)(yy[1] - yy[0])));
                }
                catch (InconvertibleUnitsException ex) {
                    SpectrogramRenderer.logger.fine("inconvertible units, setting image to null");
                    SpectrogramRenderer.logger.log(Level.WARNING, ex.getMessage(), ex);
                    this.plotImage = null;
                    this.plotImageBounds = null;
                    this.rebinDataSet = null;
                    this.imageXRange = null;
                    this.imageYRange = null;
                    if (this.getLastException() == null) {
                        this.setException(ex);
                    }
                    lparent.repaint();
                }
            }
            catch (NoDataInIntervalException e) {
                this.lastException = e;
                this.plotImage = null;
            }
            catch (ArrayIndexOutOfBoundsException | DasException ex) {
                SpectrogramRenderer.logger.log(Level.WARNING, ex.getMessage(), ex);
                this.lastException = ex;
                this.plotImage = null;
                lparent.postException(this, ex);
            }
            finally {
                SpectrogramRenderer.logger.exiting("org.das2.graph.SpectrogramRenderer", "updatePlotImage");
                lparent.repaint();
            }
        }
    }

    @Override
    protected void installRenderer() {
        DasPlot parent = this.getParent();
        if (parent != null && parent.getCanvas() != null && this.colorBar != null) {
            if (this.colorBar.getColumn() == DasColumn.NULL) {
                DasColumn column = parent.getColumn();
                this.colorBar.setColumn(new DasColumn(null, column, 1.0, 1.0, 1.0, 2.0, 0, 0));
            }
            parent.getCanvas().add(this.colorBar, parent.getRow(), this.colorBar.getColumn());
            if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
                DasMouseInputAdapter mouseAdapter = parent.mouseAdapter;
                this.vSlicer = VerticalSpectrogramSlicer.createSlicer(parent, this);
                VerticalSlicerMouseModule vsl = VerticalSlicerMouseModule.create(this);
                vsl.addDataPointSelectionListener(this.vSlicer);
                mouseAdapter.addMouseModule(vsl);
                this.hSlicer = HorizontalSpectrogramSlicer.createSlicer(parent, this);
                HorizontalSlicerMouseModule hsl = HorizontalSlicerMouseModule.create(this);
                hsl.addDataPointSelectionListener(this.hSlicer);
                mouseAdapter.addMouseModule(hsl);
                this.vAverager = VerticalSpectrogramAverager.createAverager(parent, this);
                HorizontalDragRangeSelectorMouseModule vrl = new HorizontalDragRangeSelectorMouseModule(parent, this, parent.getXAxis());
                vrl.setLabel("Interval Average");
                vrl.addDataRangeSelectionListener(this.vAverager);
                mouseAdapter.addMouseModule(vrl);
                CrossHairMouseModule ch = new CrossHairMouseModule(parent, this, parent.getXAxis(), parent.getYAxis());
                mouseAdapter.addMouseModule(ch);
            }
        }
    }

    @Override
    protected void uninstallRenderer() {
        DasPlot parent;
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false")) && (parent = this.getParent()) != null) {
            DasMouseInputAdapter mouseAdapter = parent.mouseAdapter;
            if (this.vSlicer != null) {
                this.vSlicer.dispose();
            }
            if (this.vAverager != null) {
                this.vAverager.dispose();
            }
            if (this.hSlicer != null) {
                this.hSlicer.dispose();
            }
            mouseAdapter.removeMouseModule(mouseAdapter.getModuleByLabel("Vertical Slice"));
            mouseAdapter.removeMouseModule(mouseAdapter.getModuleByLabel("Horizontal Slice"));
            mouseAdapter.removeMouseModule(mouseAdapter.getModuleByLabel("Interval Average"));
            CrossHairMouseModule ch = new CrossHairMouseModule(parent, parent.getXAxis(), parent.getYAxis());
            mouseAdapter.addMouseModule(ch);
        }
    }

    public RebinnerEnum getRebinner() {
        return this.rebinnerEnum;
    }

    public final void setRebinner(RebinnerEnum rebinnerEnum) {
        RebinnerEnum old = this.rebinnerEnum;
        if (old != rebinnerEnum) {
            this.rebinnerEnum = rebinnerEnum;
            this.raster = null;
            this.clearPlotImage();
            this.updateCacheImage();
            this.propertyChangeSupport.firePropertyChange(PROP_REBINNER, old, rebinnerEnum);
        }
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    @Override
    public String getListLabel() {
        return "spectrogram";
    }

    @Override
    public Icon getListIcon() {
        return this.rebinnerEnum.getListIcon();
    }

    @Override
    public QDataSet getConsumedDataSet() {
        if (this.sliceRebinnedData) {
            return this.rebinDataSet;
        }
        return this.ds;
    }

    private synchronized void clearPlotImage() {
        this.plotImage = null;
    }

    @Override
    public void setDataSet(QDataSet ds) {
        QDataSet oldDs = this.ds;
        DasPlot parent = this.getParent();
        if (parent != null && oldDs != ds) {
            this.raster = null;
            this.clearPlotImage();
        }
        if (this.vSlicer != null) {
            this.vSlicer.clear(ds);
            this.hSlicer.clear(ds);
            this.vAverager.clear();
        }
        super.setDataSet(ds);
    }

    public boolean isPrint300dpi() {
        return this.print300dpi;
    }

    public void setPrint300dpi(boolean print300dpi) {
        this.print300dpi = print300dpi;
    }

    public Shape selectionArea() {
        return this.selectionArea == null ? SelectionUtil.NULL : this.selectionArea;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        return this.selectionArea != null && this.selectionArea.contains(x, y);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SpectrogramRenderer.this.update();
            DasPlot p = SpectrogramRenderer.this.getParent();
            if (p != null) {
                p.invalidateCacheImageNoUpdate();
            }
        }
    }

    public static class RebinnerEnum
    implements Enumeration {
        DataSetRebinner rebinner;
        String label;
        public static final RebinnerEnum binAverage = new RebinnerEnum(new AverageTableRebinner(), "binAverage");
        public static final RebinnerEnum nearestNeighbor;
        public static final RebinnerEnum lanlNearestNeighbor;
        public static final RebinnerEnum binAverageNoInterpolate;
        public static final RebinnerEnum binAverageNoInterpolateNoEnlarge;
        public static final RebinnerEnum binXinterpY;
        public static final RebinnerEnum scatter;
        public static final RebinnerEnum triScat;

        public RebinnerEnum(DataSetRebinner rebinner, String label) {
            this.rebinner = rebinner;
            this.label = label;
        }

        @Override
        public Icon getListIcon() {
            URL url = SpectrogramRenderer.class.getResource("/images/icons/rebin." + this.label + ".png");
            if (url == null) {
                logger.info("icon not found at /images/icons/rebin." + this.label + ".png");
                return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/rebin.nearestNeighbor.png"));
            }
            return new ImageIcon(url);
        }

        @Override
        public String toString() {
            return this.label;
        }

        DataSetRebinner getRebinner() {
            return this.rebinner;
        }

        static {
            triScat = new RebinnerEnum(new TriScatRebinner(), "triScat");
            AverageTableRebinner rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            binAverageNoInterpolate = new RebinnerEnum(rebinner, "noInterpolate");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            rebinner.setEnlargePixels(false);
            binAverageNoInterpolateNoEnlarge = new RebinnerEnum(rebinner, "noInterpolateNoEnlarge");
            lanlNearestNeighbor = new RebinnerEnum(new LanlNNRebinner(), "lanlNearestNeighbor");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolateType(AverageTableRebinner.Interpolate.NearestNeighbor);
            nearestNeighbor = new RebinnerEnum(rebinner, "nearestNeighbor");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolateType(AverageTableRebinner.Interpolate.BinXInterpY);
            binXinterpY = new RebinnerEnum(rebinner, "binXinterpY");
            scatter = new RebinnerEnum(new ScatterRebinner(), "scatter");
        }
    }
}

