/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import org.das2.DasApplication;
import org.das2.DasProperties;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DataGeneralPathBuilder;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.GraphUtil;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qds.util.Reduction;
import org.das2.system.DasLogger;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeriesRenderer
extends Renderer {
    private DefaultPlotSymbol psym = DefaultPlotSymbol.CIRCLES;
    private float symSize = 3.0f;
    private float lineWidth = 1.0f;
    private boolean histogram = false;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private FillStyle fillStyle = FillStyle.STYLE_SOLID;
    private Color color = Color.BLACK;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));
    private int firstIndex = -1;
    private int lastIndex = -1;
    private int firstIndex_v = -1;
    private int lastIndex_v = -1;
    private int dslen = -1;
    boolean unitsWarning = false;
    boolean xunitsWarning = false;
    private static final Logger logger = LoggerManager.getLogger("das2.graphics.renderer.series");
    private boolean dataSetClipped;
    private boolean dataSetReduced;
    Image psymImage;
    Image[] coloredPsyms;
    int cmx;
    int cmy;
    FillRenderElement fillElement = new FillRenderElement();
    ErrorBarRenderElement errorElement = new ErrorBarRenderElement();
    PsymConnectorRenderElement psymConnectorElement = new PsymConnectorRenderElement();
    PsymRenderElement psymsElement = new PsymRenderElement();
    private boolean showLimits = true;
    public static final String PROP_SHOWLIMITS = "showLimits";
    Shape selectionArea;
    boolean haveValidColor = true;
    private static final int SIMPLIFY_PATHS_MIN_LIMIT = 1000;
    private float listIconSymSize = 3.0f;
    private boolean drawError = true;
    public static final String PROP_DRAWERROR = "drawError";
    private Color fillColor = Color.lightGray;
    private String fillDirection = "both";
    public static final String PROP_FILLDIRECTION = "fillDirection";
    private String colorByDataSetId = "";
    PropertyChangeListener colorBarListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                if (evt.getPropertyName().equals("type")) {
                    SeriesRenderer.this.updatePsym();
                    SeriesRenderer.this.update();
                } else if (evt.getPropertyName().equals("datumRange")) {
                    SeriesRenderer.this.update();
                }
            }
        }
    };
    private boolean fillToReference;
    private Datum reference = Units.dimensionless.createDatum(0);
    private boolean resetDebugCounters;
    private boolean simplifyPaths = true;
    private boolean stampPsyms = true;
    public static final String PROP_STAMPPSYMS = "stampPsyms";
    private int dataSetSizeLimit = 200000;
    private double updatesPointsPerMillisecond;
    public static final String PROP_UPDATESPOINTSPERMILLISECOND = "updatesPointsPerMillisecond";
    private double renderPointsPerMillisecond;
    public static final String PROP_RENDERPOINTSPERMILLISECOND = "renderPointsPerMillisecond";
    protected boolean cadenceCheck = true;
    public static final String PROP_CADENCECHECK = "cadenceCheck";

    public SeriesRenderer() {
        this.updatePsym();
    }

    public boolean isShowLimits() {
        return this.showLimits;
    }

    public void setShowLimits(boolean showLimits) {
        boolean oldShowLimits = this.showLimits;
        this.showLimits = showLimits;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_SHOWLIMITS, oldShowLimits, showLimits);
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.setColor(this.getColorControl("color", this.color));
        this.setFillColor(this.getColorControl("fillColor", this.fillColor));
        this.setFillDirection(this.getControl(PROP_FILLDIRECTION, "both"));
        this.setLineWidth(this.getDoubleControl("lineThick", this.lineWidth));
        this.setSymSize(this.getDoubleControl("symbolSize", this.symSize));
        this.setPsym(SeriesRenderer.decodePlotSymbolControl(this.getControl("symbol", this.psym.toString()), this.psym));
        this.setDrawError(this.getBooleanControl(PROP_DRAWERROR, this.drawError));
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("color", SeriesRenderer.encodeColorControl(this.color));
        controls.put("fillColor", SeriesRenderer.encodeColorControl(this.fillColor));
        controls.put(PROP_FILLDIRECTION, String.valueOf(this.fillDirection));
        controls.put("lineThick", String.valueOf(this.lineWidth));
        controls.put("symbolSize", String.valueOf(this.symSize));
        controls.put("symbol", SeriesRenderer.encodePlotSymbolControl(this.psym));
        controls.put(PROP_DRAWERROR, SeriesRenderer.encodeBooleanControl(this.drawError));
        return SeriesRenderer.formatControl(controls);
    }

    private QDataSet ytagsDataSet(QDataSet ds) {
        QDataSet vds;
        if (ds.rank() == 2 && SemanticOps.isBundle(ds)) {
            vds = SemanticOps.ytagsDataSet(ds);
        } else {
            if (ds.rank() == 2) {
                this.getParent().postMessage((Renderer)this, "dataset is rank 2 and not a bundle", DasPlot.INFO, null, null);
                return null;
            }
            vds = ds;
        }
        return vds;
    }

    private QDataSet colorByDataSet(QDataSet ds) {
        QDataSet colorByDataSet1 = null;
        if (this.colorByDataSetId.length() > 0) {
            if (this.colorByDataSetId.equals("PLANE_0")) {
                colorByDataSet1 = (QDataSet)ds.property("PLANE_0");
                if (colorByDataSet1 == null && ds.rank() == 2) {
                    colorByDataSet1 = DataSetOps.unbundleDefaultDataSet(ds);
                }
            } else if (ds.rank() == 2) {
                colorByDataSet1 = DataSetOps.unbundle(ds, this.colorByDataSetId);
            }
        }
        return colorByDataSet1;
    }

    private double doubleValue(Datum d, Units u) {
        if (d.getUnits().isConvertibleTo(u)) {
            return d.doubleValue(u);
        }
        try {
            return d.value();
        }
        catch (IllegalArgumentException ex) {
            throw new InconvertibleUnitsException(d.getUnits(), u);
        }
    }

    private double midPointData(DasAxis axis, double d1, Units units, double delta, boolean ratiometric, double alpha) {
        double fx1 = axis.isLog() && ratiometric ? Math.exp(Math.log(d1) + delta * alpha) : d1 + delta * alpha;
        return fx1;
    }

    private Datum getCadence(QDataSet xds, QDataSet yds, int firstIndex, int lastIndex) {
        WritableDataSet xds1 = Ops.copy(xds.trim(firstIndex, lastIndex));
        xds1.putProperty("CADENCE", null);
        return SemanticOps.guessXTagWidth(xds1, yds.trim(firstIndex, lastIndex));
    }

    private void updatePsym() {
        if (!this.isActive()) {
            return;
        }
        int sx = 6 + (int)Math.ceil(this.symSize + 2.0f * this.lineWidth);
        int sy = 6 + (int)Math.ceil(this.symSize + 2.0f * this.lineWidth);
        double dcmx = this.lineWidth + (float)((int)Math.ceil(this.symSize / 2.0f)) + 2.0f;
        double dcmy = this.lineWidth + (float)((int)Math.ceil(this.symSize / 2.0f)) + 2.0f;
        BufferedImage image = new BufferedImage(sx, sy, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Object rendering = this.antiAliased ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
        g.setColor(this.color);
        DasPlot lparent = this.getParent();
        if (lparent == null) {
            return;
        }
        g.setBackground(lparent.getBackground());
        g.setStroke(new BasicStroke(this.lineWidth));
        this.psym.draw(g, dcmx, dcmy, this.symSize, this.fillStyle);
        this.psymImage = image;
        DasColorBar lcolorBar = this.colorBar;
        if (this.colorByDataSetId != null && !this.colorByDataSetId.equals("") && lcolorBar != null) {
            this.initColoredPsyms(sx, sy, image, g, lparent, lcolorBar, rendering, dcmx, dcmy);
        }
        this.cmx = (int)dcmx;
        this.cmy = (int)dcmy;
        this.update();
    }

    private void initColoredPsyms(int sx, int sy, BufferedImage image, Graphics2D g, DasPlot lparent, DasColorBar lcolorBar, Object rendering, double dcmx, double dcmy) {
        IndexColorModel model = lcolorBar.getIndexColorModel();
        this.coloredPsyms = new Image[model.getMapSize()];
        for (int i = 0; i < model.getMapSize(); ++i) {
            Color c = new Color(model.getRGB(i));
            image = new BufferedImage(sx, sy, 2);
            g = (Graphics2D)image.getGraphics();
            g.setBackground(lparent.getBackground());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
            g.setColor(c);
            g.setStroke(new BasicStroke(this.lineWidth));
            this.psym.draw(g, dcmx, dcmy, this.symSize, this.fillStyle);
            this.coloredPsyms[i] = image;
        }
    }

    private synchronized void updateFirstLast(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet dataSet) {
        int index;
        int ixmax;
        int ixmin;
        long t0 = System.currentTimeMillis();
        this.firstIndex = -1;
        QDataSet yds = dataSet;
        if (xds.length() != yds.length()) {
            logger.fine("xds and yds have different lengths.  Assuming transitional case.");
            this.firstIndex_v = 0;
            this.lastIndex_v = xds.length();
            this.firstIndex = 0;
            this.lastIndex = xds.length();
            return;
        }
        if (yds.rank() == 2) {
            yds = DataSetOps.slice1(yds, 0);
        }
        if (yds.rank() == 3) {
            this.firstIndex = 0;
            this.lastIndex = xds.length();
            return;
        }
        if (xds.rank() == 2 && SemanticOps.isRank3JoinOfRank2Waveform(dataSet)) {
            xds = DataSetOps.slice1(xds, 0);
        }
        QDataSet wxds = SemanticOps.weightsDataSet(xds);
        QDataSet wds = SemanticOps.weightsDataSet(yds);
        DasPlot lparent = this.getParent();
        if (lparent == null) {
            return;
        }
        this.dslen = xds.length();
        if (SemanticOps.isMonotonic(xds)) {
            DatumRange visibleRange = xAxis.getDatumRange();
            Units xdsu = SemanticOps.getUnits(xds);
            if (!visibleRange.getUnits().isConvertibleTo(xdsu)) {
                visibleRange = new DatumRange(visibleRange.min().doubleValue(visibleRange.getUnits()), visibleRange.max().doubleValue(visibleRange.getUnits()), xdsu);
            }
            this.firstIndex_v = DataSetUtil.getPreviousIndex(xds, visibleRange.min());
            this.lastIndex_v = DataSetUtil.getNextIndex(xds, visibleRange.max()) + 1;
            if (lparent.isOverSize()) {
                Rectangle plotBounds = lparent.getUpdateImageBounds();
                if (plotBounds != null) {
                    visibleRange = xAxis.invTransform(plotBounds.x, plotBounds.x + plotBounds.width);
                }
                try {
                    ixmin = DataSetUtil.getPreviousIndex(xds, visibleRange.min());
                    ixmax = DataSetUtil.getNextIndex(xds, visibleRange.max()) + 1;
                }
                catch (IllegalArgumentException ex) {
                    ixmin = this.firstIndex_v;
                    ixmax = this.lastIndex_v;
                }
            } else {
                ixmin = this.firstIndex_v;
                ixmax = this.lastIndex_v;
            }
        } else {
            ixmin = 0;
            ixmax = xds.length();
            this.firstIndex_v = ixmin;
            this.lastIndex_v = ixmax;
        }
        for (index = ixmin; index < ixmax; ++index) {
            boolean isValid;
            boolean bl = isValid = wds.value(index) > 0.0 && wxds.value(index) > 0.0;
            if (!isValid) continue;
            this.firstIndex = index++;
            break;
        }
        if (this.firstIndex == -1) {
            this.lastIndex = ixmax;
            this.firstIndex = ixmax;
        }
        int pointsPlotted = 0;
        for (index = this.firstIndex; index < ixmax && pointsPlotted < this.dataSetSizeLimit; ++index) {
            boolean isValid;
            boolean bl = isValid = wds.value(index) > 0.0 && wxds.value(index) > 0.0;
            if (!isValid) continue;
            ++pointsPlotted;
        }
        if (index < ixmax && pointsPlotted == this.dataSetSizeLimit) {
            this.dataSetReduced = true;
            this.lastIndex = ixmax;
        } else {
            this.lastIndex = index;
        }
        logger.log(Level.FINE, "updateFirstLast ds: {0},  firstIndex={1} to lastIndex={2} in {3}ms", new Object[]{String.valueOf(this.ds), this.firstIndex, this.lastIndex, System.currentTimeMillis() - t0});
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updatePsym();
        }
    }

    @Override
    public synchronized void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        int symCount;
        int connectCount;
        boolean yaxisUnitsOkay;
        Units yunits;
        DasPlot lparent = this.getParent();
        logger.log(Level.FINE, "enter {0}.render: {1}", new Object[]{this.id, String.valueOf(this.getDataSet())});
        logger.log(Level.FINER, "ds: {0},  drawing indeces {1} to {2}", new Object[]{String.valueOf(this.ds), this.firstIndex, this.lastIndex});
        if (lparent == null) {
            return;
        }
        if (this.ds == null && this.lastException != null) {
            lparent.postException(this, this.lastException);
            return;
        }
        long timer0 = System.currentTimeMillis();
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            lparent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            return;
        }
        if (dataSet.rank() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("rank 0 data set");
            lparent.postMessage((Renderer)this, "rank 0 data set: " + dataSet.toString(), DasPlot.INFO, null, null);
            return;
        }
        if (dataSet.length() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("empty data set");
            lparent.postMessage((Renderer)this, "empty data set", DasPlot.INFO, null, null);
            return;
        }
        if (!(dataSet.rank() == 1 || SemanticOps.isBundle(this.ds) || SemanticOps.isRank2Waveform(this.ds) || SemanticOps.isRank3JoinOfRank2Waveform(this.ds))) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("dataset is not rank 1 or a rank 2 waveform");
            lparent.postMessage((Renderer)this, "dataset is not rank 1 or a rank 2 waveform", DasPlot.INFO, null, null);
            return;
        }
        if (this.psym == DefaultPlotSymbol.NONE && this.psymConnector == PsymConnector.NONE) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("plot symbol and symbol connector are set to none");
            lparent.postMessage((Renderer)this, "plot symbol and symbol connector are set to none", DasPlot.INFO, null, null);
            return;
        }
        boolean foreBackSameColor = true;
        if (!this.color.equals(lparent.getBackground())) {
            foreBackSameColor = false;
        }
        if (this.fillToReference && !this.color.equals(lparent.getBackground())) {
            foreBackSameColor = false;
        }
        if (lparent.getRenderers().length > 1) {
            foreBackSameColor = false;
        }
        if (foreBackSameColor) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("foreground and background colors are the same");
            lparent.postMessage((Renderer)this, "foreground and background colors are the same", DasPlot.INFO, null, null);
            return;
        }
        QDataSet tds = null;
        QDataSet vds = null;
        QDataSet xds = SemanticOps.xtagsDataSet(dataSet);
        boolean xaxisUnitsOkay = SemanticOps.getUnits(xds).isConvertibleTo(xAxis.getUnits());
        if (!SemanticOps.isTableDataSet(dataSet)) {
            vds = this.ytagsDataSet(this.ds);
            yunits = SemanticOps.getUnits(vds);
            yaxisUnitsOkay = yunits.isConvertibleTo(yAxis.getUnits());
        } else {
            tds = dataSet;
            yunits = SemanticOps.getUnits(tds);
            yaxisUnitsOkay = SemanticOps.getUnits(tds).isConvertibleTo(yAxis.getUnits());
        }
        boolean haveReportedUnitProblem = false;
        if (!xaxisUnitsOkay && !yaxisUnitsOkay && vds != null && SemanticOps.getUnits(xds) == SemanticOps.getUnits(vds) && xAxis.getUnits() == yAxis.getUnits()) {
            if (this.unitsWarning) {
                lparent.postMessage((Renderer)this, "axis units changed from \"" + SemanticOps.getUnits(vds) + "\" to \"" + yAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                haveReportedUnitProblem = true;
            } else {
                lparent.postMessage((Renderer)this, "inconvertible axis units", DasPlot.INFO, null, null);
                return;
            }
        }
        if (!haveReportedUnitProblem && !yaxisUnitsOkay) {
            if (this.unitsWarning) {
                if (vds != null) {
                    if (yAxis.getUnits() == Units.dimensionless) {
                        logger.log(Level.FINE, "data units \"{0}\" plotted on dimensionless axis", SemanticOps.getUnits(vds));
                    } else {
                        lparent.postMessage((Renderer)this, "yaxis units changed from \"" + SemanticOps.getUnits(vds) + "\" to \"" + yAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                    }
                }
            } else {
                lparent.postMessage((Renderer)this, "inconvertible yaxis units", DasPlot.INFO, null, null);
                return;
            }
        }
        if (!haveReportedUnitProblem && !xaxisUnitsOkay) {
            if (this.xunitsWarning) {
                if (xAxis.getUnits() == Units.dimensionless) {
                    logger.log(Level.FINE, "data units \"{0}\" plotted on dimensionless axis", SemanticOps.getUnits(xds));
                } else {
                    lparent.postMessage((Renderer)this, "xaxis units changed from \"" + SemanticOps.getUnits(xds) + "\" to \"" + xAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                }
            } else {
                lparent.postMessage((Renderer)this, "inconvertible xaxis units", DasPlot.INFO, null, null);
                return;
            }
        }
        int messageCount = 0;
        logger.log(Level.FINER, "rendering points: ds[{0}:{1}]", new Object[]{this.firstIndex, this.lastIndex});
        if (this.lastIndex == -1) {
            if (messageCount++ == 0) {
                lparent.postMessage((Renderer)this, "need to update first/last", DasPlot.INFO, null, null);
            }
            this.update();
            Timer t = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeriesRenderer.this.update();
                }
            });
            t.setRepeats(false);
            t.restart();
        }
        if (this.lastIndex == this.firstIndex && this.firstValidIndex == this.lastValidIndex && !this.dataSetReduced && messageCount++ == 0) {
            lparent.postMessage((Renderer)this, "dataset contains no valid data", DasPlot.INFO, null, null);
        }
        Graphics2D graphics = (Graphics2D)g;
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        mon.started();
        if (SemanticOps.isRank2Waveform(dataSet)) {
            graphics.setColor(this.color);
            logger.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
            connectCount = this.psymConnectorElement.render(graphics, xAxis, yAxis, dataSet, mon.getSubtaskMonitor("psymConnectorElement.render"));
            logger.log(Level.FINEST, "connectCount: {0}", connectCount);
            if (this.psym != DefaultPlotSymbol.NONE) {
                symCount = this.psymsElement.render(graphics, xAxis, yAxis, dataSet, mon.getSubtaskMonitor("psymsElement.render"));
                logger.log(Level.FINEST, "symCount: {0}", symCount);
            }
            if (this.drawError) {
                this.errorElement.render(graphics, xAxis, yAxis, dataSet, mon.getSubtaskMonitor("errorElement.render"));
            }
        } else if (tds != null) {
            graphics.setColor(this.color);
            logger.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
            connectCount = this.psymConnectorElement.render(graphics, xAxis, yAxis, tds, mon.getSubtaskMonitor("psymConnectorElement.render"));
            logger.log(Level.FINEST, "connectCount: {0}", connectCount);
            if (this.drawError) {
                this.errorElement.render(graphics, xAxis, yAxis, tds, mon.getSubtaskMonitor("errorElement.render"));
            }
        } else {
            if (this.fillToReference) {
                this.fillElement.render(graphics, xAxis, yAxis, vds, mon.getSubtaskMonitor("fillElement.render"));
            }
            graphics.setColor(this.color);
            logger.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
            connectCount = this.psymConnectorElement.render(graphics, xAxis, yAxis, vds, mon.getSubtaskMonitor("psymConnectorElement.render"));
            logger.log(Level.FINEST, "connectCount: {0}", connectCount);
            if (this.drawError) {
                this.errorElement.render(graphics, xAxis, yAxis, vds, mon.getSubtaskMonitor("errorElement.render"));
            }
            if (this.psym != DefaultPlotSymbol.NONE) {
                symCount = this.psymsElement.render(graphics, xAxis, yAxis, vds, mon.getSubtaskMonitor("psymsElement.render"));
                logger.log(Level.FINEST, "symCount: {0}", symCount);
            }
        }
        Map meta = (Map)this.ds.property("METADATA");
        if (meta != null && this.showLimits) {
            Line2D.Double l;
            double iy;
            DasColumn col = this.getParent().getColumn();
            Graphics2D graphics1 = (Graphics2D)graphics.create();
            Number d = SeriesRenderer.getKey(meta, "LIMITS_WARN_MIN", Number.class);
            if (d != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.RED);
                graphics1.draw(l);
            }
            if ((d = SeriesRenderer.getKey(meta, "LIMITS_WARN_MAX", Number.class)) != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.RED);
                graphics1.draw(l);
            }
            if ((d = SeriesRenderer.getKey(meta, "LIMITS_NOMINAL_MIN", Number.class)) != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.YELLOW);
                graphics1.setStroke(PsymConnector.DASHES.getStroke(1.0f));
                graphics1.draw(l);
            }
            if ((d = SeriesRenderer.getKey(meta, "LIMITS_NOMINAL_MAX", Number.class)) != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.YELLOW);
                graphics1.setStroke(PsymConnector.DASHES.getStroke(1.0f));
                graphics1.draw(l);
            }
        }
        mon.finished();
        long milli = System.currentTimeMillis();
        long renderTime = milli - timer0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        this.setRenderPointsPerMillisecond(dppms);
        logger.log(Level.FINE, "render: {0}ms total:{1} fps:{2} pts/ms:{3}", new Object[]{renderTime, milli - this.lastUpdateMillis, 1000.0 / (double)(milli - this.lastUpdateMillis), dppms});
        this.lastUpdateMillis = milli;
        int ldataSetSizeLimit = this.getDataSetSizeLimit();
        if (this.dataSetClipped) {
            lparent.postMessage((Renderer)this, "dataset clipped at " + ldataSetSizeLimit + " points", DasPlot.WARNING, null, null);
        }
        if (this.dataSetReduced) {
            lparent.postMessage((Renderer)this, "dataset reduced because of size > " + ldataSetSizeLimit + " points", DasPlot.WARNING, null, null);
        }
        if (!this.dataSetReduced) {
            if (this.lastIndex_v - this.firstIndex_v < 2 && dataSet.length() > 1 && messageCount++ == 0) {
                if (this.lastIndex_v < 2) {
                    if (this.firstValidIndex == this.lastValidIndex) {
                        lparent.postMessage((Renderer)this, "dataset contains no plottable data", DasPlot.INFO, null, null);
                    } else {
                        lparent.postMessage((Renderer)this, "data starts after range", DasPlot.INFO, null, null);
                    }
                } else if (this.dslen - this.firstIndex_v < 2) {
                    lparent.postMessage((Renderer)this, "data ends before range", DasPlot.INFO, null, null);
                } else {
                    lparent.postMessage((Renderer)this, "fewer than two points visible", DasPlot.INFO, null, null);
                }
            }
        } else if (this.lastIndex_v - this.firstIndex_v < 1 && dataSet.length() > 1) {
            lparent.postMessage((Renderer)this, "no data is visible", DasPlot.INFO, null, null);
        }
        graphics.dispose();
    }

    private static <T> T getKey(Map<String, Object> meta, String key, Class<T> type) {
        Object o = meta.get(key);
        if (o == null || !type.isInstance(o)) {
            return null;
        }
        return type.cast(o);
    }

    private QDataSet doDataSetReduce(DasAxis xAxis, DasAxis yAxis, QDataSet vds, int xlimit, int ylimit) {
        DatumRange xdr = xAxis.getDatumRange();
        QDataSet xxx = xAxis.isLog() ? Ops.exp10(Ops.linspace(Math.log10(xdr.min().doubleValue(xdr.getUnits())), Math.log10(xdr.max().doubleValue(xdr.getUnits())), xAxis.getDLength())) : Ops.linspace(xdr.min().doubleValue(xdr.getUnits()), xdr.max().doubleValue(xdr.getUnits()), Math.max(2, xAxis.getDLength() / xlimit));
        MutablePropertyDataSet mxxx = DataSetOps.makePropertiesMutable(xxx);
        mxxx.putProperty("UNITS", xdr.getUnits());
        if (xAxis.isLog()) {
            mxxx.putProperty("SCALE_TYPE", "log");
        }
        DatumRange ydr = yAxis.getDatumRange();
        QDataSet yyy = yAxis.isLog() ? Ops.exp10(Ops.linspace(Math.log10(ydr.min().doubleValue(ydr.getUnits())), Math.log10(ydr.max().doubleValue(ydr.getUnits())), yAxis.getDLength())) : Ops.linspace(ydr.min().doubleValue(ydr.getUnits()), ydr.max().doubleValue(ydr.getUnits()), Math.max(2, yAxis.getDLength() / ylimit));
        MutablePropertyDataSet myyy = DataSetOps.makePropertiesMutable(yyy);
        myyy.putProperty("UNITS", ydr.getUnits());
        if (yAxis.isLog()) {
            myyy.putProperty("SCALE_TYPE", "log");
        }
        long tt0 = System.currentTimeMillis();
        if (mxxx.length() < 2 || myyy.length() < 2) {
            logger.warning("that strange case where Kris saw  rte_1852410924");
            return vds;
        }
        QDataSet hds = Reduction.histogram2D(vds, mxxx, myyy);
        logger.log(Level.FINEST, "done histogram2D ({0}ms)", System.currentTimeMillis() - tt0);
        DataSetBuilder buildx = new DataSetBuilder(1, 100);
        DataSetBuilder buildy = new DataSetBuilder(1, 100);
        for (int ii = 0; ii < hds.length(); ++ii) {
            for (int jj = 0; jj < hds.length(0); ++jj) {
                if (!(hds.value(ii, jj) > 0.0)) continue;
                buildx.putValue(-1, xxx.value(ii));
                buildy.putValue(-1, yyy.value(jj));
                buildx.nextRecord();
                buildy.nextRecord();
            }
        }
        buildx.putProperty("UNITS", xdr.getUnits());
        buildy.putProperty("UNITS", ydr.getUnits());
        MutablePropertyDataSet mvds = DataSetOps.makePropertiesMutable(Ops.link(buildx.getDataSet(), buildy.getDataSet()));
        DataSetUtil.copyDimensionProperties(vds, mvds);
        return mvds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) {
        boolean plottable;
        Units yunits;
        long t0 = System.currentTimeMillis();
        logger.log(Level.FINE, "enter {0}.updatePlotImage: {1}", new Object[]{this.id, String.valueOf(this.getDataSet())});
        super.incrementUpdateCount();
        QDataSet dataSet = this.getDataSet();
        this.selectionArea = SelectionUtil.NULL;
        if (dataSet == null) {
            logger.fine("dataset was null");
            return;
        }
        if (dataSet.rank() == 0) {
            logger.fine("rank 0 dataset");
            return;
        }
        if (dataSet.length() == 0) {
            logger.fine("dataset was empty");
            return;
        }
        if (!this.isActive()) {
            return;
        }
        QDataSet tds = null;
        QDataSet vds = null;
        QDataSet xds = SemanticOps.xtagsDataSet(dataSet);
        if (dataSet.rank() < 3 && !SemanticOps.isRank2Waveform(dataSet)) {
            vds = this.ytagsDataSet(this.ds);
            if (vds == null) {
                logger.fine("dataset is not rank 1 or a rank 2 waveform");
                return;
            }
            if (xds.rank() != 1) {
                logger.fine("dataset xtags are not rank 1.");
                return;
            }
            if (vds.rank() != 1) {
                logger.fine("dataset is rank 2 and not a bundle.");
                return;
            }
            if (this.ds.rank() != 1 && !SemanticOps.isBundle(this.ds)) {
                logger.fine("dataset is rank 2 and not a bundle");
                return;
            }
            if (vds.length() != this.ds.length()) {
                logger.fine("dataset is rank 2 and will cause problems");
                return;
            }
            this.unitsWarning = false;
            yunits = SemanticOps.getUnits(vds);
            boolean bl = plottable = yunits.isConvertibleTo(yAxis.getUnits()) || yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(yunits);
            if (!plottable) {
                if (UnitsUtil.isRatioMeasurement(yunits) && UnitsUtil.isRatioMeasurement(yAxis.getUnits())) {
                    this.unitsWarning = true;
                }
            } else if (!yunits.isConvertibleTo(yAxis.getUnits()) && yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(yunits)) {
                this.unitsWarning = true;
            }
        } else if (SemanticOps.isRank2Waveform(dataSet)) {
            tds = dataSet;
            yunits = SemanticOps.getUnits(tds);
            boolean bl = plottable = yunits.isConvertibleTo(yAxis.getUnits()) || yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(yunits);
            if (!plottable && UnitsUtil.isRatioMeasurement(yunits) && UnitsUtil.isRatioMeasurement(yAxis.getUnits())) {
                this.unitsWarning = true;
            }
        } else if (SemanticOps.isRank3JoinOfRank2Waveform(dataSet)) {
            tds = dataSet;
            yunits = SemanticOps.getUnits(tds);
            boolean bl = plottable = yunits.isConvertibleTo(yAxis.getUnits()) || yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(yunits);
            if (!plottable && UnitsUtil.isRatioMeasurement(yunits) && UnitsUtil.isRatioMeasurement(yAxis.getUnits())) {
                this.unitsWarning = true;
            }
        }
        plottable = SemanticOps.getUnits(xds).isConvertibleTo(xAxis.getUnits());
        this.xunitsWarning = false;
        if (!plottable && UnitsUtil.isRatioMeasurement(SemanticOps.getUnits(xds)) && UnitsUtil.isRatioMeasurement(xAxis.getUnits())) {
            plottable = true;
            this.xunitsWarning = true;
        }
        if (!plottable) {
            return;
        }
        this.dataSetClipped = false;
        this.dataSetReduced = false;
        this.firstIndex = -1;
        this.lastIndex = -1;
        monitor.started();
        try {
            if (vds != null) {
                this.updateFirstLast(xAxis, yAxis, xds, vds);
                if (Schemes.isBundleDataSet(this.ds)) {
                    this.dataSetReduced = false;
                }
                if (this.dataSetReduced) {
                    QDataSet mvds;
                    logger.fine("reducing data that is bigger than dataSetSizeLimit");
                    vds = mvds = this.doDataSetReduce(xAxis, yAxis, vds, 1, 1);
                    xds = SemanticOps.xtagsDataSet(vds);
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                    logger.log(Level.FINER, "data reduced to {0} {1}", new Object[]{vds, Ops.extent(xds)});
                    logger.log(Level.FINER, "reduceDataSet complete ({0}ms)", System.currentTimeMillis() - t0);
                } else {
                    logger.log(Level.FINER, "data not reduced");
                }
                if (this.fillToReference) {
                    this.fillElement.update(xAxis, yAxis, vds, monitor.getSubtaskMonitor("fillElement.update"));
                    logger.log(Level.FINER, "fillElement.update complete ({0}ms)", System.currentTimeMillis() - t0);
                }
            } else if (tds != null) {
                MutablePropertyDataSet res;
                LoggerManager.resetTimer("render waveform");
                this.updateFirstLast(xAxis, yAxis, xds, tds);
                LoggerManager.markTime("updateFirstLast");
                if (SemanticOps.isRank2Waveform(dataSet)) {
                    res = DataSetUtil.asDataSet(xAxis.getDatumRange().width().divide(xAxis.getWidth()));
                    vds = dataSet.trim(this.firstIndex, this.lastIndex);
                    LoggerManager.markTime("trim");
                    QDataSet dep1 = (QDataSet)vds.property("DEPEND_1");
                    if (dep1.rank() == 1) {
                        vds = Reduction.reducex(vds, res);
                    }
                    LoggerManager.markTime("reducex");
                    if (vds.rank() == 2) {
                        vds = DataSetOps.flattenWaveform(vds);
                        LoggerManager.markTime("flatten");
                    }
                    xds = SemanticOps.xtagsDataSet(vds);
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                    LoggerManager.markTime("updateFirstLast again");
                } else if (SemanticOps.isRank3JoinOfRank2Waveform(dataSet)) {
                    res = DataSetUtil.asDataSet(xAxis.getDatumRange().width().divide(xAxis.getWidth()));
                    Units dsxu = SemanticOps.getUnits((QDataSet)dataSet.slice(0).property("DEPEND_0"));
                    if (!SemanticOps.getUnits(res).isConvertibleTo(dsxu.getOffsetUnits())) {
                        res = Ops.putProperty(res, "UNITS", (Object)dsxu.getOffsetUnits());
                    }
                    vds = null;
                    for (int k = this.firstIndex; k < this.lastIndex; ++k) {
                        int lastIndex1;
                        boolean xmono = true;
                        QDataSet ds1 = dataSet.slice(k);
                        QDataSet xds1 = (QDataSet)ds1.property("DEPEND_0");
                        int firstIndex1 = xmono ? DataSetUtil.getPreviousIndex(xds1, xAxis.getDatumRange().min()) : 0;
                        int n = lastIndex1 = xmono ? DataSetUtil.getNextIndex(xds1, xAxis.getDatumRange().max()) : ds1.length();
                        if (firstIndex1 == lastIndex1 && lastIndex1 == ds1.length() - 1) {
                            lastIndex1 = ds1.length();
                        }
                        if (firstIndex1 == lastIndex1) continue;
                        ds1 = ds1.trim(firstIndex1, lastIndex1);
                        LoggerManager.markTime("trim");
                        QDataSet vds1 = Reduction.reducex(ds1, res);
                        LoggerManager.markTime("reducex");
                        if (SemanticOps.isRank2Waveform(vds1)) {
                            vds1 = DataSetOps.flattenWaveform(vds1);
                            LoggerManager.markTime("flatten");
                        } else if (vds1.rank() == 2) continue;
                        vds = vds == null ? vds1 : Ops.append(vds, vds1);
                    }
                    if (vds == null) {
                        this.getParent().postMessage((Renderer)this, "first point of waveform package is not visible", Level.WARNING, null, null);
                        return;
                    }
                    xds = SemanticOps.xtagsDataSet(vds);
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                    LoggerManager.markTime("updateFirstLast again");
                }
                logger.log(Level.FINER, "renderWaveform updateFirstLast complete ({0}ms)", System.currentTimeMillis() - t0);
            } else {
                System.err.println("both tds and vds are null");
            }
            logger.log(Level.FINER, "updatePlotImage uses subset from firstIndex, lastIndex: {0}, {1} ({2} points})", new Object[]{this.firstIndex, this.lastIndex, this.lastIndex - this.firstIndex});
            if (this.psymConnector != PsymConnector.NONE) {
                try {
                    if (vds != null && vds.rank() == 1 && dataSet.rank() == 2 && SemanticOps.isBundle(dataSet)) {
                        this.psymConnectorElement.update(xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("psymConnectorElement.update"));
                    } else {
                        this.psymConnectorElement.update(xAxis, yAxis, vds, monitor.getSubtaskMonitor("psymConnectorElement.update"));
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    monitor.finished();
                    return;
                }
            }
            try {
                this.errorElement.update(xAxis, yAxis, vds, monitor.getSubtaskMonitor("errorElement.update"));
                if (vds != null && vds.rank() == 1 && dataSet.rank() == 2 && SemanticOps.isBundle(dataSet)) {
                    this.psymsElement.update(xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("psymsElement.update"));
                } else {
                    this.psymsElement.update(xAxis, yAxis, vds, monitor.getSubtaskMonitor("psymsElement.update"));
                }
                logger.log(Level.FINER, "psymsElement.update complete ({0}ms)", System.currentTimeMillis() - t0);
            }
            catch (InconvertibleUnitsException ex) {
                monitor.finished();
                return;
            }
            if (vds != null) {
                if (vds.rank() != 1) {
                    return;
                }
                this.selectionArea = this.firstIndex == 0 && this.lastIndex == xds.length() ? this.calcSelectionArea(xAxis, yAxis, xds, vds) : (this.firstIndex == -1 && this.lastIndex == -1 ? SelectionUtil.NULL : this.calcSelectionArea(xAxis, yAxis, xds.trim(this.firstIndex, this.lastIndex), vds.trim(this.firstIndex, this.lastIndex)));
            }
            logger.log(Level.FINER, "calcSelectionArea complete ({0}ms)", System.currentTimeMillis() - t0);
        }
        finally {
            monitor.finished();
        }
        long milli = System.currentTimeMillis();
        long renderTime = milli - t0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        logger.log(Level.FINE, "done updatePlotImage ({0}ms)", renderTime);
        this.setUpdatesPointsPerMillisecond(dppms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape calcSelectionArea(DasAxis xaxis, DasAxis yaxis, QDataSet xds, QDataSet ds) {
        ArrayDataSet ds3;
        long t0 = System.currentTimeMillis();
        Datum widthx = xaxis.isLog() ? Units.logERatio.createDatum(Math.log(xaxis.getDataMaximum(xaxis.getUnits()) - xaxis.getDataMinimum(xaxis.getUnits()))) : xaxis.getDatumRange().width();
        Datum widthy = yaxis.isLog() ? Units.logERatio.createDatum(Math.log(yaxis.getDataMaximum(yaxis.getUnits()) - yaxis.getDataMinimum(yaxis.getUnits()))) : yaxis.getDatumRange().width();
        if (xaxis.getColumn().getWidth() == 0 || yaxis.getRow().getHeight() == 0) {
            return null;
        }
        QDataSet ds2 = ds;
        if (this.unitsWarning) {
            ds3 = ArrayDataSet.copy(ds);
            ds3.putProperty("UNITS", yaxis.getUnits());
            ds2 = ds3;
        }
        if (this.xunitsWarning) {
            ds3 = ArrayDataSet.copy(xds);
            ds3.putProperty("UNITS", yaxis.getUnits());
            xds = ds3;
        }
        if (ds2.rank() == 2) {
            ds2 = DataSetOps.slice1(ds2, 0);
        }
        try {
            Shape s;
            Object reduce;
            if (this.psymConnector == PsymConnector.NONE || ds2.length() > 10000) {
                Shape s2;
                reduce = this.doDataSetReduce(xaxis, yaxis, ds2, 5, 5);
                logger.fine(String.format("reduce path in calcSelectionArea: %s\n", reduce));
                GeneralPath path = GraphUtil.getPath(xaxis, yaxis, SemanticOps.xtagsDataSet((QDataSet)reduce), (QDataSet)reduce, "scatter", true);
                Shape shape = s2 = new BasicStroke(Math.min(14.0f, (float)this.getSymSize() + 8.0f), 1, 1).createStrokedShape(path);
                return shape;
            }
            if (xds.length() != ds2.length()) {
                reduce = SelectionUtil.NULL;
                return reduce;
            }
            reduce = VectorUtil.reduce2D(xds, ds2, 0, xds.length(), widthx.divide(xaxis.getColumn().getWidth() / 5), widthy.divide(yaxis.getRow().getHeight() / 5));
            logger.fine(String.format("reduce path in calcSelectionArea: %s\n", reduce));
            GeneralPath path = GraphUtil.getPath(xaxis, yaxis, SemanticOps.xtagsDataSet((QDataSet)reduce), (QDataSet)reduce, this.histogram ? "histogram" : "series", true);
            Shape shape = s = new BasicStroke(Math.min(14.0f, (float)this.getSymSize() + 8.0f), 1, 1).createStrokedShape(path);
            return shape;
        }
        catch (InconvertibleUnitsException ex) {
            logger.fine("failed to convert units in calcSelectionArea");
            Shape shape = SelectionUtil.NULL;
            return shape;
        }
        finally {
            logger.log(Level.FINE, "done calcSelectionArea ({0}ms)", System.currentTimeMillis() - t0);
        }
    }

    @Override
    protected void installRenderer() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            DasPlot lparent = this.getParent();
            if (lparent == null) {
                throw new IllegalArgumentException("parent not set");
            }
            DasMouseInputAdapter mouseAdapter = lparent.mouseAdapter;
            DasPlot p = lparent;
            mouseAdapter.addMouseModule(new MouseModule(p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
            CrossHairMouseModule ch = new CrossHairMouseModule(lparent, this, lparent.getXAxis(), lparent.getYAxis());
            mouseAdapter.addMouseModule(ch);
        }
        this.updatePsym();
    }

    @Override
    protected void uninstallRenderer() {
    }

    public Element getDOMElement(Document document) {
        return null;
    }

    @Override
    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(15, 10, 2);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        this.drawListIcon(g, 0, 0);
        return new ImageIcon(i);
    }

    @Override
    public void drawListIcon(Graphics2D g1, int x, int y) {
        Graphics2D g = (Graphics2D)g1.create(x, y, 16, 16);
        g.setRenderingHints(DasProperties.getRenderingHints());
        DasPlot lparent = this.getParent();
        if (lparent != null) {
            g.setBackground(lparent.getBackground());
        }
        if (this.color.equals(Color.white)) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(new Color(0, 0, 0, 0));
        }
        g.fillRect(0, 0, 15, 10);
        if (this.fillToReference) {
            g.setColor(this.fillColor);
            Polygon p = new Polygon(new int[]{2, 13, 13, 2}, new int[]{3, 7, 10, 10}, 4);
            g.fillPolygon(p);
        }
        g.setColor(this.color);
        Stroke stroke0 = g.getStroke();
        this.getPsymConnector().drawLine(g, 2.0, 3.0, 13.0, 7.0, 1.5f);
        g.setStroke(stroke0);
        this.psym.draw(g, 7.0, 5.0, this.listIconSymSize, this.fillStyle);
    }

    public void setListIconSymSize(float newSize) {
        this.listIconSymSize = newSize;
        this.refreshRender();
    }

    @Override
    public String getListLabel() {
        return String.valueOf(this.getDataSetDescriptor());
    }

    private void refreshRender() {
        DasPlot lparent = this.getParent();
        if (lparent != null) {
            lparent.invalidateCacheImage();
            lparent.repaint();
        }
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        PsymConnector old = this.psymConnector;
        if (!p.equals(this.psymConnector)) {
            this.psymConnector = p;
            this.updateCacheImage();
            this.propertyChangeSupport.firePropertyChange("psymConnector", old, p);
        }
    }

    public PlotSymbol getPsym() {
        return this.psym;
    }

    public void setPsym(PlotSymbol psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        if (psym != this.psym) {
            DefaultPlotSymbol oldValue = this.psym;
            this.psym = (DefaultPlotSymbol)psym;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("psym", oldValue, psym);
        }
    }

    public boolean isDrawError() {
        return this.drawError;
    }

    public void setDrawError(boolean drawError) {
        boolean oldDrawError = this.drawError;
        this.drawError = drawError;
        if (oldDrawError != drawError) {
            this.update();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWERROR, oldDrawError, drawError);
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double symSize) {
        float old = this.symSize;
        if ((double)this.symSize != symSize) {
            this.symSize = (float)symSize;
            this.setPsym(this.psym);
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("symSize", Float.valueOf(old), symSize);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("null color");
        }
        Color old = this.color;
        if (!this.color.equals(color)) {
            this.color = color;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("color", old, color);
        }
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double f) {
        double old = this.lineWidth;
        if ((double)this.lineWidth != f) {
            this.lineWidth = (float)f;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("lineWidth", old, f);
        }
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        this.updatePsym();
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange("antiAliased", old, antiAliased);
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean b) {
        boolean old = b;
        if (b != this.histogram) {
            this.histogram = b;
            this.updateCacheImage();
            this.propertyChangeSupport.firePropertyChange("histogram", old, this.antiAliased);
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Color old = this.fillColor;
        if (!this.fillColor.equals(color)) {
            this.fillColor = color;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillColor", old, color);
        }
    }

    public String getFillDirection() {
        return this.fillDirection;
    }

    public void setFillDirection(String fillDirection) {
        String oldFillDirection = this.fillDirection;
        this.fillDirection = fillDirection;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_FILLDIRECTION, oldFillDirection, fillDirection);
    }

    public String getColorByDataSetId() {
        return this.colorByDataSetId;
    }

    public void setColorByDataSetId(String colorByDataSetId) {
        String oldVal = this.colorByDataSetId;
        this.colorByDataSetId = colorByDataSetId;
        this.update();
        if (!colorByDataSetId.equals("")) {
            this.updatePsym();
        }
        this.propertyChangeSupport.firePropertyChange("colorByDataSetId", oldVal, colorByDataSetId);
    }

    @Override
    public void setColorBar(DasColorBar cb) {
        if (this.colorBar == cb) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener(this.colorBarListener);
        }
        super.setColorBar(cb);
        if (this.colorBar != null) {
            DasPlot parent = this.getParent();
            if (parent != null && parent.getCanvas() != null) {
                parent.getCanvas().add(this.colorBar);
            }
            this.colorBar.addPropertyChangeListener(this.colorBarListener);
        }
        this.updateCacheImage();
        this.updatePsym();
    }

    public boolean isFillToReference() {
        return this.fillToReference;
    }

    public void setFillToReference(boolean fillToReference) {
        boolean old = this.fillToReference;
        if (this.fillToReference != fillToReference) {
            this.fillToReference = fillToReference;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillToReference", old, fillToReference);
        }
    }

    public Datum getReference() {
        return this.reference;
    }

    public void setReference(Datum reference) {
        Datum old = this.reference;
        if (!this.reference.equals(reference)) {
            this.reference = reference;
            this.updateCacheImage();
            this.propertyChangeSupport.firePropertyChange("reference", old, reference);
        }
    }

    public boolean isResetDebugCounters() {
        return this.resetDebugCounters;
    }

    public void setResetDebugCounters(boolean resetDebugCounters) {
        if (resetDebugCounters) {
            this.update();
        }
    }

    public boolean isSimplifyPaths() {
        return this.simplifyPaths;
    }

    public void setSimplifyPaths(boolean simplifyPaths) {
        this.simplifyPaths = simplifyPaths;
        this.updateCacheImage();
    }

    public boolean isStampPsyms() {
        return this.stampPsyms;
    }

    public void setStampPsyms(boolean newstampPsyms) {
        boolean oldstampPsyms = this.stampPsyms;
        this.stampPsyms = newstampPsyms;
        this.propertyChangeSupport.firePropertyChange(PROP_STAMPPSYMS, oldstampPsyms, newstampPsyms);
        this.updateCacheImage();
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillStyle fillStyle) {
        this.fillStyle = fillStyle;
        this.updatePsym();
        this.updateCacheImage();
    }

    public synchronized Shape selectionArea() {
        return this.selectionArea == null ? SelectionUtil.NULL : this.selectionArea;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        boolean accept = false;
        Point2D.Double dp = new Point2D.Double(x, y);
        if (this.fillToReference && this.fillElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.psymConnectorElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.psymsElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.drawError && this.errorElement.acceptContext(dp)) {
            accept = true;
        }
        return accept;
    }

    public synchronized int getDataSetSizeLimit() {
        return this.dataSetSizeLimit;
    }

    public synchronized void setDataSetSizeLimit(int dataSetSizeLimit) {
        int oldDataSetSizeLimit = this.dataSetSizeLimit;
        this.dataSetSizeLimit = dataSetSizeLimit;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange("dataSetSizeLimit", oldDataSetSizeLimit, dataSetSizeLimit);
    }

    public double getUpdatesPointsPerMillisecond() {
        return this.updatesPointsPerMillisecond;
    }

    public void setUpdatesPointsPerMillisecond(double newupdatesPointsPerMillisecond) {
        this.updatesPointsPerMillisecond = newupdatesPointsPerMillisecond;
    }

    public double getRenderPointsPerMillisecond() {
        return this.renderPointsPerMillisecond;
    }

    public void setRenderPointsPerMillisecond(double newrenderPointsPerMillisecond) {
        this.renderPointsPerMillisecond = newrenderPointsPerMillisecond;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public boolean isCadenceCheck() {
        return this.cadenceCheck;
    }

    public void setCadenceCheck(boolean cadenceCheck) {
        boolean oldCadenceCheck = this.cadenceCheck;
        this.cadenceCheck = cadenceCheck;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_CADENCECHECK, oldCadenceCheck, cadenceCheck);
    }

    @Override
    public boolean acceptsDataSet(QDataSet dataSet) {
        boolean plottable;
        QDataSet ds1 = dataSet;
        if (!SemanticOps.isTableDataSet(dataSet)) {
            if (!(ds1.rank() == 2 && SemanticOps.isBundle(ds1) || ds1.rank() == 1)) {
                logger.fine("dataset rank error");
                return false;
            }
            this.unitsWarning = false;
            plottable = true;
        } else {
            plottable = true;
        }
        return plottable;
    }

    private class ErrorBarRenderElement
    implements RenderElement {
        GeneralPath p;

        private ErrorBarRenderElement() {
        }

        @Override
        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            Rectangle canvasRect;
            GeneralPath lp = this.getPath();
            if (lp == null) {
                return 0;
            }
            Rectangle b = lp.getBounds();
            if (b.height == 0) {
                b.height = 1;
            }
            if (b.width == 0) {
                b.width = 1;
            }
            if (!b.intersects(canvasRect = SeriesRenderer.this.getParent().getCanvas().getBounds())) {
                logger.log(Level.FINE, "all data is off-page");
                return 0;
            }
            g.draw(lp);
            return SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex;
        }

        private synchronized GeneralPath getPath() {
            return this.p;
        }

        @Override
        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            int i;
            QDataSet w2;
            QDataSet w1;
            QDataSet p2;
            QDataSet p1;
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            if (vds == null) {
                this.p = null;
                return;
            }
            QDataSet xds = SemanticOps.xtagsDataSet(dataSet);
            QDataSet deltaPlusY = (QDataSet)vds.property("DELTA_PLUS");
            QDataSet deltaMinusY = (QDataSet)vds.property("DELTA_MINUS");
            QDataSet deltaPlusX = (QDataSet)xds.property("DELTA_PLUS");
            QDataSet deltaMinusX = (QDataSet)xds.property("DELTA_MINUS");
            Units xunits = SemanticOps.getUnits(xds);
            Units yunits = SemanticOps.getUnits(vds);
            if (SeriesRenderer.this.unitsWarning) {
                yunits = yAxis.getUnits();
            }
            if (SeriesRenderer.this.xunitsWarning) {
                xunits = xAxis.getUnits();
            }
            GeneralPath lp = new GeneralPath();
            if (deltaPlusY != null && deltaMinusY != null) {
                try {
                    p1 = Ops.add(vds, deltaPlusY);
                    p2 = Ops.subtract(vds, deltaMinusY);
                    w1 = Ops.valid(p2);
                    w2 = Ops.valid(p1);
                    if (SeriesRenderer.this.firstIndex == -1) {
                        return;
                    }
                    for (i = SeriesRenderer.this.firstIndex; i < SeriesRenderer.this.lastIndex; ++i) {
                        double ix = xAxis.transform(xds.value(i), xunits);
                        if (!(w1.value(i) > 0.0) || !(w2.value(i) > 0.0)) continue;
                        double iym = yAxis.transform(p1.value(i), yunits);
                        double iyp = yAxis.transform(p2.value(i), yunits);
                        lp.moveTo(ix, iym);
                        lp.lineTo(ix, iyp);
                    }
                }
                catch (IllegalArgumentException ex) {
                    SeriesRenderer.this.getParent().postException(SeriesRenderer.this, ex);
                }
            }
            if (deltaPlusX != null && deltaMinusX != null) {
                try {
                    p1 = Ops.subtract(xds, deltaMinusX);
                    p2 = Ops.add(xds, deltaPlusX);
                    w1 = Ops.valid(p1);
                    w2 = Ops.valid(p2);
                    for (i = SeriesRenderer.this.firstIndex; i < SeriesRenderer.this.lastIndex; ++i) {
                        double iy = yAxis.transform(vds.value(i), yunits);
                        if (!(w1.value(i) > 0.0) || !(w2.value(i) > 0.0)) continue;
                        double ixm = xAxis.transform(p1.value(i), xunits);
                        double ixp = xAxis.transform(p2.value(i), xunits);
                        lp.moveTo(ixm, iy);
                        lp.lineTo(ixp, iy);
                    }
                }
                catch (IllegalArgumentException ex) {
                    SeriesRenderer.this.getParent().postException(SeriesRenderer.this, ex);
                }
            }
            this.p = lp;
        }

        @Override
        public boolean acceptContext(Point2D.Double dp) {
            GeneralPath gp = this.getPath();
            return gp != null && gp.contains(dp.x - 2.0, dp.y - 2.0, 5.0, 5.0);
        }
    }

    class FillRenderElement
    implements RenderElement {
        private GeneralPath fillToRefPath1;

        FillRenderElement() {
        }

        @Override
        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            Rectangle canvasRect;
            if (this.fillToRefPath1 == null) {
                return 0;
            }
            Rectangle b = this.fillToRefPath1.getBounds();
            if (b.height == 0) {
                b.height = 1;
            }
            if (b.width == 0) {
                b.width = 1;
            }
            if (!b.intersects(canvasRect = SeriesRenderer.this.getParent().getCanvas().getBounds())) {
                logger.log(Level.FINE, "all data is off-page");
                return 0;
            }
            if (SeriesRenderer.this.fillColor.getAlpha() == 0) {
                double y;
                try {
                    y = yAxis.transform(SeriesRenderer.this.reference);
                }
                catch (InconvertibleUnitsException ex) {
                    y = yAxis.transform(SeriesRenderer.this.reference.value(), yAxis.getUnits());
                }
                DasColumn column = SeriesRenderer.this.getParent().getColumn();
                g.draw(new Line2D.Double(column.getDMinimum(), y, column.getDMaximum(), y));
            } else {
                g.setColor(SeriesRenderer.this.fillColor);
                g.fill(this.fillToRefPath1);
            }
            return 0;
        }

        @Override
        public void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            boolean allowSimplify;
            double fx1;
            boolean logStep;
            double xSampleWidth;
            if (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex == 0) {
                this.fillToRefPath1 = null;
                return;
            }
            QDataSet xds = SemanticOps.xtagsDataSet(dataSet);
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(SeriesRenderer.this.ds);
            Units xUnits = SemanticOps.getUnits(xds);
            Units yUnits = SemanticOps.getUnits(vds);
            if (SeriesRenderer.this.unitsWarning) {
                yUnits = yAxis.getUnits();
            }
            if (SeriesRenderer.this.xunitsWarning) {
                xUnits = xAxis.getUnits();
            }
            QDataSet wds = SemanticOps.weightsDataSet(vds);
            int pathLengthApprox = Math.max(5, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
            GeneralPath fillPath = new GeneralPath(1, pathLengthApprox);
            boolean above = SeriesRenderer.this.fillDirection.equals("above") || SeriesRenderer.this.fillDirection.equals("both");
            boolean below = SeriesRenderer.this.fillDirection.equals("below") || SeriesRenderer.this.fillDirection.equals("both");
            Datum sw = SeriesRenderer.this.getCadence(xds, vds, SeriesRenderer.this.firstIndex, SeriesRenderer.this.lastIndex);
            if (sw != null) {
                if (UnitsUtil.isRatiometric(sw.getUnits())) {
                    xSampleWidth = sw.doubleValue(Units.logERatio);
                    logStep = true;
                } else {
                    xSampleWidth = SeriesRenderer.this.doubleValue(sw, xUnits.getOffsetUnits());
                    logStep = false;
                }
            } else {
                xSampleWidth = 1.0E37;
                logStep = false;
            }
            double xSampleWidthExact = xSampleWidth;
            xSampleWidth *= 1.2;
            if (SeriesRenderer.this.reference == null) {
                SeriesRenderer.this.reference = yUnits.createDatum(yAxis.isLog() ? 1.0 : 0.0);
            }
            double yref = SeriesRenderer.this.doubleValue(SeriesRenderer.this.reference, yUnits);
            double fyref = yAxis.transform(yref, yUnits);
            int index = SeriesRenderer.this.firstIndex;
            double x = xds.value(index);
            double y = vds.value(index);
            double fx = xAxis.transform(x, xUnits);
            double fy = yAxis.transform(y, yUnits);
            if (SeriesRenderer.this.histogram) {
                fx1 = xAxis.transform(SeriesRenderer.this.midPointData(xAxis, x, xUnits, xSampleWidthExact, logStep, -0.5), xUnits);
                fillPath.moveTo(fx1 - 1.0, fyref);
                fillPath.lineTo(fx1 - 1.0, fy);
                fillPath.lineTo(fx, fy);
            } else {
                fillPath.moveTo(fx, fyref);
                fillPath.lineTo(fx, fy);
            }
            double x0 = x;
            double fx0 = fx;
            double fy0 = fy;
            if (SeriesRenderer.this.psymConnector != PsymConnector.NONE || SeriesRenderer.this.fillToReference) {
                boolean ignoreCadence;
                boolean bl = ignoreCadence = !SeriesRenderer.this.cadenceCheck;
                while (index < SeriesRenderer.this.lastIndex) {
                    x = xds.value(index);
                    y = vds.value(index);
                    boolean isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
                    fx = xAxis.transform(x, xUnits);
                    fy = yAxis.transform(y, yUnits);
                    if (isValid) {
                        double fx12;
                        double step;
                        double d = step = logStep ? Math.log(x / x0) : x - x0;
                        if (ignoreCadence || step < xSampleWidth) {
                            if (SeriesRenderer.this.histogram) {
                                Units.cdfTT2000.createDatum(x);
                                fx12 = xAxis.transform(SeriesRenderer.this.midPointData(xAxis, x, xUnits, xSampleWidthExact, logStep, -0.5), xUnits);
                                fillPath.lineTo(fx12, fy0);
                                fillPath.lineTo(fx12, fy);
                                fillPath.lineTo(fx, fy);
                            } else {
                                fillPath.lineTo(fx, fy);
                            }
                        } else if (SeriesRenderer.this.histogram) {
                            fx12 = xAxis.transform(SeriesRenderer.this.midPointData(xAxis, x0, xUnits, xSampleWidthExact, logStep, 0.5), xUnits);
                            fillPath.lineTo(fx12, fy0);
                            fillPath.lineTo(fx12, fyref);
                            fx12 = xAxis.transform(SeriesRenderer.this.midPointData(xAxis, x, xUnits, xSampleWidthExact, logStep, -0.5), xUnits);
                            fillPath.moveTo(fx12, fyref);
                            fillPath.lineTo(fx12, fy);
                            fillPath.lineTo(fx, fy);
                        } else {
                            fillPath.lineTo(fx0, fyref);
                            fillPath.moveTo(fx, fyref);
                            fillPath.lineTo(fx, fy);
                        }
                        x0 = x;
                        fx0 = fx;
                        fy0 = fy;
                    }
                    ++index;
                }
            }
            if (SeriesRenderer.this.histogram) {
                fx1 = xAxis.transform(SeriesRenderer.this.midPointData(xAxis, x0, xUnits, xSampleWidthExact, logStep, 0.5), xUnits);
                fillPath.lineTo(fx1, fy0);
                fillPath.lineTo(fx1, fyref);
            } else {
                fillPath.lineTo(fx0, fyref);
            }
            if (!above) {
                GeneralPath p;
                Area a = new Area(fillPath);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, fyref, SeriesRenderer.this.getParent().getColumn().getDMaximum(), SeriesRenderer.this.getParent().getRow().getHeight());
                a.intersect(new Area(rect));
                fillPath = p = new GeneralPath(a);
            }
            if (!below) {
                GeneralPath p;
                Area a = new Area(fillPath);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, SeriesRenderer.this.getParent().getColumn().getDMaximum(), fyref);
                a.intersect(new Area(rect));
                fillPath = p = new GeneralPath(a);
            }
            this.fillToRefPath1 = fillPath;
            boolean bl = allowSimplify = SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex > 1000 && xSampleWidth < 1.0E37;
            if (!SeriesRenderer.this.histogram && SeriesRenderer.this.simplifyPaths && allowSimplify && SeriesRenderer.this.colorByDataSetId.length() == 0) {
                GeneralPath newPath = new GeneralPath(1, pathLengthApprox);
                int count = GraphUtil.reducePath(this.fillToRefPath1.getPathIterator(null), newPath);
                this.fillToRefPath1 = newPath;
                logger.fine(String.format("reduce path(fill) in=%d  out=%d\n", SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex, count));
            }
        }

        @Override
        public boolean acceptContext(Point2D.Double dp) {
            return this.fillToRefPath1 != null && this.fillToRefPath1.contains(dp);
        }
    }

    private class PsymConnectorRenderElement
    implements RenderElement {
        private GeneralPath path1;

        private PsymConnectorRenderElement() {
        }

        @Override
        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            GeneralPath lpath1;
            long t0 = System.currentTimeMillis();
            boolean debug = false;
            logger.log(Level.FINE, "enter connector render");
            if (vds.rank() != 1 && !SemanticOps.isRank2Waveform(vds) && !SemanticOps.isRank3JoinOfRank2Waveform(vds)) {
                SeriesRenderer.this.renderException(g, xAxis, yAxis, new IllegalArgumentException("dataset is not rank 1"));
            }
            if ((lpath1 = this.getPath()) == null) {
                return 0;
            }
            Rectangle b = lpath1.getBounds();
            if (b.height == 0) {
                b.height = 1;
            }
            if (b.width == 0) {
                b.width = 1;
            }
            Rectangle canvasRect = SeriesRenderer.this.getParent().getCanvas().getBounds();
            long t = System.currentTimeMillis() - t0;
            if (!b.intersects(canvasRect)) {
                logger.log(Level.FINE, "all data is off-page ({0}ms)", t - t0);
                return 0;
            }
            SeriesRenderer.this.psymConnector.draw(g, lpath1, SeriesRenderer.this.lineWidth);
            logger.log(Level.FINE, "done connector render ({0}ms)", System.currentTimeMillis() - t0);
            return 0;
        }

        private synchronized GeneralPath getPath() {
            return this.path1;
        }

        @Override
        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            boolean allowSimplify;
            boolean notInvalidInterleave;
            boolean logStep;
            double xSampleWidth;
            DasPlot lparent;
            logger.log(Level.FINE, "enter connector update");
            QDataSet xds = SemanticOps.xtagsDataSet(dataSet);
            if (xds.rank() == 2 && xds.property("BINS_1") != null) {
                xds = Ops.reduceMean(xds, 1);
            }
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            QDataSet wds = SemanticOps.weightsDataSet(vds);
            Units xUnits = SemanticOps.getUnits(xds);
            Units yUnits = SemanticOps.getUnits(vds);
            Units xaxisUnits = xAxis.getUnits();
            Units yaxisUnits = yAxis.getUnits();
            if (!yUnits.isConvertibleTo(yaxisUnits)) {
                yUnits = yAxis.getUnits();
                SeriesRenderer.this.unitsWarning = true;
            }
            if (!xUnits.isConvertibleTo(xaxisUnits)) {
                xUnits = xAxis.getUnits();
                SeriesRenderer.this.unitsWarning = true;
            }
            if ((lparent = SeriesRenderer.this.getParent()) == null) {
                return;
            }
            if (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex == 0) {
                this.path1 = null;
                return;
            }
            long t0 = System.currentTimeMillis();
            DataGeneralPathBuilder pathBuilder = new DataGeneralPathBuilder(xAxis, yAxis);
            Datum sw = null;
            try {
                sw = SeriesRenderer.this.getCadence(xds, vds, SeriesRenderer.this.firstIndex, SeriesRenderer.this.lastIndex);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.WARNING, null, ex);
            }
            if (sw != null) {
                int i;
                if (UnitsUtil.isRatiometric(sw.getUnits())) {
                    xSampleWidth = sw.doubleValue(Units.logERatio);
                    logStep = true;
                } else {
                    xSampleWidth = SeriesRenderer.this.doubleValue(sw, xUnits.getOffsetUnits());
                    logStep = false;
                }
                int cadenceGapCount = 0;
                double xSampleWidthFudge = xSampleWidth * 1.2;
                if (logStep) {
                    for (i = 1; i < xds.length(); ++i) {
                        if (!(Math.log(xds.value(i) / xds.value(i - 1)) > xSampleWidthFudge)) continue;
                        ++cadenceGapCount;
                    }
                } else {
                    for (i = 1; i < xds.length(); ++i) {
                        if (!(xds.value(i) - xds.value(i - 1) > xSampleWidthFudge)) continue;
                        ++cadenceGapCount;
                    }
                }
                if (cadenceGapCount > wds.length() / 2) {
                    pathBuilder.setCadence(null);
                } else {
                    pathBuilder.setCadence(sw);
                }
            } else {
                xSampleWidth = 1.0E37;
                logStep = false;
            }
            double xSampleWidthExact = xSampleWidth;
            UnitsConverter xuc = xUnits.getConverter(xaxisUnits);
            UnitsConverter yuc = yUnits.getConverter(yaxisUnits);
            int index = SeriesRenderer.this.firstIndex;
            double x = xuc.convert(xds.value(index));
            double y = yuc.convert(vds.value(index));
            pathBuilder.addDataPoint(true, x, y);
            if (SeriesRenderer.this.histogram) {
                double dx = xSampleWidthExact;
                x = xds.value(index);
                xUnits.createDatum(x);
                double fx1 = SeriesRenderer.this.midPointData(xAxis, x, xUnits, dx, logStep, -0.5);
                fx1 = xuc.convert(fx1);
                pathBuilder.addDataPoint(true, fx1, y);
                double fx2 = SeriesRenderer.this.midPointData(xAxis, x, xUnits, dx, logStep, 0.5);
                fx2 = xuc.convert(fx2);
                pathBuilder.addDataPoint(true, fx2, y);
            } else {
                pathBuilder.addDataPoint(true, x, y);
            }
            ++index;
            boolean isValid = false;
            int invalidInterleaveCount = 0;
            for (int i = 1; i < xds.length(); ++i) {
                if (!(wds.value(i - 1) > 0.0) || wds.value(i) != 0.0) continue;
                ++invalidInterleaveCount;
            }
            boolean bl = notInvalidInterleave = invalidInterleaveCount < wds.length() / 3;
            while (index < SeriesRenderer.this.lastIndex) {
                x = xuc.convert(xds.value(index));
                y = yuc.convert(vds.value(index));
                boolean bl2 = isValid = wds.value(index) > 0.0;
                if (isValid || notInvalidInterleave) {
                    if (SeriesRenderer.this.histogram) {
                        double dx = xSampleWidthExact;
                        x = xds.value(index);
                        double fx1 = SeriesRenderer.this.midPointData(xAxis, x, xUnits, dx, logStep, -0.5);
                        fx1 = xuc.convert(fx1);
                        pathBuilder.addDataPoint(true, fx1, y);
                        double fx2 = SeriesRenderer.this.midPointData(xAxis, x, xUnits, dx, logStep, 0.5);
                        fx2 = xuc.convert(fx2);
                        pathBuilder.addDataPoint(true, fx2, y);
                    } else {
                        pathBuilder.addDataPoint(isValid, x, y);
                    }
                }
                ++index;
            }
            logger.log(Level.FINE, "done create general path ({0}ms)", System.currentTimeMillis() - t0);
            boolean bl3 = allowSimplify = SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex > 1000 && xSampleWidth < 1.0E37;
            if (!SeriesRenderer.this.histogram && SeriesRenderer.this.simplifyPaths && allowSimplify && SeriesRenderer.this.colorByDataSetId.length() == 0) {
                int pathLengthApprox = Math.max(5, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
                this.path1 = new GeneralPath(1, pathLengthApprox);
                int count = GraphUtil.reducePath20140622(pathBuilder.getPathIterator(), this.path1, 1, 5);
                logger.fine(String.format("reduce path in=%d  out=%d\n", SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex, count));
            } else {
                this.path1 = pathBuilder.getGeneralPath();
            }
            logger.log(Level.FINE, "done connector update ({0}ms)", System.currentTimeMillis() - t0);
        }

        @Override
        public boolean acceptContext(Point2D.Double dp) {
            GeneralPath gp = this.getPath();
            if (gp == null) {
                return false;
            }
            Rectangle2D.Double hitbox = new Rectangle2D.Double(dp.x - 5.0, dp.y - 5.0, 10.0, 10.0);
            double[] coords = new double[6];
            PathIterator it = gp.getPathIterator(null);
            it.currentSegment(coords);
            double x1 = coords[0];
            double y1 = coords[1];
            it.next();
            while (!it.isDone()) {
                int segType = it.currentSegment(coords);
                if (segType == 1 && hitbox.intersectsLine(x1, y1, coords[0], coords[1])) {
                    return true;
                }
                x1 = coords[0];
                y1 = coords[1];
                it.next();
            }
            return false;
        }
    }

    private class PsymRenderElement
    implements RenderElement {
        int[] colors;
        double[] dpsymsPathX;
        double[] dpsymsPathY;
        int count;

        private PsymRenderElement() {
        }

        private int renderStamp(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            DasPlot lparent = SeriesRenderer.this.getParent();
            if (lparent == null) {
                return 0;
            }
            long t0 = System.currentTimeMillis();
            logger.log(Level.FINE, "enter PsymRenderElement.renderStamp");
            QDataSet colorByDataSet = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
            }
            if (colorByDataSet != null) {
                for (int i = 0; i < this.count; ++i) {
                    int icolor = this.colors[i];
                    if (icolor < 0) continue;
                    g.drawImage(SeriesRenderer.this.coloredPsyms[icolor], (int)this.dpsymsPathX[i] - SeriesRenderer.this.cmx, (int)this.dpsymsPathY[i] - SeriesRenderer.this.cmy, lparent);
                }
            } else {
                try {
                    for (int i = 0; i < this.count; ++i) {
                        g.drawImage(SeriesRenderer.this.psymImage, (int)this.dpsymsPathX[i] - SeriesRenderer.this.cmx, (int)this.dpsymsPathY[i] - SeriesRenderer.this.cmy, lparent);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            logger.log(Level.FINE, "done PsymRenderElement.renderStamp ({0}ms)", System.currentTimeMillis() - t0);
            return this.count;
        }

        private int renderDraw(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            logger.log(Level.FINE, "enter PsymRenderElement.renderDraw");
            long t0 = System.currentTimeMillis();
            float fsymSize = SeriesRenderer.this.symSize;
            QDataSet colorByDataSet = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
                if (colorByDataSet != null) {
                    if (colorByDataSet.length() != dataSet.length()) {
                        throw new IllegalArgumentException("colorByDataSet and dataSet do not have same length");
                    }
                } else {
                    System.err.println("why is colorByDataSetId set?");
                }
            }
            graphics.setStroke(new BasicStroke(SeriesRenderer.this.lineWidth));
            boolean rgbColor = false;
            Color[] ccolors = null;
            if (colorByDataSet != null) {
                rgbColor = Units.rgbColor.equals(colorByDataSet.property("UNITS"));
                IndexColorModel icm = SeriesRenderer.this.colorBar.getIndexColorModel();
                ccolors = new Color[icm.getMapSize()];
                for (int j = 0; j < icm.getMapSize(); ++j) {
                    ccolors[j] = new Color(icm.getRGB(j));
                }
            }
            if (colorByDataSet != null) {
                if (rgbColor) {
                    for (int i = 0; i < this.count; ++i) {
                        if (this.colors[i] < 0) continue;
                        graphics.setColor(new Color(this.colors[i]));
                        SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                    }
                } else {
                    for (int i = 0; i < this.count; ++i) {
                        if (this.colors[i] < 0) continue;
                        graphics.setColor(ccolors[this.colors[i]]);
                        SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                    }
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    try {
                        SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
            logger.log(Level.FINE, "done PsymRenderElement.renderDraw ({0}ms)", System.currentTimeMillis() - t0);
            return this.count;
        }

        @Override
        public synchronized int render(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            DasPlot lparent;
            if (vds.rank() != 1 && !SemanticOps.isBundle(vds) && !SemanticOps.isRank2Waveform(vds)) {
                SeriesRenderer.this.renderException(graphics, xAxis, yAxis, new IllegalArgumentException("dataset is not rank 1"));
            }
            if ((lparent = SeriesRenderer.this.getParent()) == null) {
                return 0;
            }
            QDataSet colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
            boolean rgbColor = colorByDataSet != null && Units.rgbColor.equals(colorByDataSet.property("UNITS"));
            int i = SeriesRenderer.this.stampPsyms && !rgbColor && !lparent.getCanvas().isPrintingThread() ? this.renderStamp(graphics, xAxis, yAxis, vds, mon) : this.renderDraw(graphics, xAxis, yAxis, vds, mon);
            if (!SeriesRenderer.this.haveValidColor) {
                lparent.postMessage((Renderer)SeriesRenderer.this, "no valid data to color plot symbols", Level.INFO, null, null);
            }
            return i;
        }

        @Override
        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            QDataSet colorByDataSet1 = SeriesRenderer.this.colorByDataSet(dataSet);
            QDataSet wdsz = null;
            if (colorByDataSet1 != null) {
                wdsz = SemanticOps.weightsDataSet(colorByDataSet1);
                SeriesRenderer.this.haveValidColor = false;
            } else {
                SeriesRenderer.this.haveValidColor = true;
            }
            DasColorBar fcolorBar = SeriesRenderer.this.colorBar;
            Units zunits = null;
            if (colorByDataSet1 != null && fcolorBar != null) {
                zunits = SemanticOps.getUnits(colorByDataSet1);
            }
            this.count = 0;
            this.dpsymsPathX = new double[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex];
            this.dpsymsPathY = new double[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex];
            this.colors = new int[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex + 2];
            int index = SeriesRenderer.this.firstIndex;
            QDataSet xds = SemanticOps.xtagsDataSet(dataSet);
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            if (xds.rank() == 2 && xds.property("BINS_1") != null) {
                xds = Ops.reduceMean(xds, 1);
            }
            if (dataSet.rank() == 2 && xds.length() != vds.length()) {
                return;
            }
            Units xUnits = SemanticOps.getUnits(xds);
            Units yUnits = SemanticOps.getUnits(vds);
            if (SeriesRenderer.this.unitsWarning) {
                yUnits = yAxis.getUnits();
            }
            if (SeriesRenderer.this.xunitsWarning) {
                xUnits = xAxis.getUnits();
            }
            double dx0 = -99.0;
            double dy0 = -99.0;
            QDataSet wds = SemanticOps.weightsDataSet(vds);
            int buffer = (int)Math.ceil(Math.max(20.0, SeriesRenderer.this.getSymSize()));
            Rectangle window = DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn());
            window = new Rectangle(window.x - buffer, window.y - buffer, window.width + 2 * buffer, window.height + 2 * buffer);
            DasPlot lparent = SeriesRenderer.this.getParent();
            if (lparent == null) {
                return;
            }
            window = lparent.isOverSize() ? new Rectangle(window.x - window.width / 3, window.y - buffer, 5 * window.width / 3, window.height + 2 * buffer) : new Rectangle(window.x - buffer, window.y - buffer, window.width + 2 * buffer, window.height + 2 * buffer);
            boolean rgbColor = colorByDataSet1 != null && Units.rgbColor.equals(zunits);
            int i = 0;
            while (index < SeriesRenderer.this.lastIndex) {
                block23: {
                    double dy;
                    double dx;
                    block22: {
                        block21: {
                            double x = xds.value(index);
                            double y = vds.value(index);
                            boolean isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
                            dx = xAxis.transform(x, xUnits);
                            dy = yAxis.transform(y, yUnits);
                            if (!isValid || !window.contains(dx, dy)) break block22;
                            if (SeriesRenderer.this.simplifyPaths && dx == dx0 && dy == dy0) break block23;
                            this.dpsymsPathX[i] = dx;
                            this.dpsymsPathY[i] = dy;
                            if (wdsz != null && colorByDataSet1 != null && fcolorBar != null) {
                                try {
                                    if (wdsz.value(index) > 0.0) {
                                        SeriesRenderer.this.haveValidColor = true;
                                        this.colors[i] = rgbColor ? (int)colorByDataSet1.value(index) : fcolorBar.indexColorTransform(colorByDataSet1.value(index), zunits);
                                        break block21;
                                    }
                                    this.colors[i] = -1;
                                }
                                catch (NullPointerException ex) {
                                    logger.log(Level.WARNING, ex.getMessage(), ex);
                                }
                            } else if (wdsz != null && rgbColor) {
                                if (wdsz.value(index) > 0.0) {
                                    SeriesRenderer.this.haveValidColor = true;
                                    assert (colorByDataSet1 != null);
                                    this.colors[i] = (int)colorByDataSet1.value(index);
                                } else {
                                    this.colors[i] = -1;
                                }
                            }
                        }
                        ++i;
                    }
                    dx0 = dx;
                    dy0 = dy;
                }
                ++index;
            }
            this.count = i;
            if (this.count == 0) {
                SeriesRenderer.this.haveValidColor = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean acceptContext(Point2D.Double dp) {
            double[] py;
            double[] px;
            PsymRenderElement psymRenderElement = this;
            synchronized (psymRenderElement) {
                px = this.dpsymsPathX;
                py = this.dpsymsPathY;
            }
            if (px == null) {
                return false;
            }
            double rad = Math.max(SeriesRenderer.this.symSize, 5.0f);
            int np = px.length;
            int index = 0;
            while (index < np) {
                int i;
                if (!(dp.distance(px[i = index++], py[i]) < rad)) continue;
                return true;
            }
            return false;
        }
    }

    static interface RenderElement {
        public int render(Graphics2D var1, DasAxis var2, DasAxis var3, QDataSet var4, ProgressMonitor var5);

        public void update(DasAxis var1, DasAxis var2, QDataSet var3, ProgressMonitor var4);

        public boolean acceptContext(Point2D.Double var1);
    }
}

