/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;

public class RowRowConnector
extends DasCanvasComponent
implements PropertyChangeListener {
    private DasCanvas parent;
    private DasRow leftRow;
    private DasRow rightRow;
    private DasColumn leftColumn;
    private DasColumn rightColumn;
    private boolean centerRightRow = false;

    public RowRowConnector(DasCanvas parent, DasRow leftRow, DasRow rightRow, DasColumn leftColumn, DasColumn rightColumn) {
        this.leftRow = leftRow;
        this.rightRow = rightRow;
        this.leftColumn = leftColumn;
        this.rightColumn = rightColumn;
        this.parent = parent;
        leftRow.addPropertyChangeListener(this);
        rightRow.addPropertyChangeListener(this);
        rightColumn.addPropertyChangeListener(this);
        leftColumn.addPropertyChangeListener(this);
    }

    private Rectangle getMyBounds() {
        if (this.centerRightRow) {
            int rightHeight = this.rightRow.getHeight();
            int leftCenter = this.leftRow.getDMiddle();
            if (leftCenter - rightHeight / 2 < 0) {
                leftCenter = rightHeight / 2;
            }
            if (leftCenter + rightHeight / 2 > this.parent.getHeight()) {
                leftCenter = this.parent.getHeight() - rightHeight / 2;
            }
            this.rightRow.setDPosition(leftCenter - rightHeight / 2, leftCenter + rightHeight / 2);
        }
        int xleft = this.leftColumn.getDMaximum();
        int xright = this.rightColumn.getDMaximum();
        int ylow = Math.max(this.leftRow.getDMaximum(), this.rightRow.getDMaximum());
        int yhigh = Math.min(this.leftRow.getDMinimum(), this.rightRow.getDMinimum());
        Rectangle result = new Rectangle(xleft, yhigh, xright - xleft, ylow - yhigh + 2);
        return result;
    }

    public void setLeftRow(DasRow row) {
        this.leftRow = row;
        this.update();
    }

    @Override
    public void resize() {
        this.setBounds(this.getMyBounds());
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(-this.getX(), -this.getY());
        int hlen = 3;
        int x1 = this.leftColumn.getDMaximum() + hlen;
        int x2 = this.rightColumn.getDMaximum() - hlen;
        int ylow1 = this.leftRow.getDMaximum();
        int ylow2 = this.rightRow.getDMaximum();
        int yhigh1 = this.leftRow.getDMinimum();
        int yhigh2 = this.rightRow.getDMinimum();
        g.setColor(Color.lightGray);
        g.draw(new Line2D.Double(x1 - hlen, ylow1, x1, ylow1));
        g.draw(new Line2D.Double(x2, ylow2, x2 + hlen, ylow2));
        g.draw(new Line2D.Double(x1, ylow1, x2, ylow2));
        g.draw(new Line2D.Double(x1 - hlen, yhigh1, x1, yhigh1));
        g.draw(new Line2D.Double(x2, yhigh2, x2 + hlen, yhigh2));
        g.draw(new Line2D.Double(x1, yhigh1, x2, yhigh2));
        g.dispose();
        this.getDasMouseInputAdapter().paint(g1);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.markDirty();
        this.update();
    }
}

